/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.daily.web.util;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.extplugin.PluginProxy;
import kd.bos.form.IFormView;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Label;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.bill.BillModel;
import kd.bos.mvc.bill.MobileBillView;
import kd.fi.er.business.daily.reimburse.AmountObject;
import kd.fi.er.business.daily.reimburse.WriteOffTypeEnum;
import kd.fi.er.business.expand.ErExpandServiceFacade;
import kd.fi.er.business.ext.enums.ErExtcaseEnum;
import kd.fi.er.business.ext.helper.ErExtHelper;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;
import kd.fi.er.business.servicehelper.PayeeServiceHelper;
import kd.fi.er.business.utils.AmountFormatsUtil;
import kd.fi.er.business.utils.AmountUtils;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.business.utils.ReceiveEntryPropChange;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.sdk.fi.er.extpoint.dailyreimbursebill.IWriteOffMoney;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ObjectUtils;

public class WriteOffMoneyUtils {
    private static final Log logger = LogFactory.getLog(WriteOffMoneyUtils.class);

    public static void sortWriteOffEntry(IFormView view) {
        IDataModel model = view.getModel();
        IDataEntityProperty writeOffMoney = model.getProperty("writeoffmoney");
        IDataEntityProperty sourceSign = model.getProperty("sourcesign");
        IDataEntityProperty applyOffMoney = model.getProperty("writeoffapply");
        if (writeOffMoney != null && applyOffMoney != null && sourceSign != null) {
            DynamicObjectCollection applyOffEntry = model.getEntryEntity("writeoffapply");
            if (applyOffEntry.size() == 0) {
                return;
            }
            DynamicObjectCollection writeOffEntry = model.getEntryEntity("writeoffmoney");
            if (writeOffEntry.parallelStream().noneMatch(r -> r.getBoolean("sourcesign"))) {
                return;
            }
            int j = 0;
            for (int i = 0; i < writeOffEntry.size(); ++i) {
                DynamicObject row = (DynamicObject)writeOffEntry.get(i);
                if (!row.getBoolean("sourcesign")) continue;
                Collections.swap(writeOffEntry, i, j);
                ((DynamicObject)writeOffEntry.get(i)).set("seq", (Object)(i + 1));
                ((DynamicObject)writeOffEntry.get(j)).set("seq", (Object)j++);
            }
            view.updateView("writeoffmoney");
            if (view instanceof MobileBillView) {
                WriteOffMoneyUtils.hiddenOrShowWriteOff(model, view, false);
            }
        }
    }

    public static void hiddenOrShowWriteOff(IDataModel model, IFormView view, boolean show) {
        WriteOffMoneyUtils.hiddenOrShow(model, view, show, "writeoffmoney", "lab_done_writeoff", "lab_delete_writeoff", "image_delete_writeoff");
    }

    public static void writeOffMoney(IDataModel dataModel, String writeOffType) {
        if (WriteOffTypeEnum.ORGI_WO.getValue().equals(writeOffType)) {
            WriteOffMoneyUtils.writeOffMoneyByOrgiCurrcy(dataModel);
            WriteOffMoneyUtils.writeOffApplyByOrgiCurrcy(dataModel);
            WriteOffMoneyUtils.writeoffWithholdingByOrgiCurrcy(dataModel);
        } else {
            WriteOffMoneyUtils.writeOffMoneyByStandardCurrcy(dataModel);
            WriteOffMoneyUtils.writeOffApplyByStandardCurrcy(dataModel);
            WriteOffMoneyUtils.writeoffWithholdingByCurrcy(dataModel);
        }
    }

    public static void writeOffMoney(IDataModel dataModel, String writeOffType, IFormView view) {
        WriteOffMoneyUtils.writeOffMoney(dataModel, writeOffType);
        if (view != null) {
            view.updateView("writeoffapply");
            if (view instanceof MobileBillView) {
                WriteOffMoneyUtils.hiddenOrShowApply(dataModel, view, false);
            }
        }
    }

    public static void hiddenOrShowApply(IDataModel model, IFormView view, boolean show) {
        WriteOffMoneyUtils.hiddenOrShow(model, view, show, "writeoffapply", "lab_done_offapply", "lab_delete_offapply", "image_delete_apply");
    }

    public static void hiddenOrShow(IDataModel model, IFormView view, boolean show, String entryName, String labDoneName, String labDeleteName, String imageDelName) {
        if (model.getProperty(entryName) == null) {
            return;
        }
        int accountEntrySize = model.getEntryRowCount(entryName);
        CardEntry accountCard = (CardEntry)view.getControl(entryName);
        if (show) {
            view.setVisible(Boolean.TRUE, new String[]{labDoneName});
            view.setVisible(Boolean.FALSE, new String[]{labDeleteName});
        } else {
            view.setVisible(Boolean.FALSE, new String[]{labDoneName});
            view.setVisible(Boolean.TRUE, new String[]{labDeleteName});
        }
        for (int rowIndex = 0; rowIndex < accountEntrySize; ++rowIndex) {
            accountCard.setChildVisible(show, rowIndex, new String[]{imageDelName});
        }
    }

    private static void writeOffMoneyByOrgiCurrcy(IDataModel dataModel) {
        Set<Long> expeIds = AmountUtils.getCurrencyIdSet(dataModel, "expenseentryentity", "entrycurrency");
        Set<Long> woIds = AmountUtils.getCurrencyIdSet(dataModel, "writeoffmoney", "loancurrency");
        HashSet totalIds = Sets.newHashSet();
        totalIds.addAll(woIds);
        totalIds.addAll(expeIds);
        int len = expeIds.size() + woIds.size();
        if (totalIds.size() == len) {
            DynamicObjectCollection woColl = dataModel.getEntryEntity("writeoffmoney");
            for (int i = 0; i < woColl.size(); ++i) {
                dataModel.setValue("accloanamount", (Object)BigDecimal.ZERO, i);
                dataModel.setValue("curraccloanamount", (Object)BigDecimal.ZERO, i);
            }
        } else {
            boolean proxytax;
            DynamicObjectCollection expeColl = dataModel.getEntryEntity("expenseentryentity");
            DynamicObjectCollection woColl = dataModel.getEntryEntity("writeoffmoney");
            Map<String, BigDecimal> expeCurrcyAmount = AmountUtils.groupByCurrency(expeColl, "entrycurrency", "expeapproveamount");
            boolean bl = proxytax = dataModel.getDataEntity().getDataEntityType().getProperties().get((Object)"proxytax") != null;
            if (proxytax && ((Boolean)dataModel.getValue("proxytax")).booleanValue()) {
                Map<String, BigDecimal> expeProxyAmount = AmountUtils.groupByCurrency(expeColl, "entrycurrency", "proxyamt");
                expeCurrcyAmount.entrySet().forEach(entry -> entry.setValue(((BigDecimal)entry.getValue()).subtract(expeProxyAmount.getOrDefault(entry.getKey(), BigDecimal.ZERO))));
            }
            if (expeColl.getDynamicObjectType().getProperty("tripbookamount") != null) {
                Map<String, BigDecimal> tripBookCurAmount = AmountUtils.groupByCurrency(expeColl, "entrycurrency", "tripbookamount");
                expeCurrcyAmount.entrySet().forEach(entry -> entry.setValue(((BigDecimal)entry.getValue()).subtract(tripBookCurAmount.getOrDefault(entry.getKey(), BigDecimal.ZERO))));
            }
            for (Map.Entry<String, BigDecimal> entry2 : expeCurrcyAmount.entrySet()) {
                if (entry2.getValue().compareTo(BigDecimal.ZERO) < 0) continue;
                for (int i = 0; i < woColl.size(); ++i) {
                    DynamicObject woDynamicObject = (DynamicObject)woColl.get(i);
                    String currcyId = "";
                    if (woDynamicObject.get("loancurrency") != null && ((DynamicObject)woDynamicObject.get("loancurrency")).getPkValue() != null) {
                        currcyId = ((DynamicObject)woDynamicObject.get("loancurrency")).getPkValue().toString();
                    }
                    if (entry2.getKey().equals(currcyId)) {
                        if (entry2.getValue().compareTo(woDynamicObject.getBigDecimal("loanamount")) > 0) {
                            dataModel.setValue("accloanamount", (Object)woDynamicObject.getBigDecimal("loanamount"), i);
                            entry2.setValue(entry2.getValue().subtract(woDynamicObject.getBigDecimal("loanamount")));
                        } else {
                            dataModel.setValue("accloanamount", (Object)entry2.getValue(), i);
                            entry2.setValue(BigDecimal.ZERO);
                        }
                    }
                    if (expeCurrcyAmount.containsKey(currcyId)) continue;
                    dataModel.setValue("accloanamount", (Object)BigDecimal.ZERO, i);
                }
            }
        }
    }

    private static void writeOffApplyByOrgiCurrcy(IDataModel dataModel) {
        Set<Long> expeIds = AmountUtils.getCurrencyIdSet(dataModel, "expenseentryentity", "entrycurrency");
        Set<Long> woIds = AmountUtils.getCurrencyIdSet(dataModel, "writeoffapply", "applycurrency");
        HashSet totalIds = Sets.newHashSet();
        totalIds.addAll(woIds);
        totalIds.addAll(expeIds);
        int len = expeIds.size() + woIds.size();
        if (totalIds.size() == len) {
            DynamicObjectCollection woColl = dataModel.getEntryEntity("writeoffapply");
            for (int i = 0; i < woColl.size(); ++i) {
                dataModel.setValue("reimbursedamount", (Object)BigDecimal.ZERO, i);
                dataModel.setValue("reimbursedcurramount", (Object)BigDecimal.ZERO, i);
            }
        } else {
            DynamicObjectCollection expeColl = dataModel.getEntryEntity("expenseentryentity");
            DynamicObjectCollection woColl = dataModel.getEntryEntity("writeoffapply");
            Map<String, BigDecimal> expeCurrcyAmount = AmountUtils.groupByCurrency(expeColl, "entrycurrency", "expeapproveamount");
            for (Map.Entry<String, BigDecimal> entry : expeCurrcyAmount.entrySet()) {
                if (entry.getValue().compareTo(BigDecimal.ZERO) < 0) continue;
                for (int i = 0; i < woColl.size(); ++i) {
                    DynamicObject woDynamicObject = (DynamicObject)woColl.get(i);
                    String currcyId = "";
                    if (woDynamicObject.get("applycurrency") != null) {
                        currcyId = ((DynamicObject)woDynamicObject.get("applycurrency")).getPkValue().toString();
                    }
                    if (entry.getKey().equals(currcyId)) {
                        if (entry.getValue().compareTo(woDynamicObject.getBigDecimal("orgiexpebalanceamount")) > 0) {
                            dataModel.setValue("reimbursedamount", (Object)woDynamicObject.getBigDecimal("orgiexpebalanceamount"), i);
                            entry.setValue(entry.getValue().subtract(woDynamicObject.getBigDecimal("reimbursedamount")));
                        } else {
                            dataModel.setValue("reimbursedamount", (Object)entry.getValue(), i);
                            entry.setValue(BigDecimal.ZERO);
                        }
                        WriteOffMoneyUtils.setReimbursedcurramount(woDynamicObject, dataModel, i);
                    }
                    if (expeCurrcyAmount.containsKey(currcyId)) continue;
                    dataModel.setValue("reimbursedamount", (Object)BigDecimal.ZERO, i);
                    dataModel.setValue("reimbursedcurramount", (Object)BigDecimal.ZERO, i);
                }
            }
        }
    }

    public static void writeoffWithholdingByOrgiCurrcy(IDataModel dataModel) {
        Set<Long> expeIds = AmountUtils.getCurrencyIdSet(dataModel, "expenseentryentity", "entrycurrency");
        Set<Long> woIds = AmountUtils.getCurrencyIdSet(dataModel, "withholdingentry", "whcurrency");
        HashSet totalIds = Sets.newHashSet();
        totalIds.addAll(woIds);
        totalIds.addAll(expeIds);
        int len = expeIds.size() + woIds.size();
        if (totalIds.size() == len) {
            DynamicObjectCollection woColl = dataModel.getEntryEntity("withholdingentry");
            for (int i = 0; i < woColl.size(); ++i) {
                dataModel.setValue("whbursedamount", (Object)BigDecimal.ZERO, i);
                dataModel.setValue("whbursedcurramount", (Object)BigDecimal.ZERO, i);
            }
        } else {
            DynamicObjectCollection expeColl = dataModel.getEntryEntity("expenseentryentity");
            DynamicObjectCollection woColl = dataModel.getEntryEntity("withholdingentry");
            Map<String, BigDecimal> expeCurrcyAmount = AmountUtils.groupByCurrency(expeColl, "entrycurrency", "expeapproveamount");
            for (Map.Entry<String, BigDecimal> entry : expeCurrcyAmount.entrySet()) {
                if (entry.getValue().compareTo(BigDecimal.ZERO) < 0) continue;
                for (int i = 0; i < woColl.size(); ++i) {
                    DynamicObject woDynamicObject = (DynamicObject)woColl.get(i);
                    String currcyId = "";
                    if (woDynamicObject.get("whcurrency") != null) {
                        currcyId = ((DynamicObject)woDynamicObject.get("whcurrency")).getPkValue().toString();
                    }
                    if (entry.getKey().equals(currcyId)) {
                        if (entry.getValue().compareTo(woDynamicObject.getBigDecimal("orgiwhbalanceamount")) > 0) {
                            dataModel.beginInit();
                            dataModel.setValue("whbursedamount", (Object)woDynamicObject.getBigDecimal("orgiwhbalanceamount"), i);
                            dataModel.endInit();
                            entry.setValue(entry.getValue().subtract(woDynamicObject.getBigDecimal("whbursedamount")));
                        } else {
                            dataModel.setValue("whbursedamount", (Object)entry.getValue(), i);
                            entry.setValue(BigDecimal.ZERO);
                        }
                        BigDecimal whbursedamount = (BigDecimal)dataModel.getValue("whbursedamount", i);
                        BigDecimal whbalanceamount = (BigDecimal)dataModel.getValue("whbalanceamount", i);
                        if (whbursedamount.compareTo(woDynamicObject.getBigDecimal("orgiwhbalanceamount")) == 0) {
                            dataModel.beginInit();
                            dataModel.setValue("whbursedcurramount", (Object)whbalanceamount, i);
                            dataModel.endInit();
                        } else {
                            BigDecimal whbursedcurramount;
                            int precision = AmountUtils.getAmountFieldPrecision(woDynamicObject, "whbursedcurramount");
                            String whquotetype = (String)dataModel.getValue("whquotetype", i);
                            BigDecimal whexchangerate = (BigDecimal)dataModel.getValue("whexchangerate", i);
                            BigDecimal bigDecimal = whbursedcurramount = StringUtils.equals((String)"0", (String)whquotetype) ? whbursedamount.multiply(whexchangerate).setScale(precision, RoundingMode.HALF_UP) : whbursedamount.divide(whexchangerate, precision, RoundingMode.HALF_UP);
                            if (whbursedcurramount.compareTo(whbalanceamount) > 0) {
                                dataModel.beginInit();
                                dataModel.setValue("whbursedcurramount", (Object)whbalanceamount, i);
                                dataModel.endInit();
                            } else {
                                dataModel.setValue("whbursedcurramount", (Object)whbursedcurramount, i);
                            }
                        }
                    }
                    if (expeCurrcyAmount.containsKey(currcyId)) continue;
                    dataModel.setValue("whbursedamount", (Object)BigDecimal.ZERO, i);
                    dataModel.setValue("whbursedcurramount", (Object)BigDecimal.ZERO, i);
                }
            }
        }
        PluginProxy pluginProxy = PluginProxy.create(null, IWriteOffMoney.class, (String)"FI_ER_WRITEOFFMONEY", null);
        pluginProxy.callReplace(p -> {
            p.afterWriteoffWithholdingByOrgiCurrcy(dataModel);
            return null;
        });
    }

    public static void writeoffWithholdingByCurrcy(IDataModel dataModel) {
        BigDecimal currReimburseAmount = AmountUtils.getEntryAmount(dataModel, "expenseentryentity", "expeapprovecurramount");
        DynamicObjectCollection woEntrys = dataModel.getEntryEntity("withholdingentry");
        for (int i = 0; i < woEntrys.size(); ++i) {
            BigDecimal orgiwhbalanceamount;
            DynamicObject woEntry = (DynamicObject)woEntrys.get(i);
            if (currReimburseAmount.compareTo(BigDecimal.ZERO) > 0) {
                BigDecimal currLoanAmount = woEntry.getBigDecimal("whbalanceamount");
                if (currLoanAmount.compareTo(currReimburseAmount) > 0) {
                    dataModel.setValue("whbursedcurramount", (Object)currReimburseAmount, i);
                } else {
                    dataModel.setValue("whbursedcurramount", (Object)currLoanAmount, i);
                }
                currReimburseAmount = currReimburseAmount.subtract(currLoanAmount);
            } else {
                dataModel.setValue("whbursedcurramount", (Object)BigDecimal.ZERO, i);
            }
            BigDecimal woCurrAmount = woEntry.getBigDecimal("whbursedcurramount");
            if (woCurrAmount.compareTo(woEntry.getBigDecimal("whbalanceamount")) == 0) {
                dataModel.setValue("whbursedamount", (Object)woEntry.getBigDecimal("orgiwhbalanceamount"), i);
                continue;
            }
            BigDecimal woExchageRate = woEntry.getBigDecimal("whexchangerate");
            if (woExchageRate == null || woExchageRate.compareTo(BigDecimal.ZERO) == 0) {
                woExchageRate = BigDecimal.ONE;
            }
            String quoteType = dataModel.getProperty("whquotetype") == null ? "0" : (String)woEntry.get("whquotetype");
            BigDecimal writeWoCurrAmount = AmountUtils.getOriAmount(woCurrAmount, woExchageRate, AmountUtils.getAmountFieldPrecision(woEntry, "whbursedamount"), quoteType);
            if (writeWoCurrAmount.compareTo(orgiwhbalanceamount = woEntry.getBigDecimal("orgiwhbalanceamount")) > 0) {
                dataModel.beginInit();
                dataModel.setValue("whbursedamount", (Object)orgiwhbalanceamount, i);
                dataModel.endInit();
                continue;
            }
            dataModel.setValue("whbursedamount", (Object)writeWoCurrAmount, i);
        }
        PluginProxy pluginProxy = PluginProxy.create(null, IWriteOffMoney.class, (String)"FI_ER_WRITEOFFMONEY", null);
        pluginProxy.callReplace(p -> {
            p.afterWriteoffWithholdingByCurrcy(dataModel);
            return null;
        });
    }

    private static void setReimbursedcurramount(DynamicObject woDynamicObject, IDataModel dataModel, int i) {
        BigDecimal woExchageRate = woDynamicObject.getBigDecimal("applyexchangerate");
        if (woExchageRate == null || woExchageRate.compareTo(BigDecimal.ZERO) == 0) {
            woExchageRate = BigDecimal.ONE;
        }
        BigDecimal reimbursedamount = woDynamicObject.getBigDecimal("reimbursedamount");
        String quoteType = org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)"writeoffapplyquotetype") || dataModel.getProperty("writeoffapplyquotetype") == null ? "0" : (String)ObjectUtils.defaultIfNull((Object)((String)dataModel.getValue("writeoffapplyquotetype", i)), (Object)"0");
        BigDecimal reimbursedcurramount = BigDecimal.ZERO;
        reimbursedcurramount = org.apache.commons.lang3.StringUtils.equals((CharSequence)"0", (CharSequence)quoteType) ? reimbursedamount.multiply(woExchageRate).setScale(AmountUtils.getAmountFieldPrecision(woDynamicObject, "reimbursedcurramount"), RoundingMode.HALF_UP) : reimbursedamount.divide(woExchageRate, AmountUtils.getAmountFieldPrecision(woDynamicObject, "reimbursedcurramount"), RoundingMode.HALF_UP);
        dataModel.setValue("reimbursedcurramount", (Object)reimbursedcurramount, i);
    }

    private static void writeOffApplyByStandardCurrcy(IDataModel dataModel) {
        BigDecimal currReimburseAmount = AmountUtils.getEntryAmount(dataModel, "expenseentryentity", "expeapprovecurramount");
        DynamicObjectCollection woEntrys = dataModel.getEntryEntity("writeoffapply");
        for (int i = 0; i < woEntrys.size(); ++i) {
            DynamicObject woEntry = (DynamicObject)woEntrys.get(i);
            if (currReimburseAmount.compareTo(BigDecimal.ZERO) > 0) {
                BigDecimal currLoanAmount = woEntry.getBigDecimal("expebalanceamount");
                if (currLoanAmount.compareTo(currReimburseAmount) > 0) {
                    dataModel.setValue("reimbursedcurramount", (Object)currReimburseAmount, i);
                } else {
                    dataModel.setValue("reimbursedcurramount", (Object)currLoanAmount, i);
                }
                currReimburseAmount = currReimburseAmount.subtract(currLoanAmount);
            } else {
                dataModel.setValue("reimbursedcurramount", (Object)BigDecimal.ZERO, i);
            }
            BigDecimal woCurrAmount = woEntry.getBigDecimal("reimbursedcurramount");
            if (woCurrAmount.compareTo(woEntry.getBigDecimal("expebalanceamount")) == 0) {
                dataModel.setValue("reimbursedamount", (Object)woEntry.getBigDecimal("orgiexpebalanceamount"), i);
                continue;
            }
            BigDecimal woExchageRate = woEntry.getBigDecimal("applyexchangerate");
            if (woExchageRate == null || woExchageRate.compareTo(BigDecimal.ZERO) == 0) {
                woExchageRate = BigDecimal.ONE;
            }
            String quoteType = dataModel.getProperty("writeoffapplyquotetype") == null ? "0" : (String)woEntry.get("writeoffapplyquotetype");
            int precision = AmountUtils.getAmountFieldPrecision(woEntry, "reimbursedamount");
            BigDecimal writeWoCurrAmount = "0".equals(quoteType) ? woCurrAmount.divide(woExchageRate, precision, RoundingMode.HALF_UP) : woCurrAmount.multiply(woExchageRate).setScale(precision, RoundingMode.HALF_UP);
            dataModel.setValue("reimbursedamount", (Object)writeWoCurrAmount, i);
        }
    }

    private static void writeOffMoneyByStandardCurrcy(IDataModel dataModel) {
        boolean proxytax;
        BigDecimal currReimburseAmount = AmountUtils.getEntryAmount(dataModel, "expenseentryentity", "expeapprovecurramount");
        boolean bl = proxytax = dataModel.getDataEntity().getDataEntityType().getProperties().get((Object)"proxytax") != null;
        if (proxytax && ((Boolean)dataModel.getValue("proxytax")).booleanValue()) {
            BigDecimal currProxyAmount = AmountUtils.getEntryAmount(dataModel, "expenseentryentity", "curproxyamt");
            currReimburseAmount = currReimburseAmount.subtract(currProxyAmount);
        }
        if (dataModel.getProperty("tripbookcuramount") != null) {
            BigDecimal tripBookCurAmount = AmountUtils.getEntryAmount(dataModel, "expenseentryentity", "tripbookcuramount");
            currReimburseAmount = currReimburseAmount.subtract(tripBookCurAmount);
        }
        DynamicObjectCollection woEntrys = dataModel.getEntryEntity("writeoffmoney");
        for (int i = 0; i < woEntrys.size(); ++i) {
            DynamicObject woEntry = (DynamicObject)woEntrys.get(i);
            if (currReimburseAmount.compareTo(BigDecimal.ZERO) > 0) {
                BigDecimal currLoanAmount = woEntry.getBigDecimal("currloanamount");
                if (currLoanAmount.compareTo(currReimburseAmount) > 0) {
                    dataModel.setValue("curraccloanamount", (Object)currReimburseAmount, i);
                } else {
                    dataModel.setValue("curraccloanamount", (Object)currLoanAmount, i);
                }
                currReimburseAmount = currReimburseAmount.subtract(currLoanAmount);
            } else {
                dataModel.setValue("curraccloanamount", (Object)BigDecimal.ZERO, i);
            }
            woEntry = (DynamicObject)dataModel.getEntryEntity("writeoffmoney").get(i);
            BigDecimal woCurrAmount = woEntry.getBigDecimal("curraccloanamount");
            if (woCurrAmount.compareTo(woEntry.getBigDecimal("currloanamount")) == 0) {
                dataModel.setValue("accloanamount", (Object)woEntry.getBigDecimal("loanamount"), i);
                continue;
            }
            BigDecimal woExchageRate = woEntry.getBigDecimal("loanexchangerate");
            if (woExchageRate == null || woExchageRate.compareTo(BigDecimal.ZERO) == 0) {
                woExchageRate = BigDecimal.ONE;
            }
            String quoteType = dataModel.getProperty("writeoffquotetype") == null ? "0" : (String)woEntry.get("writeoffquotetype");
            int precision = AmountUtils.getAmountFieldPrecision(woEntry, "accloanamount");
            BigDecimal accloanamount = "0".equals(quoteType) ? woCurrAmount.divide(woExchageRate, precision, RoundingMode.HALF_UP) : woCurrAmount.multiply(woExchageRate).setScale(precision, RoundingMode.HALF_UP);
            dataModel.setValue("accloanamount", (Object)accloanamount, i);
        }
    }

    public static void refreshReceiveAmount(IDataModel dataModel, String writeOffType, IFormView formView) {
        AmountObject payAmountObject = WriteOffMoneyUtils.calculatePayAmount(dataModel, writeOffType, formView);
        WriteOffMoneyUtils.refreshReceiveAmount(payAmountObject, formView, writeOffType);
        dataModel.setValue("notpayamount", (Object)payAmountObject.getCurrAmount());
        int index = dataModel.getEntryRowCount("accountentry");
        for (int i = 0; i < index; ++i) {
            formView.updateView("orireceiveamount", i);
            formView.updateView("receiveamount", i);
            formView.updateView("oriaccnotpayamount", i);
            formView.updateView("accnotpayamount", i);
        }
    }

    public static AmountObject calculatePayAmount(IDataModel dataModel, String writeOffType, IFormView view) {
        DynamicObject dataEntity = dataModel.getDataEntity(true);
        BigDecimal currPayAmount = WriteOffMoneyUtils.calculatePayAmount(dataEntity, writeOffType);
        BigDecimal orgiPayAmount = WriteOffMoneyUtils.getOrgiPayAmount(dataEntity, writeOffType);
        Object invokeExtService = ErExpandServiceFacade.get().invokeExtService("ext.service.er.payamountCalc", "payamountCalc", new Object[]{dataModel, writeOffType, BigDecimal.ZERO, currPayAmount}, new Class[]{BillModel.class, String.class, BigDecimal.class, BigDecimal.class});
        List invokeBosExt = ErExtHelper.invokeExpandPlugin(view, ErExtcaseEnum.ER_EXTCASE_PAYAMOUNT);
        AmountObject result = new AmountObject(orgiPayAmount, currPayAmount);
        try {
            if (invokeBosExt != null && invokeBosExt.size() > 0) {
                result = (AmountObject)invokeBosExt.get(0);
            } else if (invokeExtService != null && !"-1".equals(invokeExtService)) {
                result = (AmountObject)invokeExtService;
            }
        }
        catch (Exception e) {
            logger.error("\u6269\u5c55\u670d\u52a1\u8fd4\u56de\u5f02\u5e38:{}", (Object)e.getMessage());
            result = new AmountObject(orgiPayAmount, currPayAmount);
        }
        return result;
    }

    private static BigDecimal getOrgiPayAmount(DynamicObject dataEntity, String writeOffType) {
        BigDecimal orgiPayAmount = null;
        if (WriteOffTypeEnum.ORGI_WO.getValue().equals(writeOffType)) {
            orgiPayAmount = WriteOffMoneyUtils.calcOriReceiveAmtByAdd_Sub(dataEntity);
        }
        return orgiPayAmount;
    }

    private static BigDecimal calcOriReceiveAmtByAdd_Sub(DynamicObject dataEntity) {
        Map<String, AmountObject> expeCurrcyAmount = AmountUtils.groupByCurrencyToObject("expquotetype", dataEntity.getDynamicObjectCollection("expenseentryentity"), "expeapproveamount", "expeapprovecurramount", "entrycurrency", "exchangerate");
        Map<String, BigDecimal> woCurrencyAmount = AmountUtils.groupByCurrency(dataEntity.getDynamicObjectCollection("writeoffmoney"), "loancurrency", "accloanamount");
        boolean proxytax = dataEntity.getDataEntityType().getProperties().get((Object)"proxytax") != null;
        WriteOffMoneyUtils.forEachEntryDeal(dataEntity, proxytax, expeCurrcyAmount, woCurrencyAmount);
        BigDecimal orgiPayAmount = expeCurrcyAmount.entrySet().stream().map(v -> ((AmountObject)v.getValue()).getOrgiAmount()).reduce((a1, a2) -> a1.add((BigDecimal)a2)).orElse(BigDecimal.ZERO);
        return orgiPayAmount;
    }

    public static BigDecimal calculatePayAmount(DynamicObject dataEntity, String writeOffType) {
        BigDecimal currPayAmount;
        boolean proxytax = dataEntity.getDataEntityType().getProperties().get((Object)"proxytax") != null;
        DynamicObjectCollection writeOffEntries = dataEntity.getDynamicObjectCollection("writeoffmoney");
        if (WriteOffTypeEnum.ORGI_WO.getValue().equals(writeOffType) && writeOffEntries.size() > 0) {
            Map<String, AmountObject> expeCurrcyAmount = AmountUtils.groupByCurrencyToObject("expquotetype", dataEntity.getDynamicObjectCollection("expenseentryentity"), "expeapproveamount", "expeapprovecurramount", "entrycurrency", "exchangerate");
            Map<String, BigDecimal> woCurrencyAmount = AmountUtils.groupByCurrency(writeOffEntries, "loancurrency", "accloanamount");
            WriteOffMoneyUtils.forEachEntryDeal(dataEntity, proxytax, expeCurrcyAmount, woCurrencyAmount);
            int currencyPrecision = AmountUtils.getCurrencyPrecision(dataEntity, "currency");
            currPayAmount = expeCurrcyAmount.entrySet().stream().map(v -> AmountUtils.getCurrencyAmount(((AmountObject)v.getValue()).getOrgiAmount(), ((AmountObject)v.getValue()).getExchangeRate(), currencyPrecision, ((AmountObject)v.getValue()).getQuoteType())).reduce((a1, a2) -> a1.add((BigDecimal)a2)).orElse(BigDecimal.ZERO);
        } else {
            BigDecimal currExpeAmount = AmountUtils.getEntryAmount(dataEntity.getDynamicObjectCollection("expenseentryentity"), "expeapprovecurramount");
            BigDecimal currWoAmount = AmountUtils.getEntryAmount(writeOffEntries, "curraccloanamount");
            currPayAmount = currExpeAmount.subtract(currWoAmount);
            BigDecimal monthsettleamount = BigDecimal.ZERO;
            DynamicObjectCollection entry_entity = dataEntity.getDynamicObjectCollection("expenseentryentity");
            if (entry_entity != null && entry_entity.size() > 0 && ((DynamicObject)entry_entity.get(0)).containsProperty("tripbookcuramount")) {
                monthsettleamount = AmountUtils.getEntryAmount(entry_entity, "tripbookcuramount");
            }
            currPayAmount = WriteOffMoneyUtils.dealProxyTaxWithCurType(dataEntity, currPayAmount, proxytax).subtract(monthsettleamount);
        }
        currPayAmount = currPayAmount.setScale(AmountUtils.getCurrencyPrecision(dataEntity, "currency"), RoundingMode.HALF_UP);
        logger.info(String.format(ResManager.loadKDString((String)"\u51b2\u9500\u65b9\u5f0f\uff1a%1$s\u3002\u4ed8\u73b0\u672c\u4f4d\u5e01\u91d1\u989d\uff1a%2$s\u3002\u4ed8\u73b0\u539f\u5e01\u91d1\u989d\uff1a%3$s\u3002", (String)"WriteOffMoneyUtils_0", (String)"fi-er-business", (Object[])new Object[0]), WriteOffTypeEnum.ORGI_WO.getValue().equals(writeOffType) ? WriteOffTypeEnum.ORGI_WO.getDesc() : WriteOffTypeEnum.CURR_WO.getDesc(), currPayAmount, BigDecimal.ZERO));
        return currPayAmount;
    }

    private static void forEachEntryDeal(DynamicObject dataEntity, boolean proxytax, Map<String, AmountObject> expeCurrcyAmount, Map<String, BigDecimal> woCurrencyAmount) {
        DynamicObjectCollection entry_entity;
        if (proxytax) {
            Map<String, AmountObject> proxyCurrencyAmount = AmountUtils.groupByCurrencyToObject("expquotetype", dataEntity.getDynamicObjectCollection("expenseentryentity"), "proxyamt", "curproxyamt", "entrycurrency", "exchangerate");
            for (Map.Entry<String, AmountObject> entry : expeCurrcyAmount.entrySet()) {
                String string = entry.getKey();
                AmountObject expAmount = expeCurrcyAmount.get(string);
                AmountObject proxyAmount = proxyCurrencyAmount.get(string);
                expAmount.setCurrAmount(expAmount.getCurrAmount().subtract(proxyAmount.getCurrAmount()));
                expAmount.setOrgiAmount(expAmount.getOrgiAmount().subtract(proxyAmount.getOrgiAmount()));
            }
        }
        if ((entry_entity = dataEntity.getDynamicObjectCollection("expenseentryentity")) != null && entry_entity.size() > 0 && ((DynamicObject)entry_entity.get(0)).containsProperty("tripbookcuramount")) {
            Map<String, AmountObject> monthSettleCurrencyAmount = AmountUtils.groupByCurrencyToObject("expquotetype", dataEntity.getDynamicObjectCollection("expenseentryentity"), "tripbookamount", "tripbookcuramount", "entrycurrency", "exchangerate");
            for (Map.Entry<String, AmountObject> entry : expeCurrcyAmount.entrySet()) {
                String currency = entry.getKey();
                AmountObject expAmount = expeCurrcyAmount.get(currency);
                AmountObject monthSettleAmount = monthSettleCurrencyAmount.get(currency);
                expAmount.setCurrAmount(expAmount.getCurrAmount().subtract(monthSettleAmount.getCurrAmount()));
                expAmount.setOrgiAmount(expAmount.getOrgiAmount().subtract(monthSettleAmount.getOrgiAmount()));
            }
        }
        for (Map.Entry<String, AmountObject> entry : expeCurrcyAmount.entrySet()) {
            for (Map.Entry<String, BigDecimal> woEntry : woCurrencyAmount.entrySet()) {
                if (!entry.getKey().equals(woEntry.getKey())) continue;
                AmountObject amount = entry.getValue();
                BigDecimal oriAmount = amount.getOrgiAmount().subtract(woEntry.getValue());
                amount.setOrgiAmount(oriAmount);
                entry.setValue(amount);
            }
        }
    }

    protected static BigDecimal dealProxyTaxWithCurType(DynamicObject dataEntity, BigDecimal currPayAmount, boolean proxytax) {
        if (proxytax) {
            BigDecimal curProxytax = AmountUtils.getEntryAmount(dataEntity.getDynamicObjectCollection("expenseentryentity"), "curproxyamt");
            currPayAmount = currPayAmount.subtract(curProxytax);
        }
        return currPayAmount;
    }

    private static void refreshReceiveAmount(AmountObject payAmountObject, IFormView view, String writeOffType) {
        IDataModel dataModel = view.getModel();
        BigDecimal currPayAmount = payAmountObject.getCurrAmount();
        if (currPayAmount.compareTo(BigDecimal.ZERO) <= 0) {
            dataModel.setValue("payamount", (Object)BigDecimal.ZERO);
        } else {
            dataModel.setValue("payamount", (Object)currPayAmount);
        }
        int count = dataModel.getEntryRowCount("accountentry");
        if (currPayAmount.compareTo(BigDecimal.ZERO) > 0 && !WriteOffMoneyUtils.isContract(dataModel)) {
            if (count <= 1) {
                if (count == 0) {
                    int rowIndex = dataModel.createNewEntryRow("accountentry");
                    String entityName = dataModel.getDataEntityType().getName();
                    if (!ErEntityTypeUtils.isPublicReimburseBill(entityName)) {
                        Object currentUser = dataModel.getValue("applier");
                        DynamicObject payer = PayeeServiceHelper.getDefaultAccount(Long.parseLong(((DynamicObject)currentUser).getPkValue().toString()));
                        CoreBaseBillServiceHelper.fillAccountEntry(dataModel, rowIndex, payer);
                    }
                }
                boolean changeReciveAmount = true;
                Object invokeExtService = ErExpandServiceFacade.get().invokeExtService("ext.service.er.changeReciveAmount", "changeReciveAmount", new Object[]{dataModel}, new Class[]{IDataModel.class});
                if (invokeExtService != null && !"-1".equals(invokeExtService)) {
                    changeReciveAmount = (Boolean)invokeExtService;
                }
                if (changeReciveAmount && (DynamicObject)dataModel.getValue("accountcurrency") != null) {
                    WriteOffMoneyUtils.setReciveAmount(payAmountObject.getOrgiAmount(), currPayAmount, dataModel, writeOffType, view);
                }
                ErExtHelper.invokeMutiParamsExpandPlugin(ErExtcaseEnum.ER_EXTCASE_AFTERCHANGE_RECIVEAMOUNT, dataModel, writeOffType);
            }
        } else if (count > 0) {
            Object[] temp = null;
            temp = dataModel.getDataEntity().getDynamicObjectCollection("accountentry").toArray();
            Stream.of(temp).forEach(v -> {
                ((DynamicObject)v).set("receiveamount", (Object)BigDecimal.ZERO);
                ((DynamicObject)v).set("oriaccnotpayamount", (Object)BigDecimal.ZERO);
                ((DynamicObject)v).set("accnotpayamount", (Object)BigDecimal.ZERO);
                ((DynamicObject)v).set("orireceiveamount", (Object)BigDecimal.ZERO);
            });
            WriteOffMoneyUtils.setIsOnAccount(view);
        }
    }

    public static boolean isContract(IDataModel model) {
        IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)model.getDataEntity().getDataEntityType().getProperties().get((Object)"detailtype");
        boolean res = false;
        if (iDataEntityProperty != null) {
            String relationContract = (String)model.getValue("relationcontract");
            String detailType = model.getValue("detailtype").toString();
            if (StringUtils.equalsIgnoreCase((String)"biztype_contract", (String)detailType) && relationContract.equals("0")) {
                return true;
            }
            switch (relationContract) {
                case "1": {
                    res = false;
                    break;
                }
                case "": {
                    if (model.getProperty("contractentry") == null) {
                        res = true;
                        break;
                    }
                    int contractEntries = model.getEntryRowCount("contractentry");
                    if (contractEntries <= 0) break;
                    res = false;
                }
            }
        }
        return res;
    }

    public static void setReciveAmount(BigDecimal orgiAmount, BigDecimal currAmount, IDataModel dataModel, String writeOffType, IFormView view) {
        BigDecimal oriReceiveAmount;
        boolean noDiffWay;
        String billStatus = (String)dataModel.getValue("billstatus");
        if (StringUtils.equals((String)"A", (String)billStatus) || StringUtils.equals((String)"D", (String)billStatus)) {
            String isgetaccountcurrency = "0";
            if (dataModel.getValue("company") != null) {
                isgetaccountcurrency = SystemParamterUtil.isgetaccountcurrency((Long)((DynamicObject)dataModel.getValue("company")).getPkValue());
            }
            if (!"1".equals(isgetaccountcurrency)) {
                if (WriteOffMoneyUtils.judgeReceiveCurrency(dataModel, writeOffType, false)) {
                    DynamicObject entrycurrency = (DynamicObject)dataModel.getValue("entrycurrency", 0);
                    if (entrycurrency != null) {
                        dataModel.setValue("accountcurrency", entrycurrency.getPkValue(), 0);
                    }
                    BigDecimal exchangerate = (BigDecimal)dataModel.getValue("exchangerate", 0);
                    dataModel.beginInit();
                    dataModel.setValue("accexchangerate", (Object)exchangerate, 0);
                    view.updateView("accexchangerate", 0);
                    dataModel.endInit();
                } else {
                    dataModel.setValue("accountcurrency", (Object)ErCommonUtils.getPk(dataModel.getValue("currency")), 0);
                    dataModel.setValue("accexchangerate", (Object)BigDecimal.ONE, 0);
                }
            }
        }
        if ((noDiffWay = writeOffType.equals(WriteOffTypeEnum.ORGI_WO.getValue()) ? WriteOffMoneyUtils.judgeReceiveCurrency(dataModel, writeOffType, true) : WriteOffMoneyUtils.judgeReceiveExchangerate(dataModel)) && ErStdConfig.get("ext.service.er.payamountCalc") == null) {
            oriReceiveAmount = ReceiveEntryPropChange.directAmount(dataModel, true);
        } else {
            BigDecimal accexchangerate = (BigDecimal)dataModel.getValue("accexchangerate", 0);
            String accQuoteType = (String)dataModel.getValue("accquotetype", 0);
            DynamicObject accountcurrency = (DynamicObject)dataModel.getValue("accountcurrency", 0);
            int amountPrecision = AmountUtils.getCurrencyPrecision(accountcurrency.getPkValue());
            oriReceiveAmount = AmountUtils.getOriAmount(currAmount, accexchangerate, amountPrecision, accQuoteType);
        }
        dataModel.setValue("receiveamount", (Object)currAmount, 0);
        dataModel.setValue("accnotpayamount", (Object)currAmount.subtract((BigDecimal)dataModel.getValue("accpayedamount")), 0);
        dataModel.beginInit();
        dataModel.setValue("orireceiveamount", (Object)oriReceiveAmount, 0);
        dataModel.setValue("oriaccnotpayamount", (Object)oriReceiveAmount.subtract((BigDecimal)dataModel.getValue("oriaccpayedamount")), 0);
        dataModel.endInit();
        view.updateView("orireceiveamount", 0);
        view.updateView("oriaccnotpayamount", 0);
        logger.info(">>>>>>>>>>>>>oriReceiveAmount:{},currAmount\uff1a{},nodiffWay:{}", new Object[]{oriReceiveAmount, currAmount, noDiffWay});
    }

    private static BigDecimal getReiveAmount(IDataModel model) {
        BigDecimal totalApprovlAmount = BigDecimal.ZERO;
        BigDecimal wrtieOffMoneyAmount = BigDecimal.ZERO;
        BigDecimal monthSettleAmount = BigDecimal.ZERO;
        int expeEntrySize = model.getEntryRowCount("expenseentryentity");
        for (int i = 0; i < expeEntrySize; ++i) {
            totalApprovlAmount = totalApprovlAmount.add((BigDecimal)model.getValue("expeapproveamount", i));
        }
        int offMoneyEntrySize = model.getEntryRowCount("writeoffmoney");
        for (int i = 0; i < offMoneyEntrySize; ++i) {
            wrtieOffMoneyAmount = wrtieOffMoneyAmount.add((BigDecimal)model.getValue("accloanamount", i));
        }
        if (model.getProperty("tripbookamount") != null) {
            monthSettleAmount = AmountUtils.getEntryAmount(model, "expenseentryentity", "tripbookamount");
        }
        return totalApprovlAmount.subtract(wrtieOffMoneyAmount).subtract(monthSettleAmount);
    }

    @Deprecated
    public static boolean judgeReceiveCurrency(IDataModel dataModel, String writeOffType) {
        return WriteOffMoneyUtils.judgeReceiveCurrency(dataModel, writeOffType, false);
    }

    public static boolean judgeReceiveCurrency(IDataModel dataModel, String writeOffType, boolean includeAccountCurrency) {
        boolean setReceiveCurrencyFlag = false;
        String entityId = dataModel.getDataEntityType().getName();
        if (ErEntityTypeUtils.isDailyReimburseBill(entityId) || ErEntityTypeUtils.isPublicReimburseBill(entityId) || ErEntityTypeUtils.isTripReimburseBill(entityId)) {
            Set<Long> expeCurrencyIdSet;
            String loanClearCurrencyKey;
            String loanClearKey;
            if (ErEntityTypeUtils.isTripReimburseBill(entityId)) {
                String entryKey = "tripentry";
                loanClearKey = "clearloanentry";
                loanClearCurrencyKey = "loancurrency";
                String entryCurrencyKey = "entrycurrency";
                String subEntryKey = "entryentity";
                expeCurrencyIdSet = AmountUtils.getCurrencyIdSet(dataModel, entryKey, entryCurrencyKey, subEntryKey);
            } else {
                String entryKey = "expenseentryentity";
                String entryCurrencyKey = "entrycurrency";
                loanClearKey = "writeoffmoney";
                loanClearCurrencyKey = "loancurrency";
                expeCurrencyIdSet = AmountUtils.getCurrencyIdSet(dataModel, entryKey, entryCurrencyKey);
            }
            Set<Long> woCurrencyIdSet = AmountUtils.getCurrencyIdSet(dataModel, loanClearKey, loanClearCurrencyKey);
            if (expeCurrencyIdSet.size() == 1 && woCurrencyIdSet.size() == 1 && expeCurrencyIdSet.iterator().next().equals(woCurrencyIdSet.iterator().next())) {
                setReceiveCurrencyFlag = ErEntityTypeUtils.isTripReimburseBill(entityId) ? WriteOffTypeEnum.ORGI_WO.getValue().equals(writeOffType) : true;
            }
            if (expeCurrencyIdSet.size() == 1 && woCurrencyIdSet.size() == 0 || expeCurrencyIdSet.size() == 1 && WriteOffTypeEnum.ORGI_WO.getValue().equals(writeOffType)) {
                setReceiveCurrencyFlag = true;
            }
            if (includeAccountCurrency && setReceiveCurrencyFlag) {
                Set<Long> accCurrencyIdSet = AmountUtils.getCurrencyIdSet(dataModel, "accountentry", "accountcurrency");
                if (expeCurrencyIdSet.size() == 1 && accCurrencyIdSet.size() == 1) {
                    setReceiveCurrencyFlag = expeCurrencyIdSet.iterator().next().equals(accCurrencyIdSet.iterator().next());
                }
            }
        }
        return setReceiveCurrencyFlag;
    }

    public static boolean judgeReceiveExchangerate(IDataModel dataModel) {
        Set<BigDecimal> woExchangerate;
        Set<Object> expExchangerate;
        Set<BigDecimal> accExchangerate = AmountUtils.getExchangeRateSet(dataModel, "accountentry", "accexchangerate");
        if (dataModel.getProperty("tripentry") != null) {
            expExchangerate = Sets.newHashSetWithExpectedSize((int)4);
            DynamicObjectCollection tripEntries = dataModel.getEntryEntity("tripentry");
            for (DynamicObject tripentry : tripEntries) {
                DynamicObjectCollection entries = tripentry.getDynamicObjectCollection("entryentity");
                for (DynamicObject entry : entries) {
                    if (entries.getDynamicObjectType().getProperty("orientryappamount") != null && entry.getBigDecimal("orientryappamount").compareTo(BigDecimal.ZERO) == 0) continue;
                    BigDecimal exchangeRate = entry.getBigDecimal("exchangerate");
                    expExchangerate.add(exchangeRate == null ? BigDecimal.ONE : exchangeRate);
                }
            }
            woExchangerate = AmountUtils.getExchangeRateSet(dataModel, "clearloanentry", "loanexchangerate");
        } else {
            expExchangerate = AmountUtils.getExchangeRateSet(dataModel, "expenseentryentity", "exchangerate");
            woExchangerate = AmountUtils.getExchangeRateSet(dataModel, "writeoffmoney", "loanexchangerate");
        }
        if (expExchangerate.size() == 1 && (woExchangerate.isEmpty() || woExchangerate.size() == 1) && accExchangerate.size() == 1) {
            BigDecimal accRate;
            BigDecimal expRate = (BigDecimal)expExchangerate.iterator().next();
            return expRate.compareTo(accRate = accExchangerate.iterator().next()) == 0 && woExchangerate.isEmpty() || expRate.compareTo(accRate) == 0 && expRate.compareTo(woExchangerate.iterator().next()) == 0;
        }
        return false;
    }

    public static void showPayAmount(IDataModel dataModel, Label encashamountlabel) {
        if (encashamountlabel != null) {
            BigDecimal payAmount = (BigDecimal)dataModel.getValue("payamount");
            String currencySign = "";
            int amountPrecition = 4;
            DynamicObject currency = (DynamicObject)dataModel.getValue("currency");
            if (currency != null) {
                currencySign = currency.getString("sign");
                amountPrecition = currency.getInt("amtprecision");
                payAmount = payAmount.setScale(amountPrecition, RoundingMode.HALF_UP);
            }
            String amountStr = AmountFormatsUtil.getLabelAmountAfterFormat(currencySign, payAmount, amountPrecition);
            encashamountlabel.setText(amountStr);
        }
    }

    public static void changeApproveAmount(IDataModel model) {
        DynamicObjectCollection expense = model.getDataEntity(true).getDynamicObjectCollection("expenseentryentity");
        if (expense != null && !expense.isEmpty()) {
            BigDecimal expeapproveamount = (BigDecimal)model.getValue("expeapproveamount", 0);
            model.beginInit();
            model.setValue("expeapproveamount", (Object)0, 0);
            model.endInit();
            model.setValue("expeapproveamount", (Object)expeapproveamount, 0);
        } else {
            int size = model.getEntryRowCount("writeoffapply");
            for (int i = 0; i < size; ++i) {
                model.setValue("reimbursedamount", (Object)BigDecimal.ZERO, i);
                model.setValue("reimbursedcurramount", (Object)BigDecimal.ZERO, i);
            }
        }
    }

    public static void refreshBillHeadAmount(IDataModel dataModel) {
        BigDecimal totalReimAmount = AmountUtils.getEntryAmount(dataModel, "expenseentryentity", "currexpenseamount");
        BigDecimal totalApproveAmount = AmountUtils.getEntryAmount(dataModel, "expenseentryentity", "expeapprovecurramount");
        BigDecimal totalNotPayAmount = AmountUtils.getEntryAmount(dataModel, "accountentry", "accnotpayamount");
        BigDecimal payAmount = (BigDecimal)dataModel.getValue("payamount");
        BigDecimal totalPayedAmount = AmountUtils.getEntryAmount(dataModel, "accountentry", "accpayedamount");
        DynamicObjectCollection accCollection = dataModel.getDataEntity(true).getDynamicObjectCollection("accountentry");
        BigDecimal onaccountamount = BigDecimal.ZERO;
        if ("er_publicreimbursebill".equals(dataModel.getDataEntity().getString("formid"))) {
            for (int i = 0; i < accCollection.size(); ++i) {
                Boolean ispaynow = (Boolean)((DynamicObject)accCollection.get(i)).get("ispaynow");
                if (ispaynow.booleanValue()) continue;
                onaccountamount = onaccountamount.add((BigDecimal)((DynamicObject)accCollection.get(i)).get("receiveamount"));
            }
            dataModel.beginInit();
            dataModel.setValue("onaccountamount", (Object)onaccountamount);
            dataModel.endInit();
        }
        dataModel.beginInit();
        dataModel.setValue("reimburseamount", (Object)totalReimAmount);
        dataModel.setValue("approveamount", (Object)totalApproveAmount);
        dataModel.setValue("notpayamount", (Object)totalNotPayAmount);
        dataModel.setValue("payedamount", (Object)totalPayedAmount);
        if (dataModel.getProperty("totalaccloanamount") != null && dataModel.getProperty("curraccloanamount") != null) {
            dataModel.setValue("totalaccloanamount", (Object)AmountUtils.getEntryAmount(dataModel, "writeoffmoney", "curraccloanamount"));
        }
        dataModel.endInit();
    }

    public static void curCheckLoanAmountChange(Object propValue, int rowIndex, String writeOffType, IDataModel dataModel, IFormView view) {
        if (WriteOffTypeEnum.CURR_WO.getValue().equals(writeOffType)) {
            dataModel.beginInit();
            BigDecimal exchangeRate1 = (BigDecimal)dataModel.getValue("loanexchangerate", rowIndex);
            DynamicObject curWriteOffMoneyEntity = (DynamicObject)dataModel.getDataEntity(true).getDynamicObjectCollection("writeoffmoney").get(rowIndex);
            BigDecimal currAmount = BigDecimal.ZERO;
            String quoteType = StringUtils.isEmpty((String)"writeoffquotetype") || dataModel.getProperty("writeoffquotetype") == null ? "0" : (String)ObjectUtils.defaultIfNull((Object)((String)dataModel.getValue("writeoffquotetype", rowIndex)), (Object)"0");
            currAmount = StringUtils.equals((String)"0", (String)quoteType) ? ((BigDecimal)propValue).divide(exchangeRate1, AmountUtils.getAmountFieldPrecision(curWriteOffMoneyEntity, "accloanamount"), RoundingMode.HALF_UP) : ((BigDecimal)propValue).multiply(exchangeRate1).setScale(AmountUtils.getAmountFieldPrecision(curWriteOffMoneyEntity, "accloanamount"), RoundingMode.HALF_UP);
            dataModel.setValue("accloanamount", (Object)currAmount, rowIndex);
            dataModel.endInit();
            view.updateView("accloanamount", rowIndex);
        }
        WriteOffMoneyUtils.refreshEncashedAmount(writeOffType, dataModel, view);
    }

    public static void refreshEncashedAmount(String wirteOffType, IDataModel dataModel, IFormView view) {
        WriteOffMoneyUtils.refreshReceiveAmount(dataModel, wirteOffType, view);
        WriteOffMoneyUtils.showPayAmount(dataModel, (Label)view.getControl("totalencashamountlabel"));
        BigDecimal totalWriteOffAmount = AmountUtils.getEntryAmount(dataModel, "writeoffmoney", "curraccloanamount");
        dataModel.setValue("totalaccloanamount", (Object)totalWriteOffAmount);
    }

    public static void setIsOnAccount(IFormView view) {
        if (ErEntityTypeUtils.isPublicReimburseBill(view.getEntityId())) {
            IDataModel dataModel = view.getModel();
            DynamicObjectCollection accountEntry = dataModel.getEntryEntity("accountentry");
            double receiveAmountSum = accountEntry.stream().mapToDouble(account -> account.getBigDecimal("receiveamount").doubleValue()).sum();
            boolean isOnAccount = receiveAmountSum == 0.0 ? false : accountEntry.stream().anyMatch(r -> !r.getBoolean("ispaynow"));
            dataModel.setValue("isonaccount", (Object)isOnAccount);
        }
    }
}

