/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.invoicecloud.v2.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.formula.OutValue;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.entity.property.DecimalProp;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.er.business.invoicecloud.ItemFrom;
import kd.fi.er.business.js.ErContextFactory;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.business.utils.InvoiceUtils;
import kd.fi.er.common.model.invoice.ManualRuleFieldDTO;
import org.apache.commons.lang3.StringUtils;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class MergeExpenseUtil {
    private static final Log log = LogFactory.getLog(MergeExpenseUtil.class);
    private static final ErContextFactory contextFactory = new ErContextFactory();

    public static boolean canImportInvoice(IFormView view, String entryKey) {
        String itemFrom;
        Boolean isexistmonthly;
        EntryGrid expenseEntryGrid = (EntryGrid)view.getControl(entryKey);
        if (expenseEntryGrid == null) {
            return true;
        }
        int[] selectRowIndexArr = expenseEntryGrid.getSelectRows();
        if (selectRowIndexArr.length == 0) {
            return true;
        }
        DynamicObjectCollection entryEntity = view.getModel().getEntryEntity(entryKey);
        DynamicObject dynamicObject = (DynamicObject)entryEntity.get(selectRowIndexArr[0]);
        if (dynamicObject.containsProperty("isexistmonthly") && (isexistmonthly = Boolean.valueOf(dynamicObject.getBoolean("isexistmonthly"))).booleanValue()) {
            view.showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u8d39\u7528\u5206\u5f55\u884c\u5df2\u5173\u8054\u5546\u65c5\u8ba2\u5355\uff0c\u8bf7\u9009\u62e9\u6216\u65b0\u5efa\u5176\u4ed6\u8d39\u7528\u5206\u5f55\u884c\u518d\u8fdb\u884c\u5bfc\u5165\u53d1\u7968\u64cd\u4f5c\u3002", (String)"MergeExpenseUtil_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (dynamicObject.containsProperty("itemfrom") && StringUtils.isNotEmpty((CharSequence)(itemFrom = dynamicObject.getString("itemfrom"))) && ItemFrom.InvoiceCloud.getValue().equals(itemFrom)) {
            if (dynamicObject.getBoolean("invoicefromparent")) {
                view.showTipNotification(String.format(ResManager.loadKDString((String)"\u62c6\u5206\u8fc7\u7684\u8d39\u7528\u660e\u7ec6\uff08\u5df2\u5173\u8054\u53d1\u7968\uff09\uff0c\u4e0d\u652f\u6301\u8fdb\u884c\u518d\u6b21\u5bfc\u5165\u53d1\u7968\u3002", (String)"MergeExpenseOrTripDetailPlugin_22", (String)"fi-er-formplugin", (Object[])new Object[0]), new Object[0]));
                return false;
            }
            String pkValue = dynamicObject.getPkValue().toString();
            boolean hasSon = entryEntity.stream().anyMatch(entity -> pkValue.equals(entity.getString("splitline")) && entity.getBoolean("invoicefromparent"));
            if (hasSon) {
                view.showTipNotification(String.format(ResManager.loadKDString((String)"\u62c6\u5206\u8fc7\u7684\u8d39\u7528\u660e\u7ec6\uff08\u5df2\u5173\u8054\u53d1\u7968\uff09\uff0c\u4e0d\u652f\u6301\u8fdb\u884c\u518d\u6b21\u5bfc\u5165\u53d1\u7968\u3002", (String)"MergeExpenseOrTripDetailPlugin_22", (String)"fi-er-formplugin", (Object[])new Object[0]), new Object[0]));
                return false;
            }
        }
        return true;
    }

    public static boolean canDeleteExpense(IFormView view, String entryKey, int[] rowIndexs) {
        Boolean canMerge = (Boolean)ThreadCache.get((Object)"canMerge");
        Boolean canDeleteInvoice = (Boolean)ThreadCache.get((Object)"canDeleteInvoice");
        if (canMerge != null && canMerge.booleanValue() || canDeleteInvoice != null && canDeleteInvoice.booleanValue()) {
            return true;
        }
        ArrayList<Object> selectRows = new ArrayList<Object>(rowIndexs.length);
        view.getModel().updateCache();
        DynamicObjectCollection entryEntity = view.getModel().getEntryEntity(entryKey);
        if (entryEntity == null) {
            return false;
        }
        for (int index : rowIndexs) {
            selectRows.add(entryEntity.get(index));
        }
        if (entryEntity.getDynamicObjectType().getProperty("splitline") != null) {
            Set pkValueSet = selectRows.stream().map(select -> select.getPkValue().toString()).collect(Collectors.toSet());
            List leafFromParentObjects = entryEntity.stream().filter(entity -> pkValueSet.contains(entity.getString("splitline")) && entity.getBoolean("invoicefromparent")).collect(Collectors.toList());
            if (!selectRows.containsAll(leafFromParentObjects) && !leafFromParentObjects.isEmpty()) {
                String seq = leafFromParentObjects.stream().map(dynamicObject -> dynamicObject.getString("seq")).collect(Collectors.joining(","));
                view.showTipNotification(String.format(ResManager.loadKDString((String)"\u62c6\u5206\u8fc7\u7684\u8d39\u7528\u660e\u7ec6\uff08\u5df2\u5173\u8054\u53d1\u7968\uff09\u4e0d\u53ef\u5220\u9664\uff0c\u8bf7\u5148\u5220\u9664\u7b2c%s\u884c\u8d39\u7528\u660e\u7ec6\u3002", (String)"MergeExpenseOrTripDetailPlugin_20", (String)"fi-er-formplugin", (Object[])new Object[0]), seq));
                return false;
            }
        }
        return true;
    }

    public static boolean canDeleteInvoice(IFormView view, String entryKey, int[] rowIndexs) {
        boolean existFromParent;
        EntryGrid invoiceEntryGrid = (EntryGrid)view.getControl("invoiceentry");
        if (invoiceEntryGrid == null) {
            return true;
        }
        if (rowIndexs.length == 0) {
            return true;
        }
        IDataModel model = view.getModel();
        HashSet<Long> selectInvoiceIds = new HashSet<Long>(rowIndexs.length);
        DynamicObjectCollection invoiceEntry = model.getEntryEntity("invoiceentry");
        for (int index : rowIndexs) {
            selectInvoiceIds.add((Long)((DynamicObject)invoiceEntry.get(index)).getPkValue());
        }
        IDataEntityProperty autoInvoice = model.getProperty("automapinvoice");
        if (autoInvoice == null) {
            return true;
        }
        boolean auto = (Boolean)model.getValue("automapinvoice");
        List<Long> expenseEntryId = auto ? InvoiceUtils.getAutoItemIdByInvoiceHeadIds(model, selectInvoiceIds, entryKey) : InvoiceUtils.getNonAutoItemIdByInvoiceHeadIds(model, selectInvoiceIds);
        if (CollectionUtils.isEmpty(expenseEntryId)) {
            return true;
        }
        DynamicObjectCollection expenseEntry = model.getEntryEntity(entryKey);
        List objectList = expenseEntry.stream().filter(expense -> expenseEntryId.contains(expense.getPkValue())).collect(Collectors.toList());
        DynamicProperty property = expenseEntry.getDynamicObjectType().getProperty("invoicefromparent");
        boolean bl = existFromParent = property == null ? false : objectList.stream().anyMatch(dynamicObject -> dynamicObject.getBoolean("invoicefromparent"));
        if (existFromParent) {
            String seq = objectList.stream().filter(obj -> obj.getBoolean("invoicefromparent")).map(dynamicObject -> dynamicObject.getString("seq")).collect(Collectors.joining(","));
            view.showTipNotification(String.format(ResManager.loadKDString((String)"\u8be5\u53d1\u7968\u5173\u8054\u7684\u8d39\u7528\u660e\u7ec6\u5df2\u62c6\u5206\uff0c\u4e0d\u80fd\u5220\u9664\uff0c\u8bf7\u5148\u5220\u9664\u7b2c%s\u884c\u8d39\u7528\u660e\u7ec6\u3002", (String)"MergeExpenseOrTripDetailPlugin_21", (String)"fi-er-formplugin", (Object[])new Object[0]), seq));
            return false;
        }
        return true;
    }

    public static boolean canSplit(IFormView view, String entryKey) {
        Boolean isexistmonthly;
        EntryGrid expenseEntryGrid = (EntryGrid)view.getControl(entryKey);
        if (expenseEntryGrid == null) {
            return false;
        }
        int[] selectedExpenseEntryRowsArr = expenseEntryGrid.getSelectRows();
        List selectedExpenseEntryRows = Arrays.stream(selectedExpenseEntryRowsArr).boxed().collect(Collectors.toList());
        if (selectedExpenseEntryRows.size() != 1) {
            view.showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u884c\u8fdb\u884c\u62c6\u5206\u3002", (String)"MergeExpenseOrTripDetailPlugin_14", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return false;
        }
        IDataModel model = view.getModel();
        if (model.getEntryEntity(entryKey) == null) {
            return false;
        }
        DynamicObject dynamicObject = (DynamicObject)model.getEntryEntity(entryKey).get(((Integer)selectedExpenseEntryRows.get(0)).intValue());
        if (ErEntityTypeUtils.isTripReimburseBill(view.getEntityId()) && dynamicObject != null && dynamicObject.get("ordernum") != null && dynamicObject.get("ordernum").toString().length() > 1) {
            view.showTipNotification(ResManager.loadKDString((String)"\u5173\u8054\u5546\u65c5\u8ba2\u5355\u7684\u5206\u5f55\u884c\u4e0d\u652f\u6301\u62c6\u5206\u3002", (String)"MergeExpenseOrTripDetailPlugin_15", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (dynamicObject != null && dynamicObject.containsProperty("isexistmonthly") && (isexistmonthly = Boolean.valueOf(dynamicObject.getBoolean("isexistmonthly"))).booleanValue()) {
            view.showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u8d39\u7528\u5206\u5f55\u884c\u5df2\u5173\u8054\u5546\u65c5\u8ba2\u5355\uff0c\u8bf7\u9009\u62e9\u6216\u65b0\u5efa\u5176\u4ed6\u8d39\u7528\u5206\u5f55\u884c\u518d\u8fdb\u884c\u62c6\u5206\u64cd\u4f5c\u3002", (String)"MergeExpenseUtil_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (dynamicObject != null && dynamicObject.containsProperty("invoicefromparent") && dynamicObject.getBoolean("invoicefromparent")) {
            view.showTipNotification(ResManager.loadKDString((String)"\u62c6\u5206\u8fc7\u7684\u660e\u7ec6\uff08\u5df2\u5173\u8054\u53d1\u7968\uff09\uff0c\u4e0d\u652f\u6301\u518d\u6b21\u8fdb\u884c\u62c6\u5206\u3002", (String)"MergeExpenseOrTripDetailPlugin_19", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public static boolean canMerge(IFormView view, String entryKey) {
        Boolean canMerge;
        IDataModel model = view.getModel();
        DynamicObjectCollection expenseEntryDOs = model.getEntryEntity(entryKey);
        EntryGrid expenseEntryGrid = (EntryGrid)view.getControl(entryKey);
        if (expenseEntryGrid == null) {
            return false;
        }
        int[] selectedExpenseEntryRowsArr = expenseEntryGrid.getSelectRows();
        ArrayList<Object> selectRow = new ArrayList<Object>(selectedExpenseEntryRowsArr.length);
        for (int index : selectedExpenseEntryRowsArr) {
            selectRow.add(expenseEntryDOs.get(index));
        }
        if (expenseEntryDOs.getDynamicObjectType().getProperty("isexistmonthly") != null && selectRow.stream().anyMatch(v -> v.getBoolean("isexistmonthly"))) {
            view.showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u8d39\u7528\u5206\u5f55\u884c\u5df2\u5173\u8054\u5546\u65c5\u8ba2\u5355\uff0c\u8bf7\u9009\u62e9\u6216\u65b0\u5efa\u5176\u4ed6\u8d39\u7528\u5206\u5f55\u884c\u518d\u8fdb\u884c\u5408\u5e76\u64cd\u4f5c\u3002", (String)"MergeExpenseUtil_2", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (expenseEntryDOs.getDynamicObjectType().getProperty("itemfrom") != null) {
            boolean hasExpenseEntryWithoutInvoice = selectRow.stream().anyMatch(dynamicObject -> !StringUtils.equals((CharSequence)dynamicObject.getString("itemfrom"), (CharSequence)ItemFrom.InvoiceCloud.getValue()));
            if (hasExpenseEntryWithoutInvoice) {
                if (ErEntityTypeUtils.isTripReimburseBill(view.getEntityId())) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5df2\u5173\u8054\u53d1\u7968\u7684\u5dee\u65c5\u660e\u7ec6\u8fdb\u884c\u5408\u5e76\u64cd\u4f5c\u3002", (String)"ImportInvoiceForDailyReimPCPlugin_4", (String)"fi-er-formplugin", (Object[])new Object[0]));
                } else {
                    view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5df2\u5173\u8054\u53d1\u7968\u7684\u8d39\u7528\u660e\u7ec6\u8fdb\u884c\u5408\u5e76\u64cd\u4f5c\u3002", (String)"ImportInvoiceForDailyReimPCPlugin_2", (String)"fi-er-formplugin", (Object[])new Object[0]));
                }
                return false;
            }
            Set expenseEntryIds = selectRow.stream().map(dynamicObject -> dynamicObject.getBoolean("invoicefromparent") ? Long.valueOf(dynamicObject.getString("splitline")) : (Long)dynamicObject.getPkValue()).collect(Collectors.toSet());
            if (expenseEntryIds.size() > 1) {
                boolean allParent = selectRow.stream().allMatch(dynamicObject -> !dynamicObject.getBoolean("invoicefromparent"));
                if (!allParent) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u62c6\u5206\u8fc7\u7684\u8d39\u7528\u660e\u7ec6\uff08\u5df2\u5173\u8054\u4e0d\u540c\u53d1\u7968\uff09\u4e0d\u5141\u8bb8\u5408\u5e76\u3002", (String)"MergeExpenseOrTripDetailPlugin_23", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    return false;
                }
                boolean hasSon = expenseEntryDOs.stream().anyMatch(dynamicObject -> dynamicObject.getBoolean("invoicefromparent") && expenseEntryIds.contains(Long.parseLong(dynamicObject.getString("splitline"))));
                if (hasSon) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u62c6\u5206\u8fc7\u7684\u8d39\u7528\u660e\u7ec6\uff08\u5df2\u5173\u8054\u4e0d\u540c\u53d1\u7968\uff09\u4e0d\u5141\u8bb8\u5408\u5e76\u3002", (String)"MergeExpenseOrTripDetailPlugin_23", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    return false;
                }
            }
        }
        if ((canMerge = MergeExpenseUtil.mergeRule(view, entryKey)).booleanValue()) {
            ThreadCache.put((Object)"canMerge", (Object)true);
        }
        return canMerge;
    }

    private static Boolean mergeRule(IFormView view, String entryKey) {
        boolean trip2travelers;
        boolean entrycurrency;
        Set invoiceCodeList;
        Set invoicetypeList;
        boolean expenseitemBool;
        boolean costcenterBolean;
        boolean costDeptBool;
        IDataModel model = view.getModel();
        String billType = model.getDataEntity().getDynamicObjectType().getName();
        DynamicObject rule = MergeExpenseUtil.getRule(billType);
        if (Objects.isNull(rule)) {
            return true;
        }
        EntryGrid expenseEntryGrid = (EntryGrid)view.getControl(entryKey);
        int[] selectedExpenseEntryRowsArr = expenseEntryGrid.getSelectRows();
        List selectedExpenseEntryRows = Arrays.stream(selectedExpenseEntryRowsArr).boxed().collect(Collectors.toList());
        if (selectedExpenseEntryRows == null || selectedExpenseEntryRows.size() <= 1) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u52fe\u90092\u884c\u62162\u884c\u4ee5\u4e0a\u5408\u5e76\u3002", (String)"ImportInvoiceForDailyReimPCPlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return false;
        }
        DynamicObjectCollection totalEntity = model.getEntryEntity(entryKey);
        List<DynamicObject> collect = selectedExpenseEntryRows.stream().map(it -> (DynamicObject)totalEntity.get(it.intValue())).collect(Collectors.toList());
        boolean entrycostcompany = rule.getBoolean("entrycostcompany");
        if (entrycostcompany) {
            String costcompany;
            if (model.getProperty("travelcostcompany") != null) {
                costcompany = "travelcostcompany";
            } else if (model.getProperty("entrycostcompany") != null) {
                costcompany = "entrycostcompany";
            } else {
                return true;
            }
            if (collect.stream().map(it -> it.get(costcompany)).distinct().count() > 1L) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8d39\u7528\u627f\u62c5\u516c\u53f8\u76f8\u540c\uff0c\u65b9\u53ef\u5408\u5e76\u3002", (String)"MergeExpenseOrTripDetailPlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
                return false;
            }
        }
        if (costDeptBool = rule.getBoolean("entrycostdept")) {
            String costDept;
            if (model.getProperty("travelcostdept") != null) {
                costDept = "travelcostdept";
            } else if (model.getProperty("entrycostdept") != null) {
                costDept = "entrycostdept";
            } else {
                return true;
            }
            if (collect.stream().map(it -> it.get(costDept)).distinct().count() > 1L) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8d39\u7528\u627f\u62c5\u90e8\u95e8\u76f8\u540c\uff0c\u65b9\u53ef\u5408\u5e76\u3002", (String)"MergeExpenseOrTripDetailPlugin_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
                return false;
            }
        }
        if (costcenterBolean = rule.getBoolean("costcenter")) {
            String travelcostcenter;
            if (model.getProperty("travelcostcenter") != null) {
                travelcostcenter = "travelcostcenter";
            } else if (model.getProperty("std_entrycostcenter") != null) {
                travelcostcenter = "std_entrycostcenter";
            } else {
                return true;
            }
            if (collect.stream().map(it -> it.get(travelcostcenter)).distinct().count() > 1L) {
                view.showTipNotification(ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u76f8\u540c\uff0c\u65b9\u53ef\u5408\u5e76\u3002", (String)"MergeExpenseOrTripDetailPlugin_3", (String)"fi-er-formplugin", (Object[])new Object[0]));
                return false;
            }
        }
        if (expenseitemBool = rule.getBoolean("expenseitem")) {
            String expenseitem;
            if (model.getProperty("travelexpenseitem") != null) {
                expenseitem = "travelexpenseitem";
            } else if (model.getProperty("expenseitem") != null) {
                expenseitem = "expenseitem";
            } else {
                return true;
            }
            if (collect.stream().map(it -> it.get(expenseitem)).distinct().count() > 1L) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8d39\u7528\u9879\u76ee\u76f8\u540c\uff0c\u65b9\u53ef\u5408\u5e76\u3002", (String)"MergeExpenseOrTripDetailPlugin_2", (String)"fi-er-formplugin", (Object[])new Object[0]));
                return false;
            }
        }
        boolean invoicetype = rule.getBoolean("invoicetype");
        DynamicObjectCollection invoiceItemEntryDOs = model.getEntryEntity("invoiceitementry");
        DynamicObjectCollection invoiceentry = model.getEntryEntity("invoiceentry");
        List collectPrimaryId = collect.stream().map(it -> it.getPkValue()).collect(Collectors.toList());
        List objectList = invoiceItemEntryDOs.stream().filter(it -> collectPrimaryId.contains(it.get("itementryid"))).map(it -> it.get("invoiceheadentryid")).collect(Collectors.toList());
        if (invoicetype && (invoicetypeList = invoiceentry.stream().filter(ite -> objectList.contains(ite.getPkValue())).map(ite -> ite.get("invoicetype")).collect(Collectors.toSet())).size() > 1) {
            view.showTipNotification(ResManager.loadKDString((String)"\u53d1\u7968\u7c7b\u578b\u76f8\u540c\uff0c\u65b9\u53ef\u5408\u5e76\u3002", (String)"MergeExpenseOrTripDetailPlugin_4", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return false;
        }
        boolean offset = rule.getBoolean("offset");
        if (offset && collect.stream().map(it -> it.get("offset")).distinct().count() > 1L) {
            view.showTipNotification(ResManager.loadKDString((String)"\u201c\u53ef\u62b5\u6263\u201d\u76f8\u540c\uff0c\u65b9\u53ef\u5408\u5e76\u3002", (String)"MergeExpenseOrTripDetailPlugin_5", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return false;
        }
        boolean invoice = rule.getBoolean("invoice");
        if (invoice && (invoiceCodeList = invoiceentry.stream().filter(ite -> objectList.contains(ite.getPkValue())).map(ite -> ite.get("invoicecode") + "-" + ite.get("invoiceno")).collect(Collectors.toSet())).size() > 1) {
            view.showTipNotification(ResManager.loadKDString((String)"\u53d1\u7968\u76f8\u540c\uff0c\u65b9\u53ef\u5408\u5e76\u3002", (String)"MergeExpenseOrTripDetailPlugin_6", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return false;
        }
        boolean taxrate = rule.getBoolean("taxrate");
        if (taxrate) {
            DecimalProp taxRateProp = (DecimalProp)model.getProperty("taxrate");
            if (collect.stream().map(it -> it.getBigDecimal("taxrate").setScale(taxRateProp.getScale())).distinct().count() > 1L) {
                view.showTipNotification(ResManager.loadKDString((String)"\u7a0e\u7387\u76f8\u540c\uff0c\u65b9\u53ef\u5408\u5e76\u3002", (String)"MergeExpenseOrTripDetailPlugin_17", (String)"fi-er-formplugin", (Object[])new Object[0]));
                return false;
            }
        }
        if (ErEntityTypeUtils.isTripReimburseBill(view.getEntityId())) {
            boolean tripitem = rule.getBoolean("tripitem");
            if (tripitem && collect.stream().map(it -> it.get("expenseitem")).distinct().count() > 1L) {
                view.showTipNotification(ResManager.loadKDString((String)"\u5dee\u65c5\u9879\u76ee\u76f8\u540c\uff0c\u65b9\u53ef\u5408\u5e76\u3002", (String)"MergeExpenseOrTripDetailPlugin_10", (String)"fi-er-formplugin", (Object[])new Object[0]));
                return false;
            }
            boolean trip2from = rule.getBoolean("trip2from");
            if (trip2from && collect.stream().map(it -> it.get("trip2from")).distinct().count() > 1L) {
                view.showTipNotification(ResManager.loadKDString((String)"\u51fa\u53d1\u5730\u76f8\u540c\uff0c\u65b9\u53ef\u5408\u5e76\u3002", (String)"MergeExpenseOrTripDetailPlugin_11", (String)"fi-er-formplugin", (Object[])new Object[0]));
                return false;
            }
            boolean trip2to = rule.getBoolean("trip2to");
            if (trip2to && collect.stream().map(it -> it.get("trip2to")).distinct().count() > 1L) {
                view.showTipNotification(ResManager.loadKDString((String)"\u76ee\u7684\u5730\u76f8\u540c\uff0c\u65b9\u53ef\u5408\u5e76\u3002", (String)"MergeExpenseOrTripDetailPlugin_12", (String)"fi-er-formplugin", (Object[])new Object[0]));
                return false;
            }
            boolean triptime = rule.getBoolean("triptime");
            if (triptime && (collect.stream().map(it -> it.get("trip2startdate")).distinct().count() > 1L || collect.stream().map(it -> it.get("trip2enddate")).distinct().count() > 1L)) {
                view.showTipNotification(ResManager.loadKDString((String)"\u884c\u7a0b\u671f\u95f4\u76f8\u540c\uff0c\u65b9\u53ef\u5408\u5e76\u3002", (String)"MergeExpenseOrTripDetailPlugin_13", (String)"fi-er-formplugin", (Object[])new Object[0]));
                return false;
            }
        }
        if ((entrycurrency = rule.getBoolean("entrycurrency")) && collect.stream().map(it -> it.get("entrycurrency")).distinct().count() > 1L) {
            view.showTipNotification(ResManager.loadKDString((String)"\u5e01\u79cd\u76f8\u540c\uff0c\u65b9\u53ef\u5408\u5e76\u3002", (String)"MergeExpenseOrTripDetailPlugin_7", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return false;
        }
        boolean reimburser = rule.getBoolean("reimburser");
        if (reimburser) {
            if (model.getProperty("reimburser") == null) {
                return true;
            }
            if (collect.stream().map(it -> it.get("reimburser")).distinct().count() > 1L) {
                view.showTipNotification(ResManager.loadKDString((String)"\u62a5\u9500\u4eba\u76f8\u540c\uff0c\u65b9\u53ef\u5408\u5e76\u3002", (String)"MergeExpenseOrTripDetailPlugin_8", (String)"fi-er-formplugin", (Object[])new Object[0]));
                return false;
            }
        }
        if (trip2travelers = rule.getBoolean("trip2travelers")) {
            if (model.getProperty("trip2travelers") == null) {
                return true;
            }
            Set<String> collectTrip = MergeExpenseUtil.getDistinctValue(collect, "trip2travelers");
            if (collectTrip.size() > 1) {
                view.showTipNotification(ResManager.loadKDString((String)"\u51fa\u5dee\u4eba\u76f8\u540c\uff0c\u65b9\u53ef\u5408\u5e76\u3002", (String)"MergeExpenseOrTripDetailPlugin_9", (String)"fi-er-formplugin", (Object[])new Object[0]));
                return false;
            }
        }
        if (rule.getBoolean("seatgrade")) {
            if (model.getProperty("seatgrade") == null) {
                return true;
            }
            Set<String> seatgrades = MergeExpenseUtil.getDistinctValue(collect, "mulseatgrade");
            if (seatgrades.size() > 1) {
                view.showTipNotification(ResManager.loadKDString((String)"\u5ea7\u4f4d\u7b49\u7ea7\u76f8\u540c\uff0c\u624d\u80fd\u5408\u5e76\u3002", (String)"MergeExpenseOrTripDetailPlugin_18", (String)"fi-er-formplugin", (Object[])new Object[0]));
                return false;
            }
        }
        return MergeExpenseUtil.doExecuteJs(rule, view, entryKey, collect);
    }

    private static boolean doExecuteJs(DynamicObject rule, IFormView view, String entryKey, List<DynamicObject> collect) {
        String jsStr = rule.getString("js");
        if (StringUtils.isBlank((CharSequence)jsStr)) {
            return true;
        }
        Context context = contextFactory.makeContext();
        contextFactory.enterContext(context);
        ScriptableObject prototype = context.initStandardObjects();
        prototype.setParentScope(null);
        Scriptable scope = context.newObject((Scriptable)prototype);
        scope.setParentScope((Scriptable)prototype);
        ManualRuleFieldDTO manualRuleFieldDTO = MergeExpenseUtil.packageManualRuleBO(view);
        if (manualRuleFieldDTO == null) {
            return true;
        }
        RowDataModel rowModel = new RowDataModel(entryKey, view.getModel());
        for (DynamicObject row : collect) {
            rowModel.setRowContext(row);
            OutValue value = new OutValue();
            if (rowModel.tryGetValue(manualRuleFieldDTO.getTaxAmount(), value).booleanValue()) {
                scope.put(manualRuleFieldDTO.getTaxAmount(), scope, value.get());
            }
            String tmpJsStr = jsStr;
            tmpJsStr = MergeExpenseUtil.packageScopeObject(rowModel, scope, tmpJsStr, manualRuleFieldDTO.getCostCenter(), manualRuleFieldDTO.getCostCompany(), manualRuleFieldDTO.getCostDept(), manualRuleFieldDTO.getExpItem());
            if (ErEntityTypeUtils.isTripReimburseBill(view.getEntityId())) {
                tmpJsStr = MergeExpenseUtil.packageScopeObject(rowModel, scope, tmpJsStr, manualRuleFieldDTO.getTripItem());
            }
            try {
                Object result = context.evaluateString(scope, tmpJsStr, null, -1, null);
                if (!Boolean.FALSE.equals(result)) continue;
                view.showMessage(ResManager.loadKDString((String)"\u5408\u5e76\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u6ee1\u8db3\u624b\u5de5\u5408\u5e76\u89c4\u5219\u81ea\u5b9a\u4e49\u6761\u4ef6\u3002", (String)"MergeExpenseOrTripDetailPlugin_30", (String)"fi-er-formplugin", (Object[])new Object[0]));
                return false;
            }
            catch (Exception e) {
                view.showErrorNotification(String.format(ResManager.loadKDString((String)"%1$s\u81ea\u5b9a\u4e49\u6761\u4ef6\u89e3\u6790\u5f02\u5e38\u3002", (String)"MergeInvoiceServiceImpl_5", (String)"fi-er-business", (Object[])new Object[0]), rule.getLocaleString(2).getLocaleValue()));
                log.error((Throwable)e);
                return false;
            }
        }
        return true;
    }

    private static String packageScopeObject(RowDataModel rowModel, Scriptable scope, String jsStr, ManualRuleFieldDTO.BaseDataFieldEnum ... baseDataFieldEnums) {
        String tmpJsStr = jsStr;
        for (ManualRuleFieldDTO.BaseDataFieldEnum baseDataFieldEnum : baseDataFieldEnums) {
            String fieldId = baseDataFieldEnum.getEntityIdInBill();
            if (fieldId == null) continue;
            OutValue value = new OutValue();
            Object obj = null;
            if (rowModel.tryGetValue(fieldId, value).booleanValue()) {
                obj = value.get();
            }
            if (obj instanceof DynamicObject) {
                scope.put(fieldId, scope, (Object)((DynamicObject)obj).getString(baseDataFieldEnum.getNumberName()));
            } else {
                scope.put(fieldId, scope, obj);
            }
            if (!tmpJsStr.contains(baseDataFieldEnum.getCompareName())) continue;
            tmpJsStr = tmpJsStr.replace(baseDataFieldEnum.getCompareName(), baseDataFieldEnum.getEntityIdInBill());
        }
        return tmpJsStr;
    }

    private static ManualRuleFieldDTO packageManualRuleBO(IFormView view) {
        String entityId = view.getEntityId();
        if (ErEntityTypeUtils.isTripReimburseBill(entityId)) {
            return new ManualRuleFieldDTO().setCostDept(ManualRuleFieldDTO.BaseDataFieldEnum.COST_DEPT.setEntityIdInBill("travelcostdept")).setCostCompany(ManualRuleFieldDTO.BaseDataFieldEnum.COST_COMPANY.setEntityIdInBill("travelcostcompany")).setCostCenter(ManualRuleFieldDTO.BaseDataFieldEnum.COST_CENTER.setEntityIdInBill("travelcostcenter")).setExpitem(ManualRuleFieldDTO.BaseDataFieldEnum.EXPENSE_ITEM.setEntityIdInBill("travelexpenseitem")).setTripItem(ManualRuleFieldDTO.BaseDataFieldEnum.TRIP_ITEM.setEntityIdInBill("expenseitem")).setTaxAmount("taxrate");
        }
        if (ErEntityTypeUtils.isDailyReimburseBill(entityId) || ErEntityTypeUtils.isPublicReimburseBill(entityId)) {
            return new ManualRuleFieldDTO().setCostDept(ManualRuleFieldDTO.BaseDataFieldEnum.COST_DEPT.setEntityIdInBill("entrycostdept")).setCostCompany(ManualRuleFieldDTO.BaseDataFieldEnum.COST_COMPANY.setEntityIdInBill("entrycostcompany")).setCostCenter(ManualRuleFieldDTO.BaseDataFieldEnum.COST_CENTER.setEntityIdInBill("std_entrycostcenter")).setExpitem(ManualRuleFieldDTO.BaseDataFieldEnum.EXPENSE_ITEM.setEntityIdInBill("expenseitem")).setTaxAmount("taxrate");
        }
        return null;
    }

    private static DynamicObject getRule(String type) {
        Map objectMap = BusinessDataServiceHelper.loadFromCache((String)"er_mergerulecfg", (QFilter[])new QFilter[0]);
        Set entries = objectMap.entrySet();
        for (Map.Entry item : entries) {
            DynamicObject dynamicObject = (DynamicObject)item.getValue();
            if (type == null || !type.equals(dynamicObject.getString("billtype"))) continue;
            return dynamicObject;
        }
        return null;
    }

    private static Set<String> getDistinctValue(List<DynamicObject> collect, String property) {
        Set<String> collectTrip = collect.stream().map(rowIndex -> {
            MulBasedataDynamicObjectCollection collection = (MulBasedataDynamicObjectCollection)rowIndex.get(property);
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < collection.size(); ++i) {
                DynamicObject item = (DynamicObject)collection.get(i);
                DynamicObject itemObj = item.getDynamicObject("fbasedataid");
                builder = builder.append(itemObj.getPkValue());
                builder = builder.append(",");
            }
            return builder.toString();
        }).collect(Collectors.toSet());
        return collectTrip;
    }
}

