/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.util;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjusters;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.MobileBillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.er.business.servicehelper.BaseCurrencyServiceHelper;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;
import kd.fi.er.business.servicehelper.PayeeServiceHelper;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.InvoiceOffsetUtils;
import kd.fi.er.business.utils.ReimburseControlUtils;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.common.constant.ErExpenseItemConstant;
import kd.fi.er.formplugin.daily.web.util.WriteOffMoneyUtils;
import kd.fi.er.formplugin.util.StreamUtil;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class AmountQueryAndReimburseUtils {
    private static Log logger = LogFactory.getLog(AmountQueryAndReimburseUtils.class);
    private static String COMPANYID = "companyId";
    private static String ORGID = "orgId";
    private static String SOURCE = "source";
    private static String EXPENSEITEMID = "expenseItemId";
    private static String BALANCEAMOUNT = "balanceamount";
    private static String CURRENCYID = "currencyId";
    private static String REPEAT = "repeat";
    private static String APPLIER_POSITION_TEXT = "applierpositionstr";
    private static String IS_MOB = "ismob";
    private static String HAPPEND_DATE = "happendate";
    private static String CUSTOM_REIMBURSE_CTL_COMPANY = "CUSTOM_REIMBURSE_CTL_COMPANY";

    private AmountQueryAndReimburseUtils() {
    }

    public static void createDailyReimburseByEmployeeReim(CreateDailyReimburseByEmployeeReimParam param) {
        AbstractFormPlugin formPlugin = param.formPlugin;
        Object userId = param.userId;
        Object companyId = param.companyId;
        Object currencyId = param.currencyId;
        Object expenseItemId = param.expenseItemId;
        BigDecimal balanceAmount = param.balanceAmount;
        HashMap customParams = Maps.newHashMap();
        customParams.put("userId", userId);
        DynamicObject employeeDOFromDB = BusinessDataServiceHelper.loadSingleFromCache((Object)userId, (String)"bos_user");
        Map<Long, String> deptIdToPosition = employeeDOFromDB.getDynamicObjectCollection("entryentity").stream().filter(StreamUtil.distinctByKey(entry -> entry.getDynamicObject("dpt").getPkValue())).collect(Collectors.toMap(entry -> (Long)entry.getDynamicObject("dpt").getPkValue(), entry -> entry.getString("position")));
        Set mainJobDepts = employeeDOFromDB.getDynamicObjectCollection("entryentity").stream().filter(entry -> !entry.getBoolean("ispartjob")).map(entry -> (Long)entry.getDynamicObject("dpt").getPkValue()).collect(Collectors.toSet());
        HashMap mainJobDeptToCompany = Maps.newHashMapWithExpectedSize((int)mainJobDepts.size());
        for (Long deptId : mainJobDepts) {
            Long companyIdByDept = CoreBaseBillServiceHelper.initCompanyByDept(deptId);
            if (companyIdByDept == null) continue;
            mainJobDeptToCompany.put(deptId, companyIdByDept);
        }
        Set partJobDepts = employeeDOFromDB.getDynamicObjectCollection("entryentity").stream().filter(entry -> entry.getBoolean("ispartjob")).map(entry -> (Long)entry.getDynamicObject("dpt").getPkValue()).collect(Collectors.toSet());
        HashMap partJobDeptToCompany = Maps.newHashMapWithExpectedSize((int)mainJobDepts.size());
        for (Long deptId : partJobDepts) {
            Long companyIdByDept = CoreBaseBillServiceHelper.initCompanyByDept(deptId);
            if (companyIdByDept == null) continue;
            partJobDeptToCompany.put(deptId, companyIdByDept);
        }
        Long deptId = null;
        Long applierCompanyId = null;
        if (!(mainJobDepts.isEmpty() || mainJobDeptToCompany.isEmpty() || "company".equals(ReimburseControlUtils.getPersonReimCtlCompanyField()))) {
            deptId = (Long)mainJobDepts.iterator().next();
            applierCompanyId = (Long)mainJobDeptToCompany.get(deptId);
        } else if ("company".equals(ReimburseControlUtils.getPersonReimCtlCompanyField())) {
            Map.Entry entry2;
            Optional<Object> entryOpt;
            if (!mainJobDepts.isEmpty() && !mainJobDeptToCompany.isEmpty() && mainJobDeptToCompany.containsValue(companyId)) {
                entryOpt = mainJobDeptToCompany.entrySet().stream().filter(entry -> Objects.equals(entry.getValue(), companyId)).findFirst();
                if (entryOpt.isPresent()) {
                    entry2 = (Map.Entry)entryOpt.get();
                    deptId = (Long)entry2.getKey();
                    applierCompanyId = (Long)entry2.getValue();
                }
            } else if (!partJobDepts.isEmpty() && !partJobDeptToCompany.isEmpty() && partJobDeptToCompany.containsValue(companyId)) {
                entryOpt = partJobDeptToCompany.entrySet().stream().filter(entry -> Objects.equals(entry.getValue(), companyId)).findFirst();
                if (entryOpt.isPresent()) {
                    entry2 = (Map.Entry)entryOpt.get();
                    deptId = (Long)entry2.getKey();
                    applierCompanyId = (Long)entry2.getValue();
                }
            } else {
                entryOpt = mainJobDeptToCompany.entrySet().stream().findFirst();
                if (entryOpt.isPresent()) {
                    entry2 = (Map.Entry)entryOpt.get();
                    deptId = (Long)entry2.getKey();
                    applierCompanyId = (Long)entry2.getValue();
                }
            }
        }
        if (!"company".equals(ReimburseControlUtils.getPersonReimCtlCompanyField())) {
            customParams.put(CUSTOM_REIMBURSE_CTL_COMPANY, companyId);
        }
        if (applierCompanyId != null && deptId != null) {
            customParams.put(COMPANYID, applierCompanyId);
            customParams.put(ORGID, deptId);
            customParams.put(APPLIER_POSITION_TEXT, deptIdToPosition.get(deptId));
        }
        customParams.put(SOURCE, "amountQueryReport");
        customParams.put(EXPENSEITEMID, expenseItemId);
        customParams.put(BALANCEAMOUNT, balanceAmount);
        customParams.put(CURRENCYID, currencyId);
        customParams.put(HAPPEND_DATE, param.happendDate);
        IFormView view = formPlugin.getView();
        BillShowParameter billParam = null;
        String entityName = formPlugin.getView().getEntityId();
        if (entityName.equals("er_employee_amount_query")) {
            billParam = new BillShowParameter();
            billParam.setParentFormId(view.getFormShowParameter().getParentFormId());
            billParam.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            billParam.setFormId("er_dailyreimbursebill");
            customParams.put(IS_MOB, "0");
        } else {
            billParam = new MobileBillShowParameter();
            billParam.setFormId("er_dailyreimbursebill_mob");
            billParam.getOpenStyle().setShowType(ShowType.Floating);
            customParams.put(IS_MOB, "1");
        }
        billParam.setStatus(OperationStatus.ADDNEW);
        billParam.setCustomParams((Map)customParams);
        view.showForm((FormShowParameter)billParam);
    }

    @Deprecated
    public static void showDailyReimburseBillPage(AbstractFormPlugin formPlugin, Object userId, Object companyId, Object currencyId, Object expenseItemId, BigDecimal balanceAmount) {
        CreateDailyReimburseByEmployeeReimParam param = new CreateDailyReimburseByEmployeeReimParam();
        param.setFormPlugin(formPlugin);
        param.setBalanceAmount(balanceAmount);
        param.setCompanyId(companyId);
        param.setCurrencyId(currencyId);
        param.setExpenseItemId(expenseItemId);
        Date lastDayOfLastMonth = ErCommonUtils.getDateFromLocalDate(LocalDate.now().minusMonths(1L).with(TemporalAdjusters.lastDayOfMonth()));
        param.setHappendDate(lastDayOfLastMonth);
        param.setUserId(userId);
        AmountQueryAndReimburseUtils.createDailyReimburseByEmployeeReim(param);
    }

    public static void createDailyReimburseByDeptReim(CreateDailyReimburseByDeptReimParam param) {
        DynamicObject employeeDOFromDB;
        Set deptPostText;
        AbstractFormPlugin formPlugin = param.formPlugin;
        Object userId = param.userId;
        Object deptId = param.deptId;
        Object companyId = param.companyId;
        Object currencyId = param.currencyId;
        Object expenseItemId = param.expenseItemId;
        BigDecimal balanceAmount = param.balanceAmount;
        HashMap customParams = Maps.newHashMap();
        customParams.put("userId", userId);
        customParams.put(COMPANYID, companyId);
        customParams.put(ORGID, deptId);
        customParams.put(SOURCE, "amountQueryReport");
        customParams.put(EXPENSEITEMID, expenseItemId);
        customParams.put(BALANCEAMOUNT, balanceAmount);
        customParams.put(CURRENCYID, currencyId);
        customParams.put(HAPPEND_DATE, param.happendDate);
        if (!"company".equals(ReimburseControlUtils.getPersonReimCtlCompanyField())) {
            customParams.put(CUSTOM_REIMBURSE_CTL_COMPANY, companyId);
        }
        if ((deptPostText = (employeeDOFromDB = BusinessDataServiceHelper.loadSingleFromCache((Object)userId, (String)"bos_user")).getDynamicObjectCollection("entryentity").stream().filter(entry -> com.google.common.base.Objects.equal((Object)entry.getDynamicObject("dpt").getPkValue(), (Object)deptId)).map(entry -> entry.getString("position")).collect(Collectors.toSet())) == null || deptPostText.isEmpty()) {
            deptPostText = employeeDOFromDB.getDynamicObjectCollection("entryentity").stream().filter(entry -> !entry.getBoolean("ispartjob")).map(entry -> entry.getString("position")).collect(Collectors.toSet());
        }
        customParams.put(APPLIER_POSITION_TEXT, deptPostText.iterator().next());
        IFormView view = formPlugin.getView();
        BillShowParameter billParam = null;
        String entityName = formPlugin.getView().getEntityId();
        if (entityName.equals("er_employee_dept_query")) {
            billParam = new BillShowParameter();
            billParam.setParentFormId(view.getFormShowParameter().getParentFormId());
            billParam.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            billParam.setFormId("er_dailyreimbursebill");
            customParams.put(IS_MOB, "0");
        } else {
            billParam = new MobileBillShowParameter();
            billParam.setFormId("er_dailyreimbursebill_mob");
            billParam.getOpenStyle().setShowType(ShowType.Floating);
            customParams.put(IS_MOB, "1");
        }
        billParam.setStatus(OperationStatus.ADDNEW);
        billParam.setCustomParams((Map)customParams);
        view.showForm((FormShowParameter)billParam);
    }

    @Deprecated
    public static void showDailyReimburseBillPage(AbstractFormPlugin formPlugin, Object userId, Object deptId, Object companyId, Object currencyId, Object expenseItemId, BigDecimal balanceAmount) {
        CreateDailyReimburseByDeptReimParam param = new CreateDailyReimburseByDeptReimParam();
        param.setFormPlugin(formPlugin);
        param.setBalanceAmount(balanceAmount);
        param.setCompanyId(companyId);
        param.setCurrencyId(currencyId);
        param.setExpenseItemId(expenseItemId);
        Date lastDayOfLastMonth = ErCommonUtils.getDateFromLocalDate(LocalDate.now().minusMonths(1L).with(TemporalAdjusters.lastDayOfMonth()));
        param.setHappendDate(lastDayOfLastMonth);
        param.setUserId(userId);
        param.setDeptId(deptId);
        AmountQueryAndReimburseUtils.createDailyReimburseByDeptReim(param);
    }

    public static void setExpenseInfoFromQueryAmount(AbstractBillPlugIn plugIn) {
        IFormView view = plugIn.getView();
        IDataModel model = view.getModel();
        Map customParams = view.getFormShowParameter().getCustomParams();
        if (customParams != null) {
            String source;
            if (model.getValue("company") == null) {
                view.showErrorNotification(ResManager.loadKDString((String)"\u7533\u8bf7\u4eba\u516c\u53f8\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8bbe\u7f6e\u3002", (String)"AmountQueryAndReimburseUtils_0", (String)"fi-er-business", (Object[])new Object[0]));
                view.setVisible(Boolean.valueOf(false), new String[]{"mtoolbarap"});
                return;
            }
            String string = source = customParams.get(SOURCE) == null ? "" : customParams.get(SOURCE).toString();
            if (StringUtils.equals((CharSequence)source, (CharSequence)"amountQueryReport") && plugIn.getPageCache().get(REPEAT) == null) {
                Object expenseItemId = customParams.get(EXPENSEITEMID);
                BigDecimal balanceamount = BigDecimal.ZERO;
                Object balanceamountRaw = customParams.get(BALANCEAMOUNT);
                if (balanceamountRaw != null) {
                    balanceamount = new BigDecimal(balanceamountRaw.toString());
                }
                DynamicObject expenseItem = CommonServiceHelper.getObjById("er_expenseitemedit", Long.valueOf(String.valueOf(expenseItemId)));
                int rows = model.getEntryRowCount("expenseentryentity");
                if (rows < 1) {
                    model.createNewEntryRow("expenseentryentity");
                }
                if (rows > 0) {
                    String isMob;
                    DynamicObject defaultAccount;
                    Object companyId = customParams.get(COMPANYID);
                    Object deptId = customParams.get(ORGID);
                    if (customParams.containsKey(COMPANYID) && customParams.containsKey(ORGID)) {
                        model.setValue("company", companyId);
                        model.setValue("org", deptId);
                    }
                    if (model.getEntryRowCount("expenseentryentity") < 1) {
                        model.createNewEntryRow("expenseentryentity");
                    }
                    if (customParams.containsKey(CUSTOM_REIMBURSE_CTL_COMPANY)) {
                        model.setValue(ReimburseControlUtils.getPersonReimCtlCompanyField(), customParams.get(CUSTOM_REIMBURSE_CTL_COMPANY));
                    }
                    if (expenseItem.getString("reimburseamountctlmethod").equals(ErExpenseItemConstant.ReimburseAmountCtlMethod.Monthly.getValue()) || expenseItem.getString("reimburseamountctlmethod").equals(ErExpenseItemConstant.ReimburseAmountCtlMethod.MonthlyAndIndex.getValue())) {
                        model.setValue("happendate", customParams.get(HAPPEND_DATE), 0);
                    }
                    Long currencyId = Long.valueOf(customParams.get(CURRENCYID).toString());
                    int expenseEntryCount = model.getEntryRowCount("expenseentryentity");
                    for (int i = 0; i < expenseEntryCount; ++i) {
                        model.setValue("entrycurrency", (Object)currencyId, i);
                    }
                    Long accountCurrencyId = currencyId;
                    String isgetaccountcurrency = SystemParamterUtil.isgetaccountcurrency(Long.parseLong(companyId.toString()));
                    if (customParams.get("userId") == null) {
                        logger.info("AmountQueryAndReimburseUtils.setExpenseInfoFromQueryAmount: userId is null");
                    }
                    if ("1".equals(isgetaccountcurrency) && customParams.get("userId") != null && (defaultAccount = PayeeServiceHelper.getDefaultAccount(Long.parseLong(customParams.get("userId").toString()))) != null && defaultAccount.get("currency") != null) {
                        DynamicObject payerCurrency = (DynamicObject)defaultAccount.get("currency");
                        accountCurrencyId = (Long)payerCurrency.getPkValue();
                    }
                    int accountEntryCount = model.getEntryRowCount("accountentry");
                    for (int i = 0; i < accountEntryCount; ++i) {
                        model.setValue("accountcurrency", (Object)accountCurrencyId, i);
                    }
                    model.setValue("expenseitem", expenseItemId, 0);
                    model.setValue("expenseamount", (Object)balanceamount, 0);
                    model.setValue("reimburser", model.getValue("applier"), 0);
                    model.setValue("description", ((DynamicObject)model.getValue("expenseitem")).get("name"));
                    if (customParams.containsKey(COMPANYID) && customParams.containsKey(ORGID)) {
                        String postStr = (String)customParams.get(APPLIER_POSITION_TEXT);
                        if (StringUtils.isNotBlank((CharSequence)postStr)) {
                            model.setValue("applierpositionstr", (Object)postStr);
                            if (view.getControl("applierpositionv") != null) {
                                ((Label)view.getControl("applierpositionv")).setText(postStr);
                            }
                        }
                        Long deptIdLong = Long.valueOf(deptId.toString());
                        Long cost_companyID = CoreBaseBillServiceHelper.getAccountOrgId(deptIdLong);
                        model.setValue("costcompany", (Object)cost_companyID, 0);
                        model.setValue("costdept", deptId, 0);
                        model.setValue("entrycostcompany", (Object)cost_companyID, 0);
                        model.setValue("entrycostdept", deptId, 0);
                        Long baseCurrencyId = BaseCurrencyServiceHelper.getBaseCurrencyId(Long.valueOf(companyId.toString()));
                        if (baseCurrencyId == null || currencyId != null && !currencyId.equals(baseCurrencyId)) {
                            model.setValue("iscurrency", (Object)true);
                            Map<String, Object> exchangeRateAndQuoteType = CommonServiceHelper.getExchangeRateFromSysParams(Long.valueOf(companyId.toString()), cost_companyID, currencyId, baseCurrencyId, model);
                            BigDecimal exchangeRate = (BigDecimal)ObjectUtils.defaultIfNull((Object)((BigDecimal)exchangeRateAndQuoteType.get("exchangeRate")), (Object)BigDecimal.ONE);
                            String expQuoteType = (String)ObjectUtils.defaultIfNull((Object)((String)exchangeRateAndQuoteType.get("quoteType")), (Object)"0");
                            BigDecimal baseCurrencyReimAmount = null;
                            baseCurrencyReimAmount = StringUtils.equals((CharSequence)"1", (CharSequence)expQuoteType) ? balanceamount.divide(exchangeRate, 4, RoundingMode.HALF_UP) : balanceamount.multiply(exchangeRate).setScale(4, RoundingMode.HALF_UP);
                            model.setValue("expquotetype", (Object)expQuoteType, 0);
                            model.setValue("exchangerate", (Object)exchangeRate, 0);
                            model.setValue("currexpenseamount", (Object)baseCurrencyReimAmount, 0);
                            model.setValue("expeapprovecurramount", (Object)baseCurrencyReimAmount, 0);
                        }
                    }
                    if (StringUtils.equals((CharSequence)(isMob = (String)customParams.get(IS_MOB)), (CharSequence)"1")) {
                        Long companuIdLong = 0L;
                        if (companyId instanceof Integer) {
                            companuIdLong = Long.valueOf(companyId.toString());
                        }
                        if (companyId instanceof Long) {
                            companuIdLong = (Long)companyId;
                        }
                        AmountQueryAndReimburseUtils.setMobExpenseItem(model, expenseItem, companuIdLong, balanceamount);
                        String writeOffType = (String)model.getValue("writeofftype");
                        WriteOffMoneyUtils.refreshReceiveAmount(model, writeOffType, view);
                    }
                    plugIn.getPageCache().put(REPEAT, "1");
                    plugIn.getView().getModel().setDataChanged(false);
                }
                view.updateView();
            }
            customParams.put(SOURCE, "");
        }
    }

    public static void setMobExpenseItem(IDataModel model, DynamicObject expenseItem, Long company, BigDecimal balanceamount) {
        BigDecimal taxrate = expenseItem.getBigDecimal("taxrate");
        if (taxrate == null) {
            taxrate = BigDecimal.ZERO;
        }
        model.setValue("taxrate", (Object)taxrate, 0);
        BigDecimal expenseAmountAppOri = (BigDecimal)model.getValue("expeapproveamount", 0);
        BigDecimal expenseTaxrate = taxrate.divide(BigDecimal.valueOf(100L), 4, RoundingMode.HALF_EVEN);
        DynamicObject expenseCurrencyDO = (DynamicObject)model.getValue("entrycurrency", 0);
        int precision = expenseCurrencyDO == null ? 10 : expenseCurrencyDO.getInt("amtprecision");
        BigDecimal airportConstructionAmount = (BigDecimal)model.getValue("airportconstructionfee", 0);
        airportConstructionAmount = (BigDecimal)ObjectUtils.defaultIfNull((Object)airportConstructionAmount, (Object)BigDecimal.ZERO);
        BigDecimal taxAmount = expenseAmountAppOri.subtract(airportConstructionAmount).multiply(expenseTaxrate).divide(BigDecimal.ONE.add(expenseTaxrate), precision, RoundingMode.HALF_EVEN);
        BigDecimal noTaxAmount = expenseAmountAppOri.subtract(taxAmount);
        model.setValue("taxamount", (Object)taxAmount, 0);
        model.setValue("orientryamount", (Object)noTaxAmount, 0);
        Boolean offsetOfExpense = SystemParamterUtil.manuallyaddexpenseoffset(company);
        Boolean expenseOffset = expenseItem.getBoolean("offset");
        boolean isOrgOffset = InvoiceOffsetUtils.deductibleOfTaxPayer(model);
        if (isOrgOffset && offsetOfExpense.booleanValue() && expenseOffset.booleanValue()) {
            model.setValue("offset", (Object)expenseOffset, 0);
            model.setValue("deductibletax", (Object)taxAmount, 0);
        } else {
            model.setValue("offset", (Object)Boolean.FALSE, 0);
            model.setValue("deductibletax", (Object)BigDecimal.ZERO, 0);
        }
    }

    public static Date getHappendDateInReimCtlReport(ReportQueryParam queryParam) {
        FilterItemInfo filterItem = queryParam.getFilter().getFilterItem("month");
        Date happendDate = CommonServiceHelper.getLastDayOfLastMonthBy(new Date());
        if (filterItem != null && StringUtils.equals((CharSequence)filterItem.getString(), (CharSequence)"this_month")) {
            happendDate = new Date();
        }
        return happendDate;
    }

    public static class CreateDailyReimburseByDeptReimParam {
        private AbstractFormPlugin formPlugin;
        private Object userId;
        private Object deptId;
        private Object companyId;
        private Object currencyId;
        private Object expenseItemId;
        private BigDecimal balanceAmount;
        private Date happendDate;

        public AbstractFormPlugin getFormPlugin() {
            return this.formPlugin;
        }

        public void setFormPlugin(AbstractFormPlugin formPlugin) {
            this.formPlugin = formPlugin;
        }

        public Object getUserId() {
            return this.userId;
        }

        public void setUserId(Object userId) {
            this.userId = userId;
        }

        public Object getDeptId() {
            return this.deptId;
        }

        public void setDeptId(Object deptId) {
            this.deptId = deptId;
        }

        public Object getCompanyId() {
            return this.companyId;
        }

        public void setCompanyId(Object companyId) {
            this.companyId = companyId;
        }

        public Object getCurrencyId() {
            return this.currencyId;
        }

        public void setCurrencyId(Object currencyId) {
            this.currencyId = currencyId;
        }

        public Object getExpenseItemId() {
            return this.expenseItemId;
        }

        public void setExpenseItemId(Object expenseItemId) {
            this.expenseItemId = expenseItemId;
        }

        public BigDecimal getBalanceAmount() {
            return this.balanceAmount;
        }

        public void setBalanceAmount(BigDecimal balanceAmount) {
            this.balanceAmount = balanceAmount;
        }

        public Date getHappendDate() {
            return this.happendDate;
        }

        public void setHappendDate(Date happendDate) {
            this.happendDate = happendDate;
        }
    }

    public static class CreateDailyReimburseByEmployeeReimParam {
        private AbstractFormPlugin formPlugin;
        private Object userId;
        private Object companyId;
        private Object currencyId;
        private Object expenseItemId;
        private BigDecimal balanceAmount;
        private Date happendDate;

        public AbstractFormPlugin getFormPlugin() {
            return this.formPlugin;
        }

        public void setFormPlugin(AbstractFormPlugin formPlugin) {
            this.formPlugin = formPlugin;
        }

        public Object getUserId() {
            return this.userId;
        }

        public void setUserId(Object userId) {
            this.userId = userId;
        }

        public Object getCompanyId() {
            return this.companyId;
        }

        public void setCompanyId(Object companyId) {
            this.companyId = companyId;
        }

        public Object getCurrencyId() {
            return this.currencyId;
        }

        public void setCurrencyId(Object currencyId) {
            this.currencyId = currencyId;
        }

        public Object getExpenseItemId() {
            return this.expenseItemId;
        }

        public void setExpenseItemId(Object expenseItemId) {
            this.expenseItemId = expenseItemId;
        }

        public BigDecimal getBalanceAmount() {
            return this.balanceAmount;
        }

        public void setBalanceAmount(BigDecimal balanceAmount) {
            this.balanceAmount = balanceAmount;
        }

        public Date getHappendDate() {
            return this.happendDate;
        }

        public void setHappendDate(Date happendDate) {
            this.happendDate = happendDate;
        }
    }
}

