/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IMobileView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.fi.er.business.servicehelper.CommonServiceHelper;

public class SpecialReimbursebillUtils {
    private static String ISLOCK = "islock";
    private static String EXPITEMNUM = "expitemnum";
    private static String BAR_VIEWLOAN = "bar_viewloan";

    private SpecialReimbursebillUtils() {
    }

    public static void addListener(AbstractFormPlugin plugin) {
        BasedataEdit expenseItemDE = (BasedataEdit)plugin.getControl("expenseitem");
        String specialType = (String)plugin.getView().getModel().getValue("specialbill");
        if (!StringUtils.isEmpty((CharSequence)specialType)) {
            expenseItemDE.addBeforeF7SelectListener(new BeforeF7SelectListener(){

                public void beforeF7Select(BeforeF7SelectEvent arg0) {
                    ListShowParameter cardF7Param = (ListShowParameter)arg0.getFormShowParameter();
                    cardF7Param.getListFilterParameter().getQFilters().add(QFilter.of((String)"isleaf=? and status='C' and enable='1' and isreimburseamountctl ='1'", (Object[])new Object[]{true}));
                }
            });
        }
    }

    public static void setExpenseInfoAfterAddNewSpecail(AbstractFormPlugin plugin) {
        IFormView view = plugin.getView();
        IDataModel model = view.getModel();
        BillShowParameter parameter = (BillShowParameter)view.getFormShowParameter();
        Map customParams = parameter.getCustomParams();
        String specailType = (String)customParams.get("specialbill");
        Boolean islock = Boolean.valueOf(String.valueOf(parameter.getCustomParams().get(ISLOCK)));
        String expItemNum = (String)parameter.getCustomParams().get(EXPITEMNUM);
        if (!StringUtils.isEmpty((CharSequence)specailType) && !StringUtils.isEmpty((CharSequence)expItemNum)) {
            model.setValue("specialbill", (Object)specailType);
            DynamicObject expitem = CommonServiceHelper.getObjByProp("er_expenseitemedit", "number", expItemNum);
            int rows = model.getEntryRowCount("expenseentryentity");
            if (rows == 0) {
                model.createNewEntryRow("expenseentryentity");
            }
            if ((rows = model.getEntryRowCount("expenseentryentity")) > 0) {
                DynamicObject costDept = (DynamicObject)model.getValue("costdept");
                DynamicObject costCompany = (DynamicObject)model.getValue("costcompany");
                model.setValue("entrycostdept", costDept == null ? null : costDept.getPkValue(), 0);
                model.setValue("entrycostcompany", costCompany == null ? null : costCompany.getPkValue(), 0);
                model.setValue("happendate", (Object)CommonServiceHelper.getLastDayOfLastMonthBy(new Date()), 0);
                Object currencyId = model.getValue("currency_id");
                if (expitem != null) {
                    model.setValue("expenseitem", (Object)expitem.getLong("id"), 0);
                    BasedataEdit expenseItemField = (BasedataEdit)plugin.getControl("expenseitem");
                    SpecialReimbursebillUtils.setDescriptionAfterChangeRow(expitem.getString("name"), plugin);
                    if (islock.booleanValue()) {
                        expenseItemField.setEnable("", false, 0);
                    }
                }
                int expenseEntryCount = model.getEntryRowCount("expenseentryentity");
                for (int i = 0; i < expenseEntryCount; ++i) {
                    model.setValue("entrycurrency", currencyId, i);
                }
            }
        }
    }

    public static void setDescriptionAfterChangeRow(AbstractFormPlugin plugin) {
        String[] captionInfo;
        String specialType = (String)plugin.getView().getModel().getValue("specialbill");
        if (!StringUtils.isEmpty((CharSequence)specialType) && (captionInfo = ((ComboProp)plugin.getView().getModel().getDataEntityType().getProperties().get((Object)"specialbill")).getItemByName(specialType).split(",")).length >= 2) {
            DynamicObject expitem = CommonServiceHelper.getObjByProp("er_expenseitemedit", "number", captionInfo[1].trim());
            SpecialReimbursebillUtils.setDescriptionAfterChangeRow(expitem.getString("name"), plugin);
        }
    }

    public static void setDescriptionAfterChangeRow(String expitemname, AbstractFormPlugin plugin) {
        SimpleDateFormat format = new SimpleDateFormat(ResManager.loadKDString((String)"yyyy\u5e74MM\u6708", (String)"SpecialReimbursebillUtils_0", (String)"fi-er-business", (Object[])new Object[0]));
        IDataModel model = plugin.getView().getModel();
        DynamicObjectCollection detailEntry = model.getDataEntity(true).getDynamicObjectCollection("expenseentryentity");
        int rowIndex = detailEntry.size();
        if (rowIndex <= 0) {
            model.setValue("description", (Object)String.format(ResManager.loadKDString((String)"%s \u62a5\u9500", (String)"SpecialReimbursebillUtils_1", (String)"fi-er-business", (Object[])new Object[0]), expitemname));
            return;
        }
        Date minDate = ((DynamicObject)detailEntry.get(0)).getDate("happendate");
        Date maxDate = ((DynamicObject)detailEntry.get(0)).getDate("happendate");
        while (rowIndex > 0) {
            Date happendate;
            if ((happendate = ((DynamicObject)detailEntry.get(--rowIndex)).getDate("happendate")) != null && (minDate == null || minDate.compareTo(happendate) > 0)) {
                minDate = happendate;
            }
            if (happendate == null || maxDate != null && maxDate.compareTo(happendate) >= 0) continue;
            maxDate = happendate;
        }
        if (minDate != null && maxDate != null && minDate.compareTo(maxDate) != 0) {
            model.setValue("description", (Object)(format.format(minDate) + "-" + format.format(maxDate) + expitemname));
        } else if (minDate != null) {
            model.setValue("description", (Object)(format.format(minDate) + expitemname));
        }
    }

    public static void afterAddDetailEntry(AbstractFormPlugin plugin) {
        IFormView thisView = plugin.getView();
        IDataModel model = thisView.getModel();
        int entitySize = model.getDataEntity().getDynamicObjectCollection("expenseentryentity").size();
        int rowIndex = entitySize - 1;
        IDataEntityProperty typeProperty = model.getProperty("specialbill");
        String specialType = null;
        if (typeProperty != null) {
            specialType = (String)model.getValue("specialbill");
        } else {
            String parentPageId = thisView.getFormShowParameter().getParentPageId();
            IFormView parentView = thisView.getViewNoPlugin(parentPageId);
            if (parentView == null) {
                return;
            }
            IDataModel parentModel = parentView.getModel();
            typeProperty = parentModel.getProperty("specialbill");
            if (typeProperty != null) {
                specialType = (String)parentModel.getValue("specialbill");
            }
        }
        if (!StringUtils.isEmpty((CharSequence)specialType) && rowIndex >= 0) {
            model.setValue("happendate", (Object)CommonServiceHelper.getLastDayOfLastMonthBy(new Date()), rowIndex);
            String[] captionInfo = ((ComboProp)model.getDataEntityType().getProperties().get((Object)"specialbill")).getItemByName(specialType).split(",");
            int infoLength = captionInfo.length;
            switch (infoLength) {
                case 2: {
                    DynamicObject expitem = CommonServiceHelper.getObjByProp("er_expenseitemedit", "number", captionInfo[1]);
                    model.setValue("expenseitem", (Object)expitem.getLong("id"), rowIndex);
                    break;
                }
                case 3: {
                    DynamicObject expitem = CommonServiceHelper.getObjByProp("er_expenseitemedit", "number", captionInfo[1]);
                    model.setValue("expenseitem", (Object)expitem.getLong("id"), rowIndex);
                    plugin.getView().updateView("expenseitem", rowIndex);
                    BasedataEdit expenseItemField = (BasedataEdit)plugin.getControl("expenseitem");
                    expenseItemField.setEnable("", !Boolean.parseBoolean(captionInfo[2]), rowIndex);
                    SpecialReimbursebillUtils.setDescriptionAfterChangeRow(expitem.getString("name"), plugin);
                }
            }
        }
    }

    public static void setSpecialFiled(String specialType, AbstractFormPlugin plugin) {
        if (!StringUtils.isEmpty((CharSequence)specialType)) {
            IFormView thisView = plugin.getView();
            if (thisView instanceof IMobileView) {
                HashMap<String, Object> clientPropertyMap = new HashMap<String, Object>();
                clientPropertyMap.put("mask", "YYYY-MM");
                clientPropertyMap.put("df", "YYYY-MM");
                clientPropertyMap.put("dateSelectType", 1);
                clientPropertyMap.put("max", CommonServiceHelper.getLastDayOfLastMonthBy(new Date()));
                clientPropertyMap.put("mi", Boolean.TRUE);
                HashMap<String, HashMap<String, Object>> items = new HashMap<String, HashMap<String, Object>>();
                items.put("item", clientPropertyMap);
                items.put("header", (HashMap<String, Object>)new LocaleString(ResManager.loadKDString((String)"\u62a5\u9500\u6708\u4efd", (String)"SpecialReimbursebillUtils_2", (String)"fi-er-business", (Object[])new Object[0])));
                plugin.getView().updateControlMetadata("happendate", items);
                Boolean islock = Boolean.valueOf(String.valueOf(plugin.getView().getParentView().getFormShowParameter().getCustomParams().get(ISLOCK)));
                Object expenseItem = plugin.getView().getModel().getValue("expenseitem");
                if (islock.booleanValue() && expenseItem != null) {
                    BasedataEdit expenseItemField = (BasedataEdit)plugin.getControl("expenseitem");
                    expenseItemField.setEnable("", false, 0);
                }
            } else {
                EntryGrid detailEntry = (EntryGrid)plugin.getControl("expenseentryentity");
                detailEntry.setColumnProperty("happendate", "header", (Object)new LocaleString(ResManager.loadKDString((String)"\u62a5\u9500\u6708\u4efd", (String)"SpecialReimbursebillUtils_2", (String)"fi-er-business", (Object[])new Object[0])));
                IClientViewProxy clientViewProxy = (IClientViewProxy)plugin.getView().getService(IClientViewProxy.class);
                clientViewProxy.invokeControlMethod("expenseentryentity", "setColEditorProp", new Object[]{"happendate", "mask", "YYYY-MM"});
                clientViewProxy.invokeControlMethod("expenseentryentity", "setColEditorProp", new Object[]{"happendate", "df", "YYYY-MM"});
                DateEdit fieldEdit = (DateEdit)plugin.getControl("happendate");
                fieldEdit.setMustInput(true);
                fieldEdit.setMaxDate(CommonServiceHelper.getLastDayOfLastMonthBy(new Date()));
                plugin.getView().setVisible(Boolean.valueOf(false), new String[]{"advconap", "orientryamount", "taxamount", "taxrate", "invoiceno_entry", BAR_VIEWLOAN});
            }
        }
    }
}

