/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.util;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;

public class TripReportUtil {
    private static Log logger = LogFactory.getLog(TripReportUtil.class);

    public List<Map<String, String>> getOrderedList(Boolean isQueryPraise) throws NumberFormatException {
        Map<Long, String> placeMap;
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        Long currentLoginUserID = this.getCurrentUser();
        List allSubordinateUserIDs = UserServiceHelper.getUserSubordinate((long)currentLoginUserID, (int)2);
        if (allSubordinateUserIDs.size() > 0 && (placeMap = TripReportUtil.getToPlace(allSubordinateUserIDs)).size() > 0) {
            ArrayList<Long> userIds = new ArrayList<Long>(placeMap.keySet());
            DynamicObjectCollection userInfoList = this.getUserInfo(userIds);
            Set praiseUserIdsSet = null;
            if (isQueryPraise.booleanValue()) {
                DynamicObjectCollection praiseUserIds = this.praiseUserIds(userIds, currentLoginUserID);
                praiseUserIdsSet = praiseUserIds.stream().map(d -> d.getLong("user")).collect(Collectors.toSet());
            }
            for (int i = 0; i < userInfoList.size(); ++i) {
                DynamicObject userInfo = (DynamicObject)userInfoList.get(i);
                Long userID = userInfo.getLong("id");
                HashMap<String, String> eachRow = new HashMap<String, String>();
                eachRow.put("userID", userID + "");
                eachRow.put("useropenid", userInfo.getString("useropenid"));
                eachRow.put("textfield_name", userInfo.getString("name"));
                eachRow.put("picturefield", userInfo.getString("picturefield"));
                eachRow.put("dept", userInfo.getString("dptId"));
                eachRow.put("textfield_position", userInfo.getString("position"));
                eachRow.put("textfield_city", placeMap.get(userID).split("#&&#")[0]);
                eachRow.put("description", placeMap.get(userID).split("#&&#")[1]);
                String isPraise = "0";
                if (praiseUserIdsSet != null && praiseUserIdsSet.contains(userID)) {
                    isPraise = "1";
                }
                eachRow.put("isPraise", isPraise);
                result.add(eachRow);
            }
        }
        return result;
    }

    private DynamicObjectCollection getUserInfo(List<Long> userIds) {
        QFilter userIDsFilter = new QFilter("id", "in", userIds);
        QFilter ispartjobFilter = new QFilter("entryentity.ispartjob", "=", (Object)Boolean.FALSE);
        return QueryServiceHelper.query((String)"bos_user", (String)"id, useropenid, name, entryentity.dpt.id dptId, entryentity.position position, picturefield", (QFilter[])new QFilter[]{userIDsFilter, ispartjobFilter});
    }

    private static Map<Long, String> getToPlace(List<Long> userIds) {
        Date nowTime = new Date();
        QFilter qFilter = QFilter.of((String)"rstartdate <= ? and renddate >= ?", (Object[])new Object[]{nowTime, nowTime}).and(new QFilter("billstatus", "in", (Object)new String[]{"B", "C", "E", "F", "G", "I"})).and(new QFilter("applier", "in", userIds));
        DynamicObjectCollection reqbillArray = QueryServiceHelper.query((String)"er_tripreqbill", (String)"applier, rto, description", (QFilter[])new QFilter[]{qFilter});
        logger.info("\u6839\u636e\u7533\u8bf7\u4eba\u67e5\u8be2\u51fa\u5dee\u5730\u57df\u3001\u4e8b\u7531, \u8fd4\u56de\u7ed3\u679c:" + reqbillArray);
        HashMap<Long, String> returnMap = new HashMap<Long, String>();
        if (reqbillArray != null) {
            for (DynamicObject dynamicObject : reqbillArray) {
                Long userId = dynamicObject.getLong("applier");
                StringBuilder req = new StringBuilder();
                String toPlace = dynamicObject.getString("rto");
                if (toPlace == null || "".equals(toPlace.trim())) {
                    toPlace = "--";
                }
                req.append(toPlace).append("#&&#");
                String description = dynamicObject.getString("description");
                if (description == null || "".equals(description.trim())) {
                    description = "--";
                }
                req.append(description);
                returnMap.put(userId, req.toString());
            }
        }
        return returnMap;
    }

    public DynamicObjectCollection praiseUserIds(List<Long> employeeIds, Long praiseuserId) {
        Date startTime = TripReportUtil.getStartTimeOfDay();
        Date endTime = TripReportUtil.getEndTimeOfDay();
        QFilter f1 = new QFilter("praiseuse", "=", (Object)praiseuserId);
        QFilter f2 = new QFilter("user", "in", employeeIds);
        QFilter f3 = new QFilter("nowdate", ">=", (Object)startTime);
        QFilter f4 = new QFilter("nowdate", "<=", (Object)endTime);
        QFilter[] fFilters = new QFilter[]{f1, f2, f3, f4};
        DynamicObjectCollection praiseUserIds = QueryServiceHelper.query((String)"er_praiserecord", (String)"user", (QFilter[])fFilters);
        return praiseUserIds;
    }

    public static Date getStartTimeOfDay() {
        Calendar calendarBefor = Calendar.getInstance();
        calendarBefor.setTime(new Date());
        calendarBefor.set(11, 0);
        calendarBefor.set(12, 0);
        calendarBefor.set(13, 0);
        calendarBefor.set(14, 0);
        Date startTime = calendarBefor.getTime();
        return startTime;
    }

    public static Date getEndTimeOfDay() {
        Calendar calendarAfter = Calendar.getInstance();
        calendarAfter.setTime(new Date());
        calendarAfter.set(11, 23);
        calendarAfter.set(12, 59);
        calendarAfter.set(13, 59);
        calendarAfter.set(14, 59);
        Date endTime = calendarAfter.getTime();
        return endTime;
    }

    private Long getCurrentUser() throws NumberFormatException {
        RequestContext requestContext = RequestContext.get();
        return Long.valueOf(requestContext.getUserId());
    }
}

