/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.web.tripboards.manager;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Output;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.MainEntityType;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.er.formplugin.web.tripboards.model.SummaryModel;
import kd.fi.er.formplugin.web.tripboards.utils.TripBoardsUtil;

public class CacheManager {
    private static final Log logger = LogFactory.getLog(CacheManager.class);
    private IPageCache pageCache;
    protected static final Cache<String, Object> localDataCache = CacheBuilder.newBuilder().maximumSize(3000L).expireAfterWrite(180L, TimeUnit.SECONDS).concurrencyLevel(16).build();
    private static final ThreadLocal<Kryo> kryoThreadLocal = ThreadLocal.withInitial(() -> {
        Kryo kryo = new Kryo();
        kryo.setReferences(true);
        kryo.setRegistrationRequired(true);
        kryo.register(SummaryModel.class);
        kryo.register(List.class);
        kryo.register(ArrayList.class);
        kryo.register(Set.class);
        kryo.register(HashSet.class);
        kryo.register(String.class);
        kryo.register(HashMap.class);
        kryo.register(BigDecimal.class);
        kryo.register(Date.class);
        kryo.register(Timestamp.class);
        return kryo;
    });
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final ObjectWriter objectWriter = objectMapper.writer();

    public CacheManager() {
    }

    public CacheManager(IPageCache pageCache) {
        this.pageCache = pageCache;
    }

    public static DistributeSessionlessCache getRedisCache() {
        return CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache();
    }

    public static Cache<String, Object> getLocalDataCache() {
        return localDataCache;
    }

    public static <T> Object getLocalCacheData(String key, Map<String, Object> queryMap, Class<T> clazz) {
        try {
            Object ifPresent = localDataCache.getIfPresent((Object)key);
            if (ifPresent != null) {
                return ifPresent;
            }
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"er_index_result", (String)"result_tag", (QFilter[])new QFilter[]{new QFilter("cachekey", "=", (Object)key)});
            if (dynamicObject != null) {
                T t = CacheManager.getDBCache(clazz, dynamicObject, queryMap);
                localDataCache.put((Object)key, t);
                return t;
            }
        }
        catch (Exception ex) {
            return null;
        }
        return null;
    }

    private static <T> T getDBCache(Class<T> clazz, DynamicObject dynamicObject, Map<String, Object> queryMap) {
        String resultStr = dynamicObject.getString("result_tag");
        byte[] resultTag = Base64.getDecoder().decode(resultStr);
        byte[] decompressedValue = CacheManager.decompress(resultTag);
        if (queryMap.containsKey("isReal")) {
            return CacheManager.deserializeDynamicObject(decompressedValue, clazz);
        }
        ArrayList<SummaryModel> returnData = new ArrayList<SummaryModel>(16);
        returnData.addAll(CacheManager.deserializeSummaryModel(decompressedValue));
        return (T)returnData;
    }

    public static <T> void put(String key, T value, Map<String, Object> queryMap) {
        CacheManager.remove(Collections.singletonList(key));
        if (queryMap.containsKey("isReal")) {
            localDataCache.put((Object)key, value);
            byte[] serializedValue = CacheManager.serializeDynamicObject(value);
            CacheManager.compressData(key, queryMap, serializedValue);
        } else {
            CacheManager.serializeSummaryModel(value, key, queryMap);
        }
    }

    private static void compressData(String key, Map<String, Object> queryMap, byte[] serializedValue) {
        byte[] compressedValue = CacheManager.compress(serializedValue);
        MainEntityType billEntityType = MetadataServiceHelper.getDataEntityType((String)"er_index_result");
        DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)billEntityType);
        dynamicObject.set("cachekey", (Object)key);
        dynamicObject.set("result_tag", (Object)(compressedValue == null ? "" : Base64.getEncoder().encodeToString(compressedValue)));
        dynamicObject.set("starttime", (Object)TripBoardsUtil.converLocalDataToDate((LocalDate)queryMap.get("starttime")));
        dynamicObject.set("endtime", (Object)TripBoardsUtil.converLocalDataToDate((LocalDate)queryMap.get("endtime")));
        dynamicObject.set("orgid", queryMap.get("orgid"));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
    }

    private static <T> void serializeSummaryModel(T value, String key, Map<String, Object> queryMap) {
        Kryo kryo = kryoThreadLocal.get();
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();
             Output output = new Output((OutputStream)bos, 0x6400000);){
            List summaryModels = (List)value;
            Map<String, List<SummaryModel>> groupData = summaryModels.stream().collect(Collectors.groupingBy(obj -> {
                LocalDate localDate = TripBoardsUtil.convertDateToLocalDate(obj.getSummaryStart());
                LocalDate localEndDate = TripBoardsUtil.convertDateToLocalDate(obj.getSummaryEnd());
                int year = localDate.getYear();
                int monthValue = localDate.getMonthValue();
                int dayOfMonth = localDate.getDayOfMonth();
                String startKey = year + "-" + monthValue + "-" + dayOfMonth;
                int endYear = localEndDate.getYear();
                int endMonthValue = localEndDate.getMonthValue();
                int endDayOfMonth = localEndDate.getDayOfMonth();
                String endKey = endYear + "-" + endMonthValue + "-" + endDayOfMonth;
                return startKey + "-" + endKey;
            }));
            for (Map.Entry<String, List<SummaryModel>> entry : groupData.entrySet()) {
                List<SummaryModel> models = entry.getValue();
                output.writeInt(models.size());
                kryo.writeObject(output, models);
                output.flush();
                String dbKey = key + entry.getKey();
                localDataCache.put((Object)dbKey, models);
                CacheManager.compressData(dbKey, queryMap, bos.toByteArray());
                output.reset();
                bos.reset();
            }
        }
        catch (Exception e) {
            logger.error("Error in serializing SummaryModel", (Throwable)e);
        }
    }

    /*
     * Exception decompiling
     */
    private static List<SummaryModel> deserializeSummaryModel(byte[] bytes) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <T> byte[] serializeDynamicObject(T obj) {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            objectWriter.writeValue((OutputStream)bos, obj);
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            logger.error("Error in serializing object", (Throwable)e);
            return null;
        }
    }

    private static <T> T deserializeDynamicObject(byte[] bytes, Class<T> clazz) {
        try {
            return (T)objectMapper.readValue(bytes, clazz);
        }
        catch (Exception e) {
            logger.error("Error in deserializing object", (Throwable)e);
            return null;
        }
    }

    public static void remove(List<String> cacheKeys) {
        localDataCache.invalidateAll(cacheKeys);
        CacheManager.getRedisCache().remove(cacheKeys.toArray(new String[0]));
    }

    public void removePageCache(List<String> cacheKeys) {
        for (String cacheKey : cacheKeys) {
            this.pageCache.remove(cacheKey);
        }
    }

    public static void removeResultCache(List<String> cacheKeys) {
        CacheManager.remove(cacheKeys);
        for (String cacheKey : cacheKeys) {
            DeleteServiceHelper.delete((String)"er_index_result", (QFilter[])new QFilter[]{new QFilter("cachekey", "like", (Object)(cacheKey + "%"))});
        }
    }

    public static <T> T getSimpleDataCache(String key, Class<T> clazz) {
        byte[] compressedValue = CacheManager.getRedisCache().getByteValue(key);
        if (compressedValue != null) {
            byte[] decompressedValue = CacheManager.decompress(compressedValue);
            return CacheManager.deserialize(decompressedValue, clazz);
        }
        return null;
    }

    public static <T> void putSimpleDataCache(String key, T value) {
        CacheManager.getRedisCache().remove(key);
        byte[] serializedValue = CacheManager.serialize(value);
        byte[] compressedValue = CacheManager.compress(serializedValue);
        CacheManager.getRedisCache().put(key, compressedValue);
    }

    /*
     * Exception decompiling
     */
    private static byte[] serialize(Object obj) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private static <T> T deserialize(byte[] bytes, Class<T> clazz) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private static byte[] compress(byte[] data) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private static byte[] decompress(byte[] compressedData) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static List<Object> typeCheckAndReturnData(Object localCacheData, List<Object> returnData) {
        if (localCacheData instanceof List) {
            List dataList = (List)localCacheData;
            if (!dataList.isEmpty() && dataList.get(0) instanceof DynamicObject) {
                List cacheData = (List)localCacheData;
                DynamicObject data = (DynamicObject)dataList.get(0);
                String props = data.containsProperty("checkindate") ? "checkindate" : (data.containsProperty("takeofftime") ? "takeofftime" : (data.containsProperty("departtime") ? "departtime" : "usetime"));
                returnData = cacheData.parallelStream().map(dynamicObject -> new SummaryModel(dynamicObject.getBigDecimal("totalamount"), dynamicObject.getString("expcommitdepnum"), dynamicObject.getString("expcommitcomnum"), dynamicObject.getDate(props))).collect(Collectors.toList());
            } else if (!dataList.isEmpty() && dataList.get(0) instanceof SummaryModel) {
                returnData = (List)localCacheData;
            } else {
                logger.error("Unexpected element type in list: " + (dataList.isEmpty() ? "empty list" : dataList.get(0).getClass().getName()));
            }
        }
        return returnData;
    }
}

