/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.web.tripboards.plugins;

import com.alibaba.fastjson.JSONObject;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ListboxItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.ext.form.control.Listbox;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.chart.Chart;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ListboxClickListener;
import kd.bos.form.control.events.ListboxEvent;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.StringUtils;
import kd.fi.er.formplugin.web.tripboards.manager.CacheManager;
import kd.fi.er.formplugin.web.tripboards.plugins.TripBoardPlugin;
import kd.fi.er.formplugin.web.tripboards.utils.DataProcessUtils;
import kd.fi.er.formplugin.web.tripboards.utils.TripBoardsUtil;

public class TripFinanceBoardPlugin
extends TripBoardPlugin
implements ProgresssListener,
ListboxClickListener {
    private static final Log logger = LogFactory.getLog(TripFinanceBoardPlugin.class);
    private static final String[] PROGRESS_BAR_KEYS = new String[]{"plane_expense_progressbar", "train_expense_progressbar", "hotel_expense_progressbar", "v_expense_progressbar", "expense_progressbar", "all_expense_progressbar", "map_progressbar", "yoy_progressbar"};
    private static final String[] PERCENTS_KEYS = new String[]{"train_task_percent", "plane_task_percent", "hotel_task_percent", "vehicle_task_percent", "expense_task_percent", "all_expense_task_percent", "yoy_task_percent", "map_task_percent"};

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        for (String key : PROGRESS_BAR_KEYS) {
            ProgressBar bar = (ProgressBar)this.getView().getControl(key);
            if (bar == null) continue;
            bar.addProgressListener((ProgresssListener)this);
        }
        Listbox listboxap = (Listbox)this.getControl("listboxap");
        if (listboxap != null) {
            listboxap.addListboxClickListener((ListboxClickListener)this);
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setViewVisibility(false, "plane_flex_progressbar", "train_flex_progressbar", "hotel_flex_progressbar", "vehicle_flex_progressbar", "expense_flex_progressbar", "all_expense_flex_progress", "yoy_flex_progressbar", "map_flex_progress", "customline");
        ListboxItem travel = new ListboxItem("traveloverviewbtn", ResManager.loadKDString((String)"\u5546\u65c5\u51fa\u884c", (String)"TripBoard_16", (String)"fi-er-business", (Object[])new Object[0]));
        ListboxItem popularLine = new ListboxItem("popularroutesbtn", ResManager.loadKDString((String)"\u70ed\u95e8\u822a\u7ebf", (String)"TripBoard_17", (String)"fi-er-business", (Object[])new Object[0]));
        ArrayList<ListboxItem> listboxItems = new ArrayList<ListboxItem>(16);
        listboxItems.add(travel);
        listboxItems.add(popularLine);
        Listbox listboxap = (Listbox)this.getControl("listboxap");
        listboxap.addItems(listboxItems);
        long currUserId = RequestContext.get().getCurrUserId();
        this.clearUserCache(currUserId);
        this.commonQuery("querydata");
        IDataModel model = this.getModel();
        model.setValue("yoy_title", (Object)ResManager.loadKDString((String)"\u5546\u65c5\u8d39\u7528\u540c\u6bd4\u5206\u6790\uff08\u5143\uff09", (String)"TripBoard_13", (String)"fi-er-business", (Object[])new Object[0]));
        model.setValue("all_rank_title", (Object)ResManager.loadKDString((String)"\u5546\u65c5\u603b\u4f53\u8d39\u7528\u53ca\u6392\u540d\uff08\u5143\uff09", (String)"TripBoard_12", (String)"fi-er-business", (Object[])new Object[0]));
        model.setValue("trip_expense_title", (Object)ResManager.loadKDString((String)"\u5546\u65c5\u8d39\u7528\u5206\u5e03\uff08\u5143\uff09", (String)"TripBoard_11", (String)"fi-er-business", (Object[])new Object[0]));
        model.setValue("v_title", (Object)ResManager.loadKDString((String)"\u7528\u8f66\u8d39\u7528\u7edf\u8ba1\uff08\u5143\uff09", (String)"TripBoard_14", (String)"fi-er-business", (Object[])new Object[0]));
        model.setValue("j_title", (Object)ResManager.loadKDString((String)"\u5546\u65c5\u51fa\u884c\u6982\u89c8", (String)"TripBoard_23", (String)"fi-er-business", (Object[])new Object[0]));
        model.setValue("p_expense_title", (Object)ResManager.loadKDString((String)"\u673a\u7968\u8d39\u7528\u7edf\u8ba1", (String)"TripBoard_24", (String)"fi-er-business", (Object[])new Object[0]));
        model.setValue("h_expense_title", (Object)ResManager.loadKDString((String)"\u9152\u5e97\u8d39\u7528\u7edf\u8ba1", (String)"TripBoard_25", (String)"fi-er-business", (Object[])new Object[0]));
        model.setValue("t_expense_title", (Object)ResManager.loadKDString((String)"\u706b\u8f66\u8d39\u7528\u7edf\u8ba1", (String)"TripBoard_26", (String)"fi-er-business", (Object[])new Object[0]));
    }

    public void beforeClosed(BeforeClosedEvent e) {
        long currUserId = RequestContext.get().getCurrUserId();
        CacheManager.removeResultCache(Arrays.asList(currUserId + "_TRIP_FINANCE_DATA_PLANE", currUserId + "_TRIP_FINANCE_DATA_HOTEL", currUserId + "_TRIP_FINANCE_DATA_TRAIN", currUserId + "_TRIP_FINANCE_DATA_VEHICLE"));
        CacheManager.removeResultCache(Arrays.asList(currUserId + "_TRIP_FINANCE_DATA_PLANE" + "_compare", currUserId + "_TRIP_FINANCE_DATA_HOTEL" + "_compare", currUserId + "_TRIP_FINANCE_DATA_TRAIN" + "_compare", currUserId + "_TRIP_FINANCE_DATA_VEHICLE" + "_compare"));
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        IDataModel model = this.getModel();
        String itemKey = evt.getItemKey();
        if ("querydata".equals(itemKey)) {
            long currUserId = RequestContext.get().getCurrUserId();
            this.clearUserCache(currUserId);
            this.otherValidate(evt, model);
        }
    }

    protected void clearUserCache(long currUserId) {
        this.queryBeforeClearCache(currUserId);
        CacheManager.removeResultCache(Arrays.asList(currUserId + "_TRIP_FINANCE_DATA_PLANE", currUserId + "_TRIP_FINANCE_DATA_HOTEL", currUserId + "_TRIP_FINANCE_DATA_TRAIN", currUserId + "_TRIP_FINANCE_DATA_VEHICLE"));
        CacheManager.removeResultCache(Arrays.asList(currUserId + "_TRIP_FINANCE_DATA_PLANE" + "_compare", currUserId + "_TRIP_FINANCE_DATA_HOTEL" + "_compare", currUserId + "_TRIP_FINANCE_DATA_TRAIN" + "_compare", currUserId + "_TRIP_FINANCE_DATA_VEHICLE" + "_compare"));
    }

    protected void otherValidate(BeforeItemClickEvent evt, IDataModel model) {
        LocalDate localEndDate;
        Object org = model.getValue("org");
        IFormView view = this.getView();
        if (org == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ec4\u7ec7\u3002", (String)"TripFinanceBoardPlugin_01", (String)"fi-er-business", (Object[])new Object[0]));
            evt.setCancel(Boolean.TRUE.booleanValue());
            return;
        }
        Date startDateObj = (Date)model.getValue("dataperiod_startdate");
        Date endDateObj = (Date)model.getValue("dataperiod_enddate");
        if (startDateObj == null || endDateObj == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u65e5\u671f\u8303\u56f4\u3002", (String)"TripSyncPullSelPlugin_11", (String)"fi-er-business", (Object[])new Object[0]));
            evt.setCancel(Boolean.TRUE.booleanValue());
            return;
        }
        LocalDate localBeginDate = TripBoardsUtil.convertDateToLocalDate(startDateObj);
        long betweenMonth = ChronoUnit.MONTHS.between(localBeginDate, localEndDate = TripBoardsUtil.convertDateToLocalDate(endDateObj)) + 1L;
        if (betweenMonth > 12L) {
            view.showTipNotification(ResManager.loadKDString((String)"\u65e5\u671f\u8de8\u5ea6\u4e0d\u53ef\u8d85\u8fc7\u4e00\u5e74\u3002", (String)"TripFinanceBoardPlugin_1", (String)"fi-er-business", (Object[])new Object[0]));
            evt.setCancel(Boolean.TRUE.booleanValue());
        }
    }

    protected void queryBeforeClearCache(long currUserId) {
        List keySet = CacheManager.getRedisCache().getKeysWithPrefix(currUserId + "_");
        boolean isOver = keySet.stream().anyMatch(key -> key.contains(currUserId + ""));
        IPageCache pageCache = this.getPageCache();
        if (isOver) {
            ArrayList<String> needRemoveCacheKeys = new ArrayList<String>(16);
            for (String key2 : keySet) {
                if (!key2.contains(String.valueOf(currUserId))) continue;
                needRemoveCacheKeys.add(key2);
                pageCache.remove(key2);
            }
            CacheManager.remove(needRemoveCacheKeys);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if ("querydata".equals(itemKey)) {
            this.commonQuery(itemKey);
        }
    }

    private void commonQuery(String itemKey) {
        IFormView view = this.getView();
        this.clearChartData(Arrays.asList("all_expense_bar", "expense_pre_anlybar"));
        this.setViewVisibility(true, "plane_flex_progressbar", "train_flex_progressbar", "hotel_flex_progressbar", "vehicle_flex_progressbar", "expense_flex_progressbar", "all_expense_flex_progress", "yoy_flex_progressbar", "map_flex_progress");
        this.setViewVisibility(false, "plane_expense_up_flex", "plane_expense_down_flex", "train_expense_flex", "hotel_expense_flex", "vehicle_expense_down_flex", "vehicle_pie_flex", "travelexpense_pie_flex", "all_expense_flex", "yoy_anal_flex", "map_total_flex");
        this.setOriginPercent(PERCENTS_KEYS);
        this.startProgressBar("plane_expense_progressbar");
        IPageCache pageCache = this.getPageCache();
        pageCache.put("clientKey", "PLANE_EXPENSE");
        view.addClientCallBack("PLANE_EXPENSE", Integer.valueOf(1000));
        view.setEnable(Boolean.FALSE, new String[]{itemKey});
        this.setViewVisibility(Boolean.FALSE, "customline");
        this.setViewVisibility(Boolean.TRUE, "traveloverview");
        view.setEnable(Boolean.FALSE, new String[]{"listboxap"});
        CustomControl travel = (CustomControl)this.getView().getControl("traveloverview");
        travel.setData(null);
        CustomControl popularLine = (CustomControl)this.getView().getControl("customline");
        popularLine.setData(null);
    }

    protected void clearChartData(List<String> controlKey) {
        for (String key : controlKey) {
            Control chartControl = this.getControl(key);
            if (!(chartControl instanceof Chart)) continue;
            Chart chart = (Chart)chartControl;
            chart.clearData();
            chart.refresh();
        }
    }

    protected void setIntervalTime(Object intervalTime, String ... key) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("itime", intervalTime);
        for (String s : key) {
            this.getView().updateControlMetadata(s, map);
        }
    }

    protected void setOriginPercent(String[] percentKeys) {
        long currUserId = RequestContext.get().getCurrUserId();
        IPageCache pageCache = this.getPageCache();
        for (String key : percentKeys) {
            pageCache.put(currUserId + "_" + key, "99");
        }
    }

    protected void startProgressBar(String key) {
        try {
            Control control = this.getControl(key);
            if (control instanceof ProgressBar) {
                ProgressBar bar = (ProgressBar)control;
                bar.start();
            }
        }
        catch (Exception ex) {
            logger.error("startProgressBar error", (Throwable)ex);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if ("orgchange".equals(name)) {
            Object newValue = e.getChangeSet()[0].getNewValue();
            if (newValue == null) {
                return;
            }
            IPageCache pageCache = this.getPageCache();
            String s = pageCache.get(newValue.toString());
            if (StringUtils.isBlank((String)s)) {
                return;
            }
            JSONObject dataJson = JSONObject.parseObject((String)s);
            this.commandDeal("all_expense_bar", (Map<String, Object>)dataJson);
        }
    }

    public void clientCallBack(ClientCallBackEvent e) {
        IPageCache pageCache = this.getPageCache();
        String clientKey = pageCache.get("clientKey");
        try {
            if (clientKey.equals("PLANE_EXPENSE")) {
                DataProcessUtils.processingUnit(this.getModel(), "PLANE", this.getPageCache());
            }
        }
        catch (Exception ex) {
            logger.error("\u5f02\u6b65\u67e5\u8be2\u5931\u8d25:", (Throwable)ex);
        }
    }

    protected void dealResult(Map<String, Object> dataResult) {
        if (dataResult == null || dataResult.isEmpty()) {
            return;
        }
        IFormView view = this.getView();
        for (Map.Entry<String, Object> entry : dataResult.entrySet()) {
            HashMap<String, Object> map;
            Label label;
            String key = entry.getKey();
            Control control = this.getControl(key);
            Object value = entry.getValue();
            if (!key.endsWith("arrow") && control instanceof Label) {
                label = (Label)control;
                label.setText(String.valueOf(value));
            }
            if (control instanceof TextEdit) {
                TextEdit textEdit = (TextEdit)control;
                this.getModel().setValue(key, (Object)value.toString());
            }
            if (key.endsWith("arrow") && control instanceof Label) {
                label = (Label)control;
                if ("up".equals(value)) {
                    label.setText("\u2191");
                    map = new HashMap();
                    map.put("cstyles", "eyJ0eXBlIjowLCJjb250ZW50IjoiXG5cbiQge1xuwqDCoGNvbG9yOiNGRjUyNTI7XG4gIGZvbnQtd2VpZ2h0OjYwMDtcbiAgZm9udC1mYW1pbHk6UGluZ0ZhbmdTQy1TZW1pYm9sZDtcbsKgfVxuIn0=");
                    view.updateControlMetadata(key, map);
                } else if ("down".equals(value)) {
                    label.setText("\u2193");
                    map = new HashMap();
                    map.put("cstyles", "eyJ0eXBlIjowLCJjb250ZW50IjoiXG5cbiQge1xuwqDCoGNvbG9yOiMwMEI5Mjg7XG4gIGZvbnQtd2VpZ2h0OjYwMDtcbiAgZm9udC1mYW1pbHk6UGluZ0ZhbmdTQy1TZW1pYm9sZDtcbsKgfVxuIn0=");
                    view.updateControlMetadata(key, map);
                } else {
                    label.setText("");
                }
            }
            if (!key.endsWith("_font")) continue;
            String newKey = key.replace("_font", "");
            map = new HashMap<String, Object>();
            map.put("cstyles", value);
            view.updateControlMetadata(newKey, map);
        }
    }

    public void onProgress(ProgressEvent progressEvent) {
        ProgressBar bar = (ProgressBar)progressEvent.getSource();
        String barKey = bar.getKey();
        try {
            this.handleProgressBarEvent(barKey, progressEvent);
        }
        catch (Exception ex) {
            logger.error("\u6307\u6807\u56de\u8c03\u62a5\u9519:", (Throwable)ex);
            this.stopProgress(progressEvent, bar);
            this.getView().setEnable(Boolean.TRUE, new String[]{"querydata"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"listboxap"});
        }
    }

    protected void handleProgressBarEvent(String barKey, ProgressEvent progressEvent) throws Exception {
        String cachePrefix = RequestContext.get().getCurrUserId() + "_";
        switch (barKey) {
            case "train_expense_progressbar": {
                this.handleProgress("train", progressEvent, cachePrefix, "VEHICLE", "train_flex_progressbar", "v_expense_progressbar", "train_expense_flex");
                break;
            }
            case "plane_expense_progressbar": {
                this.handleProgress("plane", progressEvent, cachePrefix, "HOTEL", "plane_flex_progressbar", "hotel_expense_progressbar", "plane_expense_up_flex", "plane_expense_down_flex");
                break;
            }
            case "hotel_expense_progressbar": {
                this.handleProgress("hotel", progressEvent, cachePrefix, "TRAIN", "hotel_flex_progressbar", "train_expense_progressbar", "hotel_expense_flex");
                break;
            }
            case "v_expense_progressbar": {
                this.handleVehicleProgress(progressEvent, cachePrefix);
                break;
            }
            case "expense_progressbar": {
                this.handleExpenseProgress(progressEvent, cachePrefix, "travelexpense_pie_flex");
                break;
            }
            case "all_expense_progressbar": {
                this.handleChartProgress("MAP", progressEvent, cachePrefix, "all_expense_result", "all_expense_task_percent", "all_expense_flex_progress", "all_expense_flex", "all_expense_bar", "map_progressbar");
                break;
            }
            case "yoy_progressbar": {
                this.handleChartProgress("", progressEvent, cachePrefix, "yoy_result", "yoy_task_percent", "yoy_flex_progressbar", "yoy_anal_flex", "expense_pre_anlybar", "");
                break;
            }
            case "map_progressbar": {
                this.handleMapProgress(progressEvent, cachePrefix);
                break;
            }
        }
    }

    private void handleExpenseProgress(ProgressEvent progressEvent, String cachePrefix, String showFlexKey) throws Exception {
        String taskPercent = this.getTaskPercent(cachePrefix, "expense_task_percent");
        this.updateProgress(progressEvent, taskPercent);
        IPageCache pageCache = this.getPageCache();
        if (this.isComplete(taskPercent) && pageCache.getAll().containsKey(cachePrefix + "trip_expense_result")) {
            this.stopProgress(progressEvent, (ProgressBar)progressEvent.getSource());
            DataProcessUtils.processingUnit(this.getModel(), "EXPENSE_RANK", pageCache);
            this.startProgressBar("all_expense_progressbar");
            new IntervalSetting(2700, "all_expense_progressbar");
            this.setViewVisibility(Boolean.FALSE, "expense_flex_progressbar");
            this.setViewVisibility(Boolean.TRUE, showFlexKey);
            CustomControl travel = (CustomControl)this.getView().getControl("trip_expense_custom");
            Map map = (Map)JSONObject.parseObject((String)CacheManager.getSimpleDataCache(cachePrefix + "trip_expense_result", String.class), Map.class);
            travel.setData((Object)map);
            this.dealResult(map);
            this.clearCache(cachePrefix, "trip_expense_result");
            this.clearCache(cachePrefix, "expense_task_percent");
        }
    }

    private void handleProgress(String type, ProgressEvent progressEvent, String cachePrefix, String nextExecuteKey, String progressbarKey, String startProgressBarKey, String ... flexKeys) throws Exception {
        String taskPercentKey = type + "_task_percent";
        String resultKey = type + "_result";
        ProgressBar bar = (ProgressBar)progressEvent.getSource();
        String taskPercent = this.getTaskPercent(cachePrefix, taskPercentKey);
        this.updateProgress(progressEvent, taskPercent);
        IPageCache pageCache = this.getPageCache();
        if (this.isComplete(taskPercent) && pageCache.getAll().containsKey(cachePrefix + resultKey)) {
            this.stopProgress(progressEvent, bar);
            DataProcessUtils.processingUnit(this.getModel(), nextExecuteKey, pageCache);
            this.startProgressBar(startProgressBarKey);
            this.setIntervalTimes(new IntervalSetting(2700, startProgressBarKey));
            this.toggleVisibility(false, progressbarKey, true, flexKeys);
            Object dataResult = this.getResultData(cachePrefix, resultKey);
            this.clearCache(cachePrefix, resultKey);
            if (dataResult instanceof Map) {
                this.dealResult((Map)dataResult);
            }
            this.clearCache(cachePrefix, taskPercentKey);
            this.clearCache(cachePrefix, resultKey);
        }
    }

    private void handleVehicleProgress(ProgressEvent progressEvent, String cachePrefix) throws Exception {
        String taskPercentKey = "vehicle_task_percent";
        String taskPercent = this.getTaskPercent(cachePrefix, taskPercentKey);
        if (this.isComplete(taskPercent)) {
            Object dataResult = this.getResultData(cachePrefix, "vehicle_result");
            this.handleProgress("vehicle", progressEvent, cachePrefix, "EXPENSE_SPREAD", "vehicle_flex_progressbar", "expense_progressbar", "vehicle_expense_down_flex", "vehicle_pie_flex");
            if (dataResult instanceof Map) {
                this.updateChartData((Map)dataResult, "vehicle_pie");
            }
            this.clearCache(cachePrefix, taskPercentKey);
            this.clearCache(cachePrefix, "vehicle_result");
        }
    }

    protected void handleChartProgress(String nextExecuteKey, ProgressEvent progressEvent, String cachePrefix, String resultKey, String percentKey, String hideFlexKey, String showFlexKey, String controlKey, String startProgressBarKey) throws Exception {
        String taskPercent = this.getTaskPercent(cachePrefix, percentKey);
        this.updateProgress(progressEvent, taskPercent);
        IPageCache pageCache = this.getPageCache();
        if (this.isComplete(taskPercent) && pageCache.getAll().containsKey(cachePrefix + resultKey)) {
            ProgressBar bar = (ProgressBar)progressEvent.getSource();
            this.stopProgress(progressEvent, bar);
            this.setViewVisibility(Boolean.FALSE, hideFlexKey);
            this.setViewVisibility(Boolean.TRUE, showFlexKey);
            if ("MAP".equals(nextExecuteKey)) {
                Map map = (Map)JSONObject.parseObject((String)CacheManager.getSimpleDataCache(cachePrefix + resultKey, String.class), Map.class);
                this.dealResult(map);
                Object type = this.getModel().getValue("orgchange");
                pageCache.put("dept", map != null && map.containsKey("dept") ? JSONObject.toJSONString(map.get("dept")) : JSONObject.toJSONString(TripBoardsUtil.getNullChartMap()));
                pageCache.put("company", map != null && map.containsKey("company") ? JSONObject.toJSONString(map.get("company")) : JSONObject.toJSONString(TripBoardsUtil.getNullChartMap()));
                pageCache.put("all", map != null && map.containsKey("all") ? JSONObject.toJSONString(map.get("all")) : JSONObject.toJSONString(TripBoardsUtil.getNullChartMap()));
                this.commandDeal(controlKey, map != null && map.containsKey(type) ? (Map)map.get(type) : TripBoardsUtil.getNullChartMap());
            } else {
                this.updateChartData(cachePrefix, controlKey, resultKey);
            }
            this.clearCache(cachePrefix, resultKey);
            this.clearCache(cachePrefix, taskPercent);
            if (StringUtils.isNotBlank((String)nextExecuteKey)) {
                DataProcessUtils.processingUnit(this.getModel(), nextExecuteKey, pageCache);
                this.startProgressBar(startProgressBarKey);
                new IntervalSetting("MAP".equals(nextExecuteKey) ? 5000 : 2700, startProgressBarKey);
            } else {
                IFormView view = this.getView();
                List keys = CacheManager.getRedisCache().getKeysWithPrefix(cachePrefix);
                HashSet keySet = new HashSet(keys);
                Boolean isEnable = Boolean.TRUE;
                view.setEnable(isEnable, new String[]{"querydata"});
                long currUserId = RequestContext.get().getCurrUserId();
                List<String> subIndexList = Arrays.asList("TRIP_PLANE_INDEX", "TRIP_HOTEL_INDEX", "TRIP_VEHICLE_INDEX", "TRIP_TRAIN_INDEX");
                boolean isOver = keySet.stream().anyMatch(key -> key.contains(currUserId + ""));
                if (isOver) {
                    ArrayList<String> needRemoveCacheKeys = new ArrayList<String>(16);
                    for (String key2 : keySet) {
                        boolean b = subIndexList.stream().anyMatch(key2::startsWith);
                        if (b || !key2.contains(String.valueOf(currUserId))) continue;
                        needRemoveCacheKeys.add(key2);
                    }
                    CacheManager.remove(needRemoveCacheKeys);
                }
            }
        }
    }

    private void handleMapProgress(ProgressEvent progressEvent, String cachePrefix) throws Exception {
        String taskPercent = this.getTaskPercent(cachePrefix, "map_task_percent");
        this.updateProgress(progressEvent, taskPercent);
        IPageCache pageCache = this.getPageCache();
        if (this.isComplete(taskPercent) && pageCache.getAll().containsKey(cachePrefix + "map_result")) {
            IFormView view = this.getView();
            this.showMapResult(progressEvent, cachePrefix);
            this.clearCache(cachePrefix, taskPercent);
            this.clearCache(cachePrefix, "map_result");
            view.setEnable(Boolean.TRUE, new String[]{"listboxap"});
            DataProcessUtils.processingUnit(this.getModel(), "YOY", pageCache);
            this.startProgressBar("yoy_progressbar");
            new IntervalSetting(5000, "yoy_progressbar");
        }
    }

    private void toggleVisibility(boolean progressbarVisible, String progressbarKey, boolean flexVisible, String ... flexKeys) {
        this.setViewVisibility(progressbarVisible, progressbarKey);
        for (String flexKey : flexKeys) {
            this.setViewVisibility(flexVisible, flexKey);
        }
    }

    private Object getResultData(String cachePrefix, String resultKey) {
        try {
            return JSONObject.parseObject((String)CacheManager.getSimpleDataCache(cachePrefix + resultKey, String.class), Map.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void updateChartData(Map<String, Object> dataResult, String chartKey) {
        Map data = (Map)dataResult.get("data");
        this.dealResult(data);
        CustomControl custom = (CustomControl)this.getControl("vehicle_expense_custom");
        custom.setData(dataResult);
    }

    protected void clearCache(String cachePrefix, String resultKey) {
        CacheManager.remove(Collections.singletonList(cachePrefix + resultKey));
        new CacheManager(this.getPageCache()).removePageCache(Collections.singletonList(cachePrefix + resultKey));
    }

    protected String getTaskPercent(String cachePrefix, String key) {
        IPageCache pageCache = this.getPageCache();
        return pageCache.get(cachePrefix + key);
    }

    protected void updateProgress(ProgressEvent progressEvent, String taskPercent) {
        if (StringUtils.isEmpty((String)taskPercent)) {
            return;
        }
        progressEvent.setProgress(Integer.parseInt(taskPercent));
    }

    protected boolean isComplete(String taskPercent) {
        if (StringUtils.isEmpty((String)taskPercent)) {
            return false;
        }
        return Integer.parseInt(taskPercent) >= 100;
    }

    protected void updateChartData(String cachePrefix, String controlKey, String resultKey) {
        Map commandResultMap = null;
        try {
            commandResultMap = (Map)JSONObject.parseObject((String)CacheManager.getSimpleDataCache(cachePrefix + resultKey, String.class), Map.class);
            this.dealResult(commandResultMap);
        }
        catch (Exception e) {
            commandResultMap = TripBoardsUtil.getNullChartMap();
        }
        this.commandDeal(controlKey, commandResultMap);
    }

    protected void commandDeal(String controlKey, Map<String, Object> commandResultMap) {
        Control chartControl = this.getControl(controlKey);
        Chart chart = (Chart)chartControl;
        chart.clearData();
        chart.refresh();
        commandResultMap = commandResultMap == null || commandResultMap.isEmpty() ? TripBoardsUtil.getNullChartMap() : commandResultMap;
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.setFieldProperty(chart.getKey(), "data", commandResultMap);
    }

    private void showMapResult(ProgressEvent progressEvent, String cachePrefix) {
        this.setViewVisibility(Boolean.FALSE, "map_flex_progress");
        this.setViewVisibility(Boolean.TRUE, "map_total_flex");
        ProgressBar bar = (ProgressBar)progressEvent.getSource();
        this.stopProgress(progressEvent, bar);
        Map dataResult = null;
        try {
            dataResult = (Map)JSONObject.parseObject((String)CacheManager.getSimpleDataCache(cachePrefix + "map_result", String.class), Map.class);
            CacheManager.remove(Arrays.asList(cachePrefix + "map_result", cachePrefix + "map_task_percent"));
        }
        catch (Exception e) {
            logger.error("map result error", (Throwable)e);
        }
        if (dataResult != null) {
            this.dealResult(dataResult);
            this.setTravelOverviewData(dataResult);
        }
    }

    private void setTravelOverviewData(Map<String, Object> dataResult) {
        CustomControl travel = (CustomControl)this.getView().getControl("traveloverview");
        travel.setData(dataResult.get("returnData"));
        CustomControl popularLine = (CustomControl)this.getView().getControl("customline");
        popularLine.setData(dataResult.get("returnData"));
    }

    protected void stopProgress(ProgressEvent progressEvent, ProgressBar bar) {
        progressEvent.setProgress(0);
        bar.stop();
    }

    private void setIntervalTimes(IntervalSetting ... settings) {
        for (IntervalSetting setting : settings) {
            this.setIntervalTime(setting.getInterval(), setting.getKeys());
        }
    }

    protected void setViewVisibility(boolean visibility, String ... keys) {
        this.getView().setVisible(Boolean.valueOf(visibility), keys);
    }

    public void listboxClick(ListboxEvent listboxEvent) {
        String itemId = listboxEvent.getItemId();
        if ("popularroutesbtn".equalsIgnoreCase(itemId)) {
            this.setViewVisibility(Boolean.FALSE, "traveloverview");
            this.setViewVisibility(Boolean.TRUE, "customline");
        } else if ("traveloverviewbtn".equalsIgnoreCase(itemId)) {
            this.setViewVisibility(Boolean.FALSE, "customline");
            this.setViewVisibility(Boolean.TRUE, "traveloverview");
        }
    }

    private static class IntervalSetting {
        private final int interval;
        private final String[] keys;

        IntervalSetting(int interval, String ... keys) {
            this.interval = interval;
            this.keys = keys;
        }

        public int getInterval() {
            return this.interval;
        }

        public String[] getKeys() {
            return this.keys;
        }
    }
}

