/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.web.tripboards.plugins;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ListboxItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.ext.form.control.Listbox;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ListboxClickListener;
import kd.bos.form.control.events.ListboxEvent;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.field.DateEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.StringUtils;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.formplugin.web.tripboards.manager.CacheManager;
import kd.fi.er.formplugin.web.tripboards.plugins.TripFinanceBoardPlugin;
import kd.fi.er.formplugin.web.tripboards.utils.DataProcessUtils;

public class TripPlaneBoardPlugin
extends TripFinanceBoardPlugin {
    private static final Log logger = LogFactory.getLog(TripPlaneBoardPlugin.class);
    private static final String[] PLANE_BOARD_PROGRESS_BAR_KEY = new String[]{"p_expense_progressbar", "p_reversal_progressbar", "p_amount_progressbar", "p_takeofftime_progressbar", "p_avediscount_progressbar", "p_bookinadvanced_progress", "p_popular_air_progressbar", "p_fullticket_progressbar", "p_deptrank_progresbar"};
    private static final String[] PLANE_BOARD_PROGRESS_PERCENT_KEY = new String[]{"trip_plane_expense_percent", "trip_plane_reversal_percent", "trip_plane_amount_percent", "trip_plane_takeofftime_percent", "trip_plane_avediscount_percent", "trip_plane_bookinadvanced_percent", "trip_plane_popular_air_percent", "trip_plane_fullticket_percent", "trip_plane_deptrank_percent"};

    @Override
    public void registerListener(EventObject e) {
        Listbox listDeptRank;
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        for (String key : PLANE_BOARD_PROGRESS_BAR_KEY) {
            ProgressBar bar = (ProgressBar)this.getView().getControl(key);
            if (bar == null) continue;
            bar.addProgressListener((ProgresssListener)this);
        }
        Listbox listboxap = (Listbox)this.getControl("listbox_refund");
        if (listboxap != null) {
            listboxap.addListboxClickListener((ListboxClickListener)this);
        }
        if ((listDeptRank = (Listbox)this.getControl("listbox_deptrank")) != null) {
            listDeptRank.addListboxClickListener((ListboxClickListener)this);
        }
    }

    @Override
    public void beforeClosed(BeforeClosedEvent e) {
        CacheManager.removeResultCache(Collections.singletonList(RequestContext.get().getCurrUserId() + "_TRIP_PLANE_INDEX_PLANE_SEPARATE_CACHE_KEY"));
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        IFormView view = this.getView();
        this.setViewVisibility(Boolean.FALSE, "p_refund_flex", "p_refund_line", "p_dept_avediscount_custom", "p_dept_bookinadvan_custom");
        this.setViewVisibility(Boolean.FALSE, "p_expexpense_flex", "p_reversal_progress_flex", "p_amount_progressbar_flex", "p_takeofftime_pro_flex", "p_avediscount_pro_flex", "p_bookinadvanced_pro_flex", "p_popular_air_pro_flex", "p_fullticket_pro_flex", "p_deptrank_pro_flex");
        FormShowParameter formShowParameter = view.getFormShowParameter();
        IDataModel model = this.getModel();
        model.setValue("org", formShowParameter.getCustomParam("rootOrg"));
        model.setValue("dataperiod_startdate", formShowParameter.getCustomParam("dataperiod_startdate"));
        model.setValue("dataperiod_enddate", formShowParameter.getCustomParam("dataperiod_enddate"));
        LocalDate now = LocalDate.now();
        DateEdit tripDate = (DateEdit)this.getControl("dataperiod_enddate");
        tripDate.setMaxDate(ErCommonUtils.getDateFromLocalDate(now));
        DateEdit startDate = (DateEdit)this.getControl("dataperiod_startdate");
        startDate.setMaxDate(ErCommonUtils.getDateFromLocalDate(now));
        ListboxItem changeTrend = new ListboxItem("changetrendbtn", ResManager.loadKDString((String)"\u6539\u7b7e\u8d8b\u52bf", (String)"TripBoard_18", (String)"fi-er-business", (Object[])new Object[0]));
        ListboxItem refundTrend = new ListboxItem("refundtrendbtn", ResManager.loadKDString((String)"\u9000\u7968\u8d8b\u52bf", (String)"TripBoard_19", (String)"fi-er-business", (Object[])new Object[0]));
        ListboxItem refundAndChangeRate = new ListboxItem("refundandchangebtn", ResManager.loadKDString((String)"\u9000\u6539\u7b7e\u7387", (String)"TripBoard_20", (String)"fi-er-business", (Object[])new Object[0]));
        ListboxItem averageDiscount = new ListboxItem("averagediscountbtn", ResManager.loadKDString((String)"\u5e73\u5747\u6298\u6263", (String)"TripBoard_21", (String)"fi-er-business", (Object[])new Object[0]));
        ListboxItem bookInAdvance = new ListboxItem("bookinadvancebtn", ResManager.loadKDString((String)"\u63d0\u524d\u9884\u8ba2", (String)"TripBoard_22", (String)"fi-er-business", (Object[])new Object[0]));
        ArrayList<ListboxItem> listboxItems = new ArrayList<ListboxItem>(16);
        listboxItems.add(changeTrend);
        listboxItems.add(refundTrend);
        ArrayList<ListboxItem> listBoxDeptRankItems = new ArrayList<ListboxItem>(16);
        listBoxDeptRankItems.add(refundAndChangeRate);
        listBoxDeptRankItems.add(averageDiscount);
        listBoxDeptRankItems.add(bookInAdvance);
        Listbox listboxap = (Listbox)this.getControl("listbox_refund");
        listboxap.addItems(listboxItems);
        Listbox listBoxDeptRank = (Listbox)this.getControl("listbox_deptrank");
        listBoxDeptRank.addItems(listBoxDeptRankItems);
        long currUserId = RequestContext.get().getCurrUserId();
        this.clearUserCache(currUserId);
        this.commonQuery("querytripplanedata");
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if ("orgchange".equals(name)) {
            Object newValue = e.getChangeSet()[0].getNewValue();
            if (newValue == null) {
                return;
            }
            IPageCache pageCache = this.getPageCache();
            String s = pageCache.get(newValue.toString());
            if (StringUtils.isBlank((String)s)) {
                return;
            }
            JSONObject dataJson = JSONObject.parseObject((String)s);
            this.commandDeal("p_expense_bar", (Map<String, Object>)dataJson);
        } else if ("discountchange".equals(name)) {
            Object newValue = e.getChangeSet()[0].getNewValue();
            if (newValue == null) {
                return;
            }
            IPageCache pageCache = this.getPageCache();
            String s = pageCache.get(newValue.toString());
            if (StringUtils.isBlank((String)s)) {
                return;
            }
            JSONArray dataJson = JSONObject.parseArray((String)s);
            CustomControl customControl = (CustomControl)this.getControl("p_fullticket_custom");
            if (customControl != null) {
                HashMap<String, JSONArray> map = new HashMap<String, JSONArray>(4);
                map.put("data", dataJson);
                customControl.setData(map);
            }
        }
    }

    @Override
    public void beforeItemClick(BeforeItemClickEvent evt) {
        IDataModel model = this.getModel();
        String itemKey = evt.getItemKey();
        if ("querytripplanedata".equals(itemKey)) {
            long currUserId = RequestContext.get().getCurrUserId();
            this.queryBeforeClearCache(currUserId);
            CacheManager.removeResultCache(Collections.singletonList(RequestContext.get().getCurrUserId() + "_TRIP_PLANE_INDEX_PLANE_SEPARATE_CACHE_KEY"));
            this.otherValidate(evt, model);
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if ("querytripplanedata".equals(itemKey)) {
            this.commonQuery(itemKey);
        }
    }

    private void commonQuery(String itemKey) {
        this.clearChartData(Arrays.asList("p_amount_line", "p_takeofftime_line", "p_averagediscount_line"));
        this.setViewVisibility(true, "p_expexpense_flex", "p_reversal_progress_flex", "p_amount_progressbar_flex", "p_takeofftime_pro_flex", "p_avediscount_pro_flex", "p_bookinadvanced_pro_flex", "p_popular_air_pro_flex", "p_fullticket_pro_flex", "p_deptrank_pro_flex");
        this.setViewVisibility(false, "p_expense_bar_flex", "p_refund_change_line_flex", "p_change_flex", "p_refund_flex", "p_amount_line_flex", "p_takeofftime_line_flex", "p_avdiscount_line_flex", "p_bookinadvanced_bar_flex", "p_booinadvaced_days_flex", "p_popularair_flex", "p_fullticket_flex", "p_deptrank_flex");
        this.setOriginPercent(PLANE_BOARD_PROGRESS_PERCENT_KEY);
        this.startProgressBar("p_expense_progressbar");
        try {
            DataProcessUtils.processingUnit(this.getModel(), "PLANE_EXPENSE", this.getPageCache());
        }
        catch (Exception e) {
            logger.error("\u673a\u7968\u770b\u677f \u673a\u7968\u8d39\u7528\u6307\u6807\u67e5\u8be2\u5931\u8d25:", (Throwable)e);
        }
        this.getView().setEnable(Boolean.FALSE, new String[]{itemKey});
    }

    @Override
    public void onProgress(ProgressEvent progressEvent) {
        ProgressBar bar = (ProgressBar)progressEvent.getSource();
        String barKey = bar.getKey();
        try {
            this.handleProgressBarEvent(barKey, progressEvent);
        }
        catch (Exception ex) {
            logger.error("\u6307\u6807\u56de\u8c03\u62a5\u9519:", (Throwable)ex);
            this.stopProgress(progressEvent, bar);
        }
    }

    @Override
    protected void handleProgressBarEvent(String barKey, ProgressEvent progressEvent) throws Exception {
        String cachePrefix = RequestContext.get().getCurrUserId() + "_";
        switch (barKey) {
            case "p_expense_progressbar": {
                this.handlePlaneExpense("PLANE_REVERSAL", progressEvent, cachePrefix, "trip_plane_expense_plane_result", "trip_plane_expense_percent", "p_expexpense_flex", "p_expense_bar_flex", "p_expense_bar", "p_reversal_progressbar");
                break;
            }
            case "p_reversal_progressbar": {
                this.handleChartAndFlex("PLANE_AMOUNT", progressEvent, cachePrefix, "trip_plane_reversal_result", "trip_plane_reversal_percent", "p_reversal_progress_flex", "p_refund_change_line_flex", "p_refund_line", "p_amount_progressbar");
                break;
            }
            case "p_amount_progressbar": {
                this.handleChartProgress("PLANE_TAKEOFFTIME", progressEvent, cachePrefix, "trip_plane_amount_result", "trip_plane_amount_percent", "p_amount_progressbar_flex", "p_amount_line_flex", "p_amount_line", "p_takeofftime_progressbar");
                break;
            }
            case "p_takeofftime_progressbar": {
                this.handleChartProgress("PLANE_AVERAGE_DISCOUNT", progressEvent, cachePrefix, "trip_plane_takeofftime_result", "trip_plane_takeofftime_percent", "p_takeofftime_pro_flex", "p_takeofftime_line_flex", "p_takeofftime_line", "p_avediscount_progressbar");
                break;
            }
            case "p_avediscount_progressbar": {
                this.handleChartProgress("PLANE_BOOKINADVANCED", progressEvent, cachePrefix, "trip_plane_discount_result", "trip_plane_discount_percent", "p_avediscount_pro_flex", "p_avdiscount_line_flex", "p_averagediscount_line", "p_bookinadvanced_progress");
                break;
            }
            case "p_bookinadvanced_progress": {
                this.handleChartAndFlex("PLANE_POPULAR_AIR", progressEvent, cachePrefix, "trip_plane_bookinadvanced_result", "trip_plane_bookinadvanced_percent", "p_bookinadvanced_pro_flex", "p_bookinadvanced_bar_flex", "p_bookinadvanced_bar", "p_popular_air_progressbar");
                break;
            }
            case "p_popular_air_progressbar": {
                this.handleCustom("PLANE_FULL_TICKET", progressEvent, cachePrefix, "trip_plane_popularair_result", "trip_plane_popular_air_percent", "p_popular_air_pro_flex", "p_popularair_flex", "p_popularair_custom", "p_fullticket_progressbar");
                break;
            }
            case "p_fullticket_progressbar": {
                this.handleCustom("PLANE_DEPT_RANK", progressEvent, cachePrefix, "trip_plane_fullticket_result", "trip_plane_fullticket_percent", "p_fullticket_pro_flex", "p_fullticket_flex", "p_fullticket_custom", "p_deptrank_progresbar");
                break;
            }
            case "p_deptrank_progresbar": {
                this.handleCustom("", progressEvent, cachePrefix, "trip_plane_deptrank_result", "trip_plane_deptrank_percent", "p_deptrank_pro_flex", "p_deptrank_flex", "p_dept_retreat_custom", "");
                String taskPercent = this.getTaskPercent(cachePrefix, "trip_plane_deptrank_percent");
                if (!this.isComplete(taskPercent)) break;
                HashSet keyS = new HashSet(CacheManager.getRedisCache().getKeysWithPrefix(cachePrefix));
                String userId = RequestContext.get().getCurrUserId() + "";
                ArrayList<String> needRemoveCacheKeys = new ArrayList<String>(16);
                IPageCache pageCache = this.getPageCache();
                for (String key : keyS) {
                    if (!key.contains(userId)) continue;
                    needRemoveCacheKeys.add(key);
                    pageCache.remove(key);
                }
                CacheManager.remove(needRemoveCacheKeys);
            }
        }
    }

    private void handlePlaneExpense(String nextExecuteKey, ProgressEvent progressEvent, String cachePrefix, String resultKey, String percentKey, String hideFlexKey, String showFlexKey, String controlKey, String startProgressBarKey) throws Exception {
        String taskPercent = this.getTaskPercent(cachePrefix, percentKey);
        this.updateProgress(progressEvent, taskPercent);
        IPageCache pageCache = this.getPageCache();
        if (this.isComplete(taskPercent) && pageCache.getAll().containsKey(cachePrefix + resultKey)) {
            ProgressBar bar = (ProgressBar)progressEvent.getSource();
            this.stopProgress(progressEvent, bar);
            DataProcessUtils.processingUnit(this.getModel(), nextExecuteKey, pageCache);
            if (StringUtils.isNotBlank((String)startProgressBarKey)) {
                this.startProgressBar(startProgressBarKey);
            }
            this.setViewVisibility(Boolean.FALSE, hideFlexKey);
            this.setViewVisibility(Boolean.TRUE, showFlexKey);
            Map map = (Map)JSONObject.parseObject((String)CacheManager.getSimpleDataCache(cachePrefix + resultKey, String.class), Map.class);
            pageCache.put("dept", JSONObject.toJSONString(map.get("dept")));
            pageCache.put("company", JSONObject.toJSONString(map.get("company")));
            pageCache.put("all", JSONObject.toJSONString(map.get("all")));
            this.clearCache(cachePrefix, resultKey);
            this.clearCache(cachePrefix, taskPercent);
            this.commandDeal(controlKey, (Map)map.get(this.getModel().getValue("orgchange")));
        }
    }

    private void handleCustom(String nextExecuteKey, ProgressEvent progressEvent, String cachePrefix, String resultKey, String percentKey, String hideFlexKey, String showFlexKey, String controlKey, String startProgressBarKey) throws Exception {
        String taskPercent = this.getTaskPercent(cachePrefix, percentKey);
        this.updateProgress(progressEvent, taskPercent);
        IPageCache pageCache = this.getPageCache();
        if (this.isComplete(taskPercent) && pageCache.getAll().containsKey(cachePrefix + resultKey)) {
            CustomControl customControl;
            ProgressBar bar = (ProgressBar)progressEvent.getSource();
            this.stopProgress(progressEvent, bar);
            IFormView view = this.getView();
            if (StringUtils.isNotBlank((String)nextExecuteKey)) {
                DataProcessUtils.processingUnit(this.getModel(), nextExecuteKey, pageCache);
                if (StringUtils.isNotBlank((String)startProgressBarKey)) {
                    this.startProgressBar(startProgressBarKey);
                }
            } else {
                CustomControl bookInAdvancedDayCustom;
                CustomControl discountCustom = (CustomControl)view.getControl("p_dept_avediscount_custom");
                if (discountCustom != null) {
                    discountCustom.setData(JSONObject.parseObject((String)CacheManager.getSimpleDataCache(cachePrefix + resultKey, String.class), Map.class));
                }
                if ((bookInAdvancedDayCustom = (CustomControl)view.getControl("p_dept_bookinadvan_custom")) != null) {
                    bookInAdvancedDayCustom.setData(JSONObject.parseObject((String)CacheManager.getSimpleDataCache(cachePrefix + resultKey, String.class), Map.class));
                }
                view.setEnable(Boolean.TRUE, new String[]{"querytripplanedata"});
            }
            this.setViewVisibility(Boolean.FALSE, hideFlexKey);
            this.setViewVisibility(Boolean.TRUE, showFlexKey);
            if ("p_fullticket_custom".equals(controlKey)) {
                customControl = (CustomControl)view.getControl(controlKey);
                HashMap<String, JSONArray> map = new HashMap<String, JSONArray>(4);
                map.put("data", JSONObject.parseArray((String)pageCache.get(this.getModel().getValue("discountchange").toString())));
                customControl.setData(map);
            } else {
                customControl = (CustomControl)view.getControl(controlKey);
                customControl.setData((Object)JSONObject.parseObject((String)CacheManager.getSimpleDataCache(cachePrefix + resultKey, String.class)));
            }
            this.clearCache(cachePrefix, resultKey);
            this.clearCache(cachePrefix, taskPercent);
        }
    }

    protected void handleChartAndFlex(String nextExecuteKey, ProgressEvent progressEvent, String cachePrefix, String resultKey, String percentKey, String hideFlexKey, String showFlexKey, String controlKey, String startProgressBarKey) throws Exception {
        String taskPercent = this.getTaskPercent(cachePrefix, percentKey);
        this.updateProgress(progressEvent, taskPercent);
        IPageCache pageCache = this.getPageCache();
        if (this.isComplete(taskPercent) && pageCache.getAll().containsKey(cachePrefix + resultKey)) {
            ProgressBar bar = (ProgressBar)progressEvent.getSource();
            this.stopProgress(progressEvent, bar);
            if (StringUtils.isNotBlank((String)nextExecuteKey)) {
                DataProcessUtils.processingUnit(this.getModel(), nextExecuteKey, pageCache);
                if (StringUtils.isNotBlank((String)startProgressBarKey)) {
                    this.startProgressBar(startProgressBarKey);
                }
            }
            this.setViewVisibility(Boolean.FALSE, hideFlexKey);
            this.setViewVisibility(Boolean.TRUE, showFlexKey);
            Map data = (Map)JSONObject.parseObject((String)CacheManager.getSimpleDataCache(cachePrefix + resultKey, String.class), Map.class);
            if (data != null) {
                this.dealResult((Map)data.get("flexData"));
                this.commandDeal(controlKey, (Map)data.get("command"));
                if (data.containsKey("commandChange")) {
                    IFormView view = this.getView();
                    this.setViewVisibility(Boolean.FALSE, controlKey, "p_refund_flex");
                    this.setViewVisibility(Boolean.TRUE, "p_change_line", "p_change_flex");
                    this.commandDeal("p_change_line", (Map)data.get("commandChange"));
                } else {
                    this.setViewVisibility(Boolean.TRUE, "p_booinadvaced_days_flex");
                }
            }
            this.clearCache(cachePrefix, resultKey);
            this.clearCache(cachePrefix, taskPercent);
        }
    }

    @Override
    public void listboxClick(ListboxEvent listboxEvent) {
        String itemId = listboxEvent.getItemId();
        if ("changetrendbtn".equalsIgnoreCase(itemId)) {
            this.setViewVisibility(Boolean.FALSE, "p_refund_flex", "p_refund_line");
            this.setViewVisibility(Boolean.TRUE, "p_change_flex", "p_change_line");
        } else if ("refundtrendbtn".equalsIgnoreCase(itemId)) {
            this.setViewVisibility(Boolean.FALSE, "p_change_flex", "p_change_line");
            this.setViewVisibility(Boolean.TRUE, "p_refund_flex", "p_refund_line");
        } else if ("refundandchangebtn".equalsIgnoreCase(itemId)) {
            this.setViewVisibility(Boolean.FALSE, "p_dept_avediscount_custom", "p_dept_bookinadvan_custom");
            this.setViewVisibility(Boolean.TRUE, "p_dept_retreat_custom");
        } else if ("averagediscountbtn".equalsIgnoreCase(itemId)) {
            this.setViewVisibility(Boolean.FALSE, "p_dept_retreat_custom", "p_dept_bookinadvan_custom");
            this.setViewVisibility(Boolean.TRUE, "p_dept_avediscount_custom");
        } else if ("bookinadvancebtn".equalsIgnoreCase(itemId)) {
            this.setViewVisibility(Boolean.FALSE, "p_dept_retreat_custom", "p_dept_avediscount_custom");
            this.setViewVisibility(Boolean.TRUE, "p_dept_bookinadvan_custom");
        }
    }
}

