/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.web.tripboards.template;

import java.io.IOException;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dlock.DLock;
import kd.bos.ext.fi.thread.TaskType;
import kd.bos.ext.fi.thread.ThreadService;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;
import kd.fi.er.formplugin.web.tripboards.manager.CacheManager;

public abstract class ProcessHandleTemplate {
    private static final Log logger = LogFactory.getLog(ProcessHandleTemplate.class);
    private boolean orgFilter = false;
    private Map<String, Object> param;
    private Object dataResult;
    private Boolean needYoY;
    private Boolean needCache = true;
    private Boolean zipper = false;
    private IPageCache pageCache;

    public IPageCache getPageCache() {
        return this.pageCache;
    }

    public void setPageCache(IPageCache pageCache) {
        this.pageCache = pageCache;
    }

    public Boolean getZipper() {
        return this.zipper;
    }

    public void setZipper(Boolean zipper) {
        this.zipper = zipper;
    }

    public void execute() throws Exception {
        try {
            RequestContext context = RequestContext.get();
            CacheManager.putSimpleDataCache(this.param.get("overFlag").toString(), String.valueOf(false));
            ThreadService.execute(() -> {
                try {
                    Object data = this.isNeedDB() != false ? this.queryData(context) : new Object();
                    Object filteredData = this.filterData(data);
                    if (!this.getZipper().booleanValue()) {
                        this.dataHandle(filteredData);
                        this.dataCachePut(this.getDataResult(), this.getParam());
                    }
                }
                catch (Exception e) {
                    this.handleAsyncException(e);
                }
            }, (TaskType)TaskType.ER_INVOICE_TASK, (RequestContext)RequestContext.get());
        }
        catch (Exception ex) {
            this.dataCachePut(this.getDataResult(), this.getParam());
            logger.error("DataProcessHandle.execute: " + ex.getMessage());
            throw new Exception(ex);
        }
    }

    public void executeAlgoX() throws Exception {
        try {
            CacheManager.putSimpleDataCache(this.param.get("overFlag").toString(), String.valueOf(false));
            ThreadService.execute(() -> {
                this.calcByAlgoX();
                this.dataCachePut(this.getDataResult(), this.getParam());
            }, (TaskType)TaskType.ER_INVOICE_TASK, (RequestContext)RequestContext.get());
        }
        catch (Exception ex) {
            this.dataCachePut(this.getDataResult(), this.getParam());
            logger.error("DataProcessHandle.executeAlgoX: " + ex.getMessage());
            throw new Exception(ex);
        }
    }

    public Map<String, Object> getParam() {
        return this.param;
    }

    public void setParam(Map<String, Object> param) {
        this.param = param;
    }

    public Object getDataResult() {
        return this.dataResult;
    }

    public void setDataResult(Object dataResult) {
        this.dataResult = dataResult;
    }

    public Boolean getNeedYoY() {
        return this.needYoY;
    }

    public void setNeedYoY(Boolean needYoY) {
        this.needYoY = needYoY;
    }

    public boolean isOrgFilter() {
        return this.orgFilter;
    }

    public void setOrgFilter(boolean orgFilter) {
        this.orgFilter = orgFilter;
    }

    public Boolean getNeedCache() {
        return this.needCache;
    }

    public void setNeedCache(Boolean needCache) {
        this.needCache = needCache;
    }

    protected void dataCachePut(Object resultData, Map<String, Object> param) {
        try (DLock dLock = DLock.create((String)(RequestContext.get().getCurrUserId() + this.getCacheKey()));){
            boolean isLock = dLock.tryLock(30000L);
            if (isLock) {
                CacheManager.putSimpleDataCache(param.get("overFlag").toString(), String.valueOf(true));
                this.getPageCache().put(param.get("percentKey").toString(), "100");
                this.getPageCache().put(param.get("resultKey").toString(), "resultKey");
                CacheManager.putSimpleDataCache(param.get("resultKey").toString(), JSONUtils.toString((Object)resultData));
                if (StringUtils.isNotEmpty((String)this.getResultKey())) {
                    CacheManager.putSimpleDataCache(this.getResultKey(), JSONUtils.toString((Object)resultData));
                }
            }
        }
        catch (Exception ex) {
            logger.error("dataCachePut async try lock error:", (Throwable)ex);
            CacheManager.putSimpleDataCache(param.get("overFlag").toString(), String.valueOf(true));
            this.getPageCache().put(param.get("percentKey").toString(), "100");
            try {
                CacheManager.putSimpleDataCache(param.get("resultKey").toString(), JSONUtils.toString((Object)resultData));
                if (StringUtils.isNotEmpty((String)this.getResultKey())) {
                    CacheManager.putSimpleDataCache(this.getResultKey(), JSONUtils.toString((Object)resultData));
                }
            }
            catch (IOException e) {
                logger.error("JSONUtils.toString error", (Throwable)e);
            }
        }
    }

    private void handleAsyncException(Throwable ex) {
        this.dataCachePut(this.getDataResult(), this.getParam());
        logger.error("handleAsyncException async error: ", ex);
    }

    private Object filterData(Object data) {
        Object filterData = this.dataFilter(data);
        return filterData == null ? data : filterData;
    }

    protected abstract Object dataFilter(Object var1);

    protected abstract void dataHandle(Object var1);

    protected abstract QFilter[] getFilters(Map<String, Object> var1);

    protected abstract String getFormId();

    protected abstract String getSelectProps();

    protected abstract Boolean isNeedDB();

    protected abstract String getCacheKey();

    protected abstract Object queryData(RequestContext var1);

    protected abstract String getResultKey();

    protected void calcByAlgoX() {
    }
}

