/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.web.tripboards.tripindex.financeindex;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algox.AlgoX;
import kd.bos.algox.DataSetX;
import kd.bos.algox.JobSession;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.fi.er.business.trip.supplier.ctrip.invoke.convert.ConvertUtil;
import kd.fi.er.formplugin.web.tripboards.dataprocesshandle.TripOrderDataProcessHandle;
import kd.fi.er.formplugin.web.tripboards.model.Indicator;
import kd.fi.er.formplugin.web.tripboards.utils.TripBoardsUtil;

public class HotelDataProcessHandle
extends TripOrderDataProcessHandle {
    static Map<String, Object> DEFAULT_MAP_HOTEL = new HashMap<String, Object>(16);
    private static final String TOTAL_AMOUNT_KEY = "totalamount";
    private static final String SERVICE_FEE_KEY = "servicefee";
    private static final String UNBOOK_FEE_KEY = "unbookfee";
    private static final String ORDER_TYPE_KEY = "ordertype";
    private static final String TIME_KEY = "checkindate";
    private static final String SOURCE_TRAVELER_ID_KEY = "sourcetravelerid";
    private static final String ID_KEY = "id";

    public HotelDataProcessHandle(Map<String, Object> paramMap) {
        super(paramMap);
        this.setNeedYoY(Boolean.TRUE);
        this.setDataResult(DEFAULT_MAP_HOTEL);
    }

    public HotelDataProcessHandle() {
        this.setNeedYoY(Boolean.TRUE);
        this.setDataResult(DEFAULT_MAP_HOTEL);
    }

    @Override
    public QFilter[] getFilters(Map<String, Object> filterMap) {
        return this.getCommonFilters(TIME_KEY, "expcommitcomnum", "expcommitdepnum", filterMap);
    }

    @Override
    public String getFormId() {
        Map<String, Object> param = this.getParam();
        if (param.containsKey("isReal")) {
            return "er_hotelbill";
        }
        return "er_hotel_summary";
    }

    @Override
    public String getSelectProps() {
        Map<String, Object> param = this.getParam();
        if (param.containsKey("isReal")) {
            return "totalamount,servicefee,unbookfee,expcommitcomnum,expcommitdepnum,sourcetravelerid,ordertype,cityname,checkindate,id";
        }
        return "id,summaryamount,summaryservicefee,summaryrefundamount,orgid,summarystart,summaryend,summaryactivepeople,ordernums,traveluser_tag,orgtype,otherdatasummary_tag";
    }

    @Override
    public void dataHandle(Object data) {
        Map<String, Object> param = this.getParam();
        if (param.containsKey("isReal")) {
            this.endDataProcess(data, Boolean.FALSE);
        } else {
            this.endDataProcess(data, Boolean.TRUE);
        }
    }

    public void dataDeal(Map<String, Object> resultMap, List<DynamicObject> handleData, Boolean isSummary) {
        double totalamount = 0.0;
        double servicefee = 0.0;
        double refundamount = 0.0;
        long nums = 0L;
        if (isSummary.booleanValue()) {
            List summaryTag = handleData.parallelStream().map(dynamicObject -> dynamicObject.getString("otherdatasummary_tag")).collect(Collectors.toList());
            HashSet allOrderInfoSet = new HashSet();
            for (String s : summaryTag) {
                JSONObject jsonObject = JSONObject.parseObject((String)s);
                JSONArray orderArray = jsonObject.getJSONArray("orderNumsAndAmount");
                allOrderInfoSet.addAll(orderArray.stream().map(String::valueOf).collect(Collectors.toSet()));
            }
            for (String orderInfo : allOrderInfoSet) {
                String orderType;
                String[] info = orderInfo.split("\\$");
                int length = info.length;
                String totalamountStr = length >= 2 ? info[1] : "0";
                String servicefeeStr = length >= 3 ? info[2] : "0";
                String refundamountStr = length >= 4 ? info[3] : "0";
                String string = orderType = length >= 5 ? info[4] : "unknown";
                if ("O".equals(orderType)) {
                    ++nums;
                }
                totalamount = Double.sum(totalamount, Double.parseDouble(totalamountStr));
                servicefee = Double.sum(servicefee, Double.parseDouble(servicefeeStr));
                refundamount = Double.sum(refundamount, Double.parseDouble(refundamountStr));
            }
        } else {
            totalamount = handleData.parallelStream().filter(obj -> obj.get(TOTAL_AMOUNT_KEY) != null && obj.getBigDecimal(TOTAL_AMOUNT_KEY).compareTo(ConvertUtil.getOrderAmountInit()) != 0).mapToDouble(obj -> Double.parseDouble(obj.get(TOTAL_AMOUNT_KEY).toString())).sum();
            servicefee = handleData.parallelStream().filter(obj -> obj.get(SERVICE_FEE_KEY) != null && obj.getBigDecimal(TOTAL_AMOUNT_KEY).compareTo(ConvertUtil.getOrderAmountInit()) != 0).mapToDouble(obj -> Double.parseDouble(obj.get(SERVICE_FEE_KEY).toString())).sum();
            refundamount = handleData.parallelStream().filter(obj -> obj.get(UNBOOK_FEE_KEY) != null && obj.getBigDecimal(TOTAL_AMOUNT_KEY).compareTo(ConvertUtil.getOrderAmountInit()) != 0).mapToDouble(obj -> Double.parseDouble(obj.get(UNBOOK_FEE_KEY).toString())).sum();
        }
        if (!isSummary.booleanValue()) {
            List<String> orderType = Collections.singletonList("O");
            nums = handleData.parallelStream().filter(obj -> orderType.contains(obj.getString(ORDER_TYPE_KEY))).count();
        }
        long activePeople = 0L;
        if (!isSummary.booleanValue()) {
            activePeople = handleData.parallelStream().filter(obj -> obj.get(SOURCE_TRAVELER_ID_KEY) != null).map(obj -> obj.getLong(SOURCE_TRAVELER_ID_KEY)).distinct().count();
        } else {
            List userIdList = handleData.parallelStream().map(obj -> obj.getString("traveluser_tag")).collect(Collectors.toList());
            HashSet<String> userIdSet = new HashSet<String>();
            for (String userIdStr : userIdList) {
                String[] split = userIdStr.split(",");
                userIdSet.addAll(Arrays.asList(split));
            }
            activePeople = userIdSet.size();
        }
        this.getResultMap(resultMap, totalamount, nums, activePeople, refundamount, servicefee);
        HotelDataProcessHandle.putOriginValueMap(resultMap, totalamount, nums, activePeople, refundamount, servicefee);
    }

    private static void putOriginValueMap(Map<String, Object> resultMap, double totalamount, long nums, long activePeople, double refundamount, double servicefee) {
        HashMap<String, Number> originValueMap = new HashMap<String, Number>(16);
        originValueMap.put("h_month_amount", BigDecimal.valueOf(totalamount));
        originValueMap.put("h_order_nums", nums);
        originValueMap.put("h_active_people", activePeople);
        originValueMap.put("h_refund_fee", BigDecimal.valueOf(refundamount));
        originValueMap.put("h_service_fee", BigDecimal.valueOf(servicefee));
        resultMap.put("origin", originValueMap);
    }

    private void getResultMap(Map<String, Object> resultMap, double totalamount, long nums, long activePeople, double refundamount, double servicefee) {
        resultMap.put("h_month_amount", BigDecimal.valueOf(totalamount));
        resultMap.put("h_order_nums", nums);
        resultMap.put("h_active_people", activePeople);
        resultMap.put("h_refund_fee", BigDecimal.valueOf(refundamount));
        resultMap.put("h_service_fee", BigDecimal.valueOf(servicefee));
        resultMap.put("h_month_title", this.getNewAmountTitle(totalamount, this.getAmountTitle(), this.getTenThousandAmountTitle()));
        resultMap.put("h_service_title", this.getNewAmountTitle(servicefee, this.getServiceTitle(), this.getTenThousandServiceTitle()));
        resultMap.put("h_refund_title", this.getNewAmountTitle(refundamount, this.getRefundTitle(), this.getTenThousandRefundTitle()));
    }

    @Override
    public void rateDeal(Map<String, Object> resultMap, Map<String, Object> compareResultMap) {
        INDICATORS = new HashMap(16);
        INDICATORS.put("h_month_amount", new Indicator("h_month_amount", "h_month_amount", "h_month_arrow", "h_month_rate"));
        INDICATORS.put("h_refund_fee", new Indicator("h_refund_fee", "h_refund_fee", "h_refund_arrow", "h_refund_rate"));
        INDICATORS.put("h_service_fee", new Indicator("h_service_fee", "h_service_fee", "h_service_arrow", "h_service_rate"));
        INDICATORS.put("h_order_nums", new Indicator("h_order_nums", "h_order_nums", "h_ordernums_arrow", "h_ordernums_rate"));
        super.rateDeal(resultMap, compareResultMap);
    }

    @Override
    public String getCacheKey() {
        return RequestContext.get().getCurrUserId() + "_TRIP_FINANCE_DATA_HOTEL";
    }

    @Override
    protected String getResultKey() {
        return RequestContext.get().getCurrUserId() + "_TRIP_FINANCE_RESULT_HOTEL";
    }

    private void endDataProcess(Object data, Boolean isSummary) {
        if (data == null) {
            this.setDataResult(DEFAULT_MAP_HOTEL);
            return;
        }
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)8);
        HashMap compareResultMap = Maps.newHashMapWithExpectedSize((int)8);
        List handleData = (List)((Map)data).get("current");
        List compareHandleData = (List)((Map)data).get("compare");
        if (handleData.isEmpty() && compareHandleData.isEmpty()) {
            this.setDataResult(DEFAULT_MAP_HOTEL);
            return;
        }
        this.dataDeal(resultMap, handleData, isSummary);
        this.dataDeal(compareResultMap, compareHandleData, isSummary);
        this.rateDeal(resultMap, compareResultMap);
        TripBoardsUtil.formatDecimal(resultMap);
        this.setDataResult(resultMap);
    }

    @Override
    protected void calcByAlgoX() {
        TripOrderDataProcessHandle.OrderInputs result = this.getResult(TIME_KEY);
        JobSession tripBoards = AlgoX.createSession((String)"TripBoards-Hotel-Algox");
        DataSetX dataSetX = tripBoards.fromInput(result.inputs.toArray(new Input[0]));
        DataSetX compareDataSetX = tripBoards.fromInput(result.compareInputs.toArray(new Input[0]));
        DataSetX allDataSetX = dataSetX.select(new String[]{TOTAL_AMOUNT_KEY, SERVICE_FEE_KEY, UNBOOK_FEE_KEY, ORDER_TYPE_KEY, SOURCE_TRAVELER_ID_KEY, ID_KEY});
        DataSetX compareAllDataSetX = compareDataSetX.select(new String[]{TOTAL_AMOUNT_KEY, SERVICE_FEE_KEY, UNBOOK_FEE_KEY, ORDER_TYPE_KEY, SOURCE_TRAVELER_ID_KEY, ID_KEY});
        DataSetX amountSumDataSetX = HotelDataProcessHandle.getAmountSumDataSetX(allDataSetX);
        DataSetX compareAmountSumDataSetX = HotelDataProcessHandle.getAmountSumDataSetX(compareAllDataSetX);
        DataSetX numsSet = this.getNumsSet(allDataSetX);
        DataSetX compareNumsSet = this.getNumsSet(compareAllDataSetX);
        DataSetX activePeoples = this.getActivePeoples(dataSetX);
        DataSet amountSumDataSet = HotelDataProcessHandle.getResult(amountSumDataSetX, tripBoards);
        DataSet compareAmountSumDataSet = HotelDataProcessHandle.getResult(compareAmountSumDataSetX, tripBoards);
        DataSet currentTotalNums = HotelDataProcessHandle.getResult(numsSet, tripBoards);
        DataSet compareTotalNums = HotelDataProcessHandle.getResult(compareNumsSet, tripBoards);
        DataSet activePeoplesDataSet = HotelDataProcessHandle.getResult(activePeoples, tripBoards);
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        this.algoxResultDeal(resultMap, amountSumDataSet, currentTotalNums, activePeoplesDataSet);
        HashMap<String, Object> compareResultMap = new HashMap<String, Object>(16);
        this.algoxResultDeal(compareResultMap, compareAmountSumDataSet, compareTotalNums, activePeoplesDataSet);
        this.rateDeal(resultMap, compareResultMap);
        TripBoardsUtil.formatDecimal(resultMap);
        this.setDataResult(resultMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void algoxResultDeal(Map<String, Object> resultMap, DataSet amountSumDataSetX, DataSet numsSet, DataSet activePeoples) {
        try {
            Iterator iterator = amountSumDataSetX.iterator();
            int orderNums = 0;
            for (Object row : numsSet) {
                orderNums = row.getInteger(ID_KEY);
            }
            int activePeople = 0;
            if (activePeoples.hasNext()) {
                for (Row people : activePeoples) {
                    activePeople = people.getInteger(SOURCE_TRAVELER_ID_KEY);
                }
            }
            while (iterator.hasNext()) {
                Object row;
                row = (Row)iterator.next();
                this.getResultMap(resultMap, row.getDouble(TOTAL_AMOUNT_KEY), Long.parseLong(String.valueOf(orderNums)), Long.parseLong(String.valueOf(activePeople)), row.getDouble(UNBOOK_FEE_KEY), row.getDouble(SERVICE_FEE_KEY));
                HotelDataProcessHandle.putOriginValueMap(resultMap, row.getDouble(TOTAL_AMOUNT_KEY), Long.parseLong(String.valueOf(orderNums)), Long.parseLong(String.valueOf(activePeople)), row.getDouble(UNBOOK_FEE_KEY), row.getDouble(SERVICE_FEE_KEY));
            }
        }
        finally {
            amountSumDataSetX.close();
            numsSet.close();
            activePeoples.close();
        }
    }

    private static DataSetX getAmountSumDataSetX(DataSetX allDataSetX) {
        return allDataSetX.sum(TOTAL_AMOUNT_KEY).sum(SERVICE_FEE_KEY).sum(UNBOOK_FEE_KEY);
    }

    private DataSetX getActivePeoples(DataSetX allDataSetX) {
        return allDataSetX.select(new String[]{SOURCE_TRAVELER_ID_KEY}).distinct(new String[]{SOURCE_TRAVELER_ID_KEY}).count(SOURCE_TRAVELER_ID_KEY);
    }

    private DataSetX getNumsSet(DataSetX dataSetX) {
        return dataSetX.filter("ordertype='O'").count(ID_KEY);
    }

    static {
        DEFAULT_MAP_HOTEL.put("h_active_people", 0);
        DEFAULT_MAP_HOTEL.put("h_month_arrow", "-");
        DEFAULT_MAP_HOTEL.put("h_month_amount", "-");
        DEFAULT_MAP_HOTEL.put("h_month_rate", "-");
        DEFAULT_MAP_HOTEL.put("h_order_nums", "-");
        DEFAULT_MAP_HOTEL.put("h_ordernums_arrow", "-");
        DEFAULT_MAP_HOTEL.put("h_ordernums_rate", "-");
        DEFAULT_MAP_HOTEL.put("h_refund_arrow", "-");
        DEFAULT_MAP_HOTEL.put("h_refund_rate", "-");
        DEFAULT_MAP_HOTEL.put("h_refund_fee", "-");
        DEFAULT_MAP_HOTEL.put("h_service_arrow", "-");
        DEFAULT_MAP_HOTEL.put("h_service_fee", "-");
        DEFAULT_MAP_HOTEL.put("h_service_rate", "-");
    }
}

