/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.web.tripboards.tripindex.planeindex;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import kd.bos.dataentity.ThreeTuple;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IPageCache;
import kd.bos.xdb.util.ConcurrentHashSet;
import kd.fi.er.formplugin.web.tripboards.ChartConfig;
import kd.fi.er.formplugin.web.tripboards.factory.ChartFactory;
import kd.fi.er.formplugin.web.tripboards.model.SummaryModel;
import kd.fi.er.formplugin.web.tripboards.tripindex.planeindex.TripPlaneCostsOverViewDataProcessHandle;
import kd.fi.er.formplugin.web.tripboards.utils.TripBoardsUtil;

public class TripPlaneAmountDataProcessHandle
extends TripPlaneCostsOverViewDataProcessHandle {
    public TripPlaneAmountDataProcessHandle(Map<String, Object> paramMap) {
        super(paramMap);
        this.setNeedYoY(Boolean.FALSE);
    }

    public TripPlaneAmountDataProcessHandle() {
        this.setNeedYoY(Boolean.FALSE);
    }

    @Override
    public Boolean isNeedDB() {
        return Boolean.FALSE;
    }

    @Override
    public void dataHandle(Object data) {
        if (!this.getZipper().booleanValue()) {
            List<Object> convertData;
            LocalDate localEndDate;
            Map<String, Object> param = this.getParam();
            LocalDate localDate = (LocalDate)param.get("beginDate");
            long between = ChronoUnit.MONTHS.between(localDate, localEndDate = (LocalDate)param.get("endDate")) + 1L;
            if (between != 12L) {
                param.put("beginDate", localDate.minusMonths(12L - between));
            }
            if ((convertData = this.getCacheData(this.getCacheKeys(param))).isEmpty()) {
                return;
            }
            List<SummaryModel> summaryModels = convertData.parallelStream().map(obj -> (SummaryModel)obj).collect(Collectors.toList());
            summaryModels = this.getOtherSummaryTag(summaryModels.parallelStream().map(SummaryModel::getId).collect(Collectors.toList()));
            this.finalDataDeal(summaryModels);
        }
    }

    private void finalDataDeal(List<SummaryModel> summaryModels) {
        Map dataMap = summaryModels.parallelStream().filter(obj -> {
            Date time = obj.getSummaryEnd();
            if (time == null) {
                return false;
            }
            JSONObject otherSummaryJson = JSONObject.parseObject((String)obj.getOtherSummary());
            return otherSummaryJson != null && otherSummaryJson.containsKey((Object)"orderNumsAndAmount");
        }).collect(Collectors.groupingByConcurrent(obj -> {
            Date time = obj.getSummaryEnd();
            LocalDate date = TripBoardsUtil.convertDateToLocalDate(time);
            return date.getYear() + "_" + date.getMonthValue();
        }, Collector.of(ConcurrentHashSet::new, (set, obj) -> {
            JSONObject returnJson = JSONObject.parseObject((String)obj.getOtherSummary());
            JSONArray jsonArray = returnJson.getJSONArray("orderNumsAndAmount");
            jsonArray.forEach(item -> set.add(String.valueOf(item)));
        }, (set1, set2) -> {
            set1.addAll(set2);
            return set1;
        }, new Collector.Characteristics[0])));
        List<ThreeTuple<Integer, Integer, Set<String>>> returnData = dataMap.entrySet().stream().map(entry -> {
            String[] yearAndMonth = ((String)entry.getKey()).split("_");
            return new ThreeTuple((Object)Integer.parseInt(yearAndMonth[0]), (Object)Integer.parseInt(yearAndMonth[1]), entry.getValue());
        }).sorted(Comparator.comparingInt(th -> (Integer)th.item1).thenComparingInt(th -> (Integer)th.item2)).collect(Collectors.toList());
        String suffix = ResManager.loadKDString((String)"\u6708", (String)"AccumulateControlServiceImpl_0", (String)"fi-er-business", (Object[])new Object[0]);
        String yearSuffix = ResManager.loadKDString((String)"\u5e74", (String)"TripBoard_9", (String)"fi-er-business", (Object[])new Object[0]);
        HashSet<String> legendData = new HashSet<String>();
        LinkedHashSet<String> xAxisDataSet = new LinkedHashSet<String>();
        this.getXAxisDataAndLegendData(returnData, xAxisDataSet, legendData);
        HashSet<String> amountUnitSet = new HashSet<String>(2);
        Map<String, BigDecimal> monthDataMap = returnData.stream().collect(Collectors.toMap(tuple -> tuple.item1 + yearSuffix + tuple.item2 + suffix, tuple -> {
            Set item3 = (Set)tuple.item3;
            double totalamount = 0.0;
            for (String orderInfo : item3) {
                String[] info = orderInfo.split("\\$");
                int length = info.length;
                String totalamountStr = length >= 2 ? info[1] : "0";
                totalamount = Double.sum(totalamount, Double.parseDouble(totalamountStr));
            }
            return BigDecimal.valueOf(totalamount);
        }, BigDecimal::add));
        for (BigDecimal value2 : monthDataMap.values()) {
            String amountUnit = TripBoardsUtil.getAmountUnit(value2);
            amountUnitSet.add(amountUnit);
        }
        boolean isNumberFormatter = amountUnitSet.size() == 1;
        List datas = xAxisDataSet.stream().map(month -> monthDataMap.getOrDefault(month, BigDecimal.ZERO)).map(value -> isNumberFormatter ? TripBoardsUtil.digitalProcess(TripBoardsUtil.numberFormatter(value)) : TripBoardsUtil.digitalProcess(value)).collect(Collectors.toList());
        JSONArray jsonArray = new JSONArray();
        HashMap<String, Object> jsonObject = new HashMap<String, Object>();
        jsonObject.put("type", "line");
        jsonObject.put("data", datas);
        JSONObject areaStyle = new JSONObject();
        JSONObject colorStyle = new JSONObject();
        colorStyle.put("type", (Object)"linear");
        colorStyle.put("x", (Object)"0");
        colorStyle.put("y", (Object)"0");
        colorStyle.put("x2", (Object)"0");
        colorStyle.put("y2", (Object)"1");
        JSONArray colorStops = new JSONArray();
        JSONObject stopFirst = new JSONObject();
        stopFirst.put("offset", (Object)"0");
        stopFirst.put("color", (Object)"#40A9FF");
        JSONObject stopSecond = new JSONObject();
        stopSecond.put("offset", (Object)"1");
        stopSecond.put("color", (Object)"rgba(64,169,255,0.00)");
        colorStops.add((Object)stopFirst);
        colorStops.add((Object)stopSecond);
        colorStyle.put("colorStops", (Object)colorStops);
        areaStyle.put("color", (Object)colorStyle);
        jsonObject.put("areaStyle", areaStyle);
        jsonObject.put("smooth", true);
        jsonObject.put("symbol", "emptyCircle");
        jsonObject.put("symbolSize", "8");
        JSONObject itemJson = new JSONObject();
        itemJson.put("color", (Object)"#66BAFF");
        jsonObject.put("lineStyle", itemJson);
        itemJson = new JSONObject();
        itemJson.put("color", (Object)"#66BAFF");
        jsonObject.put("itemStyle", itemJson);
        jsonArray.add(jsonObject);
        ChartConfig barConfig = new ChartConfig();
        barConfig.setSeriesList(jsonArray);
        HashMap xAxisMap = Maps.newHashMapWithExpectedSize((int)4);
        xAxisMap.put("type", "category");
        xAxisMap.put("data", xAxisDataSet);
        barConfig.setxAxisMap(xAxisMap);
        HashMap yAxisMap = Maps.newHashMapWithExpectedSize((int)4);
        yAxisMap.put("type", "value");
        yAxisMap.put("name", isNumberFormatter ? new ArrayList(amountUnitSet).get(0) : ResManager.loadKDString((String)"\u5143", (String)"ErCommonUtils_1", (String)"fi-er-business", (Object[])new Object[0]));
        barConfig.setyAxisMap(yAxisMap);
        HashMap toolTipMap = Maps.newHashMapWithExpectedSize((int)4);
        toolTipMap.put("show", true);
        toolTipMap.put("trigger", "axis");
        barConfig.setTooltipMap(toolTipMap);
        HashMap gridMap = Maps.newHashMapWithExpectedSize((int)8);
        gridMap.put("bottom", "15");
        gridMap.put("top", "30");
        barConfig.setGridMap(gridMap);
        HashMap<String, Object> legendMap = new HashMap<String, Object>(4);
        legendMap.put("show", false);
        barConfig.setLegendMap(legendMap);
        this.setDataResult(ChartFactory.createChart("LINE", barConfig));
    }

    private void getXAxisDataAndLegendData(List<ThreeTuple<Integer, Integer, Set<String>>> returnData, Set<String> xAxisData, Set<String> legendData) {
        String suffix = ResManager.loadKDString((String)"\u6708", (String)"AccumulateControlServiceImpl_0", (String)"fi-er-business", (Object[])new Object[0]);
        String yearSuffix = ResManager.loadKDString((String)"\u5e74", (String)"TripBoard_9", (String)"fi-er-business", (Object[])new Object[0]);
        for (ThreeTuple<Integer, Integer, Set<String>> returnDatum : returnData) {
            Integer year = (Integer)returnDatum.item1;
            xAxisData.add(year + yearSuffix + returnDatum.item2 + suffix);
            legendData.add(year + "");
        }
    }

    @Override
    public Boolean getZipper() {
        return Boolean.TRUE;
    }

    @Override
    public Object handleRequest(List<SummaryModel> filterData, List<SummaryModel> allData, IPageCache pageCache) {
        this.finalDataDeal(allData);
        return this.getDataResult();
    }
}

