/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.web.tripboards.tripindex.planeindex;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import kd.bos.dataentity.ThreeTuple;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IPageCache;
import kd.fi.er.business.trip.task.tripboards.OrderSummaryTask;
import kd.fi.er.formplugin.web.tripboards.ChartConfig;
import kd.fi.er.formplugin.web.tripboards.factory.ChartFactory;
import kd.fi.er.formplugin.web.tripboards.model.SummaryModel;
import kd.fi.er.formplugin.web.tripboards.service.Handle;
import kd.fi.er.formplugin.web.tripboards.tripindex.planeindex.TripPlaneCostsOverViewDataProcessHandle;
import kd.fi.er.formplugin.web.tripboards.utils.TripBoardsUtil;

public class TripPlaneChangeAndRefundAnalyseDataProcessHandle
extends TripPlaneCostsOverViewDataProcessHandle
implements Handle {
    static Map<String, Object> DEFAULT_MAP_PLANE_REFUND_AND_CHANGE_ANALYSE = new HashMap<String, Object>(16);
    private static final String JSON_REFUND_KEY = "refundanlyse";
    private static final String JSON_CHANGE_KEY = "changeanlyse";

    public TripPlaneChangeAndRefundAnalyseDataProcessHandle(Map<String, Object> paramMap) {
        super(paramMap);
        this.setNeedYoY(Boolean.FALSE);
        this.setDataResult(DEFAULT_MAP_PLANE_REFUND_AND_CHANGE_ANALYSE);
    }

    public TripPlaneChangeAndRefundAnalyseDataProcessHandle() {
        this.setNeedYoY(Boolean.FALSE);
        this.setDataResult(DEFAULT_MAP_PLANE_REFUND_AND_CHANGE_ANALYSE);
    }

    @Override
    public Boolean isNeedDB() {
        return Boolean.FALSE;
    }

    @Override
    public void dataHandle(Object data) {
        if (!this.getZipper().booleanValue()) {
            List<Object> convertData;
            LocalDate localEndDate;
            Map<String, Object> param = this.getParam();
            HashMap<String, Object> newParam = new HashMap<String, Object>(param);
            LocalDate localDate = (LocalDate)newParam.get("beginDate");
            long between = ChronoUnit.MONTHS.between(localDate, localEndDate = (LocalDate)newParam.get("endDate")) + 1L;
            if (between != 12L) {
                newParam.put("beginDate", localDate.minusMonths(12L - between));
            }
            if ((convertData = this.getCacheData(this.getCacheKeys(newParam))).isEmpty()) {
                this.setDataResult(DEFAULT_MAP_PLANE_REFUND_AND_CHANGE_ANALYSE);
                return;
            }
            List<SummaryModel> summaryModels = convertData.parallelStream().map(obj -> (SummaryModel)obj).collect(Collectors.toList());
            summaryModels = this.getOtherSummaryTag(summaryModels.parallelStream().map(SummaryModel::getId).collect(Collectors.toList()));
            List<SummaryModel> filterData = between == 12L ? summaryModels : TripPlaneChangeAndRefundAnalyseDataProcessHandle.getFilterData(param, summaryModels);
            this.finalDataDeal(filterData, summaryModels);
        }
    }

    private void finalDataDeal(List<SummaryModel> filterData, List<SummaryModel> summaryModels) {
        HashMap<String, Map<String, Object>> returnMap = new HashMap<String, Map<String, Object>>(16);
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        this.dealData(filterData, resultMap);
        returnMap.put("flexData", resultMap);
        Map<String, Object> refundAnlyseChartMap = this.dealChartData(summaryModels, JSON_REFUND_KEY);
        Map<String, Object> changeAnlyseChartMap = this.dealChartData(summaryModels, JSON_CHANGE_KEY);
        returnMap.put("command", refundAnlyseChartMap);
        returnMap.put("commandChange", changeAnlyseChartMap);
        this.setDataResult(returnMap);
    }

    protected static List<SummaryModel> getFilterData(Map<String, Object> param, List<SummaryModel> convertData) {
        LocalDate beginDate = (LocalDate)param.get("beginDate");
        LocalDate endDate = (LocalDate)param.get("endDate");
        List<OrderSummaryTask.DateRange> monthlyDateRanges = TripBoardsUtil.getMonthlyDateRanges(beginDate, endDate);
        ArrayList<SummaryModel> filterData = new ArrayList<SummaryModel>(16);
        for (OrderSummaryTask.DateRange dateRange : monthlyDateRanges) {
            LocalDate start = dateRange.getStart();
            LocalDate end = dateRange.getEnd();
            filterData.addAll(convertData.parallelStream().filter(obj -> TripBoardsUtil.convertDateToLocalDate(obj.getSummaryStart()).equals(start) && TripBoardsUtil.convertDateToLocalDate(obj.getSummaryEnd()).equals(end)).collect(Collectors.toList()));
        }
        return filterData;
    }

    private Map<String, Object> dealChartData(List<SummaryModel> convertData, String jsonKey) {
        Map dataMap = convertData.parallelStream().map(obj -> {
            String otherSummary = obj.getOtherSummary();
            if (otherSummary == null) {
                return null;
            }
            JSONObject jsonObject = JSONObject.parseObject((String)otherSummary);
            if (jsonObject == null || !jsonObject.containsKey((Object)"orderNumsAndAmount")) {
                return null;
            }
            JSONArray keyObject = jsonObject.getJSONArray("orderNumsAndAmount");
            HashSet dataSet = new HashSet();
            if (keyObject != null) {
                dataSet.addAll(keyObject.stream().map(String::valueOf).collect(Collectors.toSet()));
            }
            Date time = obj.getSummaryEnd();
            LocalDate date = TripBoardsUtil.convertDateToLocalDate(time);
            String key = date.getYear() + "_" + date.getMonthValue();
            return new AbstractMap.SimpleEntry(key, dataSet);
        }).filter(Objects::nonNull).collect(Collectors.toConcurrentMap(Map.Entry::getKey, Map.Entry::getValue, (existingSet, newSet) -> {
            existingSet.addAll(newSet);
            return existingSet;
        }, ConcurrentHashMap::new));
        List returnData = dataMap.entrySet().stream().map(entry -> {
            String[] yearAndMonth = ((String)entry.getKey()).split("_");
            return new ThreeTuple((Object)Integer.parseInt(yearAndMonth[0]), (Object)Integer.parseInt(yearAndMonth[1]), entry.getValue());
        }).sorted(Comparator.comparingInt(th -> (Integer)th.item1).thenComparingInt(th -> (Integer)th.item2)).collect(Collectors.toList());
        String suffix = ResManager.loadKDString((String)"\u6708", (String)"AccumulateControlServiceImpl_0", (String)"fi-er-business", (Object[])new Object[0]);
        String yearSuffix = ResManager.loadKDString((String)"\u5e74", (String)"TripBoard_9", (String)"fi-er-business", (Object[])new Object[0]);
        LinkedHashSet xAxisDataSet = new LinkedHashSet(16);
        xAxisDataSet.addAll(returnData.stream().map(obj -> obj.item1 + yearSuffix + obj.item2 + suffix).collect(Collectors.toList()));
        Map<String, Integer> monthDataMap = returnData.stream().collect(Collectors.toMap(tuple -> tuple.item1 + yearSuffix + tuple.item2 + suffix, tuple -> {
            Set item3 = (Set)tuple.item3;
            int totalOrderNum = 0;
            String type = "";
            switch (jsonKey) {
                case "refundanlyse": {
                    type = "T";
                    break;
                }
                case "changeanlyse": {
                    type = "G";
                }
            }
            for (String orderInfo : item3) {
                String[] info = orderInfo.split("\\$");
                int length = info.length;
                String orderType = length >= 7 ? info[6] : "unknown";
                if (!type.equals(orderType)) continue;
                ++totalOrderNum;
            }
            return totalOrderNum;
        }, Integer::sum));
        List orderNumData = xAxisDataSet.stream().map(month -> monthDataMap.getOrDefault(month, 0)).collect(Collectors.toList());
        JSONArray jsonArray = new JSONArray();
        HashMap<String, Object> jsonObject = new HashMap<String, Object>();
        jsonObject.put("type", "line");
        jsonObject.put("data", orderNumData);
        jsonObject.put("smooth", true);
        jsonObject.put("symbol", "emptyCircle");
        jsonObject.put("symbolSize", "8");
        JSONObject areaStyle = new JSONObject();
        JSONObject colorStyle = new JSONObject();
        colorStyle.put("type", (Object)"linear");
        colorStyle.put("x", (Object)"0");
        colorStyle.put("y", (Object)"0");
        colorStyle.put("x2", (Object)"0");
        colorStyle.put("y2", (Object)"1");
        JSONArray colorStops = new JSONArray();
        JSONObject stopFirst = new JSONObject();
        stopFirst.put("offset", (Object)"0");
        stopFirst.put("color", (Object)"#29C392");
        JSONObject stopSecond = new JSONObject();
        stopSecond.put("offset", (Object)"1");
        stopSecond.put("color", (Object)"rgba(41,195,146,0.00)");
        colorStops.add((Object)stopFirst);
        colorStops.add((Object)stopSecond);
        colorStyle.put("colorStops", (Object)colorStops);
        areaStyle.put("color", (Object)colorStyle);
        jsonObject.put("areaStyle", areaStyle);
        JSONObject itemJson = new JSONObject();
        itemJson.put("color", (Object)"#3FEEBF");
        jsonObject.put("lineStyle", itemJson);
        itemJson = new JSONObject();
        itemJson.put("color", (Object)"#3FEEBF");
        jsonObject.put("itemStyle", itemJson);
        jsonArray.add(jsonObject);
        ChartConfig barConfig = new ChartConfig();
        barConfig.setSeriesList(jsonArray);
        HashMap<String, Object> legendMap = new HashMap<String, Object>(4);
        legendMap.put("show", false);
        barConfig.setLegendMap(legendMap);
        HashMap yAxisMap = Maps.newHashMapWithExpectedSize((int)4);
        yAxisMap.put("type", "value");
        yAxisMap.put("name", ResManager.loadKDString((String)"\u8ba2\u5355\u6570", (String)"TripBoard_1", (String)"fi-er-business", (Object[])new Object[0]));
        barConfig.setyAxisMap(yAxisMap);
        HashMap xAxisMap = Maps.newHashMapWithExpectedSize((int)4);
        xAxisMap.put("type", "category");
        xAxisMap.put("data", xAxisDataSet);
        barConfig.setxAxisMap(xAxisMap);
        HashMap toolTipMap = Maps.newHashMapWithExpectedSize((int)4);
        toolTipMap.put("show", true);
        toolTipMap.put("trigger", "axis");
        barConfig.setTooltipMap(toolTipMap);
        HashMap gridMap = Maps.newHashMapWithExpectedSize((int)4);
        gridMap.put("bottom", "15");
        gridMap.put("top", "30");
        barConfig.setGridMap(gridMap);
        return ChartFactory.createChart("LINE", barConfig);
    }

    private void dealData(List<SummaryModel> filterData, Map<String, Object> resultMap) {
        int totalOriginOrderNum = 0;
        int totalRefundOrderNum = 0;
        int totalChangedOrderNum = 0;
        BigDecimal changeTotalLoss = BigDecimal.ZERO;
        BigDecimal refundTotalLoss = BigDecimal.ZERO;
        Set summaryTag = filterData.parallelStream().map(SummaryModel::getOtherSummary).collect(Collectors.toSet());
        Set allOrderInfoSet = summaryTag.stream().map(JSON::parseObject).filter(jsonObject -> jsonObject != null && jsonObject.containsKey((Object)"orderNumsAndAmount")).flatMap(jsonObject -> jsonObject.getJSONArray("orderNumsAndAmount").stream()).map(String::valueOf).collect(Collectors.toSet());
        Map<String, OrderLoss> lossMap = allOrderInfoSet.stream().map(orderInfo -> {
            String orderType;
            String[] info = orderInfo.split("\\$");
            int length = info.length;
            String string = orderType = length >= 7 ? info[6] : "unknown";
            if ("T".equals(orderType)) {
                String refundAmountStr = info[4];
                return new OrderLoss(orderType, "0", refundAmountStr, 1);
            }
            if ("G".equals(orderType)) {
                String changedAmountStr = info[3];
                return new OrderLoss(orderType, changedAmountStr, "0", 1);
            }
            if ("O".equals(orderType)) {
                return new OrderLoss(orderType, "0", "0", 1);
            }
            return new OrderLoss("unknown", "0", "0", 0);
        }).collect(Collectors.groupingBy(OrderLoss::getOrderType, Collectors.reducing(new OrderLoss("unknown", "0", "0", 0), OrderLoss::add)));
        OrderLoss originLoss = lossMap.getOrDefault("O", new OrderLoss("O", "0", "0", 0));
        OrderLoss changedLoss = lossMap.getOrDefault("G", new OrderLoss("G", "0", "0", 0));
        OrderLoss refundLoss = lossMap.getOrDefault("T", new OrderLoss("T", "0", "0", 0));
        totalOriginOrderNum = originLoss.getOrderNum();
        changeTotalLoss = changedLoss.getChangeAmount();
        totalChangedOrderNum = changedLoss.getOrderNum();
        refundTotalLoss = refundLoss.getRefundAmount();
        totalRefundOrderNum = refundLoss.getOrderNum();
        BigDecimal changedFormatter = TripBoardsUtil.digitalProcess(TripBoardsUtil.numberFormatter(changeTotalLoss));
        BigDecimal refundFormatter = TripBoardsUtil.digitalProcess(TripBoardsUtil.numberFormatter(refundTotalLoss));
        resultMap.put("p_changes_loss_title", this.getNewAmountTitle(Double.parseDouble(String.valueOf(changeTotalLoss == null ? Double.valueOf(0.0) : changeTotalLoss)), ResManager.loadKDString((String)"\u9000\u7968\u635f\u5931\uff08\u5143\uff09", (String)"TripBoard_2", (String)"fi-er-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u9000\u7968\u635f\u5931\uff08\u4e07\u5143\uff09", (String)"TripBoard_2_1", (String)"fi-er-business", (Object[])new Object[0])));
        resultMap.put("p_refund_loss_title", this.getNewAmountTitle(Double.parseDouble(String.valueOf(refundTotalLoss == null ? Double.valueOf(0.0) : refundTotalLoss)), ResManager.loadKDString((String)"\u6539\u7b7e\u635f\u5931\uff08\u5143\uff09", (String)"TripBoard_3", (String)"fi-er-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6539\u7b7e\u635f\u5931\uff08\u4e07\u5143\uff09", (String)"TripBoard_3_1", (String)"fi-er-business", (Object[])new Object[0])));
        resultMap.put("p_changes_loss", changedFormatter == null ? BigDecimal.ZERO : changedFormatter);
        resultMap.put("p_refund_loss", refundFormatter == null ? BigDecimal.ZERO : refundFormatter);
        resultMap.put("p_refund_num", totalRefundOrderNum);
        resultMap.put("p_changes_num", totalChangedOrderNum);
        resultMap.put("p_refund_rate", totalOriginOrderNum == 0 ? Integer.valueOf(0) : new BigDecimal(totalRefundOrderNum).divide(new BigDecimal(totalOriginOrderNum), 4, RoundingMode.HALF_UP).multiply(new BigDecimal(100)).setScale(2, RoundingMode.HALF_UP));
        resultMap.put("p_changes_rate", totalOriginOrderNum == 0 ? Integer.valueOf(0) : new BigDecimal(totalChangedOrderNum).divide(new BigDecimal(totalOriginOrderNum), 4, RoundingMode.HALF_UP).multiply(new BigDecimal(100)).setScale(2, RoundingMode.HALF_UP));
    }

    @Override
    public Object handleRequest(List<SummaryModel> filterData, List<SummaryModel> allData, IPageCache pageCache) {
        this.finalDataDeal(filterData, allData);
        return this.getDataResult();
    }

    @Override
    public Boolean getZipper() {
        return Boolean.TRUE;
    }

    static {
        DEFAULT_MAP_PLANE_REFUND_AND_CHANGE_ANALYSE.put("p_refund_loss", "-");
        DEFAULT_MAP_PLANE_REFUND_AND_CHANGE_ANALYSE.put("p_refund_rate", "-");
        DEFAULT_MAP_PLANE_REFUND_AND_CHANGE_ANALYSE.put("p_refund_num", "-");
        DEFAULT_MAP_PLANE_REFUND_AND_CHANGE_ANALYSE.put("p_changes_loss", "-");
        DEFAULT_MAP_PLANE_REFUND_AND_CHANGE_ANALYSE.put("p_changes_rate", "-");
        DEFAULT_MAP_PLANE_REFUND_AND_CHANGE_ANALYSE.put("p_changes_num", "-");
    }

    private static class OrderLoss {
        private final String orderType;
        private final BigDecimal changeAmount;
        private final BigDecimal refundAmount;
        private final int orderNum;

        public OrderLoss(String orderType, String changedAmountStr, String refundAmountStr, int orderNum) {
            this.orderType = orderType;
            this.changeAmount = new BigDecimal(changedAmountStr);
            this.refundAmount = new BigDecimal(refundAmountStr);
            this.orderNum = orderNum;
        }

        public String getOrderType() {
            return this.orderType;
        }

        public BigDecimal getChangeAmount() {
            return this.changeAmount;
        }

        public BigDecimal getRefundAmount() {
            return this.refundAmount;
        }

        public int getOrderNum() {
            return this.orderNum;
        }

        public OrderLoss add(OrderLoss other) {
            return new OrderLoss(this.orderType, this.changeAmount.add(other.changeAmount).toString(), this.refundAmount.add(other.refundAmount).toString(), Integer.sum(this.orderNum, other.getOrderNum()));
        }
    }
}

