/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.web.tripboards.tripindex.planeindex;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.ext.fi.thread.TaskType;
import kd.bos.ext.fi.thread.ThreadService;
import kd.bos.form.IPageCache;
import kd.bos.login.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.ConfigurationUtil;
import kd.fi.er.business.trip.task.tripboards.OrderSummaryTask;
import kd.fi.er.formplugin.web.tripboards.ChartConfig;
import kd.fi.er.formplugin.web.tripboards.factory.ChartFactory;
import kd.fi.er.formplugin.web.tripboards.manager.CacheManager;
import kd.fi.er.formplugin.web.tripboards.model.SummaryModel;
import kd.fi.er.formplugin.web.tripboards.service.Handle;
import kd.fi.er.formplugin.web.tripboards.tripindex.financeindex.PlaneDataProcessHandle;
import kd.fi.er.formplugin.web.tripboards.tripindex.planeindex.TripPlaneAmountDataProcessHandle;
import kd.fi.er.formplugin.web.tripboards.tripindex.planeindex.TripPlaneAverageDiscountDataProcessHandle;
import kd.fi.er.formplugin.web.tripboards.tripindex.planeindex.TripPlaneBookInAdvanceDataProcessHandle;
import kd.fi.er.formplugin.web.tripboards.tripindex.planeindex.TripPlaneChangeAndRefundAnalyseDataProcessHandle;
import kd.fi.er.formplugin.web.tripboards.tripindex.planeindex.TripPlaneDeptRankDataProcessHandle;
import kd.fi.er.formplugin.web.tripboards.tripindex.planeindex.TripPlaneFullTicketDataProcessHandle;
import kd.fi.er.formplugin.web.tripboards.tripindex.planeindex.TripPlanePopularAirDataProcessHandle;
import kd.fi.er.formplugin.web.tripboards.tripindex.planeindex.TripPlaneTakeOffTimeDataProcessHandle;
import kd.fi.er.formplugin.web.tripboards.utils.OrgTreeBuilder;
import kd.fi.er.formplugin.web.tripboards.utils.TripBoardsUtil;

public class TripPlaneCostsOverViewDataProcessHandle
extends PlaneDataProcessHandle
implements Handle {
    public static final String PROPS_KEY = "otherdatasummary_tag";
    public static final String SUMMARY_START = "summarystart";
    public static final String SUMMARY_END = "summaryend";
    public static final String OTHER_NUMS_AND_AMOUNT = "orderNumsAndAmount";
    protected Handle next;

    public TripPlaneCostsOverViewDataProcessHandle(Map<String, Object> paramMap) {
        super(paramMap);
        this.setNeedYoY(Boolean.FALSE);
    }

    public TripPlaneCostsOverViewDataProcessHandle() {
        this.setNeedYoY(Boolean.FALSE);
    }

    @Override
    public String getSelectProps() {
        return "id,summaryamount,orgid,summarystart,summaryend,orgtype,otherdatasummary_tag";
    }

    @Override
    public QFilter[] getFilters(Map<String, Object> filterMap) {
        String inThreshold = ConfigurationUtil.getString((String)"orm.opt.in.threshold");
        if (StringUtils.isEmpty((String)inThreshold)) {
            inThreshold = "10000";
        }
        Set orgIds = (Set)filterMap.get("orgIds");
        LocalDate endDate = (LocalDate)filterMap.get("endDate");
        QFilter startFilter = new QFilter(SUMMARY_START, "=", filterMap.get("beginDate"));
        QFilter endFilter = new QFilter(SUMMARY_END, "=", (Object)endDate);
        QFilter current = startFilter.and(endFilter);
        if (orgIds != null && orgIds.size() <= Integer.parseInt(inThreshold)) {
            this.setOrgFilter(Boolean.TRUE);
            current.and(new QFilter("orgid", "in", orgIds.stream().filter(Objects::nonNull).map(String::valueOf).collect(Collectors.toList())));
        }
        return new QFilter[]{current};
    }

    @Override
    public void dataHandle(Object data) {
        if (data == null) {
            ThreadService.execute(() -> this.dealRestIndex(new ArrayList<DynamicObject>(), new ArrayList<DynamicObject>()), (TaskType)TaskType.ER_LOG_TASK);
            return;
        }
        Map resultMap = (Map)data;
        List<DynamicObject> convertData = (List<DynamicObject>)resultMap.get("current");
        if (convertData.isEmpty()) {
            ThreadService.execute(() -> this.dealRestIndex(new ArrayList<DynamicObject>(), new ArrayList<DynamicObject>()), (TaskType)TaskType.ER_LOG_TASK);
            return;
        }
        Map<String, Object> param = this.getParam();
        Date date = (Date)param.get("originBeginDate");
        param.put("beginDate", TripBoardsUtil.convertDateToLocalDate(date));
        Set orgIds = (Set)param.get("orgIds");
        Set<Long> nextLevelOrgIds = TripPlaneCostsOverViewDataProcessHandle.getNextLevelOrgIds(orgIds);
        LocalDate localDate = (LocalDate)param.get("beginDate");
        LocalDate localEndDate = (LocalDate)param.get("endDate");
        long between = ChronoUnit.MONTHS.between(localDate, localEndDate) + 1L;
        List<Object> filterData = between == 12L ? convertData : TripPlaneCostsOverViewDataProcessHandle.filterData(param, convertData);
        filterData = filterData.stream().filter(obj -> nextLevelOrgIds.contains(obj.getLong("orgid"))).collect(Collectors.toList());
        List<DynamicObject> deptData = filterData.stream().filter(obj -> "dept".equalsIgnoreCase(obj.getString("orgtype"))).collect(Collectors.toList());
        LinkedList<Object> companyData = new LinkedList<Object>(filterData);
        HashSet smallSet = new HashSet(deptData);
        companyData.removeIf(smallSet::contains);
        ChartConfig barConfig = TripPlaneCostsOverViewDataProcessHandle.getChartData(filterData, nextLevelOrgIds);
        Map<String, Object> allChartData = ChartFactory.createChart("BAR", barConfig);
        ChartConfig deptBarConfig = TripPlaneCostsOverViewDataProcessHandle.getChartData(deptData, nextLevelOrgIds);
        Map<String, Object> deptChartData = ChartFactory.createChart("BAR", deptBarConfig);
        ChartConfig companyBarConfig = TripPlaneCostsOverViewDataProcessHandle.getChartData(companyData, nextLevelOrgIds);
        Map<String, Object> companyChartData = ChartFactory.createChart("BAR", companyBarConfig);
        HashMap<String, Map<String, Object>> returnMap = new HashMap<String, Map<String, Object>>();
        returnMap.put("all", allChartData);
        returnMap.put("dept", deptChartData);
        returnMap.put("company", companyChartData);
        this.setDataResult(returnMap);
        List<Object> finalFilterData = filterData;
        ThreadService.execute(() -> this.dealRestIndex(finalFilterData, convertData), (TaskType)TaskType.ER_LOG_TASK);
    }

    private void dealRestIndex(List<DynamicObject> originFilterData, List<DynamicObject> originAllData) {
        Handle first;
        Map<String, Object> param = this.getParam();
        IPageCache pageCache = this.getPageCache();
        LocalDate localDate = (LocalDate)param.get("beginDate");
        LocalDate localEndDate = (LocalDate)param.get("endDate");
        long between = ChronoUnit.MONTHS.between(localDate, localEndDate) + 1L;
        List<SummaryModel> allData = originAllData.parallelStream().map(dynamicObject -> new SummaryModel(dynamicObject.getLong("id"), dynamicObject.getBigDecimal("summaryamount"), dynamicObject.getString("orgid"), dynamicObject.getDate(SUMMARY_START), dynamicObject.getDate(SUMMARY_END), dynamicObject.getString("orgtype"), dynamicObject.getString(PROPS_KEY))).collect(Collectors.toList());
        List<SummaryModel> filterData = between == 12L ? allData : originFilterData.parallelStream().map(dynamicObject -> new SummaryModel(dynamicObject.getLong("id"), dynamicObject.getBigDecimal("summaryamount"), dynamicObject.getString("orgid"), dynamicObject.getDate(SUMMARY_START), dynamicObject.getDate(SUMMARY_END), dynamicObject.getString("orgtype"), dynamicObject.getString(PROPS_KEY))).collect(Collectors.toList());
        HashMap<String, Object> newParam = new HashMap<String, Object>(param);
        Map<String, Object> planeReverSalMap = TripPlaneCostsOverViewDataProcessHandle.putParam(newParam, "trip_plane_reversal_percent", "trip_plane_reversal_result", "OVER_TRIP_PLANE_REVERSAL");
        Map<String, Object> planeAmountMap = TripPlaneCostsOverViewDataProcessHandle.putParam(TripPlaneCostsOverViewDataProcessHandle.getNewParam(param), "trip_plane_amount_percent", "trip_plane_amount_result", "OVER_TRIP_PLANE_AMOUNT");
        TripPlaneAmountDataProcessHandle second = new TripPlaneAmountDataProcessHandle(planeAmountMap);
        Map<String, Object> takeOffTimeMap = TripPlaneCostsOverViewDataProcessHandle.putParam(TripPlaneCostsOverViewDataProcessHandle.getNewParam(param), "trip_plane_takeofftime_percent", "trip_plane_takeofftime_result", "OVER_TRIP_PLANE_TAKEOFFTIME");
        TripPlaneTakeOffTimeDataProcessHandle third = new TripPlaneTakeOffTimeDataProcessHandle(takeOffTimeMap);
        Map<String, Object> disCountMap = TripPlaneCostsOverViewDataProcessHandle.putParam(TripPlaneCostsOverViewDataProcessHandle.getNewParam(param), "trip_plane_discount_percent", "trip_plane_discount_result", "OVER_TRIP_PLANE_AVERAGE_DISCOUNT");
        TripPlaneAverageDiscountDataProcessHandle fourth = new TripPlaneAverageDiscountDataProcessHandle(disCountMap);
        Map<String, Object> bookInAdvancedMap = TripPlaneCostsOverViewDataProcessHandle.putParam(TripPlaneCostsOverViewDataProcessHandle.getNewParam(param), "trip_plane_bookinadvanced_percent", "trip_plane_bookinadvanced_result", "OVER_TRIP_PLANE_BOOKINADVANCED");
        TripPlaneBookInAdvanceDataProcessHandle fifth = new TripPlaneBookInAdvanceDataProcessHandle(bookInAdvancedMap);
        Map<String, Object> popularAirMap = TripPlaneCostsOverViewDataProcessHandle.putParam(TripPlaneCostsOverViewDataProcessHandle.getNewParam(param), "trip_plane_popular_air_percent", "trip_plane_popularair_result", "OVER_TRIP_PLANE_POPULARAIR ");
        TripPlanePopularAirDataProcessHandle sixth = new TripPlanePopularAirDataProcessHandle(popularAirMap);
        Map<String, Object> fullTicketMap = TripPlaneCostsOverViewDataProcessHandle.putParam(TripPlaneCostsOverViewDataProcessHandle.getNewParam(param), "trip_plane_fullticket_percent", "trip_plane_fullticket_result", "OVER_TRIP_PLANE_FULLTICKET");
        TripPlaneFullTicketDataProcessHandle seventh = new TripPlaneFullTicketDataProcessHandle(fullTicketMap);
        Map<String, Object> deptRankMap = TripPlaneCostsOverViewDataProcessHandle.putParam(TripPlaneCostsOverViewDataProcessHandle.getNewParam(param), "trip_plane_deptrank_percent", "trip_plane_deptrank_result", "OVER_TRIP_PLANE_DEPTRANK");
        TripPlaneDeptRankDataProcessHandle eighth = new TripPlaneDeptRankDataProcessHandle(deptRankMap);
        first.setNext(second);
        second.setNext(third);
        third.setNext(fourth);
        fourth.setNext(fifth);
        fifth.setNext(sixth);
        sixth.setNext(seventh);
        seventh.setNext(eighth);
        for (first = new TripPlaneChangeAndRefundAnalyseDataProcessHandle(planeReverSalMap); first != null; first = first.getNext()) {
            Object result = first.handleRequest(filterData, allData, pageCache);
            this.dataCachePut(result, first.getRequestParam());
        }
    }

    private static Map<String, Object> getNewParam(Map<String, Object> param) {
        return new HashMap<String, Object>(param);
    }

    private static Map<String, Object> putParam(Map<String, Object> paramMap, String percentKey, String resultKey, String overFlag) {
        String prefix = RequestContext.get().getCurrUserId() + "_";
        paramMap.put("percentKey", prefix + percentKey);
        paramMap.put("resultKey", prefix + resultKey);
        paramMap.put("overFlag", prefix + overFlag);
        return paramMap;
    }

    private static ChartConfig getChartData(List<DynamicObject> filterData, Set<Long> nextLevelOrgIds) {
        Map<Long, List<DynamicObject>> groupData = filterData.parallelStream().collect(Collectors.groupingBy(obj -> obj.getLong("orgid")));
        TreeMap<Long, Tuple> orgMap = new TreeMap<Long, Tuple>();
        ArrayList<String> ticketStatusList = new ArrayList<String>(Arrays.asList("USED", "UNUSED", "CHANGED"));
        for (Map.Entry<Long, List<DynamicObject>> entry : groupData.entrySet()) {
            Long orgId = entry.getKey();
            List<DynamicObject> group = entry.getValue();
            Object totalAmount = BigDecimal.ZERO;
            Integer orderNumCount = 0;
            HashSet allOrderInfoSet = new HashSet();
            List summaryTag = group.parallelStream().map(dynamicObject -> dynamicObject.getString(PROPS_KEY)).collect(Collectors.toList());
            for (String s : summaryTag) {
                JSONObject jsonObject = JSONObject.parseObject((String)s);
                JSONArray orderArray = jsonObject.getJSONArray(OTHER_NUMS_AND_AMOUNT);
                allOrderInfoSet.addAll(orderArray.stream().map(String::valueOf).collect(Collectors.toSet()));
            }
            for (String orderInfo : allOrderInfoSet) {
                String[] info = orderInfo.split("\\$");
                int length = info.length;
                String ticketsStatus = length >= 6 ? info[5] : "unknown";
                if (!ticketStatusList.contains(ticketsStatus)) continue;
                String totalamountStr = length >= 2 ? info[1] : "0";
                totalAmount = ((BigDecimal)totalAmount).add(BigDecimal.valueOf(Double.parseDouble(totalamountStr)));
                Integer n = orderNumCount;
                Integer n2 = orderNumCount = Integer.valueOf(orderNumCount + 1);
            }
            orgMap.put(orgId, Tuple.create((Object)totalAmount, (Object)orderNumCount));
        }
        List finalData = orgMap.entrySet().stream().sorted(new Comparator<Map.Entry<Long, Tuple<BigDecimal, Integer>>>(){

            @Override
            public int compare(Map.Entry<Long, Tuple<BigDecimal, Integer>> o1, Map.Entry<Long, Tuple<BigDecimal, Integer>> o2) {
                if (((BigDecimal)o2.getValue().item1).compareTo((BigDecimal)o1.getValue().item1) > 0) {
                    return 1;
                }
                if (((BigDecimal)o2.getValue().item1).compareTo((BigDecimal)o1.getValue().item1) < 0) {
                    return -1;
                }
                return 0;
            }
        }).collect(Collectors.toList());
        finalData = finalData.stream().limit(10L).collect(Collectors.toList());
        Map<Long, String> orgAndNameMap = TripBoardsUtil.getOrganizationInfo(new ArrayList<Long>(nextLevelOrgIds));
        ArrayList<Object> xData = new ArrayList<Object>(16);
        ArrayList<String> categoryName = new ArrayList<String>(16);
        for (Map.Entry finalDatum : finalData) {
            xData.add(((Tuple)finalDatum.getValue()).item1);
            categoryName.add(orgAndNameMap.get(finalDatum.getKey()));
        }
        ArrayList<String> funs = new ArrayList<String>();
        funs.add("yAxis");
        funs.add("axisLabel");
        funs.add("formatter");
        ArrayList<List<Object>> funList = new ArrayList<List<Object>>();
        funList.add(funs);
        ChartConfig barConfig = new ChartConfig();
        barConfig.setCurrentName(ResManager.loadKDString((String)"\u6708\u7ed3\u91d1\u989d", (String)"TripBoard_4", (String)"fi-er-business", (Object[])new Object[0]));
        barConfig.setCurrentData(xData.toArray(new BigDecimal[0]));
        barConfig.setCategoryData(categoryName.toArray());
        barConfig.setFunctions(funList);
        HashMap toolTipMap = Maps.newHashMapWithExpectedSize((int)4);
        toolTipMap.put("trigger", "axis");
        toolTipMap.put("show", true);
        barConfig.setTooltipMap(toolTipMap);
        HashMap legendMap = Maps.newHashMapWithExpectedSize((int)4);
        legendMap.put("right", "20");
        legendMap.put("itemWidth", 10);
        legendMap.put("itemHeight", 10);
        barConfig.setLegendMap(legendMap);
        HashMap gridMap = Maps.newHashMapWithExpectedSize((int)4);
        gridMap.put("bottom", "15");
        gridMap.put("right", "20");
        gridMap.put("top", "18");
        barConfig.setGridMap(gridMap);
        return barConfig;
    }

    private static Set<Long> getNextLevelOrgIds(Set<Long> orgIds) {
        HashSet<Long> nextLevelOrgIds = new HashSet<Long>();
        HashSet<Long> hasNextLevelOrgIds = new HashSet<Long>();
        OrgTreeBuilder treeBuilder = OrgTreeBuilder.getInstance();
        for (Long orgId : orgIds) {
            Set<Long> childById = treeBuilder.getChildById(orgId, treeBuilder, Boolean.TRUE);
            if (childById.size() > 1) {
                hasNextLevelOrgIds.add(orgId);
            }
            nextLevelOrgIds.addAll(childById);
        }
        nextLevelOrgIds.removeAll(hasNextLevelOrgIds);
        return nextLevelOrgIds;
    }

    @Override
    public String getCacheKey() {
        return RequestContext.get().getCurrUserId() + "_TRIP_PLANE_INDEX_PLANE_SEPARATE_CACHE_KEY";
    }

    private static List<DynamicObject> filterData(Map<String, Object> param, List<DynamicObject> convertData) {
        LocalDate beginDate = (LocalDate)param.get("beginDate");
        LocalDate endDate = (LocalDate)param.get("endDate");
        List<OrderSummaryTask.DateRange> monthlyDateRanges = TripBoardsUtil.getMonthlyDateRanges(beginDate, endDate);
        ArrayList<DynamicObject> filterData = new ArrayList<DynamicObject>(16);
        for (OrderSummaryTask.DateRange dateRange : monthlyDateRanges) {
            LocalDate start = dateRange.getStart();
            LocalDate end = dateRange.getEnd();
            filterData.addAll(convertData.parallelStream().filter(obj -> TripBoardsUtil.convertDateToLocalDate(obj.getDate(SUMMARY_START)).equals(start) && TripBoardsUtil.convertDateToLocalDate(obj.getDate(SUMMARY_END)).equals(end)).collect(Collectors.toList()));
        }
        return filterData;
    }

    protected List<String> getCacheKeys(Map<String, Object> param) {
        LocalDate beginDate = (LocalDate)param.get("beginDate");
        LocalDate endDate = (LocalDate)param.get("endDate");
        List<OrderSummaryTask.DateRange> monthlyDateRanges = TripBoardsUtil.getMonthlyDateRanges(beginDate, endDate);
        ArrayList<String> keys = new ArrayList<String>(16);
        for (OrderSummaryTask.DateRange monthlyDateRange : monthlyDateRanges) {
            LocalDate start = monthlyDateRange.getStart();
            LocalDate end = monthlyDateRange.getEnd();
            int year = start.getYear();
            int monthValue = start.getMonthValue();
            int dayOfMonth = start.getDayOfMonth();
            String startKey = year + "-" + monthValue + "-" + dayOfMonth;
            int endYear = end.getYear();
            int endMonthValue = end.getMonthValue();
            int endDayOfMonth = end.getDayOfMonth();
            String endKey = endYear + "-" + endMonthValue + "-" + endDayOfMonth;
            keys.add(this.getCacheKey() + startKey + "-" + endKey);
        }
        return keys;
    }

    protected List<Object> getCacheData(List<String> cacheKeys) {
        ConcurrentLinkedQueue returnData = new ConcurrentLinkedQueue();
        cacheKeys.forEach(cacheKey -> {
            ArrayList<Object> convertData = new ArrayList<Object>(16);
            Object localCacheData = CacheManager.getLocalCacheData(cacheKey, TripPlaneCostsOverViewDataProcessHandle.getPageQueryMap(this.getParam()), ArrayList.class);
            returnData.addAll(CacheManager.typeCheckAndReturnData(localCacheData, convertData));
        });
        return new ArrayList<Object>(returnData);
    }

    protected List<SummaryModel> getOtherSummaryTag(List<Long> summaryIdList) {
        List partition = Lists.partition(summaryIdList, (int)100000);
        ConcurrentLinkedQueue result = new ConcurrentLinkedQueue();
        CountDownLatch count = new CountDownLatch(partition.size());
        for (List ids : partition) {
            ThreadService.execute(() -> {
                try {
                    DynamicObjectCollection dbSummaryTag = QueryServiceHelper.query((String)"er_plane_summary", (String)"otherdatasummary_tag,id,summarystart,summaryend,orgtype,orgid", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)ids)});
                    result.addAll(dbSummaryTag.parallelStream().map(obj -> new SummaryModel(obj.getString(PROPS_KEY), obj.getLong("id"), obj.getDate(SUMMARY_START), obj.getDate(SUMMARY_END), obj.getString("orgtype"), obj.getString("orgid"))).collect(Collectors.toList()));
                }
                finally {
                    count.countDown();
                }
            }, (TaskType)TaskType.ER_LOG_TASK, (RequestContext)RequestContext.get());
        }
        try {
            count.await();
        }
        catch (InterruptedException e) {
            return new ArrayList<SummaryModel>(16);
        }
        return new ArrayList<SummaryModel>(result);
    }

    @Override
    public Boolean getNeedCache() {
        return Boolean.FALSE;
    }

    @Override
    public void setNext(Handle next) {
        this.next = next;
    }

    @Override
    public Handle getNext() {
        return this.next;
    }

    @Override
    public Object handleRequest(List<SummaryModel> filterData, List<SummaryModel> allData, IPageCache pageCache) {
        this.next.handleRequest(filterData, allData, pageCache);
        return this.getDataResult();
    }

    @Override
    public Map<String, Object> getRequestParam() {
        return this.getParam();
    }
}

