/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.web.tripboards.tripindex.planeindex;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.IPageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.xdb.util.ConcurrentHashSet;
import kd.fi.er.formplugin.web.tripboards.model.SummaryModel;
import kd.fi.er.formplugin.web.tripboards.service.Handle;
import kd.fi.er.formplugin.web.tripboards.tripindex.planeindex.TripPlaneTakeOffTimeDataProcessHandle;

public class TripPlaneDeptRankDataProcessHandle
extends TripPlaneTakeOffTimeDataProcessHandle {
    private static final String JSON_DEPT_RANK_AVERAGEDISCOUNT_KEY = "deptrank-averageDiscount";
    private static final String JSON_AVERAGEDISCOUNT_KEY = "averageDiscount";
    private static final String JSON_DEPT_RANK_BOOKINADVANCEDAYS_KEY = "deptrank-bookinadvancedays";
    private static final String JSON_BOOKINADVANCEDAYS_KEY = "bookinadvancedays";
    private static final String JSON_DEPT_RANK_CHANGEANDREFUND_KEY = "deptrank-changeAndRefund";
    private static final String JSON_CHANGEANDREFUNDORDERNUMS_KEY = "changeAndRefundOrderNums";

    public TripPlaneDeptRankDataProcessHandle(Map<String, Object> paramMap) {
        super(paramMap);
        this.setNeedYoY(Boolean.FALSE);
    }

    public TripPlaneDeptRankDataProcessHandle() {
        this.setNeedYoY(Boolean.FALSE);
    }

    @Override
    public void dataHandle(Object data) {
        if (!this.getZipper().booleanValue()) {
            List<Object> convertData = this.getCacheData(this.getCacheKeys(this.getParam()));
            if (convertData.isEmpty()) {
                return;
            }
            List<SummaryModel> filterData = convertData.parallelStream().map(obj -> (SummaryModel)obj).collect(Collectors.toList());
            filterData = this.getOtherSummaryTag(filterData.parallelStream().map(SummaryModel::getId).collect(Collectors.toList()));
            filterData = filterData.stream().filter(obj -> "dept".equalsIgnoreCase(obj.getOrgType())).collect(Collectors.toList());
            this.finalDataDeal(filterData);
        }
    }

    private void finalDataDeal(List<SummaryModel> filterData) {
        JSONObject changeAndRefundJson = TripPlaneDeptRankDataProcessHandle.dealChangeAndRefundData(filterData);
        Map orgAndSummaryTagMap = filterData.parallelStream().filter(obj -> {
            JSONObject dataJson = JSONObject.parseObject((String)obj.getOtherSummary());
            return dataJson != null && dataJson.containsKey((Object)"orderNumsAndAmount");
        }).collect(Collectors.groupingByConcurrent(SummaryModel::getOrgId, Collector.of(ConcurrentHashSet::new, (set, obj) -> {
            JSONObject dataJson = JSONObject.parseObject((String)obj.getOtherSummary());
            JSONArray jsonArray = dataJson.getJSONArray("orderNumsAndAmount");
            for (int i = 0; i < jsonArray.size(); ++i) {
                set.add(jsonArray.getString(i));
            }
        }, (set1, set2) -> {
            set1.addAll(set2);
            return set1;
        }, new Collector.Characteristics[0])));
        JSONObject discountJson = TripPlaneDeptRankDataProcessHandle.dealAverageDiscountAndBookInAdvancedData(orgAndSummaryTagMap, 8, "discount");
        JSONObject bookInAdvancedDaysJson = TripPlaneDeptRankDataProcessHandle.dealAverageDiscountAndBookInAdvancedData(orgAndSummaryTagMap, 9, "bookinadvanceddays");
        JSONObject resultMap = new JSONObject();
        resultMap.put("changeAndRefund", (Object)changeAndRefundJson);
        resultMap.put(JSON_AVERAGEDISCOUNT_KEY, (Object)discountJson);
        resultMap.put("bookInAdvancedDays", (Object)bookInAdvancedDaysJson);
        this.setDataResult(resultMap);
    }

    private static JSONObject dealChangeAndRefundData(List<SummaryModel> filterData) {
        HashMap changeAndRefundMap = new HashMap(16);
        AtomicReference<Integer> totalOrderNumCount = new AtomicReference<Integer>(0);
        Map<String, Integer> orgAndOrderNumCount = TripPlaneDeptRankDataProcessHandle.getOrgAndOrderCountMap(filterData);
        AtomicReference<Integer> totalOriginOrderNumCount = new AtomicReference<Integer>(0);
        filterData.forEach(dynamicObject -> {
            String orgid = dynamicObject.getOrgId();
            JSONObject jsonObject = JSONObject.parseObject((String)dynamicObject.getOtherSummary());
            Integer originOrderNums = (Integer)orgAndOrderNumCount.get(orgid);
            JSONObject dataJson = jsonObject.getJSONObject(JSON_DEPT_RANK_CHANGEANDREFUND_KEY);
            Integer orderNums = dataJson.getInteger(JSON_CHANGEANDREFUNDORDERNUMS_KEY);
            changeAndRefundMap.merge(Long.valueOf(orgid), orderNums, Integer::sum);
            totalOrderNumCount.updateAndGet(v -> v + orderNums);
            totalOriginOrderNumCount.updateAndGet(v -> v + originOrderNums);
        });
        LinkedHashMap dataMap = changeAndRefundMap.entrySet().stream().sorted(Map.Entry.comparingByValue().reversed()).limit(10L).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, Integer::sum, LinkedHashMap::new));
        Set orgIdSet = dataMap.keySet();
        Map orgIdMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "in", orgIdSet)});
        JSONArray changeAndRefundArray = new JSONArray();
        int rank = 0;
        JSONArray refundAndChangeTop3Array = new JSONArray();
        for (Map.Entry entry : dataMap.entrySet()) {
            JSONObject airData = new JSONObject();
            Long key = (Long)entry.getKey();
            DynamicObject org = (DynamicObject)orgIdMap.get(key);
            Integer orderNums = (Integer)entry.getValue();
            airData.put("rank", (Object)(++rank));
            airData.put("deptName", (Object)(org == null ? "unknown" : org.getString("name")));
            airData.put("orders", (Object)orderNums);
            String rate = "0";
            if (totalOriginOrderNumCount.get() != 0) {
                rate = new BigDecimal(orderNums).divide(new BigDecimal(totalOriginOrderNumCount.get()), 2, RoundingMode.HALF_UP).multiply(new BigDecimal(100)) + "%";
            }
            airData.put("rate", (Object)rate);
            String percentage = "0%";
            if (totalOrderNumCount.get() != 0) {
                percentage = new BigDecimal(orderNums).divide(new BigDecimal(totalOrderNumCount.get()), 2, RoundingMode.HALF_UP).multiply(new BigDecimal(100)) + "%";
            }
            airData.put("percentage", (Object)percentage);
            changeAndRefundArray.add((Object)airData);
        }
        JSONObject changeAndRefundJson = new JSONObject();
        changeAndRefundJson.put("top3", (Object)refundAndChangeTop3Array);
        changeAndRefundJson.put("others", (Object)changeAndRefundArray);
        return changeAndRefundJson;
    }

    private static JSONObject dealAverageDiscountAndBookInAdvancedData(Map<String, Set<String>> orgAndSummaryTagMap, int index, String type) {
        ArrayList<Tuple<Long, BigDecimal>> averageDiscountList = new ArrayList<Tuple<Long, BigDecimal>>(16);
        List<String> ticketStatus = Arrays.asList("USED", "UNUSED", "CHANGED");
        for (Map.Entry<String, Set<String>> entry : orgAndSummaryTagMap.entrySet()) {
            Set<String> value = entry.getValue();
            BigDecimal[] totalDiscount = new BigDecimal[]{BigDecimal.ZERO};
            AtomicInteger orderCount = new AtomicInteger(0);
            value.parallelStream().forEach(obj -> {
                String[] split = obj.split("\\$");
                if (split.length < 10) {
                    return;
                }
                if (!ticketStatus.contains(split[5])) {
                    return;
                }
                orderCount.getAndIncrement();
                String discount = split[index];
                totalDiscount[0] = totalDiscount[0].add(BigDecimal.valueOf(Double.parseDouble(discount)));
            });
            averageDiscountList.add((Tuple<Long, BigDecimal>)new Tuple((Object)Long.parseLong(entry.getKey()), (Object)(orderCount.get() == 0 ? BigDecimal.ZERO : totalDiscount[0].divide(new BigDecimal(orderCount.get()), 2, RoundingMode.HALF_UP))));
        }
        return TripPlaneDeptRankDataProcessHandle.getReturnJson(averageDiscountList, type);
    }

    private static JSONObject getReturnJson(List<Tuple<Long, BigDecimal>> averageDiscountList, String key) {
        List newDataList = averageDiscountList.stream().sorted(Comparator.comparing(th -> (BigDecimal)th.item2).reversed()).limit(10L).collect(Collectors.toList());
        if ("bookinadvanceddays".equals(key)) {
            newDataList = newDataList.stream().map(obj -> Tuple.create((Object)obj.item1, (Object)(((BigDecimal)obj.item2).compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : (BigDecimal)obj.item2))).collect(Collectors.toList());
        }
        Set orgIdSet = newDataList.stream().map(obj -> (Long)obj.item1).collect(Collectors.toSet());
        Map orgIdMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "in", orgIdSet)});
        JSONArray dataArray = new JSONArray();
        int rank = 0;
        JSONArray refundAndChangeTop3Array = new JSONArray();
        for (Tuple entry : newDataList) {
            JSONObject airData = new JSONObject();
            Long orgId = (Long)entry.item1;
            DynamicObject org = (DynamicObject)orgIdMap.get(orgId);
            airData.put("rank", (Object)(++rank));
            airData.put("deptName", (Object)(org == null ? "unknown" : org.getString("name")));
            airData.put(key, entry.item2);
            dataArray.add((Object)airData);
        }
        JSONObject returnJson = new JSONObject();
        returnJson.put("top3", (Object)refundAndChangeTop3Array);
        returnJson.put("others", (Object)dataArray);
        return returnJson;
    }

    private static Map<String, Integer> getOrgAndOrderCountMap(List<SummaryModel> filterData) {
        Map<String, List<SummaryModel>> orgGroup = filterData.stream().collect(Collectors.groupingBy(SummaryModel::getOrgId));
        HashMap<String, Integer> orgAndOrderNumCount = new HashMap<String, Integer>(16);
        for (Map.Entry<String, List<SummaryModel>> entry : orgGroup.entrySet()) {
            HashSet allOrderSummaryTag = new HashSet(16);
            AtomicInteger orderNums = new AtomicInteger(0);
            for (SummaryModel summaryModel : entry.getValue()) {
                JSONObject jsonObject = JSONObject.parseObject((String)summaryModel.getOtherSummary());
                if (jsonObject == null || !jsonObject.containsKey((Object)"orderNumsAndAmount")) continue;
                allOrderSummaryTag.addAll(new HashSet(jsonObject.getJSONArray("orderNumsAndAmount").stream().map(String::valueOf).collect(Collectors.toSet())));
            }
            allOrderSummaryTag.parallelStream().forEach(obj -> {
                String[] split = obj.split("\\$");
                if (split.length < 11) {
                    return;
                }
                String orderType = split[6];
                if ("O".equals(orderType)) {
                    orderNums.getAndAdd(1);
                }
            });
            orgAndOrderNumCount.put(entry.getKey(), orderNums.get());
        }
        return orgAndOrderNumCount;
    }

    @Override
    public Object handleRequest(List<SummaryModel> filterData, List<SummaryModel> allData, IPageCache pageCache) {
        this.finalDataDeal(allData);
        return this.getDataResult();
    }

    @Override
    public Handle getNext() {
        return null;
    }
}

