/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.web.tripboards.tripindex.planeindex;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IPageCache;
import kd.fi.er.formplugin.web.tripboards.ChartConfig;
import kd.fi.er.formplugin.web.tripboards.factory.ChartFactory;
import kd.fi.er.formplugin.web.tripboards.model.SummaryModel;
import kd.fi.er.formplugin.web.tripboards.tripindex.planeindex.TripPlaneCostsOverViewDataProcessHandle;

public class TripPlaneTakeOffTimeDataProcessHandle
extends TripPlaneCostsOverViewDataProcessHandle {
    public TripPlaneTakeOffTimeDataProcessHandle(Map<String, Object> paramMap) {
        super(paramMap);
        this.setNeedYoY(Boolean.FALSE);
    }

    public TripPlaneTakeOffTimeDataProcessHandle() {
        this.setNeedYoY(Boolean.FALSE);
    }

    @Override
    public Boolean isNeedDB() {
        return Boolean.FALSE;
    }

    @Override
    public void dataHandle(Object data) {
        if (!this.getZipper().booleanValue()) {
            if (data == null) {
                return;
            }
            List<Object> convertData = this.getCacheData(this.getCacheKeys(this.getParam()));
            if (convertData.isEmpty()) {
                return;
            }
            List<SummaryModel> filterData = convertData.parallelStream().map(obj1 -> (SummaryModel)obj1).collect(Collectors.toList());
            filterData = this.getOtherSummaryTag(filterData.parallelStream().map(SummaryModel::getId).collect(Collectors.toList()));
            this.finalDataDeal(filterData);
        }
    }

    private void finalDataDeal(List<SummaryModel> filterData) {
        ConcurrentHashMap timePeriodAndOrderNumCount = new ConcurrentHashMap(16);
        Set summaryTag = filterData.parallelStream().map(SummaryModel::getOtherSummary).collect(Collectors.toSet());
        Set allOrderSummaryTag = summaryTag.parallelStream().map(JSON::parseObject).filter(jsonObject -> jsonObject != null && jsonObject.containsKey((Object)"orderNumsAndAmount")).flatMap(jsonObject -> jsonObject.getJSONArray("orderNumsAndAmount").stream()).map(String::valueOf).collect(Collectors.toSet());
        List<String> ticketStatus = Arrays.asList("USED", "UNUSED", "CHANGED");
        allOrderSummaryTag.parallelStream().forEach(info -> {
            String[] split = info.split("\\$");
            int arrLength = split.length;
            if (arrLength < 8) {
                return;
            }
            if (!ticketStatus.contains(split[5])) {
                return;
            }
            timePeriodAndOrderNumCount.merge(split[7], 1, Integer::sum);
        });
        Set timePeriodSet = timePeriodAndOrderNumCount.keySet();
        LinkedHashMap<String, String> timePeriodMap = new LinkedHashMap<String, String>(16);
        for (String s : timePeriodSet) {
            String[] timeArr = s.split("-");
            String startTimePoint = timeArr[0];
            timePeriodMap.put(startTimePoint, s);
        }
        ArrayList timePoints = new ArrayList(timePeriodMap.keySet());
        timePoints.sort(new TimePointComparator());
        ArrayList<String> xAxisData = new ArrayList<String>(16);
        for (String timePoint : timePoints) {
            xAxisData.add((String)timePeriodMap.get(timePoint));
        }
        JSONArray jsonArray = new JSONArray();
        JSONObject seriesJson = new JSONObject();
        ArrayList yAxisData = new ArrayList(16);
        for (String timePoint : timePoints) {
            yAxisData.add(timePeriodAndOrderNumCount.get(timePeriodMap.get(timePoint)));
        }
        seriesJson.put("data", yAxisData);
        seriesJson.put("type", (Object)"bar");
        seriesJson.put("barWidth", (Object)"15");
        seriesJson.put("barMaxWidth", (Object)"25");
        JSONObject itemJson = new JSONObject();
        itemJson.put("color", (Object)"#3FEEBF");
        seriesJson.put("itemStyle", (Object)itemJson);
        jsonArray.add((Object)seriesJson);
        this.setDataResult(this.createChart(jsonArray, xAxisData));
    }

    public Map<String, Object> createChart(JSONArray jsonArray, List<String> xAxisData) {
        ChartConfig barConfig = new ChartConfig();
        barConfig.setSeriesList(jsonArray);
        HashMap xAxisMap = Maps.newHashMapWithExpectedSize((int)4);
        xAxisMap.put("type", "category");
        JSONObject axisLabelJson = new JSONObject();
        axisLabelJson.put("show", (Object)true);
        axisLabelJson.put("interval", (Object)0);
        xAxisMap.put("axisLabel", axisLabelJson);
        xAxisMap.put("data", xAxisData);
        barConfig.setxAxisMap(xAxisMap);
        HashMap yAxisMap = Maps.newHashMapWithExpectedSize((int)4);
        yAxisMap.put("type", "value");
        yAxisMap.put("name", ResManager.loadKDString((String)"\u8ba2\u5355\u6570", (String)"TripBoard_1", (String)"fi-er-business", (Object[])new Object[0]));
        barConfig.setyAxisMap(yAxisMap);
        HashMap toolTipMap = Maps.newHashMapWithExpectedSize((int)4);
        toolTipMap.put("show", true);
        toolTipMap.put("trigger", "axis");
        barConfig.setTooltipMap(toolTipMap);
        HashMap gridMap = Maps.newHashMapWithExpectedSize((int)8);
        gridMap.put("bottom", "15");
        gridMap.put("top", "30");
        barConfig.setGridMap(gridMap);
        return ChartFactory.createChart("BAR", barConfig);
    }

    @Override
    public Object handleRequest(List<SummaryModel> filterData, List<SummaryModel> allData, IPageCache pageCache) {
        this.finalDataDeal(filterData);
        return this.getDataResult();
    }

    @Override
    public Boolean getZipper() {
        return Boolean.TRUE;
    }

    static class TimePointComparator
    implements Comparator<String> {
        private final SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm");

        TimePointComparator() {
        }

        @Override
        public int compare(String timePoint1, String timePoint2) {
            try {
                return this.dateFormat.parse(timePoint1).compareTo(this.dateFormat.parse(timePoint2));
            }
            catch (Exception e) {
                return 0;
            }
        }
    }
}

