/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.web.tripboards.utils;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.ThreeTuple;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.StringUtils;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.util.ConfigurationUtil;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.formplugin.web.tripboards.dataprocesshandle.DataProcessHandle;
import kd.fi.er.formplugin.web.tripboards.manager.CacheManager;
import kd.fi.er.formplugin.web.tripboards.tripindex.financeindex.HotelDataProcessHandle;
import kd.fi.er.formplugin.web.tripboards.tripindex.financeindex.PlaneDataProcessHandle;
import kd.fi.er.formplugin.web.tripboards.tripindex.financeindex.TrainDataProcessHandle;
import kd.fi.er.formplugin.web.tripboards.tripindex.financeindex.TripAllExpenseAndRankDataProcessHandle;
import kd.fi.er.formplugin.web.tripboards.tripindex.financeindex.TripExpenseSpreadDataProcessHandle;
import kd.fi.er.formplugin.web.tripboards.tripindex.financeindex.TripTravelDataProcessHandle;
import kd.fi.er.formplugin.web.tripboards.tripindex.financeindex.TripYearBasicAnlyDataProcessHandle;
import kd.fi.er.formplugin.web.tripboards.tripindex.financeindex.VehicleDataProcessHandle;
import kd.fi.er.formplugin.web.tripboards.tripindex.planeindex.TripPlaneAmountDataProcessHandle;
import kd.fi.er.formplugin.web.tripboards.tripindex.planeindex.TripPlaneAverageDiscountDataProcessHandle;
import kd.fi.er.formplugin.web.tripboards.tripindex.planeindex.TripPlaneBookInAdvanceDataProcessHandle;
import kd.fi.er.formplugin.web.tripboards.tripindex.planeindex.TripPlaneChangeAndRefundAnalyseDataProcessHandle;
import kd.fi.er.formplugin.web.tripboards.tripindex.planeindex.TripPlaneCostsOverViewDataProcessHandle;
import kd.fi.er.formplugin.web.tripboards.tripindex.planeindex.TripPlaneDeptRankDataProcessHandle;
import kd.fi.er.formplugin.web.tripboards.tripindex.planeindex.TripPlaneFullTicketDataProcessHandle;
import kd.fi.er.formplugin.web.tripboards.tripindex.planeindex.TripPlanePopularAirDataProcessHandle;
import kd.fi.er.formplugin.web.tripboards.tripindex.planeindex.TripPlaneTakeOffTimeDataProcessHandle;
import kd.fi.er.formplugin.web.tripboards.utils.OrgTreeBuilder;
import kd.fi.er.formplugin.web.tripboards.utils.TripBoardsUtil;

public class DataProcessUtils {
    private static final Log logger = LogFactory.getLog(DataProcessUtils.class);

    public static void processingUnit(IDataModel model, String unitType, IPageCache pageCache) throws Exception {
        try {
            switch (unitType) {
                case "PLANE": {
                    DataProcessUtils.dealPlaneExpenseIndex(model, pageCache);
                    break;
                }
                case "HOTEL": {
                    DataProcessUtils.dealHotelExpenseIndex(model, pageCache);
                    break;
                }
                case "TRAIN": {
                    DataProcessUtils.dealTrainExpenseIndex(model, pageCache);
                    break;
                }
                case "VEHICLE": {
                    DataProcessUtils.dealVehicelExpenseIndex(model, pageCache);
                    break;
                }
                case "EXPENSE_RANK": {
                    DataProcessUtils.dealAllExpenseIndex(model, pageCache);
                    break;
                }
                case "EXPENSE_SPREAD": {
                    DataProcessUtils.dealTripExpenseSpreadIndex(model, pageCache);
                    break;
                }
                case "YOY": {
                    DataProcessUtils.dealYOYIndex(model, pageCache);
                    break;
                }
                case "MAP": {
                    DataProcessUtils.dealTripJourneyIndex(model, pageCache);
                    break;
                }
                case "PLANE_EXPENSE": {
                    DataProcessUtils.dealTripPlaneExpenseIndex(model, pageCache);
                    break;
                }
                case "PLANE_REVERSAL": {
                    DataProcessUtils.deelTripPlaneReversalIndex(model, pageCache);
                    break;
                }
                case "PLANE_AMOUNT": {
                    DataProcessUtils.dealTripPlaneAmountIndex(model, pageCache);
                    break;
                }
                case "PLANE_TAKEOFFTIME": {
                    DataProcessUtils.dealTripPlaneTakeOfftimeIndex(model, pageCache);
                    break;
                }
                case "PLANE_AVERAGE_DISCOUNT": {
                    DataProcessUtils.dealTripPlaneAverageDiscountIndex(model, pageCache);
                    break;
                }
                case "PLANE_BOOKINADVANCED": {
                    DataProcessUtils.dealTripPlaneBooInAdvancedIndex(model, pageCache);
                    break;
                }
                case "PLANE_POPULAR_AIR": {
                    DataProcessUtils.dealTripPlanePopularAirIndex(model, pageCache);
                    break;
                }
                case "PLANE_FULL_TICKET": {
                    DataProcessUtils.dealTripPlaneFullTicketIndex(model, pageCache);
                    break;
                }
                case "PLANE_DEPT_RANK": {
                    DataProcessUtils.dealTripPlaneDeptRankIndex(model, pageCache);
                }
            }
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
    }

    private static Map<String, Object> getParamMap(IDataModel model) {
        Date startDateObj = (Date)model.getValue("dataperiod_startdate");
        Date endDateObj = (Date)model.getValue("dataperiod_enddate");
        Object org = model.getValue("org");
        Long orgId = ErCommonUtils.getPk(org);
        HashMap paramMap = Maps.newHashMapWithExpectedSize((int)2);
        LocalDate beginDate = TripBoardsUtil.convertDateToLocalDate(startDateObj);
        LocalDate currentDate = LocalDate.now();
        LocalDate threeMonthsAgo = currentDate.minusMonths(1L);
        if (beginDate.isAfter(threeMonthsAgo = threeMonthsAgo.with(TemporalAdjusters.firstDayOfMonth())) && beginDate.isBefore(currentDate)) {
            paramMap.put("isReal", "true");
        }
        paramMap.put("beginDate", startDateObj);
        paramMap.put("endDate", endDateObj);
        paramMap.put("rootOrg", orgId);
        long currUserId = RequestContext.get().getCurrUserId();
        if (orgId != null && !CacheManager.getRedisCache().contains(currUserId + "_" + orgId)) {
            OrgTreeBuilder treeBuilder = OrgTreeBuilder.getInstance();
            Set<Long> orgIds = treeBuilder.getChildById(orgId, treeBuilder);
            CacheManager.putSimpleDataCache(currUserId + "_" + orgId, orgIds);
            paramMap.put("orgIds", orgIds);
        } else if (orgId != null) {
            Set cacheOrg = CacheManager.getSimpleDataCache(currUserId + "_" + orgId, HashSet.class);
            HashSet<Long> orgIds = new HashSet<Long>();
            if (cacheOrg == null) {
                orgIds.add(orgId);
            } else {
                for (Object o : cacheOrg) {
                    if (Objects.isNull(o)) continue;
                    orgIds.add(Long.parseLong(o.toString()));
                }
            }
            paramMap.put("orgIds", orgIds);
        }
        return paramMap;
    }

    private static void dealPlaneExpenseIndex(IDataModel model, IPageCache pageCache) throws Exception {
        Map<String, Object> paramMap = DataProcessUtils.getParamMap(model);
        DataProcessUtils.putAlgoxFlag(paramMap);
        DataProcessUtils.executeFun(paramMap, new PlaneDataProcessHandle(paramMap), "plane_task_percent", "plane_result", "OVER_PLANE", pageCache);
    }

    private static void putAlgoxFlag(Map<String, Object> paramMap) {
        String inThreshold = ConfigurationUtil.getString((String)"orm.opt.in.threshold");
        if (StringUtils.isEmpty((String)inThreshold)) {
            inThreshold = "10000";
        }
        Date beginDate = (Date)paramMap.get("beginDate");
        Date endDate = (Date)paramMap.get("endDate");
        LocalDate localBeginDate = TripBoardsUtil.convertDateToLocalDate(beginDate);
        LocalDate localEndDate = TripBoardsUtil.convertDateToLocalDate(endDate);
        long between = ChronoUnit.MONTHS.between(localBeginDate, localEndDate) + 1L;
        Set orgIds = (Set)paramMap.get("orgIds");
        if (orgIds.size() >= Integer.parseInt(inThreshold) && between > 12L) {
            paramMap.put("isAlgox", true);
        }
    }

    private static void dealHotelExpenseIndex(IDataModel model, IPageCache pageCache) throws Exception {
        Map<String, Object> paramMap = DataProcessUtils.getParamMap(model);
        DataProcessUtils.putAlgoxFlag(paramMap);
        DataProcessUtils.executeFun(paramMap, new HotelDataProcessHandle(paramMap), "hotel_task_percent", "hotel_result", "OVER_HOTEL", pageCache);
    }

    private static void dealTrainExpenseIndex(IDataModel model, IPageCache pageCache) throws Exception {
        Map<String, Object> paramMap = DataProcessUtils.getParamMap(model);
        DataProcessUtils.putAlgoxFlag(paramMap);
        DataProcessUtils.executeFun(paramMap, new TrainDataProcessHandle(paramMap), "train_task_percent", "train_result", "OVER_TRAIN", pageCache);
    }

    private static void dealVehicelExpenseIndex(IDataModel model, IPageCache pageCache) throws Exception {
        Map<String, Object> paramMap = DataProcessUtils.getParamMap(model);
        DataProcessUtils.executeFun(paramMap, new VehicleDataProcessHandle(paramMap), "vehicle_task_percent", "vehicle_result", "OVER_VEHICLE", pageCache);
    }

    private static void dealTripExpenseSpreadIndex(IDataModel model, IPageCache pageCache) throws Exception {
        Map<String, Object> paramMap = DataProcessUtils.getParamMap(model);
        paramMap.put("percentKey", RequestContext.get().getCurrUserId() + "_expense_task_percent");
        paramMap.put("resultKey", RequestContext.get().getCurrUserId() + "_trip_expense_result");
        paramMap.put("overFlag", "OVER_EXPENSE_SPREAD");
        Object rootOrg = paramMap.get("rootOrg");
        OrgTreeBuilder treeBuilder = OrgTreeBuilder.getInstance();
        Set<Long> orgIds = treeBuilder.getChildById(Long.parseLong(rootOrg.toString()), treeBuilder, Boolean.TRUE);
        paramMap.put("orgIds", orgIds);
        TripExpenseSpreadDataProcessHandle tripExpenseSpreadDataProcessHandle = new TripExpenseSpreadDataProcessHandle(paramMap);
        tripExpenseSpreadDataProcessHandle.setPageCache(pageCache);
        tripExpenseSpreadDataProcessHandle.execute();
    }

    private static void dealAllExpenseIndex(IDataModel model, IPageCache pageCache) throws Exception {
        Map<String, Object> paramMap = DataProcessUtils.getParamMap(model);
        DataProcessUtils.putAlgoxFlag(paramMap);
        DataProcessUtils.executeFun(paramMap, new TripAllExpenseAndRankDataProcessHandle(paramMap), "all_expense_task_percent", "all_expense_result", "OVER_ALL_EXPENSE", pageCache);
    }

    private static void dealYOYIndex(IDataModel model, IPageCache pageCache) throws Exception {
        Map<String, Object> paramMap = DataProcessUtils.getParamMap(model);
        DataProcessUtils.putAlgoxFlag(paramMap);
        long orgId = Long.parseLong(paramMap.get("rootOrg").toString());
        if (orgId == OrgUnitServiceHelper.getRootOrgId()) {
            paramMap.put("isAlgox", true);
        }
        DataProcessUtils.executeFun(paramMap, new TripYearBasicAnlyDataProcessHandle(paramMap), "yoy_task_percent", "yoy_result", "OVER_YOY", pageCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dealTripJourneyIndex(IDataModel model, IPageCache pageCache) throws Exception {
        Map<String, Object> paramMap = DataProcessUtils.getParamMap(model);
        List needRemoveKeys = CacheManager.getRedisCache().getKeysWithPrefix(RequestContext.get().getCurrUserId() + "_");
        long currUserId = RequestContext.get().getCurrUserId();
        String prefix = currUserId + "_";
        String[] overFlag = new String[]{prefix + "OVER_PLANE", prefix + "OVER_HOTEL", prefix + "OVER_TRAIN", prefix + "OVER_VEHICLE", prefix + "OVER_ALL_EXPENSE", prefix + "OVER_EXPENSE_SPREAD", prefix + "OVER_MAP", prefix + "OVER_YOY"};
        List<String> list = Arrays.asList(overFlag);
        String percentKey = currUserId + "_map_task_percent";
        needRemoveKeys.removeIf(needRemoveKey -> !needRemoveKey.startsWith(currUserId + "_") || list.contains(needRemoveKey) || percentKey.equals(needRemoveKey));
        CacheManager.remove(needRemoveKeys);
        paramMap.put("percentKey", percentKey);
        paramMap.put("resultKey", currUserId + "_map_result");
        paramMap.put("overFlag", "OVER_MAP");
        String sql = "select FCITYNAME,FLONGITUDE,FLATITUDE from T_ER_LON_LAT";
        ArrayList dataList = Lists.newArrayList();
        DB.query((DBRoute)DBRoute.of((String)"er"), (String)sql, resultSet1 -> {
            while (resultSet1.next()) {
                String cityName = resultSet1.getString("FCITYNAME");
                String lon = resultSet1.getString("FLONGITUDE");
                String lat = resultSet1.getString("FLATITUDE");
                dataList.add(new ThreeTuple((Object)cityName, (Object)lon, (Object)lat));
            }
            return null;
        });
        paramMap.put("latAndLon", dataList);
        TripTravelDataProcessHandle tripTravelDataProcessHandle = new TripTravelDataProcessHandle(paramMap);
        tripTravelDataProcessHandle.setNeedCache(Boolean.FALSE);
        tripTravelDataProcessHandle.setPageCache(pageCache);
        if (paramMap.containsKey("isReal")) {
            tripTravelDataProcessHandle.execute();
        } else {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
            }
            finally {
                tripTravelDataProcessHandle.execute();
            }
        }
    }

    private static void executeFun(Map<String, Object> paramMap, DataProcessHandle dataProcessHandle, String percentKey, String resultKey, String overFlag, IPageCache pageCache) throws Exception {
        String prefix = RequestContext.get().getCurrUserId() + "_";
        paramMap.put("percentKey", prefix + percentKey);
        paramMap.put("resultKey", prefix + resultKey);
        paramMap.put("overFlag", prefix + overFlag);
        dataProcessHandle.setPageCache(pageCache);
        if (paramMap.containsKey("isAlgox")) {
            dataProcessHandle.executeAlgoX();
        } else {
            dataProcessHandle.execute();
        }
    }

    private static void dealTripPlaneExpenseIndex(IDataModel model, IPageCache pageCache) throws Exception {
        Map<String, Object> paramMap = DataProcessUtils.getParamMap(model);
        Date beginDate = (Date)paramMap.get("beginDate");
        paramMap.put("originBeginDate", beginDate);
        Date endDate = (Date)paramMap.get("endDate");
        LocalDate localBeginDate = TripBoardsUtil.convertDateToLocalDate(beginDate);
        LocalDate localEndDate = TripBoardsUtil.convertDateToLocalDate(endDate);
        long between = ChronoUnit.MONTHS.between(localBeginDate, localEndDate) + 1L;
        if (between < 12L) {
            long l = 12L - between;
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(beginDate);
            calendar.add(2, (int)(-l));
            paramMap.put("beginDate", calendar.getTime());
        }
        paramMap.remove("isReal");
        DataProcessUtils.executeFun(paramMap, new TripPlaneCostsOverViewDataProcessHandle(paramMap), "trip_plane_expense_percent", "trip_plane_expense_plane_result", "OVER_TRIP_PLANE_EXPENSE", pageCache);
    }

    private static void deelTripPlaneReversalIndex(IDataModel model, IPageCache pageCache) throws Exception {
        Map<String, Object> paramMap = DataProcessUtils.getParamMap(model);
        paramMap.remove("isReal");
        DataProcessUtils.executeFun(paramMap, new TripPlaneChangeAndRefundAnalyseDataProcessHandle(paramMap), "trip_plane_reversal_percent", "trip_plane_reversal_result", "OVER_TRIP_PLANE_REVERSAL", pageCache);
    }

    private static void dealTripPlaneAmountIndex(IDataModel model, IPageCache pageCache) throws Exception {
        Map<String, Object> paramMap = DataProcessUtils.getParamMap(model);
        paramMap.remove("isReal");
        DataProcessUtils.executeFun(paramMap, new TripPlaneAmountDataProcessHandle(paramMap), "trip_plane_amount_percent", "trip_plane_amount_result", "OVER_TRIP_PLANE_AMOUNT", pageCache);
    }

    private static void dealTripPlaneTakeOfftimeIndex(IDataModel model, IPageCache pageCache) throws Exception {
        Map<String, Object> paramMap = DataProcessUtils.getParamMap(model);
        paramMap.remove("isReal");
        DataProcessUtils.executeFun(paramMap, new TripPlaneTakeOffTimeDataProcessHandle(paramMap), "trip_plane_takeofftime_percent", "trip_plane_takeofftime_result", "OVER_TRIP_PLANE_TAKEOFFTIME", pageCache);
    }

    private static void dealTripPlaneAverageDiscountIndex(IDataModel model, IPageCache pageCache) throws Exception {
        Map<String, Object> paramMap = DataProcessUtils.getParamMap(model);
        paramMap.remove("isReal");
        DataProcessUtils.executeFun(paramMap, new TripPlaneAverageDiscountDataProcessHandle(paramMap), "trip_plane_discount_percent", "trip_plane_discount_result", "OVER_TRIP_PLANE_AVERAGE_DISCOUNT", pageCache);
    }

    private static void dealTripPlaneBooInAdvancedIndex(IDataModel model, IPageCache pageCache) throws Exception {
        Map<String, Object> paramMap = DataProcessUtils.getParamMap(model);
        paramMap.remove("isReal");
        DataProcessUtils.executeFun(paramMap, new TripPlaneBookInAdvanceDataProcessHandle(paramMap), "trip_plane_bookinadvanced_percent", "trip_plane_bookinadvanced_result", "OVER_TRIP_PLANE_BOOKINADVANCED", pageCache);
    }

    private static void dealTripPlanePopularAirIndex(IDataModel model, IPageCache pageCache) throws Exception {
        Map<String, Object> paramMap = DataProcessUtils.getParamMap(model);
        paramMap.remove("isReal");
        DataProcessUtils.executeFun(paramMap, new TripPlanePopularAirDataProcessHandle(paramMap), "trip_plane_popular_air_percent", "trip_plane_popularair_result", "OVER_TRIP_PLANE_POPULARAIR ", pageCache);
    }

    private static void dealTripPlaneFullTicketIndex(IDataModel model, IPageCache pageCache) throws Exception {
        Map<String, Object> paramMap = DataProcessUtils.getParamMap(model);
        paramMap.remove("isReal");
        DataProcessUtils.executeFun(paramMap, new TripPlaneFullTicketDataProcessHandle(paramMap), "trip_plane_fullticket_percent", "trip_plane_fullticket_result", "OVER_TRIP_PLANE_FULLTICKET", pageCache);
    }

    private static void dealTripPlaneDeptRankIndex(IDataModel model, IPageCache pageCache) throws Exception {
        Map<String, Object> paramMap = DataProcessUtils.getParamMap(model);
        paramMap.remove("isReal");
        DataProcessUtils.executeFun(paramMap, new TripPlaneDeptRankDataProcessHandle(paramMap), "trip_plane_deptrank_percent", "trip_plane_deptrank_result", "OVER_TRIP_PLANE_DEPTRANK", pageCache);
    }
}

