/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.web.tripstandard.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.er.business.daily.service.model.CurrencyBO;
import kd.fi.er.business.invoicecloud.v2.seatstd.TripVhcStdChangeUtils;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.tripstd.context.StdPreCalContext;
import kd.fi.er.business.tripstd.model.TripStandardDetail;
import kd.fi.er.business.tripstd.service.IErTripStdService;
import kd.fi.er.business.tripstd.service.imp.ErTripStdControlServiceImpl;
import kd.fi.er.business.tripstd.service.imp.ErTripStdServiceImp;
import kd.fi.er.business.tripstd.service.imp.ErTripStdServiceProxy;
import kd.fi.er.business.utils.ActionLocalCache;
import kd.fi.er.business.utils.AmountFormatsUtil;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.common.ControlMethodEnum;
import kd.fi.er.formplugin.web.tripstandard.util.TripVehicleStandardUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class TripStandardUtils {
    public static ThreadLocal<String> threadLocal = new ThreadLocal();
    private static final String[] ACCD_ALLOWANCE_ATTRIBUTE = new String[]{"5", "1"};
    private static final String[] VEHIC_ATTRIBUTE = new String[]{"2", "4", "7"};
    public static final String EXPENSE_ITEM_ACCOMMODATION = "5";
    public static final String EXPENSE_ITEM_SUBSIDY = "1";
    private static final String STANDARD_DETAIL_USER_STD_SPLIT = ":";
    private static final String STANDARD_DETAIL_USER_USER_SPLIT = " | ";
    private static final Integer STANDARD_DETAIL_LENGTH_LIMIT = 255;
    private static Log logger = LogFactory.getLog(TripStandardUtils.class);

    public static Long getCurrentUserCompanyId() {
        String userId = RequestContext.getOrCreate().getUserId();
        return TripStandardUtils.getComanyIdByUserId(Long.valueOf(userId));
    }

    public static Long getComanyIdByUserId(Long userId) {
        Map<String, Object> userMap = CommonServiceHelper.getUserMap(userId, null, true);
        DynamicObject dept = (DynamicObject)userMap.get("org");
        Long companyId = 0L;
        if (dept != null) {
            Map companyfromOrg = OrgUnitServiceHelper.getCompanyfromOrg((Long)dept.getLong("id"));
            companyId = (Long)companyfromOrg.get("id");
        }
        return companyId;
    }

    public static void setTripExpenseInfoValue(IDataModel dataModel, String cityName, DynamicObject expenseitem, int expanseItemEntryIdx, int tripEntryIdx, AbstractFormPlugin formPlugin) {
        if (expenseitem == null) {
            return;
        }
        if (!expenseitem.getDynamicObjectType().getProperties().containsKey((Object)"attribute")) {
            return;
        }
        if (!StringUtils.equals((CharSequence)expenseitem.getString("attribute"), (CharSequence)EXPENSE_ITEM_ACCOMMODATION) && !StringUtils.equals((CharSequence)expenseitem.getString("attribute"), (CharSequence)EXPENSE_ITEM_SUBSIDY)) {
            dataModel.setValue("tripstandardamount", (Object)BigDecimal.valueOf(-1L), expanseItemEntryIdx, tripEntryIdx);
            dataModel.setValue("isaccommodation", (Object)Boolean.FALSE, expanseItemEntryIdx, tripEntryIdx);
            dataModel.setValue("issubsidy", (Object)Boolean.FALSE, expanseItemEntryIdx, tripEntryIdx);
            return;
        }
        BigDecimal zero = new BigDecimal(0);
        DynamicObject trip = dataModel.getEntryRowEntity("tripentry", tripEntryIdx);
        if (StringUtils.equals((CharSequence)expenseitem.getString("attribute"), (CharSequence)EXPENSE_ITEM_ACCOMMODATION)) {
            dataModel.setValue("isaccommodation", (Object)Boolean.TRUE, expanseItemEntryIdx, tripEntryIdx);
        } else if (StringUtils.equals((CharSequence)expenseitem.getString("attribute"), (CharSequence)EXPENSE_ITEM_SUBSIDY)) {
            BigDecimal stdAmount;
            DynamicObject expItem;
            DynamicObjectCollection expEntry;
            dataModel.setValue("issubsidy", (Object)Boolean.TRUE, expanseItemEntryIdx, tripEntryIdx);
            ErTripStdControlServiceImpl controlService = new ErTripStdControlServiceImpl();
            String companyId = ((DynamicObject)dataModel.getValue("company")).getPkValue().toString();
            int tripday = trip.getInt("tripday");
            BigDecimal calDaycount = controlService.calDaycount(tripday, Long.parseLong(companyId));
            boolean tripStandardOpen = TripStandardUtils.getTripStandardOpenFromPageCache(dataModel, formPlugin);
            if (tripStandardOpen && StringUtils.equals((CharSequence)expenseitem.getString("ctrltype"), (CharSequence)EXPENSE_ITEM_SUBSIDY) && (expEntry = (DynamicObjectCollection)trip.get("entryentity")) != null && expEntry.size() > 0 && !(expItem = (DynamicObject)expEntry.get(expanseItemEntryIdx)).getBoolean("useroutstdctrl") && expItem != null && (stdAmount = expItem.getBigDecimal("tripstandardamount")) != null && !StringUtils.equals((CharSequence)expItem.getString("settlementtype"), (CharSequence)"2")) {
                BigDecimal oriEntryAmount = stdAmount.multiply(calDaycount);
                if (((DynamicObject)trip.getDynamicObjectCollection("entryentity").get(expanseItemEntryIdx)).getBigDecimal("orientryamount").compareTo(zero) > 0) {
                    oriEntryAmount = ((DynamicObject)trip.getDynamicObjectCollection("entryentity").get(expanseItemEntryIdx)).getBigDecimal("orientryamount");
                }
                dataModel.setValue("orientryamount", (Object)oriEntryAmount, expanseItemEntryIdx, tripEntryIdx);
            }
        }
        dataModel.setValue("tirpcitystr", (Object)cityName, expanseItemEntryIdx, tripEntryIdx);
    }

    public static BigDecimal getTripStandardAmount(DynamicObject tripArea, List<TripStandardDetail> tripStandardDetails, IErTripStdService tripStdService, DynamicObject entry, String tripEntryCurrencyId) {
        TripStandardDetail tripStd = TripStandardUtils.getTripStandard(tripArea, tripStandardDetails, tripStdService, entry, tripEntryCurrencyId);
        return tripStd == null ? BigDecimal.ZERO : tripStd.getStandardamount();
    }

    public static TripStandardDetail getTripStandard(DynamicObject tripArea, List<TripStandardDetail> tripStandardDetails, IErTripStdService tripStdService, DynamicObject entry, String tripEntryCurrencyId) {
        DynamicObject expenseitem = entry.getDynamicObject("expenseitem");
        String tripAreaId = null;
        if (tripArea != null) {
            tripAreaId = tripArea.getPkValue().toString();
        }
        String expenseitemId = null;
        if (expenseitem != null) {
            expenseitemId = expenseitem.getPkValue().toString();
        }
        TripStandardDetail tripStd = tripStdService.getTripStandardByTripArea(tripAreaId, expenseitemId, tripEntryCurrencyId, tripStandardDetails);
        return tripStd;
    }

    public static Map<String, String> getVehicleStdFromPageCache(IDataModel dataModel, AbstractFormPlugin formPlugin) {
        Map<String, String> cacheMap = Maps.newHashMap();
        IPageCache pageCache = formPlugin.getPageCache();
        String vehicleStd = pageCache.get("vehicleStd");
        String applierId = ((DynamicObject)dataModel.getValue("applier")).getPkValue().toString();
        String companyId = ((DynamicObject)dataModel.getValue("company")).getPkValue().toString();
        if (StringUtils.isEmpty((CharSequence)vehicleStd)) {
            DynamicObject shipVehicle;
            DynamicObject trainVehicle;
            ErTripStdServiceImp tripStdService = new ErTripStdServiceImp();
            DynamicObject airVehicle = tripStdService.getVehicleStdByUserIdAndVehicleType(Long.valueOf(applierId), "air", Long.valueOf(companyId));
            if (airVehicle != null) {
                cacheMap.put("air", airVehicle.getString("cabinstr"));
            }
            if ((trainVehicle = tripStdService.getVehicleStdByUserIdAndVehicleType(Long.valueOf(applierId), "train", Long.valueOf(companyId))) != null) {
                cacheMap.put("train", trainVehicle.getString("cabinstr"));
            }
            if ((shipVehicle = tripStdService.getVehicleStdByUserIdAndVehicleType(Long.valueOf(applierId), "ship", Long.valueOf(companyId))) != null) {
                cacheMap.put("ship", shipVehicle.getString("cabinstr"));
            }
        } else {
            cacheMap = (Map)((Object)JSONObject.parseArray((String)vehicleStd, Map.class));
        }
        logger.info("\u62a5\u9500\u4ebaid\u4e3a\uff1a" + applierId + ",\u516c\u53f8\uff1a" + companyId + "\u7684\u4ea4\u901a\u5de5\u5177\u6807\u51c6\u4e3a\uff1a" + JSONObject.toJSONString(cacheMap));
        return cacheMap;
    }

    public static String getTripStandardControlFromPageCache(IDataModel dataModel, AbstractFormPlugin formPlugin) {
        IPageCache pageCache = formPlugin.getPageCache();
        String tripstandcontype = pageCache.get("tripstandcontype");
        String companyId = ((DynamicObject)dataModel.getValue("company")).getPkValue().toString();
        if (StringUtils.isEmpty((CharSequence)tripstandcontype)) {
            tripstandcontype = SystemParamterUtil.getTripStandardControlLevel(Long.parseLong(companyId)).getValue();
            pageCache.put("tripstandcontype", tripstandcontype);
        }
        return tripstandcontype;
    }

    public static boolean getTripStandardOpenFromPageCache(IDataModel dataModel, AbstractFormPlugin formPlugin) {
        String companyId = ((DynamicObject)dataModel.getValue("company")).getPkValue().toString();
        boolean openFlag = false;
        IPageCache pageCache = formPlugin.getPageCache();
        String tripstandconOpen = pageCache.get("tripstandconOpen");
        if (StringUtils.isEmpty((CharSequence)tripstandconOpen)) {
            openFlag = SystemParamterUtil.isEnableTripStandard(Long.parseLong(companyId));
            pageCache.put("tripstandconOpen", Boolean.toString(openFlag));
        } else {
            openFlag = Boolean.parseBoolean(tripstandconOpen);
        }
        return openFlag;
    }

    @Deprecated
    public static List<TripStandardDetail> getAccmodationStdFromPageCache(List<Long> userIds, AbstractFormPlugin formPlugin, String trippartneraccstdtype, Object currencyId, Object tripAreaId, DynamicObject tripExpenseItem) {
        return TripStandardUtils.getAccmodationStdFromPageCache(userIds, formPlugin, trippartneraccstdtype, currencyId, tripAreaId, tripExpenseItem, null);
    }

    public static List<TripStandardDetail> getAccmodationStdFromPageCache(List<Long> userIds, AbstractFormPlugin formPlugin, String trippartneraccstdtype, Object currencyId, Object tripAreaId, DynamicObject tripExpenseItem, Map<String, Object> extMap) {
        return TripStandardUtils.getAccmodationStdFromPageCache(userIds, formPlugin, trippartneraccstdtype, currencyId, tripAreaId, tripExpenseItem, extMap, null);
    }

    public static List<TripStandardDetail> getAccmodationStdFromPageCache(List<Long> userIds, AbstractFormPlugin formPlugin, String trippartneraccstdtype, Object currencyId, Object tripAreaId, DynamicObject tripExpenseItem, Map<String, Object> extMap, StdPreCalContext stdPreCalContext) {
        StringBuilder expenseItemSubSidyBuilderStart;
        ArrayList<String> stdList = new ArrayList<String>(userIds.size());
        ArrayList<String> includeHighStdList = new ArrayList<String>(userIds.size());
        DynamicObjectCollection userCollection = QueryServiceHelper.query((String)"bos_user", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "in", userIds)});
        CurrencyBO currency = new CurrencyBO((Long)currencyId);
        ArrayList<TripStandardDetail> detailList = new ArrayList<TripStandardDetail>();
        for (Long userId : userIds) {
            TripStandardDetail userAccmodationStd;
            String parame = threadLocal.get();
            AbstractFormPlugin formPluginDe = formPlugin;
            if (parame != null && parame.contains("AbstractTripStdCtrlPlugin-submit")) {
                formPluginDe = null;
            }
            if ((userAccmodationStd = TripStandardUtils.getAccmodationStdFromPageCache(userId, formPluginDe, currencyId, tripAreaId, tripExpenseItem.getPkValue(), extMap, stdPreCalContext)) != null) {
                detailList.add(userAccmodationStd);
            } else {
                userAccmodationStd = new TripStandardDetail();
                userAccmodationStd.setUserId(userId);
            }
            TripStandardUtils.buildStdDetail(userCollection, stdList, includeHighStdList, userAccmodationStd, currency);
        }
        BigDecimal amount = BigDecimal.ZERO;
        BigDecimal highSeasonAmount = BigDecimal.ZERO;
        Boolean userOutStdCtrl = false;
        StringBuilder stdParam = new StringBuilder();
        stdParam.append("EXPENSE_ITEM_SUBSIDY:").append(EXPENSE_ITEM_SUBSIDY).append(";").append("tripExpenseItem.getString(attribute):").append(tripExpenseItem.getString("attribute")).append(";").append("StringUtils.equals(sum, trippartneraccstdtype):").append(StringUtils.equals((CharSequence)"sum", (CharSequence)trippartneraccstdtype)).append(";");
        logger.debug(stdParam.toString());
        if (StringUtils.equals((CharSequence)EXPENSE_ITEM_SUBSIDY, (CharSequence)tripExpenseItem.getString("attribute")) || StringUtils.equals((CharSequence)"sum", (CharSequence)trippartneraccstdtype)) {
            expenseItemSubSidyBuilderStart = new StringBuilder("sum ^^^^^^ ");
            expenseItemSubSidyBuilderStart.append("detailList.size() : ").append(detailList.size()).append(";");
            logger.debug(expenseItemSubSidyBuilderStart.toString());
            for (TripStandardDetail detail : detailList) {
                if (!userOutStdCtrl.booleanValue()) {
                    userOutStdCtrl = userOutStdCtrl != false || detail.getUserOutStdCtrl() != false;
                }
                amount = amount.add(detail.getStandardamount());
                highSeasonAmount = highSeasonAmount.add(detail.getHighSeasonStandardamount());
                StringBuilder expenseItemSubSidyBuilder = new StringBuilder("detail : ");
                expenseItemSubSidyBuilder.append("amount:").append(amount).append(";").append("detail.getStandardamount():").append(detail.getStandardamount()).append(";").append("highSeasonAmount:").append(highSeasonAmount).append(";").append("detail.getHighSeasonStandardamount():").append(detail.getHighSeasonStandardamount()).append(";");
                logger.debug(expenseItemSubSidyBuilder.toString());
            }
        } else {
            expenseItemSubSidyBuilderStart = new StringBuilder("max ^^^^^^ ");
            expenseItemSubSidyBuilderStart.append("detailList.size() : ").append(detailList.size()).append(";");
            logger.debug(expenseItemSubSidyBuilderStart.toString());
            for (TripStandardDetail detail : detailList) {
                if (!userOutStdCtrl.booleanValue()) {
                    userOutStdCtrl = userOutStdCtrl != false || detail.getUserOutStdCtrl() != false;
                }
                if (amount.compareTo(detail.getStandardamount()) < 0) {
                    amount = detail.getStandardamount();
                }
                if (highSeasonAmount.compareTo(detail.getHighSeasonStandardamount()) < 0) {
                    highSeasonAmount = detail.getHighSeasonStandardamount();
                }
                StringBuilder expenseItemSubSidyBuilder = new StringBuilder("detail : ");
                expenseItemSubSidyBuilder.append("amount:").append(amount).append(";").append("detail.getStandardamount():").append(detail.getStandardamount()).append(";").append("highSeasonAmount:").append(highSeasonAmount).append(";").append("detail.getHighSeasonStandardamount():").append(detail.getHighSeasonStandardamount()).append(";");
                logger.debug(expenseItemSubSidyBuilder.toString());
            }
        }
        TripStandardDetail stdItem = new TripStandardDetail();
        stdItem.setCurrency(String.valueOf(currencyId));
        stdItem.setTripstandardtype(String.valueOf(tripExpenseItem.getPkValue()));
        stdItem.setTripArea(String.valueOf(tripAreaId));
        stdItem.setUserOutStdCtrl(userOutStdCtrl);
        stdItem.setStandardamount(amount);
        stdItem.setHighSeasonStandardamount(highSeasonAmount);
        stdItem.setStdAndHighSeasonDetailDes(TripStandardUtils.subStr(String.join((CharSequence)STANDARD_DETAIL_USER_USER_SPLIT, includeHighStdList)));
        stdItem.setStdDetailDes(TripStandardUtils.subStr(String.join((CharSequence)STANDARD_DETAIL_USER_USER_SPLIT, stdList)));
        ArrayList<TripStandardDetail> resultList = new ArrayList<TripStandardDetail>();
        resultList.add(stdItem);
        return resultList;
    }

    private static void buildStdDetail(DynamicObjectCollection userCollection, List<String> stdList, List<String> includeHighStdList, TripStandardDetail detail, CurrencyBO currency) {
        Integer precision = currency.getPrecision() == null ? Integer.valueOf(0) : currency.getPrecision();
        String symbol = currency.getSymbol();
        Long userId = detail.getUserId();
        DynamicObject user = userCollection.stream().filter(e -> userId.equals(e.getLong("id"))).findFirst().orElse(null);
        String userName = "";
        if (user != null) {
            userName = user.getString("name");
        }
        StringBuilder sb = new StringBuilder();
        StringBuilder includeHighStd = new StringBuilder();
        sb.append(userName).append(STANDARD_DETAIL_USER_STD_SPLIT);
        if (detail.getStandardamount() == null || detail.getStandardamount().compareTo(BigDecimal.ZERO) == 0) {
            sb.append(ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e", (String)"TripStandardUtils_7", (String)"fi-er-business", (Object[])new Object[0]));
        } else {
            sb.append(symbol).append(detail.getStandardamount().setScale((int)precision, RoundingMode.HALF_UP)).append(ResManager.loadKDString((String)"/\u5929", (String)"TripStandardUtils_8", (String)"fi-er-business", (Object[])new Object[0]));
        }
        includeHighStd.append((CharSequence)sb);
        includeHighStd.append("\uff0c");
        includeHighStd.append(ResManager.loadKDString((String)"\u65fa\u5b63", (String)"TripStandardUtils_9", (String)"fi-er-business", (Object[])new Object[0]));
        if (detail.getHighSeasonStandardamount() == null || detail.getHighSeasonStandardamount().compareTo(BigDecimal.ZERO) == 0) {
            includeHighStd.append(ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e", (String)"TripStandardUtils_7", (String)"fi-er-business", (Object[])new Object[0]));
        } else {
            includeHighStd.append(symbol).append(detail.getHighSeasonStandardamount().setScale((int)precision, RoundingMode.HALF_UP)).append(ResManager.loadKDString((String)"/\u5929", (String)"TripStandardUtils_8", (String)"fi-er-business", (Object[])new Object[0]));
        }
        stdList.add(sb.toString());
        includeHighStdList.add(includeHighStd.toString());
    }

    private static String subStr(String stdDetail) {
        if (StringUtils.isEmpty((CharSequence)stdDetail)) {
            return stdDetail;
        }
        if (stdDetail.length() > STANDARD_DETAIL_LENGTH_LIMIT) {
            return stdDetail.substring(0, STANDARD_DETAIL_LENGTH_LIMIT);
        }
        return stdDetail;
    }

    @Deprecated
    public static TripStandardDetail getAccmodationStdFromPageCache(Long userId, AbstractFormPlugin formPlugin, Object currencyId, Object tripAreaId, Object tripExpenseItemId) {
        return TripStandardUtils.getAccmodationStdFromPageCache(userId, formPlugin, currencyId, tripAreaId, tripExpenseItemId, null);
    }

    public static TripStandardDetail getAccmodationStdFromPageCache(Long userId, AbstractFormPlugin formPlugin, Object currencyId, Object tripAreaId, Object tripExpenseItemId, Map<String, Object> extMap) {
        return TripStandardUtils.getAccmodationStdFromPageCache(userId, formPlugin, currencyId, tripAreaId, tripExpenseItemId, extMap, null);
    }

    public static TripStandardDetail getAccmodationStdFromPageCache(Long userId, AbstractFormPlugin formPlugin, Object currencyId, Object tripAreaId, Object tripExpenseItemId, Map<String, Object> extMap, StdPreCalContext stdPreCalContext) {
        String submit;
        IDataModel model;
        TripStandardDetail result = null;
        IPageCache pageCache = null;
        Long companyId = null;
        Long userCompanyId = null;
        if (formPlugin != null) {
            pageCache = formPlugin.getPageCache();
            IDataModel model2 = formPlugin.getView().getModel();
            if (model2.getProperty("company") != null) {
                userCompanyId = (Long)((DynamicObject)model2.getValue("company")).getPkValue();
            } else {
                IFormView parentView = formPlugin.getView().getParentView();
                if (parentView != null) {
                    IDataModel pModel = parentView.getModel();
                    if (pModel.getProperty("company") != null) {
                        userCompanyId = (Long)((DynamicObject)pModel.getValue("company")).getPkValue();
                    }
                } else {
                    logger.info("company not found,get mainOrg \u2026\u2026");
                    userCompanyId = CommonServiceHelper.getCompanyIdByUserId(userId);
                }
            }
        } else {
            userCompanyId = extMap == null || extMap.get("applyCompany") == null ? CommonServiceHelper.getCompanyIdByUserId(userId) : (Long)((DynamicObject)extMap.get("applyCompany")).getPkValue();
        }
        if (userCompanyId != null) {
            companyId = userCompanyId;
        }
        String cachekey = "accStdCacheKye__" + userId + "_" + companyId + "_" + currencyId + "_" + tripAreaId + "_" + tripExpenseItemId;
        boolean hasBillNo = false;
        String billNo = "";
        if (formPlugin != null && (model = formPlugin.getView().getModel()).getDataEntity().getDataEntityType().getProperties().containsKey((Object)"billno")) {
            hasBillNo = true;
            billNo = String.valueOf(model.getValue("billno"));
        }
        if ((submit = threadLocal.get()) == null) {
            submit = "";
        }
        if (hasBillNo) {
            logger.info(String.format("billno : %s, std-begin-query-key: %s----%s", billNo, cachekey, submit));
        } else {
            logger.info(String.format("std-begin-query-key: %s-------%s", cachekey, submit));
        }
        String accStd = null;
        if (pageCache != null) {
            accStd = pageCache.get(cachekey);
        }
        if (StringUtils.isEmpty(accStd) || "[]".equals(accStd)) {
            if (companyId != null) {
                DynamicObject accStdObject;
                IErTripStdService tripStdService = new ErTripStdServiceImp();
                if (formPlugin != null) {
                    tripStdService = new ErTripStdServiceProxy(new ErTripStdServiceImp(), formPlugin.getView().getModel().getDataEntity(), extMap).getInstance();
                } else if (extMap != null && extMap.get("bill") != null) {
                    tripStdService = new ErTripStdServiceProxy(new ErTripStdServiceImp(), (DynamicObject)extMap.get("bill"), extMap).getInstance();
                }
                if (stdPreCalContext != null) {
                    ThreadCache.put((Object)"stdPreCalContext", (Object)stdPreCalContext);
                }
                if ((accStdObject = tripStdService.getAccmodationStd(userId, companyId, currencyId, tripAreaId, tripExpenseItemId)) != null) {
                    result = TripStandardUtils.getAccStandardFromAlldetail(accStdObject, userId, currencyId, tripAreaId, tripExpenseItemId);
                    if (pageCache != null) {
                        pageCache.put(cachekey, JSONObject.toJSONString((Object)result));
                    }
                }
            } else {
                logger.error(String.format("billno: %s,user,%s,company is empty----%s", billNo, userId, submit));
            }
        } else {
            result = (TripStandardDetail)JSONObject.parseObject((String)accStd, TripStandardDetail.class);
        }
        logger.info(String.format("result: billno:%s - get std- %s--------%s", billNo, JSONObject.toJSONString((Object)result), submit));
        return result;
    }

    private static TripStandardDetail getAccStandardFromAlldetail(DynamicObject accStdObject, Long userId, Object currencyId, Object tripAreaId, Object tripExpenseItemId) {
        DynamicObjectCollection details = accStdObject.getDynamicObjectCollection("entryentity");
        for (int i = 0; i < details.size(); ++i) {
            DynamicObject detail = (DynamicObject)details.get(i);
            if (!currencyId.equals(detail.getLong("currency_id")) || !tripAreaId.equals(detail.getLong("triparea_id")) || !tripExpenseItemId.equals(detail.getLong("tripstandardtype_id"))) continue;
            TripStandardDetail result = new TripStandardDetail();
            result.setCurrency(String.valueOf(currencyId));
            result.setTripstandardtype(String.valueOf(tripExpenseItemId));
            result.setStandardamount(detail.getBigDecimal("standardamount"));
            result.setHighSeasonStandardamount(detail.getBigDecimal("highseasonstandardamount"));
            result.setUserId(userId);
            Set userSet = detail.getDynamicObjectCollection("outtripstdctrluser").stream().filter(traveler -> traveler.get("fbasedataid") != null).map(traveler -> traveler.getLong("fbasedataid_id")).collect(Collectors.toSet());
            if (userSet.contains(userId)) {
                result.setUserOutStdCtrl(Boolean.TRUE);
            } else {
                result.setUserOutStdCtrl(Boolean.FALSE);
            }
            return result;
        }
        return null;
    }

    @Deprecated
    public static List<TripStandardDetail> getAccmodationStdFromPageCache(Long userId, AbstractFormPlugin formPlugin) {
        String cacheKey;
        String accmodationStd;
        List<Object> cacheList = Lists.newArrayList();
        IPageCache pageCache = formPlugin.getPageCache();
        Long companyId = null;
        Long userCompanyId = null;
        IDataModel model = formPlugin.getView().getModel();
        if (model.getProperty("company") != null) {
            userCompanyId = (Long)((DynamicObject)model.getValue("company")).getPkValue();
        } else {
            IFormView parentView = formPlugin.getView().getParentView();
            if (parentView != null) {
                IDataModel pModel = parentView.getModel();
                if (pModel.getProperty("company") != null) {
                    userCompanyId = (Long)((DynamicObject)pModel.getValue("company")).getPkValue();
                }
            } else {
                logger.info("company not found,get mainOrg \u2026\u2026");
                userCompanyId = CommonServiceHelper.getCompanyIdByUserId(userId);
            }
        }
        if (userCompanyId != null) {
            companyId = userCompanyId;
        }
        if (StringUtils.isEmpty((CharSequence)(accmodationStd = pageCache.get(cacheKey = "accmodationstd" + userId + companyId))) || "[]".equals(accmodationStd)) {
            if (companyId != null) {
                logger.info("\u51fa\u5dee\u4ebaid\u4e3a\uff1a" + userId + ",\u516c\u53f8\uff1a" + companyId);
                IErTripStdService tripStdService = new ErTripStdServiceProxy(new ErTripStdServiceImp(), formPlugin.getView().getModel().getDataEntity()).getInstance();
                cacheList = tripStdService.getTripStandardDetailList(userId, companyId);
                pageCache.put(cacheKey, JSONObject.toJSONString((Object)cacheList));
            } else {
                logger.info("\u51fa\u5dee\u4eba" + userId + ",\u51fa\u5dee\u4eba\u516c\u53f8\u4e3a\u7a7a\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01");
            }
        } else {
            List list = JSONObject.parseArray((String)accmodationStd, TripStandardDetail.class);
            cacheList.addAll(list);
        }
        logger.info("\u51fa\u5dee\u4ebaid\u4e3a\uff1a" + userId + "\u7684\u4f4f\u5bbf\u8865\u52a9\u6807\u51c6\u4e3a\uff1a" + JSONObject.toJSONString((Object)cacheList));
        return cacheList;
    }

    @Deprecated
    public static List<TripStandardDetail> getAccmodationStdFromPageCache(List<Long> userIds, AbstractFormPlugin formPlugin, String trippartneraccstdtype) {
        ArrayList<TripStandardDetail> tripStandardDetails = new ArrayList<TripStandardDetail>(2);
        ArrayList<TripStandardDetail> detailList = new ArrayList<TripStandardDetail>(2);
        for (Long userId : userIds) {
            List<TripStandardDetail> userAccmodationStd = TripStandardUtils.getAccmodationStdFromPageCache(userId, formPlugin);
            detailList.addAll(userAccmodationStd);
        }
        logger.info("\u591a\u51fa\u5dee\u4eba\u4f4f\u5bbf\u6807\u51c6\u660e\u7ec6>>>" + JSON.toJSONString(detailList));
        Map<String, List<TripStandardDetail>> currencyMappedStdDetail = detailList.stream().collect(Collectors.groupingBy(TripStandardDetail::getCurrency));
        currencyMappedStdDetail.forEach((currency, currencyDetails) -> {
            Map<String, List<TripStandardDetail>> tripAreaMappedDetails = currencyDetails.stream().collect(Collectors.groupingBy(TripStandardDetail::getTripArea));
            tripAreaMappedDetails.forEach((tripArea, tripAreaDetails) -> {
                Map<String, List<TripStandardDetail>> typeMappedStdDetail = tripAreaDetails.stream().collect(Collectors.groupingBy(TripStandardDetail::getTripstandardtype));
                Set tripExpItemIdSet = typeMappedStdDetail.keySet().stream().filter(e -> !StringUtils.isEmpty((CharSequence)e)).map(e -> Long.valueOf(e)).collect(Collectors.toSet());
                Map tripTypeDyms = BusinessDataServiceHelper.loadFromCache((Object[])tripExpItemIdSet.toArray(), (String)"er_tripexpenseitem");
                HashMap mappedTripTypeAttribute = new HashMap(2);
                tripTypeDyms.values().forEach(tripTypeDym -> mappedTripTypeAttribute.put(tripTypeDym.getPkValue().toString(), tripTypeDym.getString("attribute")));
                typeMappedStdDetail.forEach((tripType, tripTypeDetails) -> {
                    if (StringUtils.equals((CharSequence)EXPENSE_ITEM_SUBSIDY, (CharSequence)((CharSequence)mappedTripTypeAttribute.get(tripType))) || StringUtils.equals((CharSequence)"sum", (CharSequence)trippartneraccstdtype)) {
                        BigDecimal sum = BigDecimal.ZERO;
                        TripStandardDetail stdItem = new TripStandardDetail();
                        Boolean userOutStdCtrl = false;
                        for (TripStandardDetail detail : tripTypeDetails) {
                            if (!userOutStdCtrl.booleanValue()) {
                                userOutStdCtrl = userOutStdCtrl != false || detail.getUserOutStdCtrl() != false;
                            }
                            sum = sum.add(detail.getStandardamount());
                            stdItem.setCityIds(detail.getCityIds());
                        }
                        stdItem.setUserOutStdCtrl(userOutStdCtrl);
                        stdItem.setCurrency((String)currency);
                        stdItem.setTripstandardtype((String)tripType);
                        stdItem.setStandardamount(sum);
                        stdItem.setTripArea((String)tripArea);
                        tripStandardDetails.add(stdItem);
                    } else {
                        BigDecimal max = BigDecimal.ZERO;
                        TripStandardDetail stdItem = new TripStandardDetail();
                        Boolean userOutStdCtrl = false;
                        for (TripStandardDetail detail : tripTypeDetails) {
                            if (!userOutStdCtrl.booleanValue()) {
                                userOutStdCtrl = userOutStdCtrl != false || detail.getUserOutStdCtrl() != false;
                            }
                            if (max.compareTo(detail.getStandardamount()) < 0) {
                                max = detail.getStandardamount();
                            }
                            stdItem.setCityIds(detail.getCityIds());
                        }
                        stdItem.setUserOutStdCtrl(userOutStdCtrl);
                        stdItem.setCurrency((String)currency);
                        stdItem.setTripstandardtype((String)tripType);
                        stdItem.setStandardamount(max);
                        stdItem.setTripArea((String)tripArea);
                        tripStandardDetails.add(stdItem);
                    }
                });
            });
        });
        return tripStandardDetails;
    }

    public static String findStandardOverExpenseItem(IDataModel model) {
        DynamicObject tripStandard = model.getDataEntity(true);
        Long companyId = Long.valueOf(tripStandard.getDynamicObject("company").getPkValue().toString());
        Boolean isControl = SystemParamterUtil.isEnableTripStandard(companyId);
        String vehicleConType = SystemParamterUtil.getVehicleStdControlLevel(companyId).getValue();
        String tripStandardControlMethod = SystemParamterUtil.getTripStandardControlLevel(companyId).getValue();
        logger.info(String.format("\u662f\u5426\u5f00\u542f\u63a7\u5236\uff1a%s,\u4ea4\u901a\u5de5\u5177\u63a7\u5236\u65b9\u5f0f\uff1a%s,\u5dee\u65c5\u6807\u51c6\u63a7\u5236\u65b9\u5f0f\uff1a%s", isControl, vehicleConType, tripStandardControlMethod));
        if (!isControl.booleanValue() || !vehicleConType.equalsIgnoreCase(ControlMethodEnum.TIP_CONTROL.getValue()) && !tripStandardControlMethod.equalsIgnoreCase(ControlMethodEnum.TIP_CONTROL.getValue())) {
            return null;
        }
        StringBuilder overExpenseItem = new StringBuilder();
        DynamicObjectCollection tripEntrys = tripStandard.getDynamicObjectCollection("tripentry");
        ErTripStdControlServiceImpl conService = new ErTripStdControlServiceImpl();
        int tripIdx = 0;
        String tip = null;
        for (DynamicObject tripEntry : tripEntrys) {
            ++tripIdx;
            Long userId = Long.valueOf(tripStandard.getDynamicObject("applier").getPkValue().toString());
            DynamicObject traveler = tripEntry.getDynamicObject("traveler");
            if (traveler != null) {
                userId = (Long)traveler.getPkValue();
            }
            DynamicObjectCollection entrys = tripEntry.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entrys) {
                if (!entry.getDynamicObjectType().getProperties().containsKey((Object)"expenseitem")) continue;
                DynamicObject expenseItem = entry.getDynamicObject("expenseitem");
                if (expenseItem == null) {
                    logger.info("\u8fd9\u4e2a\u5dee\u65c5\u9879\u76ee\u4e3a\u7a7a>>>" + entry);
                    continue;
                }
                String attribute = entry.getDynamicObject("expenseitem").getString("attribute");
                String expenseName = expenseItem.getLocaleString("name").getLocaleValue();
                if (vehicleConType.equalsIgnoreCase(ControlMethodEnum.TIP_CONTROL.getValue()) && conService.checkCabinIsOver(entry, userId, companyId)) {
                    overExpenseItem.append(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u6bb5\u884c\u7a0b\u7684%2$s\u7684\u8231\u4f4d,", (String)"TripStandardUtils_6", (String)"fi-er-business", (Object[])new Object[0]), String.valueOf(tripIdx), expenseName));
                }
                if (vehicleConType.equalsIgnoreCase(ControlMethodEnum.TIP_CONTROL.getValue()) && (StringUtils.equals((CharSequence)attribute, (CharSequence)"2") || StringUtils.equals((CharSequence)attribute, (CharSequence)"4")) || StringUtils.equals((CharSequence)attribute, (CharSequence)"7")) {
                    String tips = TripStandardUtils.findVhcStdOverExpItem(entry, tripIdx, userId);
                    if (StringUtils.contains((CharSequence)tips, (CharSequence)ResManager.loadKDString((String)"\u5ea7\u4f4d\u7b49\u7ea7\u672a\u586b\u5199\u3002", (String)"TripStandardUtils_3", (String)"fi-er-business", (Object[])new Object[0]))) {
                        return tips.substring(0, tips.length() - 1);
                    }
                    overExpenseItem.append(tips);
                }
                if (!StringUtils.equals((CharSequence)attribute, (CharSequence)EXPENSE_ITEM_ACCOMMODATION) && !StringUtils.equals((CharSequence)attribute, (CharSequence)EXPENSE_ITEM_SUBSIDY) || !tripStandardControlMethod.equalsIgnoreCase(ControlMethodEnum.TIP_CONTROL.getValue()) || !conService.checkTripStandardAmountIsOver(tripEntry, entry, companyId, userId)) continue;
                if (!StringUtils.isBlank((CharSequence)overExpenseItem)) {
                    overExpenseItem.append("\n");
                }
                tip = ResManager.loadKDString((String)"\u7b2c%1$s\u6bb5\u884c\u7a0b\u7684%2$s\u7684\u62a5\u9500\u91d1\u989d\u8d85\u6807", (String)"TripStandardUtils_4", (String)"fi-er-business", (Object[])new Object[0]);
                overExpenseItem.append(String.format(tip, tripIdx, expenseName)).append("\uff0c");
            }
        }
        return StringUtils.isBlank((CharSequence)overExpenseItem) ? null : overExpenseItem.substring(0, overExpenseItem.length() - 1);
    }

    private static String findVhcStdOverExpItem(DynamicObject entryItem, int tripItemIndex, long userId) {
        StringBuilder overExpenseItem = new StringBuilder();
        DynamicObject tripExpenseItem = entryItem.getDynamicObject("expenseitem");
        String expenseName = tripExpenseItem.getLocaleString("name").getLocaleValue();
        String attribute = tripExpenseItem.getString("attribute");
        List<String> vhcStd = TripVhcStdChangeUtils.getVhcStd(entryItem);
        DynamicObjectCollection expItemSeatGrade = entryItem.getDynamicObjectCollection("mulseatgrade");
        List<String> seat = expItemSeatGrade.stream().map(seatGrade -> seatGrade.getDynamicObject("fbasedataid").getString("name")).collect(Collectors.toList());
        BigDecimal orientryamount = entryItem.getBigDecimal("orientryamount");
        if (orientryamount.compareTo(BigDecimal.ZERO) != 0) {
            if (seat == null || seat.isEmpty()) {
                overExpenseItem.append('\n').append(ResManager.loadKDString((String)"\u7b2c", (String)"TripStandardUtils_0", (String)"fi-er-business", (Object[])new Object[0])).append(String.valueOf(tripItemIndex)).append(ResManager.loadKDString((String)"\u6bb5\u884c\u7a0b\u7684", (String)"TripStandardUtils_1", (String)"fi-er-business", (Object[])new Object[0])).append(expenseName).append(ResManager.loadKDString((String)"\u5ea7\u4f4d\u7b49\u7ea7\u672a\u586b\u5199\u3002", (String)"TripStandardUtils_3", (String)"fi-er-business", (Object[])new Object[0])).append("\uff0c");
            } else if (!TripVhcStdChangeUtils.vhcStdContainAllSeatGrade(vhcStd, seat, attribute)) {
                String tip = ResManager.loadKDString((String)"\u7b2c%1$s\u6bb5\u884c\u7a0b\u7684%2$s\u7684\u5ea7\u4f4d\u7b49\u7ea7\u8d85\u6807", (String)"TripStandardUtils_5", (String)"fi-er-business", (Object[])new Object[0]);
                overExpenseItem.append('\n').append(String.format(tip, tripItemIndex, expenseName)).append("\uff0c");
            }
        }
        return overExpenseItem.toString();
    }

    public static String getTripStdShowInfoByDetailEntry(DynamicObject entry, String attribute) {
        return TripStandardUtils.getTripStdShowInfoByDetailEntry(null, entry, attribute, "tripstandardamount");
    }

    public static String getTripStdShowInfoByDetailEntry(String prefix, DynamicObject entry, String attribute, String propertyName) {
        DynamicObjectCollection stdSeatGradeColl;
        StringBuilder stdShow = new StringBuilder();
        if (Arrays.asList(ACCD_ALLOWANCE_ATTRIBUTE).contains(attribute)) {
            BigDecimal detailStdAmount = entry.getBigDecimal(propertyName);
            if (BigDecimal.ZERO.compareTo(detailStdAmount) < 0) {
                DynamicObject currency = entry.getDynamicObject("entrycurrency");
                if (StringUtils.isNotBlank((CharSequence)prefix)) {
                    stdShow.append(prefix);
                }
                if (currency != null) {
                    stdShow.append(AmountFormatsUtil.getLabelAmountAfterFormat(currency.getString("sign"), detailStdAmount, currency.getInt("amtprecision")));
                }
                stdShow.append(ResManager.loadKDString((String)"/\u5929", (String)"TripStandardUtils_8", (String)"fi-er-business", (Object[])new Object[0]));
            }
        } else if (Arrays.asList(VEHIC_ATTRIBUTE).contains(attribute) && (stdSeatGradeColl = entry.getDynamicObjectCollection("stdseatgrade")).size() > 0) {
            List seatList = stdSeatGradeColl.stream().filter(seat -> StringUtils.isNotEmpty((CharSequence)seat.getDynamicObject("fbasedataid").getLocaleString("name").getLocaleValue())).map(seat -> seat.getDynamicObject("fbasedataid").getLocaleString("name").getLocaleValue()).collect(Collectors.toList());
            stdShow.append(StringUtils.join(seatList, (String)"\uff0c"));
        }
        if (stdShow.length() <= 0) {
            stdShow.append(ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e", (String)"TripStandardUtils_7", (String)"fi-er-business", (Object[])new Object[0]));
        }
        return stdShow.toString();
    }

    @Deprecated
    public static Map<Object, DynamicObject> getVhcSeatGradeStd(List<Long> userList, Long companyId, String attribute) {
        List<Object> userIds = userList.stream().collect(Collectors.toList());
        List<String> vhcStdNameList = TripVehicleStandardUtils.getTripVhcStd(userIds, attribute, companyId);
        HashSet<String> seatGradeNumber = new HashSet<String>();
        for (String vhcName : vhcStdNameList) {
            String[] seatGradeInfo = TripVhcStdChangeUtils.getVhcSeatGrade(vhcName, attribute);
            if (seatGradeInfo == null) continue;
            seatGradeNumber.add(seatGradeInfo[1]);
        }
        QFilter filter = new QFilter("number", "in", seatGradeNumber);
        filter.and(new QFilter("attribute", "=", (Object)attribute));
        Map seatGradeResult = BusinessDataServiceHelper.loadFromCache((String)"er_seatgradestd", (String)"id,attribute,number,name", (QFilter[])new QFilter[]{filter});
        return seatGradeResult;
    }

    @Deprecated
    public static Map<Object, DynamicObject> getVhcSeatGradeStd(List<Long> userList, Long companyId, String attribute, IPageCache pageCache) {
        return TripStandardUtils.getVhcSeatGradeStd(userList, companyId, attribute, pageCache, null);
    }

    @Deprecated
    public static Map<Object, DynamicObject> getVhcSeatGradeStd(List<Long> userList, Long companyId, String attribute, IPageCache pageCache, AbstractFormPlugin plugin) {
        return TripStandardUtils.getVhcSeatGradeStd(userList, companyId, attribute, pageCache, plugin, null);
    }

    public static Map<Object, DynamicObject> getVhcSeatGradeStd(List<Long> userList, Long companyId, String attribute, IPageCache pageCache, AbstractFormPlugin plugin, Map<String, Object> extMap) {
        return TripStandardUtils.getVhcSeatGradeStd(userList, companyId, attribute, pageCache, plugin, extMap, null);
    }

    public static Map<Object, DynamicObject> getVhcSeatGradeStd(List<Long> userList, Long companyId, String attribute, IPageCache pageCache, AbstractFormPlugin plugin, Map<String, Object> extMap, StdPreCalContext stdPreCalContext) {
        List<Object> userIds = userList.stream().collect(Collectors.toList());
        List<String> vhcStdNameList = TripVehicleStandardUtils.getTripVhcStd(userIds, attribute, companyId, pageCache, plugin, extMap, stdPreCalContext);
        HashMap<String, String> seatGradeNumber = new HashMap<String, String>(16);
        for (String vhcName : vhcStdNameList) {
            String[] seatGradeInfo = TripVhcStdChangeUtils.getVhcSeatGrade(vhcName, attribute);
            if (seatGradeInfo == null) continue;
            seatGradeNumber.put(vhcName, seatGradeInfo[1]);
        }
        QFilter filter = new QFilter("number", "in", seatGradeNumber.values());
        filter.and(new QFilter("attribute", "=", (Object)attribute));
        Map seatGradeResult = BusinessDataServiceHelper.loadFromCache((String)"er_seatgradestd", (String)"id,attribute,number,name", (QFilter[])new QFilter[]{filter});
        TripStandardUtils.buildSeatStdDetail(userList, extMap, userIds, seatGradeNumber, seatGradeResult);
        return seatGradeResult;
    }

    private static StringBuilder buildSeatStdDetail(List<Long> userList, Map<String, Object> extMap, List<Object> userIds, Map<String, String> seatGradeNumber, Map<Object, DynamicObject> seatGradeResult) {
        if (extMap == null) {
            return new StringBuilder();
        }
        Map userMap = (Map)ActionLocalCache.get().get("kd.fi.er.business.servicehelper.CommonServiceHelper.USER_DYNAMIC_OBJECT_MAP");
        if (userMap != null) {
            Set oldList = userMap.keySet();
            HashSet newList = Sets.newHashSetWithExpectedSize((int)userIds.size());
            for (Object user : userIds) {
                if (oldList.contains(user)) continue;
                newList.add(user);
            }
            if (newList.size() > 0) {
                HashSet<Long> set = new HashSet<Long>(4);
                set.addAll(newList);
                userMap.putAll(CommonServiceHelper.getUsers(set));
            }
        }
        if (userMap == null) {
            userMap = BusinessDataServiceHelper.loadFromCache((String)"bos_user", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "in", userIds)});
        }
        StringBuilder sb = new StringBuilder();
        int userSize = userList.size();
        int i = 0;
        for (Long userId : userList) {
            ++i;
            String userName = "";
            DynamicObject user = (DynamicObject)userMap.get(userId);
            if (user != null) {
                userName = user.getString("name");
            }
            List userStdList = (List)extMap.get(String.valueOf(userId));
            String value = ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e", (String)"TripStandardUtils_7", (String)"fi-er-business", (Object[])new Object[0]);
            if (CollectionUtils.isNotEmpty((Collection)userStdList) && seatGradeNumber != null && seatGradeNumber.size() > 0) {
                List userStd = seatGradeNumber.entrySet().stream().filter(e -> userStdList.contains(e.getKey())).map(e -> (String)e.getValue()).collect(Collectors.toList());
                value = String.join((CharSequence)"\u3001", seatGradeResult.values().stream().filter(e -> userStd.contains(e.getString("number"))).map(e -> e.getString("name")).collect(Collectors.toList()));
            }
            sb.append(userName).append(STANDARD_DETAIL_USER_STD_SPLIT).append(value);
            if (i == userSize) continue;
            sb.append(STANDARD_DETAIL_USER_USER_SPLIT);
        }
        extMap.put("stddetail", TripStandardUtils.subStr(sb.toString()));
        return sb;
    }

    public static boolean isOverVhcStd(DynamicObjectCollection entrySeatGrade, DynamicObjectCollection seatGradeStd) {
        boolean isOverStd = false;
        if (entrySeatGrade == null || entrySeatGrade.isEmpty()) {
            return isOverStd;
        }
        Set seatGradeStdKeySet = seatGradeStd.stream().map(seatGrade -> seatGrade.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toSet());
        Set entrySeat = entrySeatGrade.stream().filter(seatGrade -> seatGrade.getDynamicObject("fbasedataid") != null).filter(seatGrade -> seatGrade.getDynamicObject("fbasedataid").getPkValue() != null).map(seatGrade -> seatGrade.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toSet());
        isOverStd = entrySeat != null && !entrySeat.isEmpty() ? !seatGradeStdKeySet.containsAll(entrySeat) : false;
        return isOverStd;
    }

    public static String fetchGroupKey(DynamicObject entryObject, String ... groupPrppertyName) {
        StringBuilder sb = new StringBuilder();
        if (groupPrppertyName != null && groupPrppertyName.length > 0) {
            for (int i = 0; i < groupPrppertyName.length; ++i) {
                Object property = entryObject.get(groupPrppertyName[i]);
                if (property instanceof DynamicObject) {
                    sb.append(((DynamicObject)property).getPkValue());
                    continue;
                }
                if (property == null) continue;
                sb.append(property);
            }
        }
        return sb.toString();
    }

    public static void setStdDetail(IDataModel dataModel, TripStandardDetail tripStdDetail, int curIndex, int parentIndex) {
        if (dataModel.getDataEntity().getBoolean("isopenhighseasontripstd")) {
            dataModel.setValue("stddetail", (Object)(tripStdDetail == null ? null : tripStdDetail.getStdAndHighSeasonDetailDes()), curIndex, parentIndex);
        } else {
            dataModel.setValue("stddetail", (Object)(tripStdDetail == null ? null : tripStdDetail.getStdDetailDes()), curIndex, parentIndex);
        }
    }

    public static void setStdDetail(IDataModel dataModel, Map<String, Object> map, int curIndex, int parentIndex) {
        dataModel.setValue("stddetail", map == null ? null : map.get("stddetail"), curIndex, parentIndex);
    }

    public static void resetStdDetail(IDataModel dataModel, int curIndex, int parentIndex) {
        dataModel.setValue("stddetail", null, curIndex, parentIndex);
    }

    public static boolean overrideGetAccmodationStd() {
        String extServiceName = ErStdConfig.get("IErTripStdService.getAccmodationStd");
        return StringUtils.isNotBlank((CharSequence)extServiceName);
    }

    public static Map buildExtMap(IFormView view, DynamicObject entry, int parentEntryIndex, int curEntryIndex) {
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        if (TripStandardUtils.overrideGetAccmodationStd()) {
            map.put("view", view);
            map.put("bill", view.getModel().getDataEntity(true));
            map.put("parentIndex", parentEntryIndex);
            map.put("index", curEntryIndex);
            map.put("entry", entry);
        }
        return map;
    }
}

