/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.api.controller;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.fa.business.depretask.DepreStatusEnum2;
import kd.fi.fa.common.util.ContextUtil;
import kd.fi.fa.common.util.Fa;

@ApiController(value="/", desc="\u8ba1\u63d0\u6298\u65e7\u81ea\u5b9a\u4e49Api2.0")
public class DepreController {
    private static final Log logger = LogFactory.getLog(DepreController.class);

    @ApiPostMapping(value="/assetbook/depre")
    public CustomApiResult<String> depre(@ApiParam(value="\u7ec4\u7ec7\u7f16\u7801", required=true) @ApiParam(value="\u7ec4\u7ec7\u7f16\u7801", required=true) List<String> orgNums, @ApiParam(value="\u6298\u65e7\u7528\u9014\u7f16\u7801", required=true) @ApiParam(value="\u6298\u65e7\u7528\u9014\u7f16\u7801", required=true) List<String> depreUseNums) {
        Object[] bookIds;
        OperationResult result;
        StringBuilder sb;
        HasPermOrgResult permOrgs;
        LicenseCheckResult checkResult = LicenseServiceHelper.checkByAppAndBizObj((String)"83bfebc800001aac", (String)"fa_new_depre", (Long)ContextUtil.getUserId());
        if (!checkResult.getHasLicense().booleanValue()) {
            return CustomApiResult.fail((String)"validate_error", (String)ResManager.loadKDString((String)"\u6ca1\u6709\u8d22\u52a1+\u4f9b\u5e94\u94fe+\u5236\u9020\u5206\u7ec4\u56fa\u5b9a\u8d44\u4ea7\u8bb8\u53ef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"DepreController_19", (String)"fi-fa-webapi", (Object[])new Object[0]));
        }
        DynamicObjectCollection assetBooks = QueryServiceHelper.query((String)"fa_assetbook", (String)Fa.comma((String[])new String[]{"id", "org", Fa.dot((String[])new String[]{"org", "number"}), Fa.dot((String[])new String[]{"org", "name"})}), (QFilter[])new QFilter[]{new QFilter(Fa.dot((String[])new String[]{"org", "number"}), "in", orgNums), new QFilter(Fa.dot((String[])new String[]{"depreuse", "number"}), "in", depreUseNums)});
        if (assetBooks.isEmpty()) {
            return CustomApiResult.fail((String)"validate_error", (String)ResManager.loadKDString((String)"\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u7684\u8d26\u7c3f\u3002", (String)"DepreController_0", (String)"fi-fa-webapi", (Object[])new Object[0]));
        }
        List hasBookOrgNums = assetBooks.stream().map(v -> v.getString(Fa.dot((String[])new String[]{"org", "number"}))).collect(Collectors.toList());
        orgNums.removeAll(hasBookOrgNums);
        StringBuilder msgBuilder = new StringBuilder();
        if (!orgNums.isEmpty()) {
            msgBuilder.append(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u7ec4\u7ec7\u6ca1\u6709\u8d26\u7c3f\u3002", (String)"DepreController_20", (String)"fi-fa-webapi", (Object[])new Object[0]), orgNums));
        }
        if (!(permOrgs = PermissionServiceHelper.getAllPermOrgs((long)ContextUtil.getUserId(), (String)"10", (String)"fa", (String)"fa_new_depre", (String)"/KT7BBQL51C7")).hasAllOrgPerm()) {
            List orgIds = permOrgs.getHasPermOrgs();
            List noAuthorityBookNames = assetBooks.stream().filter(v -> !orgIds.contains(v.getLong("org"))).map(v -> v.getString(Fa.dot((String[])new String[]{"org", "name"}))).collect(Collectors.toList());
            if (!noAuthorityBookNames.isEmpty()) {
                sb = new StringBuilder();
                for (String noAuthorityBookName : noAuthorityBookNames) {
                    sb.append(noAuthorityBookName).append("\u3001");
                }
                String errMsg = sb.length() > 0 ? sb.substring(0, sb.length() - 1) : "";
                String noAuthMsg = String.format(ResManager.loadKDString((String)"\u4ee5\u4e0b\u6838\u7b97\u7ec4\u7ec7[%s]\u6ca1\u6709\u8ba1\u63d0\u6743\u9650\u3002", (String)"DepreController_1", (String)"fi-fa-webapi", (Object[])new Object[0]), errMsg);
                msgBuilder.append(noAuthMsg);
            }
            assetBooks.removeIf(book -> !orgIds.contains(book.getLong("org")));
            if (assetBooks.isEmpty()) {
                return CustomApiResult.fail((String)"validate_error", (String)msgBuilder.toString());
            }
        }
        if (!(result = OperationServiceHelper.executeOperate((String)"fadepreciate", (String)"fa_assetbook", (Object[])(bookIds = assetBooks.stream().map(v -> v.getLong("id")).toArray()), null)).isSuccess()) {
            String msg;
            sb = new StringBuilder();
            List validateInfo = result.getAllErrorOrValidateInfo();
            for (IOperateInfo iOperateInfo : validateInfo) {
                sb.append(iOperateInfo.getMessage()).append("\u3001");
            }
            String string = msg = sb.length() > 0 ? sb.substring(0, sb.length() - 1) : sb.toString();
            if (StringUtils.isNotEmpty((String)msg)) {
                return CustomApiResult.fail((String)"validate_error", (String)String.format(ResManager.loadKDString((String)"\u8ba1\u63d0\u64cd\u4f5c\u8c03\u7528\u5931\u8d25\uff0c%s", (String)"DepreController_2", (String)"fi-fa-webapi", (Object[])new Object[0]), msg));
            }
        }
        return CustomApiResult.success((Object)String.format(ResManager.loadKDString((String)"\u8ba1\u63d0\u64cd\u4f5c\u8c03\u7528\u6210\u529f\uff0c%s", (String)"DepreController_3", (String)"fi-fa-webapi", (Object[])new Object[0]), msgBuilder.toString()));
    }

    @ApiPostMapping(value="/assetbook/queryDepreResult")
    public CustomApiResult<String> queryDepreResult(@ApiParam(value="\u7ec4\u7ec7\u7f16\u7801", required=true) @ApiParam(value="\u7ec4\u7ec7\u7f16\u7801", required=true) List<String> orgNums, @ApiParam(value="\u6298\u65e7\u7528\u9014\u7f16\u7801", required=true) @ApiParam(value="\u6298\u65e7\u7528\u9014\u7f16\u7801", required=true) List<String> depreUseNums) {
        HasPermOrgResult permOrgs;
        LicenseCheckResult checkResult = LicenseServiceHelper.checkByAppAndBizObj((String)"83bfebc800001aac", (String)"fa_new_depre", (Long)ContextUtil.getUserId());
        if (!checkResult.getHasLicense().booleanValue()) {
            return CustomApiResult.fail((String)"validate_error", (String)ResManager.loadKDString((String)"\u6ca1\u6709\u8d22\u52a1+\u4f9b\u5e94\u94fe+\u5236\u9020\u5206\u7ec4\u56fa\u5b9a\u8d44\u4ea7\u8bb8\u53ef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"DepreController_19", (String)"fi-fa-webapi", (Object[])new Object[0]));
        }
        StringBuilder msgSb = new StringBuilder();
        DynamicObjectCollection assetBooks = QueryServiceHelper.query((String)"fa_assetbook", (String)Fa.comma((String[])new String[]{"id", "name", "org", Fa.dot((String[])new String[]{"org", "number"}), Fa.dot((String[])new String[]{"org", "name"}), "curperiod"}), (QFilter[])new QFilter[]{new QFilter(Fa.dot((String[])new String[]{"org", "number"}), "in", orgNums), new QFilter(Fa.dot((String[])new String[]{"depreuse", "number"}), "in", depreUseNums)});
        if (assetBooks.isEmpty()) {
            return CustomApiResult.fail((String)"validate_error", (String)ResManager.loadKDString((String)"\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u7684\u8d26\u7c3f\u3002", (String)"DepreController_0", (String)"fi-fa-webapi", (Object[])new Object[0]));
        }
        List hasBookOrgNums = assetBooks.stream().map(v -> v.getString(Fa.dot((String[])new String[]{"org", "number"}))).collect(Collectors.toList());
        orgNums.removeAll(hasBookOrgNums);
        if (!orgNums.isEmpty()) {
            msgSb.append(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u7ec4\u7ec7\u6ca1\u6709\u8d26\u7c3f\u3002", (String)"DepreController_20", (String)"fi-fa-webapi", (Object[])new Object[0]), orgNums));
        }
        if (!(permOrgs = PermissionServiceHelper.getAllPermOrgs((long)ContextUtil.getUserId(), (String)"10", (String)"fa", (String)"fa_new_depre", (String)"47150e89000000ac")).hasAllOrgPerm()) {
            List orgIds = permOrgs.getHasPermOrgs();
            List noAuthorityBookNames = assetBooks.stream().filter(v -> !orgIds.contains(v.getLong("org"))).map(v -> v.getString(Fa.dot((String[])new String[]{"org", "name"}))).collect(Collectors.toList());
            if (!noAuthorityBookNames.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                for (String noAuthorityBookName : noAuthorityBookNames) {
                    sb.append(noAuthorityBookName).append("\u3001");
                }
                String errMsg = sb.length() > 0 ? sb.substring(0, sb.length() - 1) : "";
                String noAuthMsg = String.format(ResManager.loadKDString((String)"\u4ee5\u4e0b\u6838\u7b97\u7ec4\u7ec7[%s]\u6ca1\u6709\u67e5\u8be2\u6743\u9650\u3002", (String)"DepreController_21", (String)"fi-fa-webapi", (Object[])new Object[0]), errMsg);
                msgSb.append(noAuthMsg);
            }
            assetBooks.removeIf(book -> !orgIds.contains(book.getLong("org")));
            if (assetBooks.isEmpty()) {
                return CustomApiResult.fail((String)"validate_error", (String)msgSb.toString());
            }
        }
        ArrayList<String> results = new ArrayList<String>(assetBooks.size());
        for (DynamicObject assetBook : assetBooks) {
            String bookName = assetBook.getString("name");
            long assetBookId = assetBook.getLong("id");
            long currentPeriodId = assetBook.getLong("curperiod");
            DynamicObject disDepreLog = QueryServiceHelper.queryOne((String)"fa_disdepre_log", (String)Fa.comma((String[])new String[]{"status", "result_tag", "result"}), (QFilter[])new QFilter[]{new QFilter("assetbook", "=", (Object)assetBookId), new QFilter("period", "=", (Object)currentPeriodId), new QFilter("isnew", "=", (Object)Boolean.TRUE)});
            String bookNameStr = String.format(ResManager.loadKDString((String)"\u8d26\u7c3f%s", (String)"DepreController_22", (String)"fi-fa-webapi", (Object[])new Object[0]), bookName);
            String msg = ResManager.loadKDString((String)"\u5f53\u671f\u672a\u8ba1\u63d0\u3002", (String)"DepreController_4", (String)"fi-fa-webapi", (Object[])new Object[0]);
            if (disDepreLog != null) {
                String status = disDepreLog.getString("status");
                String result = disDepreLog.getString("result");
                String resultTag = disDepreLog.getString("result_tag");
                DepreStatusEnum2 statusEm = DepreStatusEnum2.fromString((String)status);
                if (DepreStatusEnum2.SUC == statusEm) {
                    msg = ResManager.loadKDString((String)"\u8ba1\u63d0\u6210\u529f\u3002", (String)"DepreController_5", (String)"fi-fa-webapi", (Object[])new Object[0]);
                } else if (DepreStatusEnum2.INIT != statusEm) {
                    if (DepreStatusEnum2.FAI == statusEm) {
                        msg = String.format(ResManager.loadKDString((String)"\u8ba1\u63d0\u5931\u8d25\uff1a%s", (String)"DepreController_6", (String)"fi-fa-webapi", (Object[])new Object[0]), result);
                    } else if (DepreStatusEnum2.DOING == statusEm) {
                        msg = ResManager.loadKDString((String)"\u8ba1\u63d0\u4e2d\u3002", (String)"DepreController_7", (String)"fi-fa-webapi", (Object[])new Object[0]);
                    } else if (DepreStatusEnum2.NEED_RE_DEPRE == statusEm) {
                        msg = ResManager.loadKDString((String)"\u9700\u91cd\u63d0\uff0c\u5b58\u5728\u672a\u5b8c\u6210\u7684\u4e1a\u52a1\uff1a", (String)"DepreController_8", (String)"fi-fa-webapi", (Object[])new Object[0]);
                        if (StringUtils.isNotEmpty((String)resultTag)) {
                            List unAuditRealCards;
                            List mergeObjects;
                            List workLoadObjects;
                            List splitObjects;
                            List devalsObjects;
                            List useDeptChangeObjects;
                            List clearObjects;
                            List unAuditMergedCards;
                            Map unFinishMap = (Map)SerializationUtils.fromJsonString((String)resultTag, Map.class);
                            List unAuditCards = (List)unFinishMap.get("unAuditCards");
                            if (!unAuditCards.isEmpty()) {
                                List<String> numbers = this.queryNumbers("fa_card_fin", "number", unAuditCards);
                                msg = msg + String.format(ResManager.loadKDString((String)"\u8d22\u52a1\u5361\u7247\u672a\u5ba1\u6838\uff1a%s\u3002", (String)"DepreController_9", (String)"fi-fa-webapi", (Object[])new Object[0]), numbers);
                            }
                            if (!(unAuditMergedCards = (List)unFinishMap.get("unAuditMergedCards")).isEmpty()) {
                                List<String> numbers = this.queryNumbers("fa_card_real", "number", unAuditMergedCards);
                                msg = msg + String.format(ResManager.loadKDString((String)"\u8d44\u4ea7\u5361\u7247\u672a\u5ba1\u6838\uff1a%s\u3002", (String)"DepreController_10", (String)"fi-fa-webapi", (Object[])new Object[0]), numbers);
                            }
                            if (!(clearObjects = (List)unFinishMap.get("clearObjects")).isEmpty()) {
                                List<String> numbers = this.queryNumbers("fa_clearbill", "billno", clearObjects);
                                msg = msg + String.format(ResManager.loadKDString((String)"\u6e05\u7406\u5355\u672a\u5ba1\u6838\uff1a%s\u3002", (String)"DepreController_11", (String)"fi-fa-webapi", (Object[])new Object[0]), numbers);
                            }
                            if (!(useDeptChangeObjects = (List)unFinishMap.get("useDeptChangeObjects")).isEmpty()) {
                                List<String> numbers = this.queryNumbers("fa_change_dept", "billno", useDeptChangeObjects);
                                msg = msg + String.format(ResManager.loadKDString((String)"\u53d8\u66f4\u5355\u672a\u5ba1\u6838\uff1a%s\u3002", (String)"DepreController_12", (String)"fi-fa-webapi", (Object[])new Object[0]), numbers);
                            }
                            if (!(devalsObjects = (List)unFinishMap.get("devalsObjects")).isEmpty()) {
                                List<String> numbers = this.queryNumbers("fa_asset_devalue", "billno", devalsObjects);
                                msg = msg + String.format(ResManager.loadKDString((String)"\u51cf\u503c\u5355\u672a\u5ba1\u6838\uff1a%s\u3002", (String)"DepreController_13", (String)"fi-fa-webapi", (Object[])new Object[0]), numbers);
                            }
                            if (!(splitObjects = (List)unFinishMap.get("splitObjects")).isEmpty()) {
                                List<String> numbers = this.queryNumbers("fa_assetsplitbill", "billno", splitObjects);
                                msg = msg + String.format(ResManager.loadKDString((String)"\u62c6\u5206\u5355\u672a\u5ba1\u6838\uff1a%s\u3002", (String)"DepreController_14", (String)"fi-fa-webapi", (Object[])new Object[0]), numbers);
                            }
                            if (!(workLoadObjects = (List)unFinishMap.get("workLoadObjects")).isEmpty()) {
                                List<String> numbers = this.queryNumbers("fa_workload", "billno", workLoadObjects);
                                msg = msg + String.format(ResManager.loadKDString((String)"\u5de5\u4f5c\u91cf\u7ef4\u62a4\u672a\u5ba1\u6838\uff1a%s\u3002", (String)"DepreController_15", (String)"fi-fa-webapi", (Object[])new Object[0]), numbers);
                            }
                            if (!(mergeObjects = (List)unFinishMap.get("mergeObjects")).isEmpty()) {
                                List<String> numbers = this.queryNumbers("fa_mergebill", "billno", mergeObjects);
                                msg = msg + String.format(ResManager.loadKDString((String)"\u5408\u5e76\u5355\u672a\u5ba1\u6838\uff1a%s\u3002", (String)"DepreController_16", (String)"fi-fa-webapi", (Object[])new Object[0]), numbers);
                            }
                            if (!(unAuditRealCards = (List)unFinishMap.get("unAuditRealCards")).isEmpty()) {
                                List<String> numbers = this.queryNumbers("fa_card_real", "number", unAuditRealCards);
                                msg = msg + String.format(ResManager.loadKDString((String)"\u5b9e\u7269\u5361\u7247\u672a\u5ba1\u6838\uff1a%s\u3002", (String)"DepreController_17", (String)"fi-fa-webapi", (Object[])new Object[0]), numbers);
                            }
                        }
                    } else if (DepreStatusEnum2.INTERRUPT == statusEm) {
                        msg = String.format(ResManager.loadKDString((String)"\u8ba1\u63d0\u7ec8\u6b62\uff1a%s", (String)"DepreController_18", (String)"fi-fa-webapi", (Object[])new Object[0]), result);
                    }
                }
            }
            results.add(bookNameStr + msg);
        }
        msgSb.append(results);
        return CustomApiResult.success((Object)msgSb.toString());
    }

    private List<String> queryNumbers(String entityName, String selectFields, List<Object> ids) {
        return QueryServiceHelper.query((String)entityName, (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", ids)}).stream().map(v -> v.getString(selectFields)).collect(Collectors.toList());
    }
}

