/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.api.lease;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.ApiResult;
import kd.fi.fa.api.utils.FaApiUtils;
import kd.fi.fa.business.lease.LeaseTerminationHandler;
import kd.fi.fa.business.model.LeaseTerminationParam;
import kd.fi.fa.business.validator.lease.TerminationValidator;
import kd.fi.fa.common.util.DateUtil;

public class LeaseTerminationApiPlugin
implements IBillWebApiPlugin {
    private static final String HEAD = "datas";
    private static final String CONTRACT_ID = "contractId";
    private static final String TERMINATION_DATE = "terminationDate";
    private static final String CHANGE_MODE_ID = "changeModeId";
    private static final String RENEWAL_END_DATE = "renewalEndDate";

    public ApiResult doCustomService(Map<String, Object> params) {
        try {
            List datas = (List)params.get(HEAD);
            if (datas == null) {
                return ApiResult.fail((String)ResManager.loadKDString((String)"\u8bf7\u6c42\u4f53\u4e2d\u201cdatas\u201d\u5b57\u6bb5\u4e3a\u7a7a\uff0c\u8bf7\u6839\u636eAPI\u6e05\u5355\u68c0\u67e5\u8bf7\u6c42\u4f53\u6570\u636e\u3002", (String)"LeaseTerminationApiPlugin_0", (String)"fi-fa-webapi", (Object[])new Object[0]), (String)"no_data");
            }
            SimpleDateFormat format = DateUtil.getShortDate();
            ArrayList<LeaseTerminationParam> terminationParams = new ArrayList<LeaseTerminationParam>(datas.size());
            for (int i = 0; i < datas.size(); ++i) {
                Map data = (Map)datas.get(i);
                if (!data.containsKey(CONTRACT_ID)) {
                    return ApiResult.fail((String)String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff1a\u8bf7\u6c42\u4f53\u4e2d\u201ccontarctId\u201d\u5b57\u6bb5\u4e3a\u7a7a\uff0c\u8bf7\u6839\u636eAPI\u6e05\u5355\u68c0\u67e5\u8bf7\u6c42\u4f53\u6570\u636e\u3002", (String)"LeaseTerminationApiPlugin_1", (String)"fi-fa-webapi", (Object[])new Object[0]), i + 1), (String)"missing_params");
                }
                if (!data.containsKey(TERMINATION_DATE)) {
                    return ApiResult.fail((String)String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff1a\u8bf7\u6c42\u4f53\u4e2d\u201cterminationDate\u201d\u5b57\u6bb5\u4e3a\u7a7a\uff0c\u8bf7\u6839\u636eAPI\u6e05\u5355\u68c0\u67e5\u8bf7\u6c42\u4f53\u6570\u636e\u3002", (String)"LeaseTerminationApiPlugin_2", (String)"fi-fa-webapi", (Object[])new Object[0]), i + 1), (String)"missing_params");
                }
                if (!data.containsKey(CHANGE_MODE_ID)) {
                    return ApiResult.fail((String)String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff1a\u8bf7\u6c42\u4f53\u4e2d\u201cchangeModeId\u201d\u5b57\u6bb5\u4e3a\u7a7a\uff0c\u8bf7\u6839\u636eAPI\u6e05\u5355\u68c0\u67e5\u8bf7\u6c42\u4f53\u6570\u636e\u3002", (String)"LeaseTerminationApiPlugin_3", (String)"fi-fa-webapi", (Object[])new Object[0]), i + 1), (String)"missing_params");
                }
                if (!data.containsKey(RENEWAL_END_DATE)) {
                    return ApiResult.fail((String)String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff1a\u8bf7\u6c42\u4f53\u4e2d\u201crenewalEndDate\u201d\u5b57\u6bb5\u4e3a\u7a7a\uff0c\u8bf7\u6839\u636eAPI\u6e05\u5355\u68c0\u67e5\u8bf7\u6c42\u4f53\u6570\u636e\u3002", (String)"LeaseTerminationApiPlugin_4", (String)"fi-fa-webapi", (Object[])new Object[0]), i + 1), (String)"missing_params");
                }
                long contractId = FaApiUtils.parseIdToLong(data.get(CONTRACT_ID));
                String terminationDateStr = (String)data.get(TERMINATION_DATE);
                Date terminationDate = format.parse(terminationDateStr);
                long changeModeId = FaApiUtils.parseIdToLong(data.get(CHANGE_MODE_ID));
                String renewalEndDateStr = (String)data.get(RENEWAL_END_DATE);
                Date renewalEndDate = null;
                if (StringUtils.isNotEmpty((CharSequence)renewalEndDateStr)) {
                    renewalEndDate = format.parse(renewalEndDateStr);
                }
                LeaseTerminationParam param = new LeaseTerminationParam(contractId, terminationDate, changeModeId, renewalEndDate);
                terminationParams.add(param);
            }
            List errorInfo = new TerminationValidator(terminationParams).validate();
            if (!errorInfo.isEmpty()) {
                return ApiResult.fail((String)String.join((CharSequence)" ", errorInfo), (String)"validate_error");
            }
            new LeaseTerminationHandler(terminationParams).handle();
            return ApiResult.success((Object)"success");
        }
        catch (Exception ex) {
            return ApiResult.ex((Throwable)ex);
        }
    }
}

