/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.api.openapi.cloudapp;

import java.util.Map;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.validate.BillStatus;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.url.UrlService;
import kd.fi.fa.business.BizStatusEnum;
import kd.fi.fa.common.util.ThrowableHelper;
import kd.kuep.capp.model.card.DataListCard;
import kd.kuep.capp.sdk.DataListCardProxy;

public class FaCloudAppMainPageOpenapi
implements IBillWebApiPlugin {
    public static final Log logger = LogFactory.getLog(FaCloudAppMainPageOpenapi.class);
    private static final String DEFAULT_LINK_TYPE = "webview";

    public ApiResult doCustomService(Map<String, Object> params) {
        logger.info("FaCloudAppMainPageOpenapi request parameters\uff1a" + params);
        ApiResult result = new ApiResult();
        result.setSuccess(true);
        try {
            QFilter[] filters = this.createFilters();
            DynamicObjectCollection cols = QueryServiceHelper.query((String)"fa_card_real", (String)"assetname,number,picturefield", (QFilter[])filters);
            DataListCardProxy cardProxy = new DataListCardProxy();
            DataListCard card = cardProxy.getDataListCard();
            String linkUrl = UrlService.getDomainContextUrl() + "/mobile.html?form=fa_my_asset_template&billFormId=fa_mobile&type=mobilelist";
            String imageFullUrl = UrlService.getImageFullUrl((String)"");
            logger.info(String.format("the result of query :%s ,linkUrl:%s ,imageFullUrl:%s", cols, linkUrl, imageFullUrl));
            card.setDataListType(DataListCard.DataListType.imageText);
            card.setCardTitle(ResManager.loadKDString((String)"\u6211\u7684\u8d44\u4ea7", (String)"FaCloudAppMainPageOpenapi_0", (String)"fi-fa-webapi", (Object[])new Object[0]));
            card.setLinkUrl(linkUrl);
            card.setLinkType(DEFAULT_LINK_TYPE);
            String prefix = ResManager.loadKDString((String)"\u5b9e\u7269\u7f16\u7801:", (String)"FaCloudAppMainPageOpenapi_1", (String)"fi-fa-webapi", (Object[])new Object[0]);
            int size = Math.min(cols.size(), 3);
            for (int i = 0; i < size; ++i) {
                DynamicObject dy = (DynamicObject)cols.get(i);
                String assetName = dy.getString("assetname");
                String number = prefix + dy.getString("number");
                String picturePath = imageFullUrl + dy.getString("picturefield");
                cardProxy.addDataList(assetName, "", number, picturePath, null, null, null, null);
            }
            result.setData((Object)card);
        }
        catch (Throwable e) {
            logger.error("FaCloudAppMainPageOpenapi handle failed ", (Object)ThrowableHelper.toString((Throwable)e));
            result.setErrorCode("fi-fa");
            result.setMessage("data parsing failed");
            result.setSuccess(false);
        }
        return result;
    }

    private QFilter[] createFilters() {
        QFilter filter = new QFilter("headuseperson", "=", (Object)RequestContext.get().getCurrUserId());
        filter.and(new QFilter("isbak", "=", (Object)false));
        filter.and(new QFilter("isstoraged", "=", (Object)false));
        filter.and(new QFilter("bizstatus", "!=", (Object)BizStatusEnum.DELETE.toString()));
        filter.and(new QFilter("billstatus", "=", (Object)BillStatus.C.toString()));
        return filter.toArray();
    }
}

