/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.api.utils;

import java.util.Date;
import java.util.LinkedList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.fa.api.bean.Scheme;
import kd.fi.fa.common.util.ContextUtil;

public class FaInventoryUtils {
    private static Log log = LogFactory.getLog(FaInventoryUtils.class);
    private static String inventoryReportTable = "t_fa_inventory_record";

    public static Scheme getLatestSchemeId(Long userId) {
        new LinkedList();
        QFilter qFilter = new QFilter("realCard.headuseperson", "=", (Object)userId);
        DynamicObjectCollection inventorySchemes = ORM.create().query("fa_inventory_record", "id,inventschemeentry.id,inventschemeentry.name", new QFilter[]{qFilter}, "inventschemeentry.createtime desc", 1);
        if (inventorySchemes.size() > 0) {
            DynamicObject inventoryScheme = (DynamicObject)inventorySchemes.get(0);
            return new Scheme(inventoryScheme.getLong("inventschemeentry.id"), inventoryScheme.getString("inventschemeentry.name"));
        }
        return null;
    }

    public static Scheme getLatestSchemeId(String userId) {
        return FaInventoryUtils.getLatestSchemeId(Long.valueOf(userId));
    }

    public static String updateRecord(String barCode, Long curSchemeId, String schemename) {
        log.info("FaInventoryUtils.updateRecord-----curSchemeId----" + curSchemeId);
        log.info("FaInventoryUtils.updateRecord-----schemename2----" + schemename);
        QFilter qBarCode = new QFilter("realcard.barcode", "=", (Object)barCode);
        Long user = ContextUtil.getUserId();
        QFilter qUser = new QFilter("realcard.headuseperson", "=", (Object)user);
        String selectProperties = FaInventoryUtils.getSelectField2();
        DynamicObjectCollection records = ORM.create().query("fa_inventory_record", selectProperties, new QFilter[]{qBarCode, qUser}, "inventschemeentry.createtime desc", 1);
        if (records == null || records.size() == 0) {
            log.info("\u4e0b\u9762\u5206\u7c7b\u5224\u65ad\uff0c\u662f\u6ca1\u6709\u76d8\u70b9\u8bb0\u5f55\uff0c\u8fd8\u662f\u6ca1\u6709\u5361\u7247");
            qBarCode = new QFilter("barcode", "=", (Object)barCode);
            DynamicObject card = BusinessDataServiceHelper.loadSingle((String)"fa_card_real", (String)"headuseperson", (QFilter[])new QFilter[]{qBarCode});
            if (card == null) {
                log.info("\u5361\u7247\u90fd\u6ca1\u6709");
                return ResManager.loadKDString((String)"\u8be5\u8d44\u4ea7\u7f16\u7801\u4e0d\u5b58\u5728\u5bf9\u5e94\u5b9e\u7269\u5361\u7247", (String)"FaInventoryUtils_0", (String)"fi-fa-webapi", (Object[])new Object[0]);
            }
            if (user.equals(card.getLong("headuseperson.id"))) {
                log.info("98---\u8d44\u4ea7\u65e0\u9700\u76d8\u70b9");
                return ResManager.loadKDString((String)"\u8be5\u8d44\u4ea7\u672c\u6b21\u65e0\u9700\u76d8\u70b9\uff0c\u8bf7\u626b\u63cf\u5f85\u76d8\u8d44\u4ea7\u7684\u6761\u7801", (String)"FaInventoryUtils_1", (String)"fi-fa-webapi", (Object[])new Object[0]);
            }
            log.info("102---\u975e\u672c\u4eba\u8d44\u4ea7");
            return ResManager.loadKDString((String)"\u8be5\u8d44\u4ea7\u4e0d\u5728\u4f60\u540d\u4e0b\uff0c\u8bf7\u548c\u8d44\u4ea7\u7ba1\u7406\u5458\u8054\u7cfb", (String)"FaInventoryUtils_2", (String)"fi-fa-webapi", (Object[])new Object[0]);
        }
        DynamicObject record = (DynamicObject)records.get(0);
        String error = FaInventoryUtils.getErrorInfo(record, curSchemeId, schemename);
        if (StringUtils.isEmpty((Object)error)) {
            String recordId = String.valueOf(record.getPkValue());
            boolean status = FaInventoryUtils.updateRecordSuccess(recordId);
            if (status) {
                return ResManager.loadKDString((String)"\u76d8\u70b9\u6210\u529f", (String)"FaInventoryUtils_3", (String)"fi-fa-webapi", (Object[])new Object[0]);
            }
            return ResManager.loadKDString((String)"\u6267\u884csql,\u66f4\u65b0\u6570\u636e\u5e93\u5931\u8d25!", (String)"FaInventoryUtils_4", (String)"fi-fa-webapi", (Object[])new Object[0]);
        }
        return error;
    }

    private static String getErrorInfo(DynamicObject record, Long curSchemeId, String schemename2) {
        String detailTip = "";
        Long userId = record.getLong("realcard.headuseperson.id");
        String schemeId = record.getString("inventschemeentry.id");
        log.info("\u626b\u63cf\u7684\u5b9e\u7269\u7684\u4f7f\u7528\u4eba\uff1a+" + userId);
        if (!ContextUtil.getUserId().equals(userId)) {
            detailTip = ResManager.loadKDString((String)"\u8be5\u8d44\u4ea7\u4e0d\u5728\u4f60\u540d\u4e0b\uff0c\u8bf7\u548c\u8d44\u4ea7\u7ba1\u7406\u5458\u8054\u7cfb", (String)"FaInventoryUtils_2", (String)"fi-fa-webapi", (Object[])new Object[0]);
        }
        log.info("\u626b\u63cf\u7684\u5b9e\u7269\u7684\u76d8\u70b9\u65b9\u6848id+" + schemeId);
        log.info("\u672c\u9875\u9762\u5bf9\u5e94\u7684\u6700\u65b0\u7684\u76d8\u70b9\u65b9\u6848id+" + curSchemeId);
        if (!String.valueOf(curSchemeId).equals(schemeId)) {
            detailTip = ResManager.loadKDString((String)"\u8be5\u8d44\u4ea7\u672c\u6b21\u65e0\u9700\u76d8\u70b9\uff0c\u8bf7\u626b\u63cf\u5f85\u76d8\u8d44\u4ea7\u7684\u6761\u7801", (String)"FaInventoryUtils_1", (String)"fi-fa-webapi", (Object[])new Object[0]);
        }
        String status = record.getString("inventorystate");
        int difference = record.getInt("difference");
        log.info("\u626b\u63cf\u7684\u76d8\u70b9\u8bb0\u5f55\u72b6\u6001\uff1a+" + status);
        if ("A".equals(status) && difference >= 0) {
            detailTip = ResManager.loadKDString((String)"\u8be5\u8d44\u4ea7\u4f60\u5df2\u7ecf\u626b\u8fc7\u4e86\uff0c\u8bf7\u626b\u63cf\u5f85\u76d8\u8d44\u4ea7\u7684\u6761\u7801", (String)"FaInventoryUtils_5", (String)"fi-fa-webapi", (Object[])new Object[0]);
        }
        return detailTip;
    }

    private static boolean updateRecordSuccess(Object recordId) {
        String sql = "update " + inventoryReportTable + " set finventorystate = 'A',finventoryway = 'A',finventoryquantity = 1,finventorytime = ?,fdifference = 1-fbookquantity,freason='' where finventoryuser = '" + ContextUtil.getUserId() + "' and fid = '" + recordId + "'";
        log.info("----------------\u66f4\u65b0\u8bed\u53e5sql\uff1a" + sql);
        return DB.execute((DBRoute)DBRoute.of((String)"fa"), (String)sql, (Object[])new Object[]{new java.sql.Date(new Date().getTime())});
    }

    private static String getSelectField2() {
        StringBuilder fields = new StringBuilder(13);
        fields.append("realcard.number,").append("id,").append("realcard.billno,").append("realcard.id,").append("realcard.assetname,").append("realcard.picturefield,").append("realcard.model,").append("realcard.assetcat.name,").append("inventschemeentry.id,").append("inventschemeentry.name,").append("realcard.headuseperson.id,").append("difference,").append("inventorystate");
        return fields.toString();
    }
}

