/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.FaCopyFinCardDao;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class FaCopyFinCardService {
    private boolean isOnlyDbProperty;
    private boolean _clearPrimaryKeyValue;
    private Map<Long, Long> finID2bakRealIDMap = new HashMap<Long, Long>();

    public FaCopyFinCardService(Boolean isOnlyDbProperty, Boolean _clearPrimaryKeyValue) {
        this.isOnlyDbProperty = isOnlyDbProperty;
        this._clearPrimaryKeyValue = _clearPrimaryKeyValue;
    }

    public DynamicObject clone(DynamicObject finCard) {
        DynamicObject clonefincard = (DynamicObject)new CloneUtils(this.isOnlyDbProperty, this._clearPrimaryKeyValue).clone((IDataEntityBase)finCard);
        this.finID2bakRealIDMap.put(Long.parseLong(finCard.getPkValue().toString()), clonefincard.getLong("realcard_id"));
        return clonefincard;
    }

    public DynamicObject clone(IDataEntityType dt, DynamicObject finCard) {
        DynamicObject clonefincard = (DynamicObject)new CloneUtils(this.isOnlyDbProperty, this._clearPrimaryKeyValue).clone(dt, (Object)finCard);
        this.finID2bakRealIDMap.put(Long.parseLong(finCard.getPkValue().toString()), clonefincard.getLong("realcard_id"));
        return clonefincard;
    }

    public void setCardId(DynamicObject finCard, DynamicObject clonefincard, Long newid) {
        clonefincard.set("id", (Object)newid);
    }

    public void saveService(DynamicObject[] fincards) {
        SaveServiceHelper.save((DynamicObject[])fincards);
        List realIds = Arrays.asList(fincards).stream().map(v -> v.getLong("realcard_id")).collect(Collectors.toList());
        HashMap<Long, Long> needUpdate = new HashMap<Long, Long>();
        for (Map.Entry<Long, Long> next : this.finID2bakRealIDMap.entrySet()) {
            if (!realIds.contains(next.getValue())) continue;
            Long value = 0L;
            for (DynamicObject fc : fincards) {
                if (fc.getLong("realcard_id") != next.getValue().longValue()) continue;
                value = Long.parseLong(fc.getPkValue().toString());
            }
            needUpdate.put(next.getKey(), value);
        }
        this.updateDepreSplitEntry(needUpdate);
        this.updateConfigTable(needUpdate);
    }

    public void saveOperate(DynamicObject[] fincards, OperateOption option) {
        OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)"fa_card_fin", (DynamicObject[])fincards, (OperateOption)option);
        if (!result.isSuccess()) {
            List msg = result.getAllErrorOrValidateInfo().stream().map(IOperateInfo::getMessage).collect(Collectors.toList());
            String errInfo = String.join((CharSequence)" ", msg);
            throw new KDBizException(errInfo);
        }
        this.updateDepreSplitAndConfig(fincards);
    }

    public void updateDepreSplitAndConfig(DynamicObject[] fincards) {
        List ids = Arrays.asList(fincards).stream().map(v -> v.getLong("realcard_id")).collect(Collectors.toList());
        HashMap<Long, Long> needUpdate = new HashMap<Long, Long>(this.finID2bakRealIDMap.size());
        for (Map.Entry<Long, Long> next : this.finID2bakRealIDMap.entrySet()) {
            if (!ids.contains(next.getValue())) continue;
            Long value = 0L;
            for (DynamicObject fc : fincards) {
                if (fc.getLong("realcard_id") != next.getValue().longValue()) continue;
                value = Long.parseLong(fc.getPkValue().toString());
            }
            needUpdate.put(next.getKey(), value);
        }
        this.updateDepreSplitEntry(needUpdate);
        this.updateConfigTable(needUpdate);
    }

    public void updateFinRealIdMap(long newFinCardId, long oldRealCardId) {
        if (this.finID2bakRealIDMap.containsKey(newFinCardId)) {
            this.finID2bakRealIDMap.put(newFinCardId, oldRealCardId);
        }
    }

    private void updateDepreSplitEntry(Map<Long, Long> needUpdate) {
        if (needUpdate == null || needUpdate.size() == 0) {
            return;
        }
        ArrayList<Object[]> params = new ArrayList<Object[]>(needUpdate.size());
        ArrayList<Object[]> detailParams = new ArrayList<Object[]>(needUpdate.size());
        List oriIds = needUpdate.entrySet().stream().mapToLong(v -> (Long)v.getKey()).boxed().collect(Collectors.toList());
        SqlBuilder querySql = new SqlBuilder();
        querySql.append("select fdetailsid,fentryid,ffincardid from t_fa_depredetailentry where ", new Object[0]);
        querySql.appendIn("ffincardid", oriIds.toArray());
        HashSet<Long> detailsIdSet = new HashSet<Long>(needUpdate.size(), 1.0f);
        try (DataSet dataSet = DB.queryDataSet((String)"depresplitDetailQuery", (DBRoute)DBRoute.of((String)"fa"), (SqlBuilder)querySql);){
            for (Row dsentry : dataSet) {
                Object[] param = new Object[]{needUpdate.get(dsentry.getLong("ffincardid")), dsentry.getLong("fentryid")};
                params.add(param);
                Long detailsId = dsentry.getLong("fdetailsid");
                if (!detailsIdSet.add(detailsId)) continue;
                Object[] detailParam = new Object[]{needUpdate.get(dsentry.getLong("ffincardid")), detailsId};
                detailParams.add(detailParam);
            }
        }
        if (!params.isEmpty()) {
            String updateSql = "update T_FA_DEPREDETAILENTRY set FFINCARDID = ? where FENTRYID = ? ";
            DB.executeBatch((DBRoute)DBRoute.of((String)"fa"), (String)updateSql, params);
        }
        if (!detailParams.isEmpty()) {
            String updateDetailSql = "update t_fa_depresplitdetail set FFINCARDID = ? where fdetailsid = ? ";
            DB.executeBatch((DBRoute)DBRoute.of((String)"fa"), (String)updateDetailSql, detailParams);
        }
    }

    private void updateConfigTable(Map<Long, Long> needUpdate) {
        DynamicObject[] ec = BusinessDataServiceHelper.load((String)"fa_externalconfig", (String)"cloudid,appid,servicename,methodName", null);
        Object[] param = new Object[]{needUpdate};
        Arrays.asList(ec).stream().forEach(v -> DispatchServiceHelper.invokeService((String)v.getString("cloudid"), (String)v.getString("appid"), (String)v.getString("servicename"), (String)v.getString("methodName"), (Object[])param));
    }
}

