/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.assetsplit;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.validate.BillStatus;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.fi.fa.business.billmapping.BillFieldMappingConvertHelper;
import kd.fi.fa.business.card.FaCardDTO;
import kd.fi.fa.business.utils.BillFieldMappingBlackListUtils;
import kd.fi.fa.business.utils.FaCardInitFieldUtil;
import kd.fi.fa.business.utils.FaUtils;
import kd.fi.fa.common.util.Fa;

public class FaSplitBillAndCardHelper {
    private static final String REALCARD_MAPPING_NUMBER = "SR01";
    private static final String FINCARD_MAPPING_NUMBER = "SF01";
    private static final String REAL_JSON = "realjson_tag";
    private static final String FIN_JSON = "finjson_tag";
    private static final String PREFIX_FIN = "fin_";
    private BillFieldMappingConvertHelper realConfigHelper = FaSplitBillAndCardHelper.getConfigHelper("SR01");
    private BillFieldMappingConvertHelper finConfigHelper = FaSplitBillAndCardHelper.getConfigHelper("SF01");
    private Map<String, List<String>> realFinCardFieldMap = this.initRealFinCardFields();
    private static final Log log = LogFactory.getLog(FaSplitBillAndCardHelper.class);
    private static final String[] ENABLE_WHITELIST_SPLIT = new String[]{"aft_assetamount", "aft_originalval", "aft_accumdepre", "aft_decval", "aft_preresidualval", "aft_incometax", "aft_picturefield", "aft_originmethod"};
    private static final String[] ENABLE_WHITELIST_REALCARD = new String[]{"assetamount", "isfacility", "facility_entry", "picturefield", "originmethod"};
    private static final String[] ENABLE_WHITELIST_FINCARD = new String[]{"originalval", "accumdepre", "decval", "preresidualval", "incometax", "workloadunit"};
    private static final String[] NEEDLESS_VOUCHER_WHITELIST_REALCARD = new String[]{"assetamount", "isfacility", "picturefield"};
    private static final String[] NEEDLESS_VOUCHER_WHITELIST_FINCARD = new String[]{"originalval", "accumdepre", "decval", "preresidualval", "incometax", "originalamount", "networth", "netamount", "addupyeardepre", "workloadunit", "depredamount", "depremethod"};
    private static final Collection<String> MANUAL_CODE_FIELDS_SPLIT = Arrays.asList("aft_cardbillno", "aft_cardnumber", "aft_barcode");
    private static final Collection<String> QUANTITY_SPLIT_TYPE_FIELDS_SPLIT = Arrays.asList("aft_assetcat", "aft_unit");
    private static final Collection<String> MANUAL_CODE_FIELDS_CARD = Arrays.asList("billno", "number", "barcode");
    private static final Collection<String> QUANTITY_SPLIT_TYPE_FIELDS_CARD = Arrays.asList("assetcat", "unit");

    public Map<Integer, DynamicObject> splitBillConvert2AssetCardMap(DynamicObject splitBill) {
        Map<Integer, FaCardDTO> convertMap = this.splitBillConvert2CardDTOMap(splitBill);
        HashMap<Integer, DynamicObject> results = new HashMap<Integer, DynamicObject>(FaUtils.getInitialCapacity43(convertMap.size()));
        for (Map.Entry<Integer, FaCardDTO> convert : convertMap.entrySet()) {
            FaCardDTO faCardDTO = convert.getValue();
            DynamicObject assetCard = this.realCard2AssetCard(faCardDTO.getRealCard());
            assetCard.set("id", faCardDTO.getRealCard().getPkValue());
            this.setFinCards2AssetCard(assetCard, faCardDTO.getFinCardList());
            results.put(convert.getKey(), assetCard);
        }
        return results;
    }

    private Map<Integer, FaCardDTO> splitBillConvert2CardDTOMap(DynamicObject splitBill) {
        Map<Integer, List<DynamicObject>> entryGroupMap = this.getTargetEntries(splitBill);
        HashMap<Integer, FaCardDTO> results = new HashMap<Integer, FaCardDTO>(entryGroupMap.size());
        DynamicObject befRealDy = this.getBefRealDy(splitBill);
        Map<Long, DynamicObject> befFinDyMap = this.getBefFinDy(splitBill);
        for (Map.Entry<Integer, List<DynamicObject>> item : entryGroupMap.entrySet()) {
            List<DynamicObject> realFinCardObjList = item.getValue();
            boolean isAutoCarry = splitBill.getBoolean("isautocarry");
            FaCardDTO faCardDTO = this.entryConvert2Cards(realFinCardObjList, befRealDy, befFinDyMap, isAutoCarry, false);
            DynamicObject realCard = faCardDTO.getRealCard();
            realCard.set("srcbillid", splitBill.getPkValue());
            realCard.set("srcbillentityname", (Object)"fa_assetsplitbill");
            realCard.set("srcbillnumber", (Object)splitBill.getString("billno"));
            results.put(item.getKey(), faCardDTO);
        }
        return results;
    }

    public Map<Integer, FaCardDTO> splitBillConvert2RealFinCardMap(DynamicObject splitBill, List<Integer> indexList) {
        Map<Integer, List<DynamicObject>> entryGroupMap = this.getTargetEntries(splitBill, indexList);
        boolean isAutoCarry = splitBill.getBoolean("isautocarry");
        DynamicObject befRealDy = this.getBefRealDy(splitBill);
        Map<Long, DynamicObject> befFinDyMap = this.getBefFinDy(splitBill);
        HashMap<Integer, FaCardDTO> results = new HashMap<Integer, FaCardDTO>(entryGroupMap.size());
        long[] realCardIds = DB.genLongIds((String)"t_fa_card_real", (int)entryGroupMap.size());
        int i = 0;
        for (Map.Entry<Integer, List<DynamicObject>> item : entryGroupMap.entrySet()) {
            Integer index = item.getKey();
            List<DynamicObject> realFinCardObjList = item.getValue();
            boolean isSourceCard = realFinCardObjList.get(0).getBoolean("issourcecard");
            FaCardDTO faCardDTO = this.entryConvert2Cards(realFinCardObjList, befRealDy, befFinDyMap, isAutoCarry, isSourceCard);
            Long realCardId = realCardIds[i];
            if (faCardDTO.getRealCard().getLong("id") == 0L) {
                faCardDTO.getRealCard().set("id", (Object)realCardId);
                realFinCardObjList.stream().forEach(t -> t.set(Fa.id((String)"aft_realcard"), (Object)realCardId));
            }
            results.put(index, faCardDTO);
            ++i;
        }
        return results;
    }

    public void cardConvert2SplitBill(DynamicObject assetCard, DynamicObject splitBill, int index) {
        List<String> realFields = this.realFinCardFieldMap.get("fa_card_real");
        List<String> finFields = this.realFinCardFieldMap.get("fa_card_fin");
        DynamicObject realCard = this.assetCard2RealCard(assetCard, realFields);
        List<DynamicObject> finCards = this.assetCard2FinCard(assetCard, finFields);
        this.cardConvert2SplitBill(realCard, finCards, splitBill, index);
    }

    public void cardConvert2SplitBill(FaCardDTO cardDTO, DynamicObject splitBill, int index) {
        DynamicObject realCard = cardDTO.getRealCard();
        List<DynamicObject> finCards = cardDTO.getFinCardList();
        this.cardConvert2SplitBill(realCard, finCards, splitBill, index);
    }

    public void cardConvert2SubEntity(DynamicObject curRow, DynamicObject realCard, DynamicObject finCard, boolean isForceConvert, Map<String, Set<String>> unNeededFieldMap) {
        this.realConfigHelper.convert(realCard, curRow, true, isForceConvert, unNeededFieldMap.get("fa_card_real"));
        this.finConfigHelper.convert(finCard, curRow, true, isForceConvert, unNeededFieldMap.get("fa_card_fin"));
    }

    public Map<String, Set<String>> getNeedGenVoucherFields4Card() {
        HashMap<String, Set<String>> voucherFieldsMap = new HashMap<String, Set<String>>(2);
        HashSet realVoucherFields = new HashSet(16);
        HashSet finVoucherFields = new HashSet(16);
        voucherFieldsMap.put("fa_card_real", realVoucherFields);
        voucherFieldsMap.put("fa_card_fin", finVoucherFields);
        Collection<DynamicObject> realChangeItems = this.queryChangeItems4Entity("fa_card_real");
        Collection<DynamicObject> finChangeItems = this.queryChangeItems4Entity("fa_card_fin");
        realChangeItems.stream().forEach(t -> {
            String field = t.getString("number");
            if (t.getBoolean("isgenvoucher") && !Arrays.asList(NEEDLESS_VOUCHER_WHITELIST_REALCARD).contains(field)) {
                realVoucherFields.add(field);
            }
        });
        finChangeItems.stream().forEach(t -> {
            String field = t.getString("number");
            if (t.getBoolean("isgenvoucher") && !Arrays.asList(NEEDLESS_VOUCHER_WHITELIST_FINCARD).contains(field)) {
                finVoucherFields.add(field);
            }
        });
        return voucherFieldsMap;
    }

    public Set<String> getEnableFields4Split() {
        return this.getEnableFields4Split(false);
    }

    public Set<String> getEnableFields4Split(boolean isOpenManualCode) {
        return this.getEnableFields4Split(isOpenManualCode, true);
    }

    public Set<String> getEnableFields4Split(boolean isOpenManualCode, boolean isQuantitySplit) {
        HashSet<String> enableFields = new HashSet<String>(16);
        enableFields.addAll(Arrays.asList(ENABLE_WHITELIST_SPLIT));
        Collection<DynamicObject> realChangeItems = this.queryChangeItems4Entity("fa_card_real");
        Collection<DynamicObject> finChangeItems = this.queryChangeItems4Entity("fa_card_fin");
        Map<String, String> real2SplitColsMap = this.realConfigHelper.getColsMap(true, false);
        Map<String, String> fin2SplitColsMap = this.finConfigHelper.getColsMap(true, false);
        realChangeItems.stream().forEach(t -> {
            String field = t.getString("number");
            String splitField = (String)real2SplitColsMap.get(field);
            if (StringUtils.isNotEmpty((String)splitField)) {
                enableFields.add(splitField);
            }
        });
        finChangeItems.stream().forEach(t -> {
            String field = t.getString("number");
            String splitField = (String)fin2SplitColsMap.get(field);
            if (StringUtils.isNotEmpty((String)splitField)) {
                enableFields.add(splitField);
            }
        });
        if (isOpenManualCode) {
            enableFields.addAll(MANUAL_CODE_FIELDS_SPLIT);
        } else {
            enableFields.removeAll(MANUAL_CODE_FIELDS_SPLIT);
        }
        if (isQuantitySplit) {
            enableFields.removeAll(QUANTITY_SPLIT_TYPE_FIELDS_SPLIT);
        } else {
            enableFields.addAll(QUANTITY_SPLIT_TYPE_FIELDS_SPLIT);
        }
        return enableFields;
    }

    public Map<String, Set<String>> getEnableFields4Card() {
        return this.getEnableFields4Card(false);
    }

    public Map<String, Set<String>> getEnableFields4Card(boolean isOpenManualCode) {
        return this.getEnableFields4Card(isOpenManualCode, true);
    }

    public Map<String, Set<String>> getEnableFields4Card(boolean isOpenManualCode, boolean isQuantitySplit) {
        HashMap<String, Set<String>> enableFieldsMap = new HashMap<String, Set<String>>(2);
        HashSet realEnableFields = new HashSet(16);
        HashSet finEnableFields = new HashSet(16);
        enableFieldsMap.put("fa_card_real", realEnableFields);
        enableFieldsMap.put("fa_card_fin", finEnableFields);
        Collection<DynamicObject> realChangeItems = this.queryChangeItems4Entity("fa_card_real");
        Collection<DynamicObject> finChangeItems = this.queryChangeItems4Entity("fa_card_fin");
        realChangeItems.stream().forEach(t -> realEnableFields.add(t.getString("number")));
        finChangeItems.stream().forEach(t -> finEnableFields.add(t.getString("number")));
        realEnableFields.addAll(Arrays.stream(ENABLE_WHITELIST_REALCARD).collect(Collectors.toSet()));
        finEnableFields.addAll(Arrays.stream(ENABLE_WHITELIST_FINCARD).collect(Collectors.toSet()));
        if (isOpenManualCode) {
            ((Set)enableFieldsMap.get("fa_card_real")).addAll(MANUAL_CODE_FIELDS_CARD);
        } else {
            ((Set)enableFieldsMap.get("fa_card_real")).removeAll(MANUAL_CODE_FIELDS_CARD);
        }
        if (isQuantitySplit) {
            ((Set)enableFieldsMap.get("fa_card_real")).removeAll(QUANTITY_SPLIT_TYPE_FIELDS_CARD);
        } else {
            ((Set)enableFieldsMap.get("fa_card_real")).addAll(QUANTITY_SPLIT_TYPE_FIELDS_CARD);
        }
        return enableFieldsMap;
    }

    private void cardConvert2SplitBill(DynamicObject realCard, List<DynamicObject> finCards, DynamicObject splitBill, int index) {
        List<String> realFields = this.realFinCardFieldMap.get("fa_card_real");
        List<String> finFields = this.realFinCardFieldMap.get("fa_card_fin");
        List<String> realConfigFields = this.realConfigHelper.getConfigFields4Target();
        List<String> finConfigFields = this.finConfigHelper.getConfigFields4Target();
        Set<String> blacklist4Real = BillFieldMappingBlackListUtils.getBlacklist("fa_card_real");
        Set<String> blacklist4Fin = BillFieldMappingBlackListUtils.getBlacklist("fa_card_fin");
        List unConfigFields4Real = realFields.stream().filter(t -> !realConfigFields.contains(t) && !blacklist4Real.contains(t)).collect(Collectors.toList());
        unConfigFields4Real.add("facility_entry");
        ArrayList unConfigFields4Fin = new ArrayList(8);
        finFields.stream().forEach(t -> {
            String field = t.replace(PREFIX_FIN, "");
            if (!finConfigFields.contains(field) && !blacklist4Fin.contains(field)) {
                unConfigFields4Fin.add(field);
            }
        });
        String unConfigMapStr4Real = null;
        if (CollectionUtils.isNotEmpty(unConfigFields4Real)) {
            HashMap<String, Object> unConfigMap4Real = new HashMap<String, Object>(unConfigFields4Real.size());
            for (String field : unConfigFields4Real) {
                unConfigMap4Real.put(field, this.getFieldVal(realCard, field));
            }
            unConfigMapStr4Real = SerializationUtils.serializeToBase64(unConfigMap4Real);
        }
        DynamicObjectCollection befSplitEntries = splitBill.getDynamicObjectCollection("assetsplitentry");
        for (DynamicObject befSplitEntry : befSplitEntries) {
            DynamicObjectCollection aftSplitEntries = befSplitEntry.getDynamicObjectCollection("subassetsplitentry");
            DynamicObject aftSplitEntry = aftSplitEntries.stream().filter(t -> t.getInt("index") == index).findFirst().orElse(null);
            Long depreuseId = aftSplitEntry.getLong(Fa.dot((String[])new String[]{"aft_depreuse", "id"}));
            DynamicObject finCard = finCards.stream().filter(t -> {
                Long cardDepreuseId = t.getLong(Fa.dot((String[])new String[]{"depreuse", "id"}));
                return depreuseId.equals(cardDepreuseId);
            }).findFirst().orElse(null);
            if (finCard == null) continue;
            this.realConfigHelper.convert(realCard, aftSplitEntry, true, true, null);
            this.finConfigHelper.convert(finCard, aftSplitEntry, true, true, null);
            String unConfigMapStr4Fin = null;
            HashMap<String, Object> unConfigMap4Fin = null;
            if (CollectionUtils.isNotEmpty(unConfigFields4Fin)) {
                unConfigMap4Fin = new HashMap<String, Object>(unConfigFields4Fin.size());
                for (String field : unConfigFields4Fin) {
                    unConfigMap4Fin.put(field, this.getFieldVal(finCard, field));
                }
                unConfigMapStr4Fin = SerializationUtils.serializeToBase64(unConfigMap4Fin);
            }
            aftSplitEntry.set(FIN_JSON, unConfigMapStr4Fin);
            aftSplitEntry.set(REAL_JSON, (Object)unConfigMapStr4Real);
        }
    }

    private Map<Integer, List<DynamicObject>> getTargetEntries(DynamicObject splitBill, List<Integer> indexList) {
        HashMap<Integer, List<DynamicObject>> entryGroupMap = new HashMap<Integer, List<DynamicObject>>(16);
        DynamicObjectCollection befSplitEntries = splitBill.getDynamicObjectCollection("assetsplitentry");
        for (DynamicObject befSplitEntry : befSplitEntries) {
            DynamicObjectCollection aftSplitEntries = befSplitEntry.getDynamicObjectCollection("subassetsplitentry");
            aftSplitEntries.stream().forEach(t -> {
                Integer index = t.getInt("index");
                if (CollectionUtils.isEmpty((Collection)indexList) || indexList.contains(index)) {
                    ArrayList<DynamicObject> entryValList = (ArrayList<DynamicObject>)entryGroupMap.get(index);
                    if (entryValList == null) {
                        entryValList = new ArrayList<DynamicObject>(4);
                        entryGroupMap.put(index, entryValList);
                    }
                    entryValList.add((DynamicObject)t);
                }
            });
        }
        return entryGroupMap;
    }

    private Map<Integer, List<DynamicObject>> getTargetEntries(DynamicObject splitBill) {
        HashMap<Integer, List<DynamicObject>> entryGroupMap = new HashMap<Integer, List<DynamicObject>>(16);
        DynamicObjectCollection befSplitEntries = splitBill.getDynamicObjectCollection("assetsplitentry");
        for (DynamicObject befSplitEntry : befSplitEntries) {
            DynamicObjectCollection aftSplitEntries = befSplitEntry.getDynamicObjectCollection("subassetsplitentry");
            aftSplitEntries.forEach(t -> {
                Integer index = t.getInt("index");
                if (!t.getBoolean("issourcecard")) {
                    List entryValList = entryGroupMap.computeIfAbsent(index, k -> new ArrayList(4));
                    entryValList.add(t);
                }
            });
        }
        return entryGroupMap;
    }

    private Object getFieldVal(DynamicObject obj, String field) {
        Object fieldObj = obj.get(field);
        if (fieldObj instanceof DynamicObject) {
            return ((DynamicObject)fieldObj).getPkValue();
        }
        return obj.get(field);
    }

    private FaCardDTO entryConvert2Cards(List<DynamicObject> realFinCardObjList, DynamicObject befRealDy, Map<Long, DynamicObject> befFinDyMap, boolean isAutoCarry, boolean isSourceCard) {
        String realJsonStr;
        DynamicObject realCard;
        ArrayList<DynamicObject> finCards = new ArrayList<DynamicObject>(realFinCardObjList.size());
        DynamicObject entryContainRealObj = realFinCardObjList.get(0);
        DynamicObject aftRealObj = entryContainRealObj.getDynamicObject("aft_realcard");
        if (aftRealObj != null) {
            realCard = BusinessDataServiceHelper.loadSingleFromCache((Object)aftRealObj.getPkValue(), (String)"fa_card_real");
        } else if (isSourceCard) {
            realCard = (DynamicObject)new CloneUtils(true, false).clone((IDataEntityBase)befRealDy);
        } else if (isAutoCarry) {
            realCard = (DynamicObject)new CloneUtils(true, true).clone((IDataEntityBase)befRealDy);
            FaCardInitFieldUtil.restoreInitFields(realCard);
        } else {
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"fa_card_real");
            realCard = new DynamicObject((DynamicObjectType)dataEntityType);
        }
        this.realConfigHelper.convert(entryContainRealObj, realCard, false, true, null);
        realCard.set("mergedcard", (Object)true);
        if (!isSourceCard) {
            realCard.set("justrealcard", (Object)befRealDy.getBoolean("justrealcard"));
            realCard.set("usedate", (Object)befRealDy.getDate("usedate"));
            realCard.set("id", (Object)entryContainRealObj.getLong(Fa.id((String)"aft_realcard")));
            realCard.set("masterid", (Object)entryContainRealObj.getLong(Fa.id((String)"aft_realcard")));
            realCard.set("initialcard", (Object)Boolean.FALSE);
            realCard.set("createtime", null);
        }
        if (StringUtils.isNotEmpty((String)(realJsonStr = entryContainRealObj.getString(REAL_JSON)))) {
            Map realExtMap = (Map)SerializationUtils.deSerializeFromBase64((String)realJsonStr);
            for (Map.Entry entry : realExtMap.entrySet()) {
                if (!realCard.containsProperty((String)entry.getKey())) continue;
                realCard.set((String)entry.getKey(), entry.getValue());
            }
        }
        realCard.set("billstatus", (Object)BillStatus.A);
        for (DynamicObject realFinEntry : realFinCardObjList) {
            DynamicObject finCard;
            DynamicObject aftFinObj = realFinEntry.getDynamicObject("aft_fincard");
            if (aftFinObj != null) {
                finCard = BusinessDataServiceHelper.loadSingleFromCache((Object)aftFinObj.getPkValue(), (String)"fa_card_fin");
            } else {
                Long depreUseId = realFinEntry.getLong(Fa.dot((String[])new String[]{"aft_depreuse", "id"}));
                DynamicObject befFinCard = befFinDyMap.get(depreUseId);
                if (befFinCard == null) {
                    log.info("\u5165\u53c2befFinDyMap\u7684\u503c\uff1a" + befFinDyMap.toString());
                    log.info("\u62c6\u5206\u540e\u5206\u5f55\u6298\u65e7\u7528\u9014id\uff1a" + depreUseId);
                    throw new KDBizException(ResManager.loadKDString((String)"\u6620\u5c04\u8f6c\u6362\u6570\u636e\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u662f\u5426\u6b63\u786e\u3002", (String)"FaSplitBillAndCardHelper_0", (String)"fi-fa-business", (Object[])new Object[0]));
                }
                if (isSourceCard) {
                    finCard = (DynamicObject)new CloneUtils(true, false).clone((IDataEntityBase)befFinCard);
                } else {
                    if (isAutoCarry) {
                        finCard = (DynamicObject)new CloneUtils(true, true).clone((IDataEntityBase)befFinCard);
                        FaCardInitFieldUtil.restoreInitFields(finCard);
                    } else {
                        finCard = new DynamicObject((DynamicObjectType)this.finConfigHelper.getTargetEntityType());
                        finCard.set("finaccountdate", befFinCard.get("finaccountdate"));
                    }
                    finCard.set("id", (Object)realFinEntry.getLong(Fa.id((String)"aft_fincard")));
                    finCard.set(Fa.id((String)"realcard"), (Object)realFinEntry.getLong(Fa.id((String)"aft_realcard")));
                    finCard.set("realcardmasterid", (Object)realFinEntry.getLong(Fa.id((String)"aft_realcard")));
                    finCard.set("billno", (Object)realCard.getString("billno"));
                    finCard.set("number", (Object)realCard.getString("number"));
                    finCard.set("assetcat", (Object)realCard.getDynamicObject("assetcat"));
                    finCard.set("org", (Object)befFinCard.getDynamicObject("org"));
                    DynamicObject assetBook = befFinCard.getDynamicObject("assetbook");
                    finCard.set("assetbook", (Object)assetBook);
                    finCard.set("period", (Object)befFinCard.getDynamicObject("period"));
                    DynamicObject assetBookCurPeriod = assetBook.getDynamicObject("curperiod");
                    finCard.set("bizperiod", (Object)assetBookCurPeriod);
                    finCard.set("endperiod", (Object)99999999999L);
                    finCard.set("monthdepre", (Object)BigDecimal.ZERO);
                    finCard.set("hasvoucher", (Object)true);
                    BigDecimal depredAmount = befFinCard.getBigDecimal("depredamount");
                    BigDecimal addiDepreAmount = befFinCard.getBigDecimal("addidepreamount");
                    BigDecimal curDepredAmount = depredAmount;
                    DynamicObject finCardBizPeriod = befFinCard.getDynamicObject("bizperiod");
                    if (finCardBizPeriod != null && finCardBizPeriod.getLong("id") == assetBookCurPeriod.getLong("id")) {
                        curDepredAmount = curDepredAmount.subtract(addiDepreAmount);
                    }
                    finCard.set("depredamount", (Object)curDepredAmount);
                    finCard.set("addidepreamount", (Object)BigDecimal.ZERO);
                    finCard.set("isneeddepre", (Object)"1");
                    finCard.set("createtime", null);
                }
            }
            if (!isSourceCard) {
                finCard.getDynamicObjectCollection("billhead_lk").clear();
            }
            this.finConfigHelper.convert(realFinEntry, finCard, false, true, null);
            String finJsonStr = realFinEntry.getString(FIN_JSON);
            if (StringUtils.isNotEmpty((String)finJsonStr)) {
                Map finExtMap = (Map)SerializationUtils.deSerializeFromBase64((String)finJsonStr);
                for (Map.Entry entry : finExtMap.entrySet()) {
                    if (!finCard.containsProperty((String)entry.getKey())) continue;
                    finCard.set((String)entry.getKey(), entry.getValue());
                }
            }
            finCard.set("billstatus", (Object)BillStatus.A);
            finCards.add(finCard);
        }
        FaCardDTO result = new FaCardDTO(realCard, null, finCards);
        result.setSourceCard(isSourceCard);
        return result;
    }

    private void setFinCards2AssetCard(DynamicObject assetCard, List<DynamicObject> sourceFinCards) {
        DynamicObjectCollection finCardObjs = assetCard.getDynamicObjectCollection("finentry");
        sourceFinCards.stream().forEach(t -> {
            DynamicObject finObj = finCardObjs.addNew();
            finObj.set("fincard", t);
        });
    }

    public DynamicObject realCard2AssetCard(DynamicObject realCard) {
        MainEntityType assetCardEntityType = EntityMetadataCache.getDataEntityType((String)"fa_asset_card");
        DynamicObject assetCard = new DynamicObject((DynamicObjectType)assetCardEntityType);
        Map assetCardPropertyMap = assetCardEntityType.getAllFields();
        IDataEntityType parent = null;
        for (IDataEntityProperty pro : assetCardPropertyMap.values()) {
            String proName = pro.getName();
            parent = pro.getParent();
            if (!(parent instanceof MainEntityType)) continue;
            assetCard.set(proName, realCard.get(proName));
        }
        assetCard.set("facility_entry", realCard.get("facility_entry"));
        assetCard.set("id", (Object)realCard.getLong("id"));
        return assetCard;
    }

    private DynamicObject assetCard2RealCard(DynamicObject assetCard, List<String> realCardFields) {
        MainEntityType realEntityType = EntityMetadataCache.getDataEntityType((String)"fa_card_real");
        DynamicObject realCard = new DynamicObject((DynamicObjectType)realEntityType);
        realCardFields.stream().forEach(t -> realCard.set(t, assetCard.get(t)));
        return realCard;
    }

    private List<DynamicObject> assetCard2FinCard(DynamicObject assetCard, List<String> finCardFields) {
        DynamicObjectCollection finCardEntries = assetCard.getDynamicObjectCollection("finentry");
        ArrayList<DynamicObject> finCardList = new ArrayList<DynamicObject>(finCardEntries.size());
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"fa_card_fin");
        for (DynamicObject finCardEntry : finCardEntries) {
            DynamicObject finCard = new DynamicObject((DynamicObjectType)dataEntityType);
            finCardFields.stream().forEach(t -> finCard.set(t.replace(PREFIX_FIN, ""), finCardEntry.get(t)));
            finCardList.add(finCard);
        }
        return finCardList;
    }

    private Map<String, List<String>> initRealFinCardFields() {
        String proName;
        HashMap<String, List<String>> fieldsMap = new HashMap<String, List<String>>(2);
        ArrayList<String> realCardFields = new ArrayList<String>(16);
        ArrayList<String> finCardFields = new ArrayList<String>(16);
        MainEntityType realEntityType = EntityMetadataCache.getDataEntityType((String)"fa_card_real");
        MainEntityType finEntityType = EntityMetadataCache.getDataEntityType((String)"fa_card_fin");
        Map realPropertyMap = realEntityType.getAllFields();
        Map finPropertyMap = finEntityType.getAllFields();
        IDataEntityType parent = null;
        for (IDataEntityProperty pro : realPropertyMap.values()) {
            proName = pro.getName();
            parent = pro.getParent();
            if (!(parent instanceof MainEntityType)) continue;
            realCardFields.add(proName);
        }
        for (IDataEntityProperty pro : finPropertyMap.values()) {
            proName = pro.getName();
            parent = pro.getParent();
            if (!(parent instanceof MainEntityType)) continue;
            finCardFields.add(proName);
        }
        fieldsMap.put("fa_card_real", realCardFields);
        fieldsMap.put("fa_card_fin", finCardFields);
        return fieldsMap;
    }

    private DynamicObject getBefRealDy(DynamicObject splitBill) {
        Long realCardId = splitBill.getLong(Fa.dot((String[])new String[]{"split_realcard", "id"}));
        return BusinessDataServiceHelper.loadSingleFromCache((Object)realCardId, (String)"fa_card_real");
    }

    private Map<Long, DynamicObject> getBefFinDy(DynamicObject splitBill) {
        DynamicObjectCollection befEntries = splitBill.getDynamicObjectCollection("assetsplitentry");
        if (CollectionUtils.isEmpty((Collection)befEntries)) {
            log.info("\u62c6\u5206\u524d\u5206\u5f55\u6570\u636e\u4e3a\u7a7a");
            return new HashMap<Long, DynamicObject>();
        }
        HashMap<Long, DynamicObject> befFinDyMap = new HashMap<Long, DynamicObject>(befEntries.size());
        HashSet finCardIds = new HashSet(befEntries.size());
        befEntries.stream().forEach(t -> finCardIds.add(t.getLong(Fa.dot((String[])new String[]{"bef_fincard", "id"}))));
        log.info("\u62c6\u5206\u524d\u5206\u5f55\u8d22\u52a1\u5361\u7247id\u96c6\u5408\uff1a" + ((Object)finCardIds).toString());
        DynamicObject[] finCardObjs = BusinessDataServiceHelper.load((Object[])finCardIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fa_card_fin"));
        Arrays.stream(finCardObjs).forEach(t -> befFinDyMap.put(t.getLong(Fa.dot((String[])new String[]{"depreuse", "id"})), (DynamicObject)t));
        return befFinDyMap;
    }

    private Collection<DynamicObject> queryChangeItems4Entity(String entity) {
        QFilter[] filters;
        if (!"fa_card_real".equals(entity) && !"fa_card_fin".equals(entity)) {
            log.info("\u53ea\u652f\u6301\u5b9e\u7269\u3001\u8d22\u52a1\u67e5\u8be2\u53ef\u53d8\u66f4\u9879\u76ee\uff01");
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> entityHeadFields = new ArrayList<String>(16);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entity);
        Map propertyMap = entityType.getAllFields();
        for (IDataEntityProperty pro : propertyMap.values()) {
            String proName = pro.getName();
            IDataEntityType parent = pro.getParent();
            if (!(parent instanceof MainEntityType)) continue;
            entityHeadFields.add(proName);
        }
        String selectFields = Fa.comma((String[])new String[]{"topic", "number", "isgenvoucher"});
        Collection<DynamicObject> items = BusinessDataServiceHelper.loadFromCache((String)"fa_change_item", (String)selectFields, (QFilter[])(filters = new QFilter[]{new QFilter("topic", "=", (Object)entity), new QFilter("number", "in", entityHeadFields), new QFilter("enable", "=", (Object)Boolean.TRUE)})).values();
        if (CollectionUtils.isEmpty(items)) {
            log.info("topic[{}]\u5728\u53ef\u53d8\u66f4\u9879\u76ee\u4e2d\u65e0\u914d\u7f6e\u6570\u636e\uff01", (Object)entity);
        }
        return items;
    }

    public static BillFieldMappingConvertHelper getConfigHelper(String number) {
        DynamicObject realCardConfig = BusinessDataServiceHelper.loadSingleFromCache((String)"fa_billfieldmapping", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)number), new QFilter("isenable", "=", (Object)Boolean.TRUE)});
        return new BillFieldMappingConvertHelper(realCardConfig);
    }

    public BillFieldMappingConvertHelper getRealConfigHelper() {
        return this.realConfigHelper;
    }

    public BillFieldMappingConvertHelper getFinConfigHelper() {
        return this.finConfigHelper;
    }
}

