/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.busyrecord;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.fi.fa.business.busyrecord.utils.BusyChgRecordUtils;
import kd.fi.fa.business.busyrecord.utils.PeriodBusyChgUtils;
import kd.fi.fa.business.utils.FaRptMediateUtil;

public class AbstractBusyRecordServicePlugin
extends AbstractOperationServicePlugIn {
    public static final Map<String, String> entity2Entry4PeriodchgMap = new HashMap<String, String>(6, 1.0f);
    public static final Map<String, String> entity2Entry4BusyChgRecordSpecilBillMap;
    public static final Map<String, String> entity2Entry4BusyChgRecordMap;

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("createtime");
        fieldKeys.add("modifytime");
        fieldKeys.add("auditdate");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        this.genPeriodBusyChgRecord(e);
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        this.genBusyChgRecord(e);
        String operationKey = e.getOperationKey();
        String billName = this.billEntityType.getName();
        if ("audit".equals(operationKey)) {
            FaRptMediateUtil.record(billName, e.getDataEntities());
        } else if ("unaudit".equals(operationKey)) {
            FaRptMediateUtil.deleteByUnaudit(billName, e.getDataEntities());
        }
    }

    private void genPeriodBusyChgRecord(BeginOperationTransactionArgs e) {
        String operationKey = e.getOperationKey();
        DynamicObject[] bills = e.getDataEntities();
        if (bills == null || bills.length == 0) {
            return;
        }
        String entityName = this.billEntityType.getName();
        if (!entity2Entry4PeriodchgMap.containsKey(entityName)) {
            return;
        }
        if (operationKey.equalsIgnoreCase("audit")) {
            PeriodBusyChgUtils.genPeriodBusyChgRecord(entityName, bills);
        }
    }

    private void genBusyChgRecord(EndOperationTransactionArgs e) {
        String operationKey = e.getOperationKey();
        DynamicObject[] bills = e.getDataEntities();
        if (bills == null || bills.length == 0) {
            return;
        }
        String entityName = this.billEntityType.getName();
        if (!entity2Entry4BusyChgRecordMap.containsKey(entityName)) {
            return;
        }
        if (operationKey.equalsIgnoreCase("save") || operationKey.equalsIgnoreCase("submit")) {
            BusyChgRecordUtils.busyChgRecord4SaveUpdate(entityName, bills);
        } else if (operationKey.equalsIgnoreCase("audit") || operationKey.equalsIgnoreCase("unaudit")) {
            BusyChgRecordUtils.busyChgRecord4AuditOp(entityName, bills);
        } else if (operationKey.equalsIgnoreCase("delete")) {
            BusyChgRecordUtils.busyChgRecord4DeleteOp(entityName, bills);
        }
    }

    static {
        entity2Entry4PeriodchgMap.put("fa_change_dept", "fieldentry");
        entity2Entry4PeriodchgMap.put("fa_clearbill", "detail_entry");
        entity2Entry4PeriodchgMap.put("fa_asset_devalue", "changebillentry");
        entity2Entry4PeriodchgMap.put("fa_assetsplitbill", "assetsplitentry");
        entity2Entry4PeriodchgMap.put("fa_mergebill", "inentryentity");
        entity2Entry4PeriodchgMap.put("fa_restartrealbill", "restartentity");
        entity2Entry4BusyChgRecordSpecilBillMap = new HashMap<String, String>(2, 1.0f);
        entity2Entry4BusyChgRecordSpecilBillMap.put("fa_depreadjustbill", "entryentity");
        entity2Entry4BusyChgRecordSpecilBillMap.put("fa_dispatch", "dispatchentry");
        entity2Entry4BusyChgRecordMap = new HashMap<String, String>(8, 1.0f);
        entity2Entry4BusyChgRecordMap.putAll(entity2Entry4PeriodchgMap);
        entity2Entry4BusyChgRecordMap.putAll(entity2Entry4BusyChgRecordSpecilBillMap);
    }
}

