/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.busyrecord.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.fa.business.busyrecord.AbstractBusyRecordServicePlugin;
import kd.fi.fa.business.busyrecord.FaBusyChgRecordPo;
import kd.fi.fa.business.busyrecord.utils.BusyChgCommUtils;
import kd.fi.fa.business.utils.FaPeriodUtils;
import kd.fi.fa.business.utils.PeriodUtil;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.common.util.ThrowableHelper;

public class BusyChgRecordUtils {
    private static final Log log = LogFactory.getLog(BusyChgRecordUtils.class);
    private static String selectBusyChgRecordFields = Fa.comma((String[])new String[]{"billid", "billstatus", "billmodifytime", "billauditdate", "isdelete"});

    public static void busyChgRecord4SaveUpdate(String entityName, DynamicObject[] bills) {
        if (bills == null || bills.length == 0) {
            return;
        }
        Collection<FaBusyChgRecordPo> busyChgRecordPoList = BusyChgRecordUtils.bills2List(entityName, bills);
        if (busyChgRecordPoList.size() == 0) {
            return;
        }
        HashSet<Long> billIdSet = new HashSet<Long>(busyChgRecordPoList.size());
        for (FaBusyChgRecordPo busyChgRecordPo : busyChgRecordPoList) {
            billIdSet.add(busyChgRecordPo.getBillId());
        }
        if (billIdSet.size() > 0) {
            QFilter[] delFilters = new QFilter[]{new QFilter("billid", "in", billIdSet), new QFilter("billentityname", "=", (Object)entityName), new QFilter("isdelete", "=", (Object)Boolean.FALSE)};
            DeleteServiceHelper.delete((String)"fa_busy_chg_record", (QFilter[])delFilters);
        }
        ArrayList<DynamicObject> busyChgRecordList = new ArrayList<DynamicObject>(busyChgRecordPoList.size());
        MainEntityType busyChgRecordType = EntityMetadataCache.getDataEntityType((String)"fa_busy_chg_record");
        for (FaBusyChgRecordPo busyChgRecordPo : busyChgRecordPoList) {
            Set<Long> masterIds = busyChgRecordPo.getMasterIds();
            if (masterIds == null || masterIds.size() == 0) continue;
            DynamicObject changeDy = new DynamicObject((DynamicObjectType)busyChgRecordType);
            changeDy.set("billid", (Object)busyChgRecordPo.getBillId());
            changeDy.set("billno", (Object)busyChgRecordPo.getBillNo());
            changeDy.set("billentityname", (Object)busyChgRecordPo.getBillEntityName());
            changeDy.set("billstatus", (Object)busyChgRecordPo.getBillStatus());
            changeDy.set("org", (Object)busyChgRecordPo.getOrgId());
            changeDy.set("depreuse", (Object)busyChgRecordPo.getDepreUseId());
            changeDy.set("period", (Object)busyChgRecordPo.getPeriodId());
            changeDy.set("busydate", (Object)busyChgRecordPo.getBusyDate());
            changeDy.set("billcreatetime", (Object)busyChgRecordPo.getBillCreateTime());
            changeDy.set("billmodifytime", (Object)busyChgRecordPo.getBillModifyTime());
            changeDy.set("billauditdate", (Object)busyChgRecordPo.getBillAuditDate());
            changeDy.set("chtypedetail", (Object)busyChgRecordPo.getChtypedetail());
            for (Long masterId : masterIds) {
                if (masterId == null || masterId == 0L) continue;
                DynamicObjectCollection busyChgRecordEntry = changeDy.getDynamicObjectCollection("entryentity");
                DynamicObject busyChgRecordEntryDy = busyChgRecordEntry.addNew();
                busyChgRecordEntryDy.set("realcardmasterid", (Object)masterId);
            }
            busyChgRecordList.add(changeDy);
        }
        if (busyChgRecordList.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])busyChgRecordList.toArray(new DynamicObject[1]));
        }
    }

    private static Collection<FaBusyChgRecordPo> bills2List(String entityName, DynamicObject[] bills) {
        HashMap<String, DynamicObject> typeIDDate2PeriodMap = new HashMap<String, DynamicObject>(bills.length);
        Map<Map<String, Long>, Long> orgDepreUseId2TypeIdMap = BusyChgCommUtils.getOrgDepreUseId2TypeIdMap(entityName, bills);
        HashMap<String, FaBusyChgRecordPo> faBusyChgRecordPoMap = new HashMap<String, FaBusyChgRecordPo>(bills.length * 3);
        HashMap<Long, DynamicObject> periodCache = new HashMap<Long, DynamicObject>(10);
        for (DynamicObject bill : bills) {
            Long orgId = bill.getLong("org.id");
            Map<Long, Map<Long, Long>> masterId2depreUseId2PeriodIdMap = null;
            if (AbstractBusyRecordServicePlugin.entity2Entry4PeriodchgMap.containsKey(entityName)) {
                masterId2depreUseId2PeriodIdMap = BusyChgCommUtils.getCommMasterId2depreUseId2PeriodId(bill, entityName, orgDepreUseId2TypeIdMap, typeIDDate2PeriodMap);
            }
            if (AbstractBusyRecordServicePlugin.entity2Entry4BusyChgRecordSpecilBillMap.containsKey(entityName)) {
                masterId2depreUseId2PeriodIdMap = BusyChgCommUtils.getSpecialBillMasterId2depreUseId2PeriodId(bill, entityName, orgDepreUseId2TypeIdMap, typeIDDate2PeriodMap);
            }
            if (masterId2depreUseId2PeriodIdMap == null || masterId2depreUseId2PeriodIdMap.size() == 0) continue;
            for (Map.Entry<Long, Map<Long, Long>> entry : masterId2depreUseId2PeriodIdMap.entrySet()) {
                Long masterId = entry.getKey();
                if (masterId == 0L) continue;
                Map<Long, Long> entryValue = entry.getValue();
                for (Map.Entry<Long, Long> depreuseId2periodId : entryValue.entrySet()) {
                    Set<Long> masterIdsSet;
                    String key = bill.getLong("id") + "_" + depreuseId2periodId.getKey();
                    FaBusyChgRecordPo busyChgRecordPo = (FaBusyChgRecordPo)faBusyChgRecordPoMap.get(key);
                    if (busyChgRecordPo == null) {
                        busyChgRecordPo = new FaBusyChgRecordPo();
                        busyChgRecordPo.setBillId(bill.getLong("id"));
                        busyChgRecordPo.setBillNo(bill.getString("billno"));
                        busyChgRecordPo.setBillEntityName(entityName);
                        busyChgRecordPo.setBillStatus(bill.getString("billstatus"));
                        busyChgRecordPo.setOrgId(bill.getLong("org.id"));
                        busyChgRecordPo.setDepreUseId(depreuseId2periodId.getKey());
                        busyChgRecordPo.setPeriodId(depreuseId2periodId.getValue());
                        Date date = null;
                        switch (entityName) {
                            case "fa_change_dept": {
                                date = bill.getDate("changedate");
                                break;
                            }
                            case "fa_clearbill": {
                                date = bill.getDate("cleardate");
                                break;
                            }
                            case "fa_asset_devalue": {
                                date = bill.getDate("businessdate");
                                break;
                            }
                            case "fa_assetsplitbill": {
                                date = bill.getDate("splitdate");
                                break;
                            }
                            case "fa_mergebill": {
                                date = bill.getDate("mergedate");
                                break;
                            }
                            case "fa_depreadjustbill": {
                                long periodId = bill.getLong(Fa.id((String)"period"));
                                DynamicObject periodObj = (DynamicObject)periodCache.get(periodId);
                                if (periodObj == null) {
                                    periodObj = PeriodUtil.getBdPeriod(periodId);
                                    periodCache.put(periodId, periodObj);
                                }
                                date = periodObj.getDate("enddate");
                                break;
                            }
                            case "fa_dispatch": {
                                date = bill.getDate("dispatchdate");
                                break;
                            }
                            case "fa_restartrealbill": {
                                date = bill.getDate("restartdate");
                            }
                        }
                        busyChgRecordPo.setBusyDate(date);
                        busyChgRecordPo.setBillCreateTime(bill.getDate("createtime"));
                        busyChgRecordPo.setBillModifyTime(bill.getDate("modifytime"));
                        busyChgRecordPo.setBillAuditDate(bill.getDate("auditdate"));
                        if (entityName.equals("fa_change_dept")) {
                            busyChgRecordPo.setChtypedetail(bill.getString("chtypedetail"));
                        } else {
                            busyChgRecordPo.setChtypedetail("0");
                        }
                        faBusyChgRecordPoMap.put(key, busyChgRecordPo);
                    }
                    if ((masterIdsSet = busyChgRecordPo.getMasterIds()) == null) {
                        masterIdsSet = new HashSet<Long>(masterId2depreUseId2PeriodIdMap.size());
                        busyChgRecordPo.setMasterIds(masterIdsSet);
                    }
                    masterIdsSet.add(masterId);
                }
            }
        }
        return faBusyChgRecordPoMap.values();
    }

    public static void busyChgRecord4AuditOp(String entityName, DynamicObject[] bills) {
        HashMap<Long, DynamicObject> billIdMap = new HashMap<Long, DynamicObject>(bills.length);
        for (DynamicObject bill : bills) {
            billIdMap.put(bill.getLong("id"), bill);
        }
        QFilter[] filters = new QFilter[]{new QFilter("billid", "in", billIdMap.keySet()), new QFilter("billentityname", "=", (Object)entityName), new QFilter("isdelete", "=", (Object)Boolean.FALSE)};
        DynamicObject[] busyRecordData = BusinessDataServiceHelper.load((String)"fa_busy_chg_record", (String)selectBusyChgRecordFields, (QFilter[])filters);
        if (busyRecordData.length == 0) {
            return;
        }
        for (DynamicObject busyRecord : busyRecordData) {
            DynamicObject bill = (DynamicObject)billIdMap.get(busyRecord.getLong("billid"));
            busyRecord.set("billstatus", (Object)bill.getString("billstatus"));
            busyRecord.set("billmodifytime", (Object)bill.getDate("modifytime"));
            busyRecord.set("billauditdate", (Object)bill.getDate("auditdate"));
        }
        SaveServiceHelper.save((DynamicObject[])busyRecordData);
    }

    public static void busyChgRecord4DeleteOp(String entityName, DynamicObject[] bills) {
        HashMap<Long, DynamicObject> billIdMap = new HashMap<Long, DynamicObject>(bills.length);
        for (DynamicObject bill : bills) {
            billIdMap.put(bill.getLong("id"), bill);
        }
        QFilter[] filters = new QFilter[]{new QFilter("billid", "in", billIdMap.keySet()), new QFilter("billentityname", "=", (Object)entityName), new QFilter("isdelete", "=", (Object)Boolean.FALSE)};
        DynamicObject[] busyRecordData = BusinessDataServiceHelper.load((String)"fa_busy_chg_record", (String)selectBusyChgRecordFields, (QFilter[])filters);
        if (busyRecordData.length == 0) {
            return;
        }
        for (DynamicObject busyRecord : busyRecordData) {
            DynamicObject bill = (DynamicObject)billIdMap.get(busyRecord.getLong("billid"));
            busyRecord.set("billstatus", (Object)bill.getString("billstatus"));
            busyRecord.set("billmodifytime", (Object)new Date());
            busyRecord.set("isdelete", (Object)Boolean.TRUE);
        }
        SaveServiceHelper.save((DynamicObject[])busyRecordData);
    }

    public static void deleteBusyChgRecord(DynamicObject bookObj) {
        try {
            DynamicObject org = bookObj.getDynamicObject("org");
            DynamicObject currentPeriod = bookObj.getDynamicObject("curperiod");
            DynamicObject depreuse = bookObj.getDynamicObject("depreuse");
            Long orgID = (Long)org.getPkValue();
            Long depreuseID = (Long)depreuse.getPkValue();
            Long currentPeriodID = (Long)currentPeriod.getPkValue();
            Long periodtypeId = currentPeriod.getLong("periodtype.id");
            Long deleteStartPeriodId = FaPeriodUtils.getBeforePeriodId(currentPeriodID, periodtypeId, 6);
            if (deleteStartPeriodId == -1L) {
                return;
            }
            QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)orgID), new QFilter("depreuse", "=", (Object)depreuseID), new QFilter("period", "<=", (Object)deleteStartPeriodId), new QFilter("isdelete", "=", (Object)Boolean.TRUE)};
            DeleteServiceHelper.delete((String)"fa_busy_chg_record", (QFilter[])filters);
        }
        catch (Exception e) {
            log.error(ThrowableHelper.toString((Throwable)e));
        }
    }
}

