/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.cardgenerate.impl;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.BillStatus;
import kd.bos.exception.KDBizException;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.fa.business.BizStatusEnum;
import kd.fi.fa.business.cardgenerate.IRealCardGenerate;
import kd.fi.fa.business.dao.factory.FaRealCardDaoFactory;
import kd.fi.fa.business.errorcode.CardGenerateError;

public abstract class AbstractRealCardGenerate
implements IRealCardGenerate {
    protected DynamicObject bill;
    protected List<DynamicObject> realList;

    protected final DynamicObject getNewRealCard() {
        DynamicObject realCard = FaRealCardDaoFactory.getInstance().getEmptyDynamicObject();
        this.setDefaultRealCardInfo(realCard);
        this.realList.add(realCard);
        return realCard;
    }

    protected final DynamicObject copyNewRealCard(DynamicObject outRealCardDy) {
        if (outRealCardDy == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u751f\u6210\u5b9e\u7269\u5361\u7247\u65f6\u51fa\u73b0\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AbstractRealCardGenerate_0", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        DynamicObject newRealCard = (DynamicObject)new CloneUtils(true, true).clone((IDataEntityBase)outRealCardDy);
        newRealCard.set("assetname", (Object)outRealCardDy.getString("assetname"));
        newRealCard.set("masterid", null);
        this.setDefaultRealCardInfo(newRealCard);
        this.realList.add(newRealCard);
        return newRealCard;
    }

    protected void setDefaultRealCardInfo(DynamicObject realCard) {
        Object sourceBillNumber = this.bill.get("billno");
        if (sourceBillNumber == null) {
            throw new KDBizException(CardGenerateError.GET_SRC_BILLNO_ERROR, new Object[0]);
        }
        this.setValToCard(realCard, "srcbillnumber", this.bill.get("billno"));
        this.setValToCard(realCard, "srcbillid", this.bill.getPkValue());
        this.setValToCard(realCard, "srcbillentityname", this.getEntityName());
        this.setValToCard(realCard, "billstatus", BillStatus.A);
        this.setValToCard(realCard, "bizstatus", (Object)BizStatusEnum.ADD);
        this.setValToCard(realCard, "realaccountdate", new Date());
    }

    protected void setValToCard(DynamicObject card, String property, Object value) {
        card.set(property, value);
    }

    protected Object[] saveRealCardList() {
        DynamicObject[] realCards = new DynamicObject[]{};
        OperateOption operate = OperateOption.create();
        operate.setVariableValue("ishasright", String.valueOf(true));
        operate.setVariableValue("importtag_of_datasource", String.valueOf(true));
        OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)"fa_card_real", (DynamicObject[])this.realList.toArray(realCards), (OperateOption)operate);
        if (!result.isSuccess()) {
            List allError = result.getAllErrorOrValidateInfo();
            StringBuilder errorInfo = new StringBuilder();
            if (!CollectionUtils.isEmpty((Collection)allError)) {
                for (IOperateInfo in : allError) {
                    errorInfo.append(in.getMessage());
                }
            }
            String msg = new LocaleString(String.format("%s%s-%s", ResManager.loadKDString((String)"\u751f\u6210\u5b9e\u7269\u5361\u7247\u5931\u8d25\u3002", (String)"AbstractRealCardGenerate_1", (String)"fi-fa-business", (Object[])new Object[0]), result.getMessage(), errorInfo.toString())).toString();
            throw new KDBizException(msg);
        }
        List successPkIds = result.getSuccessPkIds();
        return successPkIds.toArray(new Object[successPkIds.size()]);
    }

    private Object[] getPKs(DynamicObject[] realCards) {
        Object[] pks = new Object[realCards.length];
        for (int idx = 0; idx < realCards.length; ++idx) {
            pks[idx] = realCards[idx].getPkValue();
        }
        return pks;
    }

    @Override
    public final Object[] generateRealCard() {
        this.generate();
        return this.saveRealCardList();
    }

    abstract void generate();

    protected abstract String getEntityName();
}

