/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.cardgenerate.impl;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.validate.BillStatus;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.fa.business.DispatchtypeEnum;
import kd.fi.fa.business.OriginvalueEnum;
import kd.fi.fa.business.cardgenerate.impl.AbstractFinCardGenerate;
import kd.fi.fa.business.constants.FaClearSourceEnum;
import kd.fi.fa.business.utils.SystemParamHelper;
import kd.fi.fa.common.util.Fa;

public class DispatchToFinCardGenerate
extends AbstractFinCardGenerate {
    private static final String[] SELECT_CLEAR_FIELDS = new String[]{"id", "billno", "billstatus", "srcbill", "detail_entry.realcard", "detail_entry.fincard", "detail_entry.addupdepre", "detail_entry.decval", "detail_entry.depredamount", "detail_entry.netamount"};

    @Override
    protected List<DynamicObject> generate(List<DynamicObject> dynamicDispatch, Map<Object, DynamicObject[]> orgAssetbooksMap, MainEntityType finCardType, DynamicObjectType billHeadType, Long realCardTableId, Map<Object, Object> finCardAndrealCard) {
        List<DynamicObject> finCards = this.getFinCardDynamicObject(dynamicDispatch, orgAssetbooksMap, finCardType, billHeadType, realCardTableId, finCardAndrealCard);
        int size = dynamicDispatch.size();
        ArrayList<Object> srdIds = new ArrayList<Object>(size);
        ArrayList<Object> srcbillNumbers = new ArrayList<Object>(size);
        HashMap<Object, Object> realCardAndSrcCard = new HashMap<Object, Object>(size);
        HashMap<Object, Object> realcarAndSourcenumber = new HashMap<Object, Object>(size);
        HashMap<Object, Object> realcarAndSourceId = new HashMap<Object, Object>(size);
        for (DynamicObject realCard : dynamicDispatch) {
            srdIds.add(realCard.get("sourceentryid"));
            srcbillNumbers.add(realCard.get("srcbillnumber"));
            realcarAndSourcenumber.put(realCard.getPkValue(), realCard.get("srcbillnumber"));
            realCardAndSrcCard.put(realCard.getPkValue(), realCard.get("sourceentryid"));
            realcarAndSourceId.put(realCard.getPkValue(), realCard.get("srcbillid"));
        }
        Map<String, Map<Object, Object>> dispatchBills = this.getSrcBill(srcbillNumbers);
        Map<Object, DynamicObject> srcFinCards = this.getSrcFinCards(srdIds);
        Map<Long, DynamicObject> clearBills = this.getClearEntityForDepreData(new ArrayList<Object>(realcarAndSourceId.values()));
        for (DynamicObject finCard : finCards) {
            this.setFinInfo(finCard, finCardAndrealCard, realCardAndSrcCard, srcFinCards, dispatchBills, realcarAndSourcenumber, realcarAndSourceId, clearBills);
        }
        return finCards;
    }

    private void setFinInfo(DynamicObject finCard, Map<Object, Object> finCardAndrealCard, Map<Object, Object> realCardAndSrcCard, Map<Object, DynamicObject> srcFinCards, Map<String, Map<Object, Object>> dispatchBills, Map<Object, Object> realcarAndSourcenumber, Map<Object, Object> realcarAndSourceId, Map<Long, DynamicObject> clearBills) {
        Object realCardId = finCardAndrealCard.get(finCard.get("number") + "" + finCard.get("depreuse_id"));
        Long srcBillId = (Long)realcarAndSourceId.get(realCardId);
        Object srcRealCardId = realCardAndSrcCard.get(realCardId);
        DynamicObject srcFinCard = srcFinCards.get(srcRealCardId + "" + finCard.get("depreuse_id"));
        long baseCurrencyId = 0L;
        Long oriCurrencyId = 0L;
        if (Objects.nonNull(srcFinCard)) {
            baseCurrencyId = srcFinCard.getDynamicObject("basecurrency").getLong("id");
            oriCurrencyId = srcFinCard.getDynamicObject("currency").getLong("id");
        }
        Map currencyObjsMap = BusinessDataServiceHelper.loadFromCache((String)"bd_currency", (String)"id,amtprecision", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)oriCurrencyId), new QFilter("id", "=", (Object)baseCurrencyId)});
        DynamicObjectCollection currencyObjs = new DynamicObjectCollection();
        currencyObjs.addAll(currencyObjsMap.values());
        int oriScale = 0;
        int baseScale = 0;
        Long curId = null;
        Map<Object, Object> numberAndevaluate = dispatchBills.get("numberAndEvaluate");
        Map<Object, Object> idAndDispatchBill = dispatchBills.get("idAndDispatchBill");
        DynamicObject realCard = finCard.getDynamicObject("realcard");
        String realCardNumber = realCard.getString("number");
        for (DynamicObject obj : currencyObjs) {
            curId = obj.getLong("id");
            if (oriCurrencyId.equals(curId)) {
                baseScale = obj.getInt("amtprecision");
            }
            if (!oriCurrencyId.equals(curId)) continue;
            oriScale = obj.getInt("amtprecision");
        }
        if (srcFinCard != null) {
            DynamicObject depresystem;
            BigDecimal currency_rate = new BigDecimal("1");
            BigDecimal nowOriginalAmount = srcFinCard.getBigDecimal("originalamount");
            BigDecimal nowOriginalVal = srcFinCard.getBigDecimal("originalval");
            this.setValToCard(finCard, "originalamount", this.multi(nowOriginalAmount, currency_rate, oriScale));
            this.setValToCard(finCard, "originalval", this.multi(nowOriginalVal, currency_rate, baseScale));
            this.setValToCard(finCard, "incometax", this.multi(srcFinCard.get("incometax"), currency_rate, baseScale));
            DynamicObject clearBill = clearBills.get(srcBillId);
            DynamicObject clearBillEntity = this.getClearEntityForDepreData(clearBill, finCard.getString("number"), (Long)srcRealCardId, (Long)srcFinCard.getPkValue());
            BigDecimal addupdepre = clearBillEntity.getBigDecimal("addupdepre");
            int depredamount = clearBillEntity.getInt("depredamount");
            this.setValToCard(finCard, "accumdepre", clearBillEntity.getBigDecimal("addupdepre"));
            this.setValToCard(finCard, "depredamount", depredamount);
            BigDecimal depreDiffer = addupdepre.subtract(srcFinCard.getBigDecimal("accumdepre"));
            BigDecimal addupyeardepre = srcFinCard.getBigDecimal("addupyeardepre").add(depreDiffer);
            this.setValToCard(finCard, "addupyeardepre", BigDecimal.ZERO);
            this.setValToCard(finCard, "decval", clearBillEntity.getBigDecimal("decval"));
            DynamicObject baseCurrency = finCard.getDynamicObject("basecurrency");
            int amtprecision = 2;
            if (baseCurrency != null) {
                amtprecision = baseCurrency.getInt("amtprecision");
            }
            DynamicObject dispatchBill = (DynamicObject)idAndDispatchBill.get(srcBillId);
            String dispatchtype = "";
            long orgId = 0L;
            long inorgId = 0L;
            DynamicObject currency = null;
            if (dispatchBill != null) {
                DynamicObject org = dispatchBill.getDynamicObject("org");
                DynamicObject inorg = dispatchBill.getDynamicObject("inorg");
                if (org != null) {
                    orgId = org.getLong("id");
                }
                if (inorg != null) {
                    inorgId = inorg.getLong("id");
                }
                dispatchtype = dispatchBill.getString("dispatchtype");
                currency = dispatchBill.getDynamicObject("currency");
            }
            Boolean isCrossOrg = orgId != inorgId;
            String originvalue = SystemParamHelper.getStringParam("originvalue", inorgId, "originvalue");
            DynamicObject assetBook = finCard.getDynamicObject("assetbook");
            long depresystemId = 0L;
            long assetBookId = 0L;
            DynamicObject exchangetable = null;
            if (assetBook != null) {
                assetBookId = assetBook.getLong("id");
                depresystem = assetBook.getDynamicObject("depresystem");
                if (depresystem == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u5bf9\u5e94\u7684\u8d44\u4ea7\u8d26\u7c3f\u4fe1\u606f\u4e2d\u6ca1\u6709\u8d44\u4ea7\u653f\u7b56\u3002", (String)"DispatchToFinCardGenerate_0", (String)"fi-fa-business", (Object[])new Object[0]));
                }
                depresystemId = depresystem.getLong("id");
            } else {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8d22\u52a1\u5361\u7247\uff08\u7f16\u7801\uff1a%s\uff09\u6240\u5c5e\u7684\u8d26\u7c3f\u4fe1\u606f\u4e3a\u7a7a\u3002", (String)"DispatchToFinCardGenerate_1", (String)"fi-fa-business", (Object[])new Object[0]), finCard.getString("number")));
            }
            exchangetable = assetBook.getDynamicObject("exchangetable");
            DynamicObject assetCat = finCard.getDynamicObject("assetcat");
            long assetCatId = 0L;
            if (assetCat == null) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8d22\u52a1\u5361\u7247\u7f16\u7801%s\uff0c\u8d44\u4ea7\u7c7b\u522b\u4e3a\u7a7a\u3002", (String)"DispatchToFinCardGenerate_2", (String)"fi-fa-business", (Object[])new Object[0]), finCard.getString("number")));
            }
            assetCatId = assetCat.getLong("id");
            BigDecimal netresidualvalrate = (BigDecimal)this.netresidualvalrateMap.get(String.format("%s_%s", depresystemId, assetCatId));
            if (netresidualvalrate == null) {
                String cateLongNumber = assetCat.getString("number");
                String depreSystemName = depresystem.getString("name");
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6839\u636e\u8d44\u4ea7\u7c7b\u522b\u201c%1$s\u201d\u5728\u201c%2$s\u201d\u4e0b\u627e\u4e0d\u5230\u6298\u65e7\u653f\u7b56\u3002", (String)"DispatchToFinCardGenerate_3", (String)"fi-fa-business", (Object[])new Object[0]), cateLongNumber, depreSystemName));
            }
            netresidualvalrate = netresidualvalrate.divide(new BigDecimal(100));
            if (isCrossOrg.booleanValue()) {
                if (DispatchtypeEnum.A.name().equals(dispatchtype)) {
                    if (OriginvalueEnum.A.name().equals(originvalue)) {
                        this.setFinCardValueByEquAndOri(srcFinCard, clearBillEntity, finCard, amtprecision, netresidualvalrate);
                    } else if (OriginvalueEnum.B.name().equals(originvalue)) {
                        this.setFinCardValueByEquAndNet(srcFinCard, clearBillEntity, finCard, amtprecision, depredamount, netresidualvalrate);
                    }
                } else if (DispatchtypeEnum.B.name().equals(dispatchtype)) {
                    this.setFinCardValueByNoneequ(srcFinCard, finCard, amtprecision, depredamount, numberAndevaluate, realCardNumber, netresidualvalrate);
                }
            } else {
                this.setFinCardValueBySameOrg(finCard, srcFinCard, clearBillEntity);
            }
            BigDecimal networth = finCard.getBigDecimal("originalval").subtract(finCard.getBigDecimal("accumdepre"));
            BigDecimal netamount = networth.subtract(finCard.getBigDecimal("decval"));
            this.setValToCard(finCard, "networth", networth);
            this.setValToCard(finCard, "netamount", netamount);
            this.setValToCard(finCard, "billstatus", BillStatus.A);
            DynamicObject inBaseCurrency = finCard.getDynamicObject("basecurrency");
            long currencyId = 0L;
            long inBaseCurrencyId = 0L;
            long exchangetableId = 0L;
            BigDecimal exchangeRate = BigDecimal.ONE;
            if (exchangetable != null) {
                exchangetableId = exchangetable.getLong("id");
            }
            if (currency != null) {
                currencyId = currency.getLong("id");
            }
            if (inBaseCurrency != null) {
                inBaseCurrencyId = inBaseCurrency.getLong("id");
            }
            if (currencyId == inBaseCurrencyId) {
                return;
            }
            exchangeRate = (BigDecimal)this.getExchangeRate(exchangetableId, currencyId, inBaseCurrencyId, finCard.getDate("finaccountdate"));
            this.setValToCard(finCard, "currency", currency);
            if (exchangeRate != null) {
                this.setValueByNewCurrency(finCard, exchangeRate, amtprecision);
                this.setValToCard(finCard, "currencyrate", exchangeRate);
            } else {
                this.setValueZeroByNewCurrency(finCard);
            }
        }
    }

    private Object getExchangeRate(Long exchangeTableID, Long sourceCurrencyID, Long targetCurrencyID, Date date) {
        return BaseDataServiceHelper.getExchangeRate((Long)exchangeTableID, (Long)sourceCurrencyID, (Long)targetCurrencyID, (Date)date);
    }

    private void setValueByNewCurrency(DynamicObject finCard, BigDecimal exchangeRate, int amtprecision) {
        this.setValToCard(finCard, "originalamount", finCard.getBigDecimal("originalval"));
        this.setValToCard(finCard, "originalval", this.multi(finCard.getBigDecimal("originalval"), exchangeRate, amtprecision));
        this.setValToCard(finCard, "incometax", this.multi(finCard.getBigDecimal("incometax"), exchangeRate, amtprecision));
        this.setValToCard(finCard, "preresidualval", this.multi(finCard.getBigDecimal("preresidualval"), exchangeRate, amtprecision));
    }

    private void setValueZeroByNewCurrency(DynamicObject finCard) {
        this.setValToCard(finCard, "originalamount", finCard.getBigDecimal("originalval"));
        this.setValToCard(finCard, "originalval", BigDecimal.ZERO);
        this.setValToCard(finCard, "incometax", BigDecimal.ZERO);
        this.setValToCard(finCard, "preresidualval", BigDecimal.ZERO);
    }

    private void setFinCardValueByEquAndOri(DynamicObject srcFinCard, DynamicObject clearBillEntity, DynamicObject finCard, int amtprecision, BigDecimal netresidualvalrate) {
        this.setValToCard(finCard, "originalval", srcFinCard.get("originalval"));
        this.setValToCard(finCard, "incometax", BigDecimal.ZERO);
        this.setValToCard(finCard, "accumdepre", clearBillEntity.getBigDecimal("addupdepre"));
        this.setValToCard(finCard, "preresidualval", this.multi(finCard.get("originalval"), netresidualvalrate, amtprecision));
        this.setValToCard(finCard, "depredamount", clearBillEntity.getInt("depredamount"));
        this.setValToCard(finCard, "decval", clearBillEntity.getBigDecimal("decval"));
    }

    private void setFinCardValueByEquAndNet(DynamicObject srcFinCard, DynamicObject clearBillEntity, DynamicObject finCard, int amtprecision, int depredamount, BigDecimal netresidualvalrate) {
        this.setValToCard(finCard, "originalval", clearBillEntity.getBigDecimal("netamount"));
        this.setValToCard(finCard, "incometax", BigDecimal.ZERO);
        this.setValToCard(finCard, "accumdepre", BigDecimal.ZERO);
        this.setValToCard(finCard, "addupyeardepre", BigDecimal.ZERO);
        this.setValToCard(finCard, "preresidualval", this.multi(finCard.get("originalval"), netresidualvalrate, amtprecision));
        this.setValToCard(finCard, "depredamount", BigDecimal.ZERO);
        this.setValToCard(finCard, "decval", BigDecimal.ZERO);
        this.setValToCard(finCard, "preusingamount", srcFinCard.getInt("preusingamount") - depredamount);
    }

    private void setFinCardValueByNoneequ(DynamicObject srcFinCard, DynamicObject finCard, int amtprecision, int depredamount, Map<Object, Object> numberAndevaluate, String realCardNumber, BigDecimal netresidualvalrate) {
        this.setValToCard(finCard, "originalval", numberAndevaluate.get(realCardNumber));
        this.setValToCard(finCard, "incometax", BigDecimal.ZERO);
        this.setValToCard(finCard, "accumdepre", BigDecimal.ZERO);
        this.setValToCard(finCard, "addupyeardepre", BigDecimal.ZERO);
        this.setValToCard(finCard, "preresidualval", this.multi(finCard.get("originalval"), netresidualvalrate, amtprecision));
        this.setValToCard(finCard, "depredamount", BigDecimal.ZERO);
        this.setValToCard(finCard, "decval", BigDecimal.ZERO);
        this.setValToCard(finCard, "preusingamount", srcFinCard.getInt("preusingamount") - depredamount);
    }

    private void setFinCardValueBySameOrg(DynamicObject finCard, DynamicObject srcFinCard, DynamicObject clearBillEntity) {
        this.setValToCard(finCard, "originalval", srcFinCard.get("originalval"));
        this.setValToCard(finCard, "incometax", srcFinCard.get("incometax"));
        this.setValToCard(finCard, "accumdepre", clearBillEntity.getBigDecimal("addupdepre"));
        this.setValToCard(finCard, "preresidualval", srcFinCard.get("preresidualval"));
        this.setValToCard(finCard, "depredamount", clearBillEntity.getInt("depredamount"));
        this.setValToCard(finCard, "decval", clearBillEntity.getBigDecimal("decval"));
        this.setValToCard(finCard, "preusingamount", srcFinCard.getInt("preusingamount"));
    }

    private Map<String, Map<Object, Object>> getSrcBill(List<Object> sourceBillNumbers) {
        String sic = Fa.join((String)",", (String[])new String[]{"id,billno,dispatchdate,currency,dispatchtype,org,inorg,dispatchentry.realcard,dispatchentry.evaluate"});
        QFilter[] filter = new QFilter("billno", "in", sourceBillNumbers).toArray();
        DynamicObject[] dispatchs = BusinessDataServiceHelper.load((String)"fa_dispatch", (String)sic, (QFilter[])filter);
        HashMap<Object, DynamicObject> idAndDispatchBill = new HashMap<Object, DynamicObject>(8);
        HashMap<String, Object> idAndEvaluate = new HashMap<String, Object>();
        for (DynamicObject doj : dispatchs) {
            idAndDispatchBill.put(doj.get("id"), doj);
            String billnumber = "";
            DynamicObjectCollection entries = doj.getDynamicObjectCollection("dispatchentry");
            for (DynamicObject dynamicObject : entries) {
                DynamicObject realCard = dynamicObject.getDynamicObject("realcard");
                if (realCard != null) {
                    billnumber = realCard.getString("number");
                }
                idAndEvaluate.put(billnumber, dynamicObject.get("evaluate"));
            }
        }
        HashMap<String, Map<Object, Object>> srcMap = new HashMap<String, Map<Object, Object>>();
        srcMap.put("numberAndEvaluate", idAndEvaluate);
        srcMap.put("idAndDispatchBill", idAndDispatchBill);
        return srcMap;
    }

    private Map<Object, DynamicObject> getSrcFinCards(List<Object> srcIds) {
        String sic = Fa.join((String)",", (String[])new String[]{"id", "org", "depreuse_id", "realcard_id", "assetbook_id", "bizperiod", "basecurrency", "currency", "originalval", "originalamount", "originalamount", "puroriginalval", "incometax", "accumdepre", "puraccumdepre", "depredamount", "preusingamount", "preusingamount", "preresidualval", "decval", "networth", "netamount", "addupyeardepre", "monthdepre", "addidepreamount"});
        QFilter filters1 = new QFilter("realcard_id", "in", srcIds);
        QFilter filters3 = new QFilter("endperiod", "=", (Object)99999999999L);
        DynamicObject[] colls = BusinessDataServiceHelper.load((String)"fa_card_fin", (String)sic, (QFilter[])new QFilter[]{filters1, filters3});
        HashMap<Object, DynamicObject> srcFinCards = new HashMap<Object, DynamicObject>(colls.length);
        for (DynamicObject srcFinCard : colls) {
            srcFinCards.put(srcFinCard.get("realcard_id") + "" + srcFinCard.get("depreuse_id"), srcFinCard);
        }
        return srcFinCards;
    }

    private Object multi(Object object, BigDecimal currency_rate, int scale) {
        return this.getBigDecimal(object).multiply(currency_rate).setScale(scale, RoundingMode.HALF_UP);
    }

    private DynamicObject getClearEntityForDepreData(DynamicObject clearBill, String srcAssetNumber, Long realCardId, Long srcFinCardId) {
        String clearBillNo = clearBill.getString("billno");
        DynamicObjectCollection clearEntity = clearBill.getDynamicObjectCollection("detail_entry");
        String clearStatus = clearBill.getString("billstatus");
        if (!clearStatus.equals(BillStatus.C.name())) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8c03\u62e8\u751f\u6210\u7684\u5b9e\u7269\u5361\u7247\uff0c\u9700\u5148\u5ba1\u6838\u8c03\u51fa\u65b9\u7684\u6e05\u7406\u5355\u3010%s\u3011", (String)"DispatchToFinCardGenerate_4", (String)"fi-fa-business", (Object[])new Object[0]), clearBillNo));
        }
        DynamicObject clearEntityFinal = null;
        for (DynamicObject clearBillEntityDo : clearEntity) {
            Long clearEntity_fincardId = clearBillEntityDo.getLong("fincard_id");
            Long clearEntity_realcardId = clearBillEntityDo.getLong("realcard_id");
            if (realCardId.longValue() != clearEntity_realcardId.longValue() || clearEntity_fincardId.longValue() != srcFinCardId.longValue()) continue;
            clearEntityFinal = clearBillEntityDo;
            break;
        }
        if (clearEntityFinal == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5728\u8c03\u51fa\u65b9\u7684\u6e05\u7406\u5355\u201c%1$s\u201d\u4e2d\u672a\u627e\u5230\u5361\u7247\u201c%2$s\u201d\u7684\u7d2f\u8ba1\u6298\u65e7\u4fe1\u606f\u3002", (String)"DispatchToFinCardGenerate_5", (String)"fi-fa-business", (Object[])new Object[0]), clearBillNo, srcAssetNumber));
        }
        return clearEntityFinal;
    }

    private Map<Long, DynamicObject> getClearEntityForDepreData(List<Object> srcIds) {
        QFilter clearSourceBillIdFilter = new QFilter("srcbill", "in", srcIds);
        QFilter clearSourceFilter = new QFilter("clearsource", "=", (Object)FaClearSourceEnum.DISPATCH.name());
        QFilter[] selectClearFilter = new QFilter[]{clearSourceBillIdFilter, clearSourceFilter};
        DynamicObject[] clearBillColl = BusinessDataServiceHelper.load((String)"fa_clearbill", (String)Fa.join((Object[])SELECT_CLEAR_FIELDS, (String)","), (QFilter[])selectClearFilter);
        HashMap<Long, DynamicObject> clearBills = new HashMap<Long, DynamicObject>(clearBillColl.length);
        Arrays.stream(clearBillColl).forEach(clearBill -> clearBills.put(clearBill.getLong("srcbill"), (DynamicObject)clearBill));
        return clearBills;
    }
}

