/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.cardgenerate.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.business.DispatchtypeEnum;
import kd.fi.fa.business.OriginvalueEnum;
import kd.fi.fa.business.SourceFlagEnum;
import kd.fi.fa.business.cardgenerate.impl.AbstractRealCardGenerate;
import kd.fi.fa.business.utils.FaChangeModeConfUtil;
import kd.fi.fa.business.utils.SystemParamHelper;
import kd.fi.fa.common.util.ContextUtil;
import kd.fi.fa.common.util.DateUtil;

public class DispatchToRealCardGenerate
extends AbstractRealCardGenerate {
    public DispatchToRealCardGenerate(Object billId) {
        DynamicObject _bill = this.loadSingle(billId, (DynamicObjectType)this.getDataEntityType());
        this.init(_bill);
    }

    private void init(DynamicObject bill) {
        this.bill = bill;
        this.realList = new ArrayList();
    }

    private DynamicObject loadSingle(Object pk, DynamicObjectType type) {
        return BusinessDataServiceHelper.loadSingle((Object)pk, (DynamicObjectType)type);
    }

    public final MainEntityType getDataEntityType() {
        return EntityMetadataCache.getDataEntityType((String)this.getEntityName());
    }

    @Override
    public void generate() {
        DynamicObject[] outRealCardArr;
        DynamicObject[] outRealCard;
        DynamicObjectCollection dispatchEntry = this.bill.getDynamicObjectCollection("dispatchentry");
        HashMap<Long, DynamicObject> realId2RealDyMap = new HashMap<Long, DynamicObject>(dispatchEntry.size());
        HashSet<Long> outRealCardIdSet = new HashSet<Long>(dispatchEntry.size());
        for (DynamicObject row : dispatchEntry) {
            outRealCard = row.getDynamicObject("realcard");
            Long outRealCardPk = outRealCard.getLong("id");
            outRealCardIdSet.add(outRealCardPk);
        }
        MainEntityType realType = EntityMetadataCache.getDataEntityType((String)"fa_card_real");
        outRealCard = outRealCardArr = BusinessDataServiceHelper.load((Object[])outRealCardIdSet.toArray(), (DynamicObjectType)realType);
        int outRealCardPk = outRealCard.length;
        for (int i = 0; i < outRealCardPk; ++i) {
            DynamicObject outRealCard2;
            DynamicObject realCard = outRealCard2 = outRealCard[i];
            realId2RealDyMap.put(realCard.getLong("id"), realCard);
        }
        HashMap<Long, String> inorgId2OriginvalueParamMap = new HashMap<Long, String>(dispatchEntry.size());
        HashMap<Long, DynamicObject> inorgId2AssetBookMap = new HashMap<Long, DynamicObject>(dispatchEntry.size());
        HashMap<Long, Long> inAssetUnit2ChangeModeMap = new HashMap<Long, Long>(dispatchEntry.size());
        String srcEntityName = "fa_dispatch_in";
        Long srcTableId = EntityMetadataCache.loadTableDefine((String)srcEntityName, (String)srcEntityName).getTableId();
        for (DynamicObject row : dispatchEntry) {
            DynamicObject outRealCard3 = row.getDynamicObject("realcard");
            DynamicObject outRealCardDy = (DynamicObject)realId2RealDyMap.get(outRealCard3.getLong("id"));
            DynamicObject realCard = this.copyNewRealCard(outRealCardDy);
            this.setValToCard(realCard, "mergedcard", false);
            this.setRealInfo(this.bill, row, realCard, outRealCardDy, srcTableId, inorgId2OriginvalueParamMap, inorgId2AssetBookMap, inAssetUnit2ChangeModeMap);
        }
    }

    private void setRealInfo(DynamicObject obj, DynamicObject row, DynamicObject realCard, DynamicObject outRealCardDy, Long srcTableId, Map<Long, String> inorgId2OriginvalueParamMap, Map<Long, DynamicObject> inorgId2AssetBookMap, Map<Long, Long> inAssetUnit2ChangeModeMap) {
        DynamicObject inUseDept;
        DynamicObject assetBook;
        this.setValToCard(realCard, "billno", null);
        this.setValToCard(realCard, "storeplace", null);
        this.setValToCard(realCard, "initialcard", false);
        this.setValToCard(realCard, "modifier", null);
        this.setValToCard(realCard, "modifytime", null);
        this.setValToCard(realCard, "auditor", null);
        this.setValToCard(realCard, "auditdate", null);
        this.setValToCard(realCard, "isbak", false);
        this.setValToCard(realCard, "price", BigDecimal.ZERO);
        this.setValToCard(realCard, "justrealcard", false);
        this.setValToCard(realCard, "sourceflag", SourceFlagEnum.DISPATCH.name());
        this.setValToCard(realCard, "assetcat", outRealCardDy.get("assetcat"));
        this.setValToCard(realCard, "org", obj.get("inorg"));
        this.setValToCard(realCard, "assetunit", obj.get("inassetunit"));
        this.setValToCard(realCard, "number", outRealCardDy.get("number"));
        this.setValToCard(realCard, "assetname", outRealCardDy.get("assetname"));
        this.setValToCard(realCard, "remark", ResManager.loadKDString((String)"\u8d44\u4ea7\u8c03\u5165", (String)"DispatchToRealCardGenerate_0", (String)"fi-fa-business", (Object[])new Object[0]));
        this.setValToCard(realCard, "barcode", outRealCardDy.get("barcode"));
        this.setValToCard(realCard, "model", outRealCardDy.get("model"));
        this.setValToCard(realCard, "assetamount", outRealCardDy.get("assetamount"));
        this.setValToCard(realCard, "unit", outRealCardDy.get("unit"));
        this.setValToCard(realCard, "createtime", new Date());
        this.setValToCard(realCard, "creator", ContextUtil.getUserId());
        this.setValToCard(realCard, "creator_id", ContextUtil.getUserId());
        this.setValToCard(realCard, "realaccountdate", outRealCardDy.getDate("realaccountdate"));
        Long orgId = 0L;
        Long inorgId = 0L;
        String dispatchtype = "";
        if (obj != null) {
            DynamicObject org = obj.getDynamicObject("org");
            DynamicObject inorg = obj.getDynamicObject("inorg");
            if (org != null) {
                orgId = org.getLong("id");
            }
            if (inorg != null) {
                inorgId = inorg.getLong("id");
            }
            dispatchtype = obj.getString("dispatchtype");
        }
        Boolean isCrossOrg = orgId.longValue() != inorgId.longValue();
        String originvalue = inorgId2OriginvalueParamMap.get(inorgId);
        if (originvalue == null) {
            originvalue = SystemParamHelper.getStringParam("originvalue", inorgId, "originvalue");
            inorgId2OriginvalueParamMap.put(inorgId, originvalue);
        }
        if ((assetBook = inorgId2AssetBookMap.get(inorgId)) == null) {
            QFilter orgFilter = new QFilter("org", "=", (Object)inorgId);
            QFilter mainFilter = new QFilter("ismainbook", "=", (Object)true);
            String selectfields = "id,periodtype,curperiod.beginDate begindate,curperiod.enddate enddate";
            assetBook = QueryServiceHelper.queryOne((String)"fa_assetbook", (String)selectfields, (QFilter[])new QFilter[]{orgFilter, mainFilter});
            inorgId2AssetBookMap.put(inorgId, assetBook);
        }
        if (isCrossOrg.booleanValue()) {
            if (DispatchtypeEnum.A.name().equals(dispatchtype) && OriginvalueEnum.B.name().equals(originvalue)) {
                this.setValToCard(realCard, "realaccountdate", this.getRealaccountdate(assetBook));
            } else if (DispatchtypeEnum.B.name().equals(dispatchtype)) {
                this.setValToCard(realCard, "realaccountdate", this.getRealaccountdate(assetBook));
            }
        }
        this.setValToCard(realCard, "storeplace", row.getDynamicObject("instoreplace"));
        this.setValToCard(realCard, "headusedept", row.getDynamicObject("inusedept"));
        this.setValToCard(realCard, "costcentrer", row.getDynamicObject("incostcentrer"));
        this.setValToCard(realCard, "usedate", outRealCardDy.getDate("usedate"));
        this.setValToCard(realCard, "usestatus", outRealCardDy.get("usestatus"));
        this.setValToCard(realCard, "supplier", outRealCardDy.get("supplier"));
        this.setValToCard(realCard, "sourceentryid", outRealCardDy.getPkValue());
        DynamicObject inAssetUnit = (DynamicObject)obj.get("inassetunit");
        Long inAssetUnitId = inAssetUnit.getLong("id");
        Long changeModeDefaultValue = inAssetUnit2ChangeModeMap.get(inAssetUnitId);
        if (changeModeDefaultValue == null) {
            changeModeDefaultValue = FaChangeModeConfUtil.getChangeModeDefaultValue(inAssetUnitId, "fa_dispatch_in", "fa_card_real");
            inAssetUnit2ChangeModeMap.put(inAssetUnitId, changeModeDefaultValue);
        }
        this.setValToCard(realCard, "originmethod_id", changeModeDefaultValue);
        DynamicObject originmethodId = row.getDynamicObject("originmethod");
        if (originmethodId != null) {
            this.setValToCard(realCard, "originmethod", originmethodId);
        }
        if ((inUseDept = row.getDynamicObject("inusedept")) != null) {
            this.setValToCard(realCard, "headusedept", inUseDept);
        } else {
            this.setValToCard(realCard, "headusedept", null);
        }
        DynamicObject inUseStatus = row.getDynamicObject("inusestatus");
        if (inUseStatus != null) {
            this.setValToCard(realCard, "usestatus", inUseStatus);
        }
        DynamicObjectCollection billHeads = realCard.getDynamicObjectCollection("billhead_lk");
        billHeads.clear();
        DynamicObject billHead = billHeads.addNew();
        billHead.set("seq", (Object)1);
        billHead.set("billhead_lk_stableid", (Object)srcTableId);
        billHead.set("billhead_lk_sbillid", (Object)obj.getLong("id"));
        billHead.set("billhead_lk_sid", (Object)obj.getLong("id"));
    }

    @Override
    protected String getEntityName() {
        return "fa_dispatch_in";
    }

    private Date getRealaccountdate(DynamicObject assetBook) {
        Date date = new Date();
        if (assetBook == null || assetBook.getDate("enddate") == null || assetBook.getDate("begindate") == null) {
            return date;
        }
        Date enddate = assetBook.getDate("enddate");
        Date begindate = assetBook.getDate("begindate");
        if (date.before(begindate)) {
            date = begindate;
        } else if (date.after(enddate)) {
            date = enddate;
        }
        return DateUtil.stripTime((Date)date);
    }
}

