/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.cardgenerate.impl;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.fa.business.calc.DynamicObjectWrapper;
import kd.fi.fa.business.calc.FinCardCalc;
import kd.fi.fa.business.cardgenerate.impl.AbstractFinCardGenerate;
import kd.fi.fa.business.utils.FaCommonUtils;
import kd.fi.fa.business.utils.FaUtils;
import kd.fi.fa.common.util.Fa;

public class PurchaseToFinCardGenerate
extends AbstractFinCardGenerate {
    private static final Log log = LogFactory.getLog(PurchaseToFinCardGenerate.class);
    private static final String BUILDWAY_ONE = "1";
    private static final String BUILDWAY_TWO = "2";
    private static final String BUILDWAY_THREE = "3";

    @Override
    protected List<DynamicObject> generate(List<DynamicObject> realCardPurchases, Map<Object, DynamicObject[]> orgAssetbooksMap, MainEntityType finCardType, DynamicObjectType billHeadType, Long realCardTableId, Map<Object, Object> finCardAndrealCard) {
        List<DynamicObject> finCards = this.getFinCardDynamicObject(realCardPurchases, orgAssetbooksMap, finCardType, billHeadType, realCardTableId, finCardAndrealCard);
        int size = realCardPurchases.size();
        ArrayList<Object> sourceEntryIds = new ArrayList<Object>(size);
        HashMap<Object, Object> realCardAndPurchase = new HashMap<Object, Object>(size);
        HashMap<Object, Object> realCardAndEntries = new HashMap<Object, Object>(size);
        HashMap<Object, Integer> realCardSourceentrysplitseq = new HashMap<Object, Integer>(size);
        HashMap<String, DynamicObjectCollection> assetentriesMap = new HashMap<String, DynamicObjectCollection>();
        for (DynamicObject realCard : realCardPurchases) {
            sourceEntryIds.add(realCard.get("sourceentryid"));
            realCardAndPurchase.put(realCard.getPkValue(), realCard.get("srcbillnumber"));
            realCardAndEntries.put(realCard.getPkValue(), realCard.get("sourceentryid"));
            realCardSourceentrysplitseq.put(realCard.getPkValue(), realCard.getInt("sourceentrysplitseq"));
        }
        HashMap<String, Object> purchaseBill = new HashMap<String, Object>();
        HashMap<String, DynamicObject> currencyMap = new HashMap<String, DynamicObject>();
        HashMap<String, BigDecimal> exrateMap = new HashMap<String, BigDecimal>();
        HashMap<String, Date> purchasedateMap = new HashMap<String, Date>();
        Map<Object, DynamicObject> purchaseEntity = this.getPurchaseEntity(sourceEntryIds, "fa_purchasebill", assetentriesMap, purchaseBill, currencyMap, exrateMap, purchasedateMap);
        HashSet<Object> realCardIds = new HashSet<Object>(FaUtils.getInitialCapacity43(finCards.size()));
        for (DynamicObject finCard : finCards) {
            Object realCardId = finCardAndrealCard.get(finCard.get("number") + "" + finCard.get("depreuse_id"));
            Object sourceBillNumber = realCardAndPurchase.get(realCardId);
            Object buildway = purchaseBill.get(sourceBillNumber);
            DynamicObject currency = (DynamicObject)currencyMap.get(sourceBillNumber);
            BigDecimal exrate = (BigDecimal)exrateMap.get(sourceBillNumber);
            Date purchaseDate = (Date)purchasedateMap.get(sourceBillNumber);
            DynamicObject assetInfo = purchaseEntity.get(realCardAndEntries.get(realCardId));
            if (assetInfo == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u91c7\u8d2d\u8f6c\u56fa\u8d44\u4ea7\u4fe1\u606f\uff0c\u8bf7\u786e\u8ba4\u91c7\u8d2d\u8f6c\u56fa-\u5b9e\u7269\u5361\u7247BOTP\u7684\u201c\u6765\u6e90\u5206\u5f55\u201d\u5b57\u6bb5\u914d\u7f6e\u662f\u5426\u6b63\u786e", (String)"PurchaseToFinCardGenerate_0", (String)"fi-fa-business", (Object[])new Object[0]));
            }
            DynamicObjectCollection assetentry = (DynamicObjectCollection)assetentriesMap.get(realCardAndPurchase.get(realCardId));
            boolean isdeductiontax = assetInfo.getBoolean("isdeductiontax");
            int assetqty = Double.valueOf(assetInfo.get("assetqty").toString()).intValue();
            if (BUILDWAY_ONE.equals(buildway)) {
                this.splitByEntriesInfo(finCard, assetInfo, isdeductiontax, assetqty, currency, exrate, purchaseDate);
                continue;
            }
            if (BUILDWAY_TWO.equals(buildway)) {
                this.splitByCount(finCard, assetInfo, (Integer)realCardSourceentrysplitseq.get(realCardId), isdeductiontax, assetqty, currency, exrate, purchaseDate);
                continue;
            }
            if (BUILDWAY_THREE.equals(buildway)) {
                boolean isNotExists = realCardIds.add(realCardId);
                this.splitByBill(finCard, assetentry, 1, currency, exrate, purchaseDate, isNotExists);
                continue;
            }
            throw new KDBizException(new ErrorCode("UNKNOWN_ERR", ResManager.loadKDString((String)"\u5efa\u5361\u65b9\u5f0f\u4e0d\u5b58\u5728\u3002", (String)"PurchaseToFinCardGenerate_1", (String)"fi-fa-business", (Object[])new Object[0])), new Object[0]);
        }
        return finCards;
    }

    private Map<Object, DynamicObject> getPurchaseEntity(List<Object> sourceEntryIds, String entityName, Map<String, DynamicObjectCollection> assetentries, Map<String, Object> purchaseBill, Map<String, DynamicObject> currencyMap, Map<String, BigDecimal> exrateMap, Map<String, Date> purchasedateMap) {
        QFilter[] filter = new QFilter("assetsentry", "in", sourceEntryIds).toArray();
        Map purchases = BusinessDataServiceHelper.loadFromCache((String)entityName, (QFilter[])filter);
        HashMap<Object, DynamicObject> srcBills = new HashMap<Object, DynamicObject>();
        for (Map.Entry entry : purchases.entrySet()) {
            String billno = ((DynamicObject)entry.getValue()).get("billno").toString();
            DynamicObjectCollection entries = ((DynamicObject)entry.getValue()).getDynamicObjectCollection("assetsentry");
            assetentries.put(billno, entries);
            purchaseBill.put(billno, ((DynamicObject)entry.getValue()).get("buildway"));
            DynamicObject purchasecurrency = ((DynamicObject)entry.getValue()).getDynamicObject("purchasecurrency");
            BigDecimal exrate = ((DynamicObject)entry.getValue()).getBigDecimal("exchangerate");
            currencyMap.put(billno, purchasecurrency);
            exrateMap.put(billno, exrate);
            Date purchaseDate = ((DynamicObject)entry.getValue()).getDate("purchasedate");
            purchasedateMap.put(billno, purchaseDate);
            for (DynamicObject entryE : entries) {
                srcBills.put(entryE.getPkValue(), entryE);
            }
        }
        return srcBills;
    }

    private void splitByBill(DynamicObject finCard, DynamicObjectCollection assetentry, int assetqty, DynamicObject currency, BigDecimal exrate, Date purchaseDate, boolean isNotExists) {
        if (isNotExists) {
            this.sumAmountByAllEntries(assetentry);
        }
        DynamicObject assetInfo = (DynamicObject)assetentry.get(0);
        this.setFinInfo(assetInfo, finCard, true, assetqty, currency, exrate, purchaseDate);
    }

    private void splitByCount(DynamicObject finCard, DynamicObject assetInfo, int sourceentrysplitseq, boolean isDeductionTax, int assetqty, DynamicObject currency, BigDecimal exrate, Date purchaseDate) {
        DynamicObject curCurrency = finCard.getDynamicObject("basecurrency");
        BigDecimal[] lastDiff = this.splitAmountByQty(assetInfo, assetqty, isDeductionTax, curCurrency, currency);
        if (sourceentrysplitseq == assetqty) {
            this.setFinInfoByLastDiff(lastDiff, finCard, 1, currency, exrate, purchaseDate, isDeductionTax);
        } else {
            this.setFinInfo(assetInfo, finCard, isDeductionTax, assetqty, currency, exrate, purchaseDate);
        }
    }

    private void splitByEntriesInfo(DynamicObject finCard, DynamicObject assetInfo, boolean isDeductionTax, int assetqty, DynamicObject currency, BigDecimal exrate, Date purchaseDate) {
        this.setFinInfo(assetInfo, finCard, isDeductionTax, 1, currency, exrate, purchaseDate);
    }

    private void setFinInfo(DynamicObject assetInfo, DynamicObject finCard, boolean isDeductionTax, Object assetqty, DynamicObject currency, BigDecimal exrate, Date purchaseDate) {
        Object originalamount;
        Object originalval;
        Object taxamount = assetInfo.get("taxamount");
        if (isDeductionTax) {
            originalval = assetInfo.get("notaxamount");
            originalamount = assetInfo.get("originnotaxamount");
        } else {
            originalval = assetInfo.get("totalamount");
            originalamount = assetInfo.get("origintotalamount");
        }
        this.setFinCardInfo(finCard, originalval, originalamount, taxamount, assetqty, currency, exrate, purchaseDate, isDeductionTax);
    }

    private void setFinInfoByLastDiff(BigDecimal[] lastDiff, DynamicObject finCard, int assetqty, DynamicObject currency, BigDecimal exrate, Date purchaseDate, Boolean isDeductionTax) {
        BigDecimal originalval = lastDiff[0];
        BigDecimal originalamount = lastDiff[1];
        BigDecimal taxamount = lastDiff[2];
        this.setFinCardInfo(finCard, originalval, originalamount, taxamount, assetqty, currency, exrate, purchaseDate, isDeductionTax);
    }

    private void setFinCardInfo(DynamicObject finCard, Object originalval, Object originalamount, Object taxamount, Object assetQty, DynamicObject currency, BigDecimal curExrate, Date purchaseDate, Boolean isDeductionTax) {
        int amt = 2;
        if (currency == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u91c7\u8d2d\u5e01\u522b", (String)"PurchaseToFinCardGenerate_2", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        amt = currency.getInt("amtprecision");
        DynamicObject org = finCard.getDynamicObject("org");
        Long orgId = 0L;
        if (org != null) {
            orgId = org.getLong("id");
        }
        long depreuseId = 0L;
        DynamicObject depreuse = finCard.getDynamicObject("depreuse");
        if (depreuse != null) {
            depreuseId = depreuse.getLong("id");
        }
        DynamicObjectCollection assetBooks = PurchaseToFinCardGenerate.getAssetBooksByOrg(orgId);
        DynamicObject mainAssetBook = null;
        DynamicObject assetBook = null;
        if (assetBooks != null) {
            for (DynamicObject dynamicObject : assetBooks) {
                long curDepreuseId;
                if (dynamicObject.getBoolean("ismainbook")) {
                    mainAssetBook = dynamicObject;
                }
                if ((curDepreuseId = dynamicObject.getLong(Fa.dot((String[])new String[]{"depreuse", "id"}))) != depreuseId) continue;
                assetBook = dynamicObject;
            }
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u6838\u7b97\u7ec4\u7ec7\u6ca1\u6709\u8d44\u4ea7\u8d26\u7c3f", (String)"PurchaseToFinCardGenerate_3", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        int amtprecision = 2;
        long mainDepreuseId = 0L;
        long mainBasecurrencyId = 0L;
        long exchangetableId = 0L;
        long curCurrencyId = 0L;
        long currencyId = 0L;
        if (mainAssetBook != null) {
            mainDepreuseId = mainAssetBook.getLong(Fa.dot((String[])new String[]{"depreuse", "id"}));
            mainBasecurrencyId = mainAssetBook.getLong(Fa.dot((String[])new String[]{"basecurrency", "id"}));
        }
        if (assetBook != null) {
            exchangetableId = assetBook.getLong(Fa.dot((String[])new String[]{"exchangetable", "id"}));
            curCurrencyId = assetBook.getLong(Fa.dot((String[])new String[]{"basecurrency", "id"}));
            int asssetAmt = assetBook.getInt(Fa.dot((String[])new String[]{"basecurrency", "amtprecision"}));
            if (asssetAmt != 0) {
                amtprecision = asssetAmt;
            }
        }
        if (currency != null) {
            currencyId = currency.getLong("id");
        }
        BigDecimal spiltOriginalval = this.splitAmount(originalval, (Integer)assetQty, amtprecision);
        BigDecimal spiltOriginalamount = this.splitAmount(originalamount, (Integer)assetQty, amt);
        BigDecimal spiltTaxamount = this.splitAmount(taxamount, (Integer)assetQty, amtprecision);
        if (!isDeductionTax.booleanValue()) {
            spiltTaxamount = BigDecimal.ZERO;
        }
        if (depreuseId != mainDepreuseId) {
            BigDecimal exrate = BigDecimal.ONE;
            if (mainBasecurrencyId != curCurrencyId) {
                exrate = this.setCurrencyRateByAssetBook(mainBasecurrencyId, curCurrencyId, exchangetableId, purchaseDate);
            }
            if (currencyId == curCurrencyId) {
                this.setValToCard(finCard, "originalval", this.multi(spiltOriginalval, exrate, amtprecision));
                this.setValToCard(finCard, "incometax", this.multi(spiltTaxamount, exrate, amtprecision));
            } else {
                this.setValToCard(finCard, "currency", currency);
                this.setValToCard(finCard, "originalval", this.multi(spiltOriginalval, exrate, amtprecision));
                this.setValToCard(finCard, "originalamount", spiltOriginalamount);
                this.setValToCard(finCard, "currencyrate", this.setCurrencyRateByAssetBook(currencyId, curCurrencyId, exchangetableId, purchaseDate));
                this.setValToCard(finCard, "incometax", this.multi(spiltTaxamount, exrate, amtprecision));
            }
        } else if (currencyId == mainBasecurrencyId) {
            this.setValToCard(finCard, "originalval", spiltOriginalval);
            this.setValToCard(finCard, "incometax", spiltTaxamount);
        } else {
            this.setValToCard(finCard, "currency", currency);
            this.setValToCard(finCard, "originalval", spiltOriginalval);
            this.setValToCard(finCard, "incometax", spiltTaxamount);
            this.setValToCard(finCard, "originalamount", spiltOriginalamount);
            this.setValToCard(finCard, "currencyrate", curExrate);
        }
        DynamicObjectWrapper objWrapper = new DynamicObjectWrapper(finCard);
        this.setValToCard(finCard, "networth", FinCardCalc.setNetWorth(objWrapper));
        this.setValToCard(finCard, "netamount", FinCardCalc.setNetAmount(objWrapper));
        this.setValToCard(finCard, "preresidualval", FinCardCalc.setPreResidualVal(objWrapper, false, currency));
        DynamicObject basecurrency = finCard.getDynamicObject("basecurrency");
        BigDecimal preresidualval = FinCardCalc.setPreResidualVal(objWrapper, false, basecurrency);
        this.setValToCard(finCard, "preresidualval", preresidualval);
    }

    private static DynamicObjectCollection getAssetBooksByOrg(Object orgId) {
        String selectfields = "id,depreuse,org,ismainbook,basecurrency,basecurrency.amtprecision,periodtype,depresystem,curperiod,exchangetable";
        QFilter filter = new QFilter("org", "=", orgId);
        Map assetBooksMap = BusinessDataServiceHelper.loadFromCache((String)"fa_assetbook", (String)selectfields, (QFilter[])new QFilter[]{filter});
        DynamicObjectCollection assetBooks = new DynamicObjectCollection();
        assetBooks.addAll(assetBooksMap.values());
        return assetBooks;
    }

    private BigDecimal setCurrencyRateByAssetBook(Long oriBasecurrencyId, Long curBasecurrencyId, Long exchangetableId, Date purchaseDate) {
        BigDecimal exrate = BigDecimal.ZERO;
        QFilter oriFilter = new QFilter("orgcur", "=", (Object)oriBasecurrencyId);
        QFilter curFilter = new QFilter("cur", "=", (Object)curBasecurrencyId);
        QFilter exchangetableFilter = new QFilter("exctable", "=", (Object)exchangetableId);
        QFilter dateFilter = new QFilter("effectdate", "<=", (Object)purchaseDate);
        String selectFields = "orgcur,cur,excval,exctable";
        Map exratedyosMap = BusinessDataServiceHelper.loadFromCache((String)"bd_exrate_tree", (String)selectFields, (QFilter[])new QFilter[]{oriFilter, curFilter, exchangetableFilter, dateFilter}, (String)"effectdate desc");
        DynamicObjectCollection exratedyos = new DynamicObjectCollection();
        exratedyos.addAll(exratedyosMap.values());
        if (exratedyos.size() > 0) {
            exrate = ((DynamicObject)exratedyos.get(0)).getBigDecimal("excval");
        }
        return exrate;
    }

    private BigDecimal[] splitAmountByQty(DynamicObject assetInfo, int assetqty, boolean isDeductionTax, DynamicObject basecurrency, DynamicObject currency) {
        Object originalAmount;
        Object originalVal;
        int amt = 2;
        if (basecurrency == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8d22\u52a1\u5361\u7247\u6ca1\u6709\u672c\u4f4d\u5e01", (String)"PurchaseToFinCardGenerate_4", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        amt = basecurrency.getInt("amtprecision");
        int originAmt = 2;
        if (currency == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u91c7\u8d2d\u5e01\u522b", (String)"PurchaseToFinCardGenerate_2", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        originAmt = currency.getInt("amtprecision");
        Object taxamount = assetInfo.get("taxamount");
        if (isDeductionTax) {
            originalVal = assetInfo.get("notaxamount");
            originalAmount = assetInfo.get("originnotaxamount");
        } else {
            originalVal = assetInfo.get("totalamount");
            originalAmount = assetInfo.get("origintotalamount");
        }
        BigDecimal splitOriginVal = this.splitAmount(originalVal, assetqty, amt);
        BigDecimal splitOriginalAmount = this.splitAmount(originalAmount, assetqty, originAmt);
        BigDecimal splitTaxamount = this.splitAmount(taxamount, assetqty, amt);
        BigDecimal lastDiffOriginVal = this.getLastDiff(originalVal, splitOriginVal, assetqty);
        BigDecimal lastDiffOriginalAmount = this.getLastDiff(originalAmount, splitOriginalAmount, assetqty);
        BigDecimal lastDiffTaxamount = this.getLastDiff(taxamount, splitTaxamount, assetqty);
        BigDecimal[] lastDiff = new BigDecimal[]{lastDiffOriginVal, lastDiffOriginalAmount, lastDiffTaxamount};
        return lastDiff;
    }

    private BigDecimal getLastDiff(Object total, BigDecimal amount, int assetqty) {
        BigDecimal lastDiff = null;
        lastDiff = assetqty > 1 ? this.getBigDecimal(total).subtract(amount.multiply(this.getBigDecimal(assetqty - 1))) : this.getBigDecimal(total);
        return lastDiff;
    }

    private BigDecimal splitAmount(Object amount, int qty, int scale) {
        BigDecimal totalAmt = FaCommonUtils.getBigDecimal(amount);
        if (totalAmt.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        BigDecimal totalQty = FaCommonUtils.getBigDecimal(qty);
        if (BigDecimal.ZERO.equals(totalQty)) {
            throw new KDBizException(new ErrorCode("UNKNOWN_ERR", String.format(ResManager.loadKDString((String)"\u9664\u6570\u4e0d\u80fd\u4e3a0\uff1a(%1$s\u00f7%2$s)\u3002", (String)"PurchaseToFinCardGenerate_5", (String)"fi-fa-business", (Object[])new Object[0]), totalAmt, totalQty)), new Object[0]);
        }
        BigDecimal halfUpAvg = totalAmt.divide(totalQty, scale, RoundingMode.HALF_UP);
        BigDecimal halfUpTotalAmt = halfUpAvg.multiply(totalQty);
        if (halfUpTotalAmt.compareTo(totalAmt) <= 0) {
            return halfUpAvg;
        }
        BigDecimal downAvg = totalAmt.divide(totalQty, scale, RoundingMode.DOWN);
        return downAvg;
    }

    private BigDecimal add(BigDecimal total, Object obj) {
        return total.add(this.getBigDecimal(obj));
    }

    private void sumAmountByAllEntries(DynamicObjectCollection assetentry) {
        BigDecimal totalTax = BigDecimal.ZERO;
        BigDecimal totalTotalAmount = BigDecimal.ZERO;
        for (DynamicObject assetInfo : assetentry) {
            Object notaxamount = assetInfo.get("notaxamount");
            Object taxamount = assetInfo.get("taxamount");
            Object totalamount = assetInfo.get("totalamount");
            boolean isDeductionTax = assetInfo.getBoolean("isdeductiontax");
            if (isDeductionTax) {
                totalTotalAmount = this.add(totalTotalAmount, notaxamount);
                totalTax = this.add(totalTax, taxamount);
                continue;
            }
            totalTotalAmount = this.add(totalTotalAmount, totalamount);
        }
        DynamicObject assetInfo = (DynamicObject)assetentry.get(0);
        assetInfo.set("notaxamount", (Object)totalTotalAmount);
        assetInfo.set("taxamount", (Object)totalTax);
    }

    private BigDecimal multi(BigDecimal bigDecimal1, BigDecimal bigDecimal2, int scale) {
        return bigDecimal1.multiply(bigDecimal2).setScale(scale, RoundingMode.HALF_UP);
    }
}

