/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.clear;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.business.DispatchtypeEnum;
import kd.fi.fa.business.clear.ClearBillHDGenerator;
import kd.fi.fa.business.clear.convertor.ApplyClearBill2ClearBillConvertor;
import kd.fi.fa.business.clear.convertor.DispatchBill2ClearBillConvertor;
import kd.fi.fa.business.clear.convertor.LeaseContract2ClearBillConvertor;
import kd.fi.fa.business.constants.FaClearSourceEnum;
import kd.fi.fa.business.dao.factory.FaBaseDaoFactory;
import kd.fi.fa.business.depretask.DailyDepreImpl;
import kd.fi.fa.business.enums.ClearMethodAccumDepre;
import kd.fi.fa.business.utils.CompFieldsValuesUtils;
import kd.fi.fa.business.utils.FaConstants;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.common.util.FaCurrencyUtil;

public class ClearBillGenerateFacade {
    private static final Log log = LogFactory.getLog(ClearBillGenerateFacade.class);
    static String selectFinPreFields = Fa.comma((String[])new String[]{"number", "monthdepre", "accumdepre", "depredamount", "bizperiod"});
    static String selectBookFields = Fa.comma((String[])new String[]{"depreuse", "periodtype"});
    private static final List<String> SPLIT_MERGE_FLAG = Arrays.asList(FaClearSourceEnum.MERGE.name(), FaClearSourceEnum.SPLIT.name());

    public void generateClearBillByApply(Object billPK) {
        ClearBillHDGenerator generator = new ClearBillHDGenerator(new ApplyClearBill2ClearBillConvertor());
        generator.generate(billPK, "fa_clearapplybill");
    }

    public void generateClearBillByDispt(Object billPK) {
        ClearBillHDGenerator generator = new ClearBillHDGenerator(new DispatchBill2ClearBillConvertor());
        generator.generate(billPK, "fa_dispatch");
    }

    public void generateClearBillByLease(long billPk, long changeModeId, Date leaseTerminationDate) {
        LeaseContract2ClearBillConvertor convertor = new LeaseContract2ClearBillConvertor(changeModeId, leaseTerminationDate);
        ClearBillHDGenerator generator = new ClearBillHDGenerator(convertor);
        generator.generate(billPk, "fa_lease_contract");
    }

    public Map<String, String> resetBeforeSave(DynamicObject clearBillDy, boolean needLog) {
        DynamicObjectCollection clearEntries = clearBillDy.getDynamicObjectCollection("detail_entry");
        List finCards = clearEntries.stream().map(v -> v.getDynamicObject("fincard")).collect(Collectors.toList());
        String clearSource = clearBillDy.getString("clearsource");
        HashMap<String, BigDecimal[]> preDepreResult = new HashMap<String, BigDecimal[]>(16);
        Map<Long, List<DynamicObject>> grp = finCards.stream().collect(Collectors.groupingBy(v -> v.getLong("assetbook_id")));
        Set<Map.Entry<Long, List<DynamicObject>>> entrySet = grp.entrySet();
        HashMap<String, String> logMap = new HashMap<String, String>(entrySet.size(), 1.0f);
        HashMap<Long, Long> depreuseId2PeroidTypeId = new HashMap<Long, Long>(3, 1.0f);
        QFilter[] bookFilters = new QFilter[]{new QFilter("org", "=", (Object)clearBillDy.getLong("org.id"))};
        DynamicObjectCollection books = QueryServiceHelper.query((String)"fa_assetbook", (String)selectBookFields, (QFilter[])bookFilters);
        for (DynamicObject book : books) {
            depreuseId2PeroidTypeId.put(book.getLong("depreuse"), book.getLong("periodtype"));
        }
        HashMap<Long, DynamicObject> periodId2Period = new HashMap<Long, DynamicObject>(16);
        HashMap<String, HashSet<DynamicObject>> depreUseIdPeriodid2ClearEntry = new HashMap<String, HashSet<DynamicObject>>(16);
        for (DynamicObject clearEntry : clearEntries) {
            String depreUseIdPeriodid;
            HashSet<DynamicObject> clearEntrySet;
            DynamicObject finCard = clearEntry.getDynamicObject("fincard");
            Long l = finCard.getLong("depreuse.id");
            Date bizdate = clearEntry.getDate("bizdate");
            Long typeId = (Long)depreuseId2PeroidTypeId.get(l);
            DynamicObject periodDy = null;
            for (DynamicObject period : periodId2Period.values()) {
                if (period.getDate("begindate").compareTo(bizdate) > 0 || bizdate.compareTo(period.getDate("enddate")) > 0) continue;
                periodDy = period;
            }
            if (periodDy == null) {
                QFilter[] periodFilters = new QFilter[]{new QFilter("periodtype", "=", (Object)typeId), new QFilter("isadjustperiod", "=", (Object)"0"), new QFilter("begindate", "<=", (Object)bizdate), new QFilter("enddate", ">=", (Object)bizdate)};
                Map periodDyMap = BusinessDataServiceHelper.loadFromCache((String)"bd_period", (QFilter[])periodFilters);
                if (periodDyMap == null || periodDyMap.size() <= 0) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u65e5\u671f\u201c%s\u201d\u83b7\u53d6\u4f1a\u8ba1\u671f\u95f4\u4e3a\u7a7a\u3002", (String)"ClearBillGenerateFacade_0", (String)"fi-fa-business", (Object[])new Object[0]), bizdate));
                }
                Collection periodDyMapValues = periodDyMap.values();
                DynamicObject[] periodDyMapArray = periodDyMapValues.toArray(new DynamicObject[1]);
                periodDy = periodDyMapArray[0];
                periodId2Period.put(periodDy.getLong("id"), periodDy);
            }
            if ((clearEntrySet = (HashSet<DynamicObject>)depreUseIdPeriodid2ClearEntry.get(depreUseIdPeriodid = l + "_" + periodDy.getLong("id"))) == null) {
                clearEntrySet = new HashSet<DynamicObject>(256);
                depreUseIdPeriodid2ClearEntry.put(depreUseIdPeriodid, clearEntrySet);
            }
            clearEntrySet.add(clearEntry);
        }
        HashMap<String, DynamicObject> fromAdjustFinResultMap = new HashMap<String, DynamicObject>(256, 1.0f);
        HashMap<String, DynamicObject> fromFinResultMap = new HashMap<String, DynamicObject>(16);
        if (!SPLIT_MERGE_FLAG.contains(clearSource)) {
            for (Map.Entry entry : depreUseIdPeriodid2ClearEntry.entrySet()) {
                Long orgId = clearBillDy.getLong("org.id");
                String key = (String)entry.getKey();
                String[] KeyArr = key.split("_");
                Long depreUseId = Long.valueOf(KeyArr[0]);
                Long periodId = Long.valueOf(KeyArr[1]);
                Set dpClearEntrySet = (Set)entry.getValue();
                this.handleAdjustData(orgId, depreUseId, periodId, clearBillDy, dpClearEntrySet, fromAdjustFinResultMap);
                log.info("clearpreresult,handleAdjustData:fromFinResultMap:" + fromAdjustFinResultMap.keySet().toString());
                DynamicObject clearPrePeriod = (DynamicObject)periodId2Period.get(periodId);
                Set<String> clearDepreNumberSetNO = this.handleClearPreDepreData(orgId, depreUseId, periodId, clearPrePeriod, clearBillDy, dpClearEntrySet, fromAdjustFinResultMap, preDepreResult);
                log.info("clearpreresult,handleClearPreDepreData:preDepreResult:" + preDepreResult.keySet().toString());
                this.handleClearPreDepreNoReturnData(orgId, depreUseId, clearDepreNumberSetNO, fromFinResultMap);
                log.info("clearpreresult,handleClearPreDepreNoReturnData:fromFinResultMap:" + fromFinResultMap.keySet().toString());
            }
        }
        DynamicObjectCollection clearBillEntrys = clearBillDy.getDynamicObjectCollection("detail_entry");
        for (DynamicObject clearBillEntry : clearBillEntrys) {
            Boolean isCrossOrg;
            long sourceBillId;
            String source;
            BigDecimal depReAmount;
            BigDecimal monthdepre;
            BigDecimal accumDep;
            DynamicObject finCard = clearBillEntry.getDynamicObject("fincard");
            long finCardId = finCard.getLong("id");
            DynamicObject basecurrency = clearBillEntry.getDynamicObject("basecurrency");
            if (basecurrency == null) {
                Long basecurrencyId = clearBillEntry.getLong("basecurrency_id");
                basecurrency = FaBaseDaoFactory.getInstance("bd_currency").queryOne(basecurrencyId);
            }
            Long depreUseId = finCard.getLong("depreuse.id");
            String number = finCard.getString("number");
            String key = depreUseId + "_" + number;
            BigDecimal clearAccumDepre = BigDecimal.ZERO;
            BigDecimal clearDepreAmount = BigDecimal.ZERO;
            BigDecimal clearRate = clearBillEntry.getBigDecimal("clearrate");
            if (SPLIT_MERGE_FLAG.contains(clearSource)) {
                clearBillEntry.set("addupdepre", (Object)new BigDecimal(0));
                clearBillEntry.set("clearmethod", (Object)ClearMethodAccumDepre.MERGE);
                clearBillEntry.set("isadjustdepre", (Object)"0");
            } else if (fromAdjustFinResultMap.get(key) != null) {
                accumDep = ((DynamicObject)fromAdjustFinResultMap.get(key)).getBigDecimal("accumdepre");
                monthdepre = ((DynamicObject)fromAdjustFinResultMap.get(key)).getBigDecimal("monthdepre");
                depReAmount = ((DynamicObject)fromAdjustFinResultMap.get(key)).getBigDecimal("depredamount");
                accumDep = FaCurrencyUtil.parseByCurAmtPrecision((DynamicObject)basecurrency, (BigDecimal)accumDep.multiply(clearRate));
                clearBillEntry.set("addupdepre", (Object)accumDep);
                Long clearperiodId = clearBillDy.getLong(Fa.id((String)"clearperiod"));
                Long bizdatePeriodId = ((DynamicObject)fromAdjustFinResultMap.get(key)).getLong("bizperiod.id");
                if (clearperiodId.longValue() == bizdatePeriodId.longValue()) {
                    clearBillEntry.set("isadjustdepre", (Object)"1");
                    clearBillEntry.set("monthadjustdepreforcur", (Object)monthdepre);
                }
                clearAccumDepre = accumDep;
                clearDepreAmount = depReAmount;
                clearBillEntry.set("clearmethod", (Object)ClearMethodAccumDepre.ADJ);
            } else if (fromFinResultMap.get(key) != null) {
                accumDep = ((DynamicObject)fromFinResultMap.get(key)).getBigDecimal("accumdepre");
                monthdepre = ((DynamicObject)fromFinResultMap.get(key)).getBigDecimal("monthdepre");
                depReAmount = ((DynamicObject)fromFinResultMap.get(key)).getBigDecimal("depredamount");
                accumDep = FaCurrencyUtil.parseByCurAmtPrecision((DynamicObject)basecurrency, (BigDecimal)accumDep.multiply(clearRate));
                clearBillEntry.set("addupdepre", (Object)accumDep);
                clearBillEntry.set("monthadjustdepreforcur", (Object)monthdepre);
                clearAccumDepre = accumDep;
                clearDepreAmount = depReAmount;
                clearBillEntry.set("clearmethod", (Object)ClearMethodAccumDepre.FIN);
            } else if (preDepreResult.get(key) != null) {
                BigDecimal[] clearDepreArr = (BigDecimal[])preDepreResult.get(key);
                clearAccumDepre = clearDepreArr[0];
                clearAccumDepre = FaCurrencyUtil.parseByCurAmtPrecision((DynamicObject)basecurrency, (BigDecimal)clearAccumDepre.multiply(clearRate));
                clearDepreAmount = clearDepreArr[1];
                clearBillEntry.set("addupdepre", (Object)FaCurrencyUtil.parseByCurAmtPrecision((DynamicObject)basecurrency, (BigDecimal)clearAccumDepre));
                clearBillEntry.set("clearmethod", (Object)ClearMethodAccumDepre.PRE);
            } else {
                DynamicObject realCard = clearBillEntry.getDynamicObject("realcard");
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7a0b\u5e8f\u5f02\u5e38\uff1a\u8d22\u52a1\u5361\u7247ID[%1$s],number[%2$s]\u6ca1\u6709\u6298\u65e7\u9884\u63d0\u91d1\u989d", (String)"ClearBillGenerateFacade_1", (String)"fi-fa-business", (Object[])new Object[0]), finCardId, realCard.getString("number")));
            }
            clearBillEntry.set("depredamount", (Object)clearDepreAmount);
            BigDecimal clearOriValue = clearBillEntry.getBigDecimal("assetvalue");
            BigDecimal clearNetWorth = clearOriValue.subtract(clearAccumDepre);
            BigDecimal clearNetAmount = clearNetWorth.subtract(clearBillEntry.getBigDecimal("decval"));
            clearBillEntry.set("netamount", (Object)FaCurrencyUtil.parseByCurAmtPrecision((DynamicObject)basecurrency, (BigDecimal)clearNetAmount));
            clearBillEntry.set("compfieldsv", (Object)CompFieldsValuesUtils.genCompfieldsvStyleS1(finCard));
            if (!clearBillEntry.getBoolean("isclearall")) {
                this.resetClearPreresidualVal(finCard, clearBillEntry, clearBillDy.getString("billno"), (BigDecimal[])preDepreResult.get(key));
            }
            if ((source = clearBillDy.getString("clearsource")) == null || !"DISPATCH".equals(source) || (sourceBillId = clearBillDy.getLong("srcbill")) == 0L) continue;
            String selectfields = "id,inorg,org,dispatchtype";
            DynamicObject dispatchBill = QueryServiceHelper.queryOne((String)"fa_dispatch", (String)selectfields, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)sourceBillId)});
            long orgId = 0L;
            long inorgId = 0L;
            String dispatchtype = "";
            if (dispatchBill != null) {
                orgId = dispatchBill.getLong("org");
                inorgId = dispatchBill.getLong("inorg");
                dispatchtype = dispatchBill.getString("dispatchtype");
            }
            if (!(isCrossOrg = Boolean.valueOf(orgId != inorgId)).booleanValue() || !DispatchtypeEnum.A.name().equals(dispatchtype)) continue;
            clearBillEntry.set("clearincome", clearBillEntry.get("netamount"));
        }
        return logMap;
    }

    private void resetClearPreresidualVal(DynamicObject finCard, DynamicObject clearBillEntry, String clearBillNo, BigDecimal[] clearDepreArr) {
        BigDecimal restOfPreresidualVal;
        DynamicObject baseCurrency = clearBillEntry.getDynamicObject("basecurrency");
        BigDecimal befNetAmount = finCard.getBigDecimal("netamount");
        if (clearDepreArr != null) {
            befNetAmount = clearDepreArr[2];
        }
        BigDecimal befPreresidualVal = finCard.getBigDecimal("preresidualval");
        BigDecimal clearNetAmount = clearBillEntry.getBigDecimal("netamount");
        BigDecimal clearPreresidualVal = clearBillEntry.getBigDecimal("preresidualval");
        BigDecimal restOfNetAmount = FaCurrencyUtil.parseByCurAmtPrecision((DynamicObject)baseCurrency, (BigDecimal)befNetAmount.subtract(clearNetAmount));
        if (restOfNetAmount.compareTo(restOfPreresidualVal = FaCurrencyUtil.parseByCurAmtPrecision((DynamicObject)baseCurrency, (BigDecimal)befPreresidualVal.subtract(clearPreresidualVal))) < 0) {
            clearBillEntry.set("preresidualval", (Object)clearNetAmount);
            log.info("\u5361\u7247[{}]\u505a\u5b8c\u6e05\u7406\u5355[{}]\u4e4b\u540e\uff0c\u5269\u4f59\u51c0\u989d[{}]<\u5269\u4f59\u51c0\u6b8b\u503c[{}]\uff0c\u9700\u8981\u5c06\u6e05\u7406\u51c0\u6b8b\u503c\u8bbe\u7f6e\u4e3a[{}]", new Object[]{finCard.getString("number"), clearBillNo, restOfNetAmount, restOfPreresidualVal, clearNetAmount});
        }
    }

    private void handleClearPreDepreNoReturnData(Long orgId, Long depreUseId, Set<String> clearDepreNumberSetNO, Map<String, DynamicObject> fromFinResultMap) {
        DynamicObject[] finDy4NoClearPre;
        if (clearDepreNumberSetNO.size() == 0) {
            return;
        }
        QFilter[] finNoClearPreFilters = new QFilter[]{new QFilter("number", "in", (Object)clearDepreNumberSetNO.toArray()), new QFilter("org", "=", (Object)orgId), new QFilter("depreuse", "=", (Object)depreUseId), new QFilter("endperiod", "=", (Object)99999999999L)};
        for (DynamicObject fin : finDy4NoClearPre = BusinessDataServiceHelper.load((String)"fa_card_fin", (String)selectFinPreFields, (QFilter[])finNoClearPreFilters)) {
            fromFinResultMap.put(depreUseId + "_" + fin.getString("number"), fin);
        }
    }

    private Set<String> handleClearPreDepreData(Long orgId, Long depreUseId, Long periodId, DynamicObject clearPrePeriod, DynamicObject clearBillDy, Set<DynamicObject> dpClearEntrySet, Map<String, DynamicObject> fromFinResultMap, Map<String, BigDecimal[]> preDepreResult) {
        Set<String> noAjustDepreSystemResultKeySet = fromFinResultMap.keySet();
        HashSet<String> clearDepreNumberSet = new HashSet<String>(dpClearEntrySet.size(), 1.0f);
        HashSet<Long> realIdSet = new HashSet<Long>(dpClearEntrySet.size());
        HashMap<Long, Date> realMasterId2Bizdate = new HashMap<Long, Date>(dpClearEntrySet.size(), 1.0f);
        for (DynamicObject dpClearEntry : dpClearEntrySet) {
            DynamicObject finCard = dpClearEntry.getDynamicObject("fincard");
            String depreUseIdNumber = finCard.getLong("depreuse.id") + "_" + finCard.getString("number");
            if (!noAjustDepreSystemResultKeySet.contains(depreUseIdNumber)) {
                clearDepreNumberSet.add(finCard.getString("number"));
            }
            DynamicObject realCard = dpClearEntry.getDynamicObject("realcard");
            Long realCardId = (Long)realCard.getPkValue();
            realIdSet.add(realCardId);
            Date bizDate = dpClearEntry.getDate("bizdate");
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(bizDate);
            if (calendar.get(11) != 0) {
                calendar.set(11, 0);
            }
            if (calendar.get(12) != 0) {
                calendar.set(12, 0);
            }
            if (calendar.get(13) != 0) {
                calendar.set(13, 0);
            }
            if (calendar.get(14) != 0) {
                calendar.set(14, 0);
            }
            realMasterId2Bizdate.put(realCardId, calendar.getTime());
        }
        DailyDepreImpl dailyDepreImpl = new DailyDepreImpl(Boolean.FALSE, "fa_clearbill");
        Map<String, Map<String, Object>> clearDepreResult = dailyDepreImpl.clearPrePeriodDepe(orgId, depreUseId, clearPrePeriod, clearDepreNumberSet, realIdSet, realMasterId2Bizdate);
        HashSet<String> haveResultNumberSet = new HashSet<String>(16);
        for (Map.Entry<String, Map<String, Object>> clearDepreResultEntry : clearDepreResult.entrySet()) {
            Map<String, Object> clearDepreResultMap = clearDepreResultEntry.getValue();
            BigDecimal accumdepre = (BigDecimal)clearDepreResultMap.get("accumdepre");
            BigDecimal depredamount = (BigDecimal)clearDepreResultMap.get("depredamount");
            BigDecimal netAmount = (BigDecimal)clearDepreResultMap.get("netamount");
            haveResultNumberSet.add(clearDepreResultEntry.getKey());
            preDepreResult.put(depreUseId + "_" + clearDepreResultEntry.getKey(), new BigDecimal[]{accumdepre, depredamount, netAmount});
        }
        clearDepreNumberSet.removeAll(haveResultNumberSet);
        return clearDepreNumberSet;
    }

    private void handleAdjustData(Long orgId, Long depreUseId, Long periodId, DynamicObject clearBillDy, Set<DynamicObject> dpClearEntrySet, Map<String, DynamicObject> fromFinResultMap) {
        DynamicObject[] finDy4Adjust;
        Serializable masterId;
        HashSet<Long> dpMasterIdSet = new HashSet<Long>(dpClearEntrySet.size(), 1.0f);
        for (DynamicObject dpClearEntry : dpClearEntrySet) {
            DynamicObject realCard = dpClearEntry.getDynamicObject("realcard");
            masterId = Long.valueOf(realCard.getLong("masterid"));
            dpMasterIdSet.add((Long)masterId);
        }
        if (dpMasterIdSet.size() == 0) {
            return;
        }
        SqlBuilder sbSqlAdjust = new SqlBuilder();
        sbSqlAdjust.append("SELECT d.frealcardid realcardid  FROM t_fa_depreadjustbill m,t_fa_depreadjustentry d where m.fid = d.fid ", new Object[0]).append(" and m.forgid = ? ", new Object[]{orgId}).append(" and m.fdepreuseid = ? ", new Object[]{depreUseId}).append(" and m.fperiodid  = ? ", new Object[]{periodId}).appendIn(" and d.frealcardid ", dpMasterIdSet.toArray());
        HashSet<Long> adjustRealSet = new HashSet<Long>(dpMasterIdSet.size());
        DataSet adjustDS = DB.queryDataSet((String)"resetBeforeSaveQueryAdjustRealIds", (DBRoute)FaConstants.faDBRoute, (SqlBuilder)sbSqlAdjust);
        masterId = null;
        try {
            for (Row row : adjustDS) {
                adjustRealSet.add(row.getLong("realcardid"));
            }
        }
        catch (Throwable throwable) {
            masterId = throwable;
            throw throwable;
        }
        finally {
            if (adjustDS != null) {
                if (masterId != null) {
                    try {
                        adjustDS.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)masterId).addSuppressed(throwable);
                    }
                } else {
                    adjustDS.close();
                }
            }
        }
        if (adjustRealSet.size() == 0) {
            return;
        }
        QFilter[] finAjustFilters = new QFilter[]{new QFilter("realcardmasterid", "in", (Object)adjustRealSet.toArray()), new QFilter("org", "=", (Object)orgId), new QFilter("depreuse", "=", (Object)depreUseId), new QFilter("bizperiod", "=", (Object)periodId)};
        for (DynamicObject fin : finDy4Adjust = BusinessDataServiceHelper.load((String)"fa_card_fin", (String)selectFinPreFields, (QFilter[])finAjustFilters)) {
            fromFinResultMap.put(depreUseId + "_" + fin.getString("number"), fin);
        }
    }

    DynamicObject[] getFinCardDys(DynamicObject clearBillDy) {
        DynamicObjectCollection clearBillEntrys = clearBillDy.getDynamicObjectCollection("detail_entry");
        if (clearBillEntrys == null || clearBillEntrys.size() == 0) {
            return new DynamicObject[0];
        }
        HashSet<Object> readCardIds = new HashSet<Object>();
        for (DynamicObject clearBillEntry : clearBillEntrys) {
            readCardIds.add(clearBillEntry.get("realcard.masterid"));
        }
        ApplyClearBill2ClearBillConvertor convertor = new ApplyClearBill2ClearBillConvertor();
        DynamicObject[] result = convertor.queryFinCards(readCardIds);
        return result;
    }

    Map<String, Integer> getFinRowIndex(DynamicObject clearBillDy) {
        DynamicObjectCollection clearBillEntrys = clearBillDy.getDynamicObjectCollection("detail_entry");
        if (clearBillEntrys == null || clearBillEntrys.size() == 0) {
            return new HashMap<String, Integer>(0);
        }
        int size = clearBillEntrys.size();
        HashMap<String, Integer> result = new HashMap<String, Integer>(size, 1.0f);
        for (int index = 0; index < size; ++index) {
            DynamicObject clrEntry = (DynamicObject)clearBillEntrys.get(index);
            String key = String.format("%s,%s", clrEntry.get("realcard.masterid"), clrEntry.get("depreuse_id"));
            result.put(key, index);
        }
        return result;
    }
}

