/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.clear;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.fa.business.clear.data.ClearBillData;
import kd.fi.fa.business.clear.data.ClearBillDetailData;
import kd.fi.fa.business.clear.data.ClearBillHeadData;
import kd.fi.fa.business.dao.factory.FaAssetBookDaoFactory;
import kd.fi.fa.business.dao.factory.FaBaseDaoFactory;
import kd.fi.fa.business.dao.factory.FaBillDaoFactory;
import kd.fi.fa.business.dao.factory.FaClearBillDaoFactory;
import kd.fi.fa.business.dao.impl.FaDaoOrmImpl;
import kd.fi.fa.business.enums.ClearBizStatus;
import kd.fi.fa.business.errorcode.ClearErrorCode;
import kd.fi.fa.business.utils.FaUtils;
import kd.fi.fa.common.util.DateUtil;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.common.util.FaCurrencyUtil;

public class ClearBillGeneratorHelper {
    private static Log logger = LogFactory.getLog(ClearBillGeneratorHelper.class);
    public static final String ADJUST_FILED = "depreuse, " + Fa.dot((String[])new String[]{"entryentity", "realcard"}) + " AS " + "realcard" + ", " + "auditdate";
    public static final String CLEAR_FILED = Fa.dot((String[])new String[]{"detail_entry", "depreuse"}) + " AS " + "depreuse" + ", " + Fa.dot((String[])new String[]{"detail_entry", "realcard"}) + " AS " + "realcard" + ", " + "auditdate";

    public DynamicObject[] getAssetBookEntriesByAssetOrg(Object assetOrgID) {
        DynamicObject[] books = FaAssetBookDaoFactory.getInstance().query(FaDaoOrmImpl.comma("id", "curperiod", "org"), new QFilter("org", "=", assetOrgID), "ismainbook DESC");
        if (books == null || books.length == 0) {
            throw new KDBizException(ClearErrorCode.NO_ASSETBOOK, new Object[0]);
        }
        DynamicObject[] bookEntries = new DynamicObject[books.length];
        for (int idx = 0; idx < books.length; ++idx) {
            DynamicObject book = books[idx];
            Object currPeriod = book.get("curperiod");
            DynamicObject entry = FaBaseDaoFactory.getInstance("fa_clearentry_entity").getEmptyDynamicObject();
            entry.set("fid", (Object)0);
            entry.set("assetbook", (Object)book);
            entry.set("period", currPeriod);
            bookEntries[idx] = entry;
        }
        return bookEntries;
    }

    public DynamicObject getClearBillHDByClearBillDataAndBookEntries(ClearBillData data, DynamicObject[] bookEntries) {
        boolean isFromSplitOrMergeBill;
        DynamicObject clearBill = FaClearBillDaoFactory.getInstance().getEmptyDynamicObject();
        ClearBillHeadData headData = data.getHeadData();
        clearBill.set("reason", (Object)headData.getReason());
        clearBill.set("org", (Object)FaBillDaoFactory.getInstance("bos_org").queryOne(headData.getOrgID()));
        clearBill.set(FaDaoOrmImpl.id("changemode"), headData.getChangeModeID());
        clearBill.set("srcbill", headData.getSourceBillID());
        clearBill.set("billstatus", (Object)headData.getBillStatus());
        boolean bl = isFromSplitOrMergeBill = "fa_assetsplitbill".equals(data.getSrcEntityName()) || "fa_mergebill".equals(data.getSrcEntityName());
        if (isFromSplitOrMergeBill) {
            clearBill.set("hasvoucher", (Object)true);
        }
        clearBill.set("clearsource", (Object)headData.getClearSource());
        clearBill.set("cleardate", (Object)headData.getClearDate());
        clearBill.set("createtime", (Object)headData.getCreateTime());
        clearBill.set("creator", (Object)headData.getCreatorId());
        DynamicObject periodDy = QueryServiceHelper.queryOne((String)"bd_period", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)headData.getClearPeriod())});
        clearBill.set("clearperiod_id", (Object)periodDy.getLong("id"));
        Map<Object, List<ClearBillDetailData>> detailDataMap = data.getDetailDataMap();
        Collection<List<ClearBillDetailData>> detailDatas = detailDataMap.values();
        HashSet<Object> realIdSet = new HashSet<Object>();
        HashSet<Object> finIdSet = new HashSet<Object>();
        for (List<ClearBillDetailData> detailDataLst : detailDatas) {
            for (ClearBillDetailData detailData : detailDataLst) {
                realIdSet.add(detailData.getRealCardID());
                finIdSet.add(detailData.getFinCardID());
            }
        }
        DynamicObject[] realCards = BusinessDataServiceHelper.load((Object[])realIdSet.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fa_card_real"));
        DynamicObject[] finCards = BusinessDataServiceHelper.load((Object[])finIdSet.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fa_card_fin"));
        Map<Object, DynamicObject> realMap = Stream.of(realCards).collect(Collectors.toMap(v -> v.getPkValue(), v -> v));
        Map<Object, DynamicObject> finMap = Stream.of(finCards).collect(Collectors.toMap(v -> v.getPkValue(), v -> v));
        DynamicObjectCollection clearDetailCol = (DynamicObjectCollection)clearBill.get("detail_entry");
        String srcEntityName = data.getSrcEntityName();
        boolean isLease = false;
        if ("fa_lease_contract".equals(srcEntityName)) {
            isLease = true;
        }
        for (DynamicObject bookEntry : bookEntries) {
            List<ClearBillDetailData> detailDataList = detailDataMap.get(bookEntry.getDynamicObject("assetbook").getPkValue());
            if (detailDataList == null) {
                if (!isLease) break;
                continue;
            }
            int seq = 1;
            Set<Object> currencyIdSet = new HashSet(detailDataList.size());
            currencyIdSet = detailDataList.stream().map(v -> v.getBaseCurrencyID()).collect(Collectors.toSet());
            DynamicObjectCollection currencys = QueryServiceHelper.query((String)"bd_currency", (String)"id,amtprecision", (QFilter[])new QFilter[]{new QFilter("id", "in", currencyIdSet)});
            HashMap<Long, DynamicObject> currencyMap = new HashMap<Long, DynamicObject>(currencys.size());
            for (DynamicObject currency : currencys) {
                currencyMap.put(currency.getLong("id"), currency);
            }
            for (ClearBillDetailData detailData : detailDataList) {
                DynamicObject basecurrency = (DynamicObject)currencyMap.get(detailData.getBaseCurrencyID());
                DynamicObject clearDetail = new DynamicObject(clearDetailCol.getDynamicObjectType());
                DynamicObject realCardDy = realMap.get(detailData.getRealCardID());
                DynamicObject finCardDy = finMap.get(detailData.getFinCardID());
                BigDecimal assetQty = realCardDy.getBigDecimal("assetamount");
                BigDecimal rate = assetQty.compareTo(BigDecimal.ONE) == 0 ? BigDecimal.ONE : detailData.getClearQty().divide(assetQty, 10, 4);
                BigDecimal originalVal = detailData.getOriginalVal();
                BigDecimal addupDepre = detailData.getAddupDepre();
                BigDecimal decVal = detailData.getDecVal();
                BigDecimal netAmount = detailData.getNetAmount();
                BigDecimal preresidualval = detailData.getPreresidualval();
                Date bizDate = detailData.getBizDate();
                if (rate.compareTo(BigDecimal.ONE) != 0) {
                    originalVal = originalVal.multiply(rate);
                    addupDepre = addupDepre.multiply(rate);
                    decVal = decVal.multiply(rate);
                    netAmount = netAmount.multiply(rate);
                    preresidualval = preresidualval.multiply(rate);
                }
                originalVal = FaCurrencyUtil.parseByCurAmtPrecision((DynamicObject)basecurrency, (BigDecimal)originalVal);
                addupDepre = FaCurrencyUtil.parseByCurAmtPrecision((DynamicObject)basecurrency, (BigDecimal)addupDepre);
                decVal = FaCurrencyUtil.parseByCurAmtPrecision((DynamicObject)basecurrency, (BigDecimal)decVal);
                netAmount = FaCurrencyUtil.parseByCurAmtPrecision((DynamicObject)basecurrency, (BigDecimal)netAmount);
                preresidualval = FaCurrencyUtil.parseByCurAmtPrecision((DynamicObject)basecurrency, (BigDecimal)preresidualval);
                clearDetail.set("Seq", (Object)seq);
                clearDetail.set("assetvalue", (Object)originalVal);
                clearDetail.set("addupdepre", (Object)addupDepre);
                clearDetail.set("decval", (Object)decVal);
                clearDetail.set("netamount", (Object)netAmount);
                clearDetail.set("preresidualval", (Object)preresidualval);
                clearDetail.set("clearrate", (Object)rate);
                String isclearAll = "1";
                if (rate.compareTo(BigDecimal.ONE) != 0) {
                    isclearAll = "2";
                }
                clearDetail.set("isclearall", (Object)isclearAll);
                clearDetail.set("number", (Object)realCardDy.getString("number"));
                clearDetail.set("basecurrency_id", detailData.getBaseCurrencyID());
                clearDetail.set("fincard", (Object)finCardDy);
                clearDetail.set("clearincome", (Object)detailData.getClearIncome());
                clearDetail.set("measureunit", detailData.getMeasureunit());
                clearDetail.set("entry", bookEntry.getPkValue());
                clearDetail.set("realcard", (Object)realCardDy);
                clearDetail.set("assetqty", (Object)assetQty);
                clearDetail.set("clearqty", (Object)detailData.getClearQty());
                clearDetail.set("clearfare", (Object)detailData.getClearFare());
                clearDetail.set("remark", (Object)detailData.getRemark());
                clearDetail.set("depreuse_id", detailData.getDepreuseID());
                clearDetail.set("bizdate", (Object)(bizDate == null ? DateUtil.getCurrentDayStart((Date)headData.getClearDate()) : DateUtil.getCurrentDayStart((Date)bizDate)));
                clearDetail.set("bizstatus", (Object)ClearBizStatus.READY.name());
                clearDetailCol.add((Object)clearDetail);
                ++seq;
            }
        }
        if (isFromSplitOrMergeBill) {
            return clearBill;
        }
        DynamicObjectCollection billHeads = clearBill.getDynamicObjectCollection("billhead_lk");
        DynamicObject billHead = billHeads.addNew();
        if ("fa_dispatch_in".equals(srcEntityName)) {
            srcEntityName = "fa_dispatch";
        }
        Long srcTableId = EntityMetadataCache.loadTableDefine((String)srcEntityName, (String)srcEntityName).getTableId();
        billHead.set("seq", (Object)1);
        billHead.set("billhead_lk_stableid", (Object)srcTableId);
        billHead.set("billhead_lk_sbillid", clearBill.get("srcbill"));
        billHead.set("billhead_lk_sid", clearBill.get("srcbill"));
        return clearBill;
    }

    public static Map<String, Date> getCardDepReAdjust(DynamicObject bill) {
        DynamicObjectCollection clearEntries = bill.getDynamicObjectCollection("detail_entry");
        HashMap<Long, HashSet<Long>> clearMap = new HashMap<Long, HashSet<Long>>(8);
        for (DynamicObject clearEntry : clearEntries) {
            Long depReUseId = clearEntry.getLong(Fa.join((String)"_", (String[])new String[]{"depreuse", "id"}));
            Long realCardId = clearEntry.getLong(Fa.dot((String[])new String[]{"realcard", "id"}));
            HashSet<Long> realCardIdSet = (HashSet<Long>)clearMap.get(depReUseId);
            if (realCardIdSet == null || realCardIdSet.isEmpty()) {
                realCardIdSet = new HashSet<Long>(FaUtils.getInitialCapacity43(clearEntries.size()));
                clearMap.put(depReUseId, realCardIdSet);
            }
            realCardIdSet.add(realCardId);
        }
        Object orgId = bill.get(Fa.dot((String[])new String[]{"org", "id"}));
        long clearPeriod = bill.getLong(Fa.dot((String[])new String[]{"clearperiod", "id"}));
        Set realCardIds = clearEntries.stream().map(v -> v.getLong(Fa.dot((String[])new String[]{"realcard", "id"}))).collect(Collectors.toSet());
        QFilter[] filters = new QFilter[]{new QFilter("billstatus", "=", (Object)"C"), new QFilter("org", "=", orgId), new QFilter("period", "=", (Object)clearPeriod), new QFilter(Fa.dot((String[])new String[]{"entryentity", "realcard"}), "in", realCardIds)};
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"FaClearBillSaveValidator.checkCardDepReAdjust", (String)"fa_depreadjustbill", (String)ADJUST_FILED, (QFilter[])filters, null);
        HashMap<String, Date> map = new HashMap<String, Date>(16);
        if (dataSet.isEmpty()) {
            return map;
        }
        DataSet processData = dataSet.groupBy(new String[]{"depreuse", "realcard"}).max("auditdate").finish();
        for (Row row : processData) {
            Long depReUse = row.getLong("depreuse");
            Set realCardSet = (Set)clearMap.get(depReUse);
            Long realCard = row.getLong("realcard");
            if (realCardSet == null || realCardSet.isEmpty() || !realCardSet.contains(realCard)) continue;
            map.put(depReUse + "_" + realCard, row.getDate("auditdate"));
        }
        return map;
    }

    public static String checkDepAdjustAfterFinCardClear(DynamicObject bill, Map<String, Date> checkResult) {
        DynamicObjectCollection clearDetailEntry = bill.getDynamicObjectCollection("detail_entry");
        Set<String> keySet = checkResult.keySet();
        HashSet<Long> realCardIdSet = new HashSet<Long>(16);
        for (String key : keySet) {
            String[] ids = key.split("_");
            realCardIdSet.add(Long.valueOf(ids[1]));
        }
        long clearPeriodId = bill.getLong(Fa.dot((String[])new String[]{"clearperiod", "id"}));
        Object orgId = bill.get("org_id");
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", orgId), new QFilter("billstatus", "=", (Object)"C"), new QFilter("clearperiod", "=", (Object)clearPeriodId), new QFilter(Fa.dot((String[])new String[]{"detail_entry", "realcard"}), "in", realCardIdSet)};
        DataSet clearDataSet = QueryServiceHelper.queryDataSet((String)"FaClearBillSaveValidator.checkDepAdjustAfterFinCardClear", (String)"fa_clearbill", (String)CLEAR_FILED, (QFilter[])filters, (String)"auditdate DESC");
        HashMap<String, Date> map = new HashMap<String, Date>(16);
        if (clearDataSet.isEmpty()) {
            return "";
        }
        clearDataSet = clearDataSet.groupBy(new String[]{"depreuse", "realcard"}).max("auditdate").finish();
        for (Row row : clearDataSet) {
            map.put(row.get("depreuse") + "_" + row.get("realcard"), row.getDate("auditdate"));
        }
        HashMap<Long, HashSet<Long>> adjustAfterClear = new HashMap<Long, HashSet<Long>>(16);
        if (map.isEmpty()) {
            return "";
        }
        Set clearEntries = map.entrySet();
        for (Map.Entry clearEntry : clearEntries) {
            if (!((Date)clearEntry.getValue()).after(checkResult.get(clearEntry.getKey()))) continue;
            String[] split = ((String)clearEntry.getKey()).split("_");
            Long depReUseId = Long.parseLong(split[0]);
            Long realCardId = Long.parseLong(split[1]);
            HashSet<Long> realCardSet = (HashSet<Long>)adjustAfterClear.get(depReUseId);
            if (realCardSet == null || realCardSet.isEmpty()) {
                realCardSet = new HashSet<Long>();
                adjustAfterClear.put(depReUseId, realCardSet);
            }
            realCardSet.add(realCardId);
        }
        if (adjustAfterClear.isEmpty()) {
            return "";
        }
        HashSet<String> msgSet = new HashSet<String>(16);
        for (DynamicObject detailEntry : clearDetailEntry) {
            Long realCardId = detailEntry.getLong(Fa.dot((String[])new String[]{"realcard", "id"}));
            Long depReUseId = detailEntry.getLong(Fa.dot((String[])new String[]{"depreuse", "id"}));
            if (adjustAfterClear.get(depReUseId) == null || !((Set)adjustAfterClear.get(depReUseId)).contains(realCardId)) continue;
            msgSet.add(detailEntry.getString("number") + ": " + detailEntry.get("depreuse.name"));
        }
        return ClearBillGeneratorHelper.processData(msgSet);
    }

    private static String processData(Set<String> msgSet) {
        String msg = "";
        int msgTotalNumber = msgSet.size();
        if (msgTotalNumber > 0) {
            int logBatchNumber = 100;
            if (msgTotalNumber > logBatchNumber) {
                int number = (int)Math.ceil((float)msgTotalNumber / (float)logBatchNumber);
                ArrayList<String> msgList = new ArrayList<String>(msgSet);
                for (int i = 0; i < number; ++i) {
                    int fromIndex = i * logBatchNumber;
                    int toIndex = Math.min((i + 1) * logBatchNumber, msgTotalNumber);
                    logger.info(String.format("\u4ee5\u4e0b\u7684\u5361\u7247\u5728\u6298\u65e7\u8c03\u6574\u540e\u5df2\u505a\u6e05\u7406\u5355\uff0c\u4e0d\u5141\u8bb8\u518d\u505a\u64cd\u4f5c\uff1a%s", Arrays.toString(msgList.subList(fromIndex, toIndex).toArray())));
                }
                List<String> returnMsgList = msgList.subList(0, logBatchNumber);
                returnMsgList.add("......");
                msgSet = new HashSet<String>(returnMsgList);
            }
            Optional<String> msgOptional = Optional.of(String.join((CharSequence)";", msgSet));
            msg = String.format(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u5361\u7247\u5728\u6298\u65e7\u8c03\u6574\u540e\u5df2\u505a\u6e05\u7406\u5355\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\uff1a%s\u3002", (String)"ClearBillGeneratorHelper_0", (String)"fi-fa-business", (Object[])new Object[0]), msgOptional.get());
        }
        return msg;
    }

    public static String getAdjustClearCard(DynamicObject bill) {
        DynamicObjectCollection clearEntries = bill.getDynamicObjectCollection("detail_entry");
        Set clearRealCardIds = clearEntries.stream().map(v -> v.getLong(Fa.dot((String[])new String[]{"realcard", "id"}))).collect(Collectors.toSet());
        long orgId = bill.getLong(Fa.id((String)"org"));
        long clearPeriodId = bill.getLong(Fa.id((String)"clearperiod"));
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("billstatus", "=", (Object)"C"), new QFilter(Fa.dot((String[])new String[]{"detail_entry", "isadjustdepre"}), "=", (Object)"1"), new QFilter("clearperiod", "=", (Object)clearPeriodId), new QFilter(Fa.dot((String[])new String[]{"detail_entry", "realcard"}), "in", clearRealCardIds)};
        String clearFiled = Fa.dot((String[])new String[]{"detail_entry", "depreuse"}) + " AS " + "depreuse" + ", " + Fa.dot((String[])new String[]{"detail_entry", "realcard"}) + " AS " + "realcard";
        DataSet clearDataSet = QueryServiceHelper.queryDataSet((String)"ClearBillGeneratorHelper.getAdjustClearCard", (String)"fa_clearbill", (String)clearFiled, (QFilter[])filters, null);
        if (clearDataSet.isEmpty()) {
            return StringUtils.getEmpty();
        }
        HashSet<String> existsData = new HashSet<String>(16);
        for (Row row : clearDataSet) {
            existsData.add(row.getLong("depreuse") + "_" + row.getLong("realcard"));
        }
        if (existsData.isEmpty()) {
            return StringUtils.getEmpty();
        }
        HashSet<String> msgSet = new HashSet<String>(16);
        for (DynamicObject clearEntry : clearEntries) {
            long realCardId = clearEntry.getLong(Fa.dot((String[])new String[]{"realcard", "id"}));
            long depReUseId = clearEntry.getLong(Fa.dot((String[])new String[]{"depreuse", "id"}));
            String key = depReUseId + "_" + realCardId;
            if (!existsData.contains(key)) continue;
            msgSet.add(clearEntry.getString("number") + ": " + clearEntry.getString(Fa.dot((String[])new String[]{"depreuse", "name"})));
        }
        return ClearBillGeneratorHelper.processData(msgSet);
    }
}

