/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.clear;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.fa.business.clear.ClearBillGeneratorHelper;
import kd.fi.fa.business.clear.IClearBillGenerator;
import kd.fi.fa.business.clear.convertor.IClearBillConvertor;
import kd.fi.fa.business.clear.data.ClearBillData;
import kd.fi.fa.business.clear.data.ClearBillHeadData;
import kd.fi.fa.business.constants.FaClearSourceEnum;
import kd.fi.fa.business.dao.factory.FaBaseDaoFactory;

public class ClearBillHDGenerator
implements IClearBillGenerator {
    private final IClearBillConvertor convertor;
    private final ClearBillGeneratorHelper helper = new ClearBillGeneratorHelper();

    public ClearBillHDGenerator(IClearBillConvertor convertor) {
        this.convertor = convertor;
    }

    @Override
    public void generate(ClearBillData data) {
        ArrayList<Long> ids;
        Object assetOrgID = data.getAssetOrgID();
        DynamicObject[] bookEntries = this.saveAssetBookEntries(assetOrgID);
        Object clearBillID = this.saveClearBill(data, bookEntries);
        this.updateAssetBook(clearBillID, bookEntries);
        ClearBillHeadData headData = data.getHeadData();
        if (this.getAutoSubmitAndAuditSource().contains((Object)headData.getClearSource())) {
            ids = new ArrayList<Long>(1);
            ids.add(Long.parseLong(clearBillID.toString()));
            String srcEntityName = data.getSrcEntityName();
            this.submitAndAudit(ids, srcEntityName);
        }
        if (this.getNoGenVoucherSource().contains((Object)headData.getClearSource())) {
            ids = new ArrayList(1);
            ids.add(Long.parseLong(clearBillID.toString()));
            this.noGenVoucher(ids);
        }
    }

    private void noGenVoucher(List<Long> ids) {
        OperateOption noGenVoucherOption = OperateOption.create();
        noGenVoucherOption.setVariableValue("ishasright", String.valueOf(true));
        OperationResult result = OperationServiceHelper.executeOperate((String)"nogenvoucher", (String)"fa_clearbill", (Object[])ids.toArray(), (OperateOption)noGenVoucherOption);
        if (!result.isSuccess()) {
            List allError = result.getAllErrorOrValidateInfo();
            result.getAllErrorInfo();
            StringBuilder errorInfo = new StringBuilder();
            if (!CollectionUtils.isEmpty((Collection)allError)) {
                for (IOperateInfo in : allError) {
                    errorInfo.append(in.getMessage());
                }
            }
            String msg = new LocaleString(String.format("%s%s-%s", ResManager.loadKDString((String)"\u6e05\u7406\u5355\u4e0d\u751f\u6210\u51ed\u8bc1\u5931\u8d25\u3002", (String)"ClearBillHDGenerator_0", (String)"fi-fa-business", (Object[])new Object[0]), result.getMessage(), errorInfo.toString())).toString();
            throw new KDBizException(msg);
        }
    }

    private Set<FaClearSourceEnum> getNoGenVoucherSource() {
        HashSet<FaClearSourceEnum> set = new HashSet<FaClearSourceEnum>(4);
        set.add(FaClearSourceEnum.MERGE);
        set.add(FaClearSourceEnum.SPLIT);
        return set;
    }

    private Set<FaClearSourceEnum> getAutoSubmitAndAuditSource() {
        HashSet<FaClearSourceEnum> set = new HashSet<FaClearSourceEnum>(8);
        set.add(FaClearSourceEnum.DISPATCH);
        set.add(FaClearSourceEnum.LEASE_TERMINATION);
        set.add(FaClearSourceEnum.MERGE);
        set.add(FaClearSourceEnum.SPLIT);
        return set;
    }

    private void submitAndAudit(List<Long> ids, String srcEntityName) {
        OperationResult result;
        OperateOption submitOp = OperateOption.create();
        submitOp.setVariableValue("ishasright", String.valueOf(true));
        submitOp.setVariableValue("WF", "FALSE");
        if (srcEntityName.equals("fa_lease_contract")) {
            submitOp.setVariableValue("ignoreSourceFlagValidate", "true");
        }
        if (!(result = OperationServiceHelper.executeOperate((String)"submit", (String)"fa_clearbill", (Object[])ids.toArray(), (OperateOption)submitOp)).isSuccess()) {
            List allError = result.getAllErrorOrValidateInfo();
            result.getAllErrorInfo();
            StringBuilder errorInfo = new StringBuilder();
            if (!CollectionUtils.isEmpty((Collection)allError)) {
                for (IOperateInfo in : allError) {
                    errorInfo.append(in.getMessage());
                }
            }
            String msg = new LocaleString(String.format("%s%s-%s", ResManager.loadKDString((String)"\u751f\u6210\u6e05\u7406\u5355\u63d0\u4ea4\u5931\u8d25\u3002", (String)"ClearBillHDGenerator_1", (String)"fi-fa-business", (Object[])new Object[0]), result.getMessage(), errorInfo.toString())).toString();
            throw new KDBizException(msg);
        }
        OperateOption auditOp = OperateOption.create();
        auditOp.setVariableValue("ishasright", String.valueOf(true));
        result = OperationServiceHelper.executeOperate((String)"audit", (String)"fa_clearbill", (Object[])ids.toArray(), (OperateOption)auditOp);
        if (!result.isSuccess()) {
            List allError = result.getAllErrorOrValidateInfo();
            result.getAllErrorInfo();
            StringBuilder errorInfo = new StringBuilder();
            if (!CollectionUtils.isEmpty((Collection)allError)) {
                for (IOperateInfo in : allError) {
                    errorInfo.append(in.getMessage());
                }
            }
            String msg = new LocaleString(String.format("%s%s-%s", ResManager.loadKDString((String)"\u751f\u6210\u6e05\u7406\u5355\u5ba1\u6838\u5931\u8d25\u3002", (String)"ClearBillHDGenerator_2", (String)"fi-fa-business", (Object[])new Object[0]), result.getMessage(), errorInfo.toString())).toString();
            throw new KDBizException(msg);
        }
    }

    @Override
    public void generate(Object billID, String entityName) {
        this.generate(BusinessDataServiceHelper.loadSingle((Object)billID, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)entityName)));
    }

    @Override
    public void generate(DynamicObject bill) {
        this.generate(this.convertor.convert(bill));
    }

    protected DynamicObject[] saveAssetBookEntries(Object assetOrgID) {
        DynamicObject[] bookEntries = this.helper.getAssetBookEntriesByAssetOrg(assetOrgID);
        Stream.of(bookEntries).forEach(v -> {
            IDataEntityType dt = v.getDataEntityType();
            v.set((IDataEntityProperty)dt.getPrimaryKey(), (Object)DBServiceHelper.genLongIds((String)dt.getAlias(), (int)1));
        });
        return bookEntries;
    }

    protected Object saveClearBill(ClearBillData data, DynamicObject[] bookEntries) {
        OperationResult result;
        DynamicObject clearBill = this.helper.getClearBillHDByClearBillDataAndBookEntries(data, bookEntries);
        OperateOption operate = OperateOption.create();
        operate.setVariableValue("ishasright", String.valueOf(true));
        if ("fa_lease_contract".equals(data.getSrcEntityName())) {
            operate.setVariableValue("ignoreSourceFlagValidate", "true");
        }
        if (!(result = OperationServiceHelper.executeOperate((String)"save", (String)"fa_clearbill", (DynamicObject[])new DynamicObject[]{clearBill}, (OperateOption)operate)).isSuccess()) {
            List allError = result.getAllErrorOrValidateInfo();
            result.getAllErrorInfo();
            String resultMsg = result.getMessage();
            StringBuilder errorInfo = new StringBuilder();
            if (StringUtils.isNotEmpty((CharSequence)resultMsg)) {
                errorInfo.append(ResManager.loadKDString((String)"\u6e05\u7406\u5355", (String)"ClearBillHDGenerator_3", (String)"fi-fa-business", (Object[])new Object[0])).append(resultMsg);
            }
            if (!CollectionUtils.isEmpty((Collection)allError)) {
                for (IOperateInfo in : allError) {
                    errorInfo.append(ResManager.loadKDString((String)"\u6e05\u7406\u5355", (String)"ClearBillHDGenerator_3", (String)"fi-fa-business", (Object[])new Object[0])).append(in.getMessage());
                }
            }
            String msg = new LocaleString(String.format("%s%s", ResManager.loadKDString((String)"\u751f\u6210\u6e05\u7406\u5355\u5931\u8d25\u3002", (String)"ClearBillHDGenerator_4", (String)"fi-fa-business", (Object[])new Object[0]), errorInfo.toString())).toString();
            throw new KDBizException(msg);
        }
        return clearBill.getPkValue();
    }

    protected void updateAssetBook(Object clearBillID, DynamicObject[] bookEntries) {
        for (DynamicObject bookEntry : bookEntries) {
            bookEntry.set("fid", clearBillID);
        }
        FaBaseDaoFactory.getInstance("fa_clearentry_entity").update(bookEntries);
    }
}

