/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.clear.convertor;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.validate.BillStatus;
import kd.bos.exception.KDBizException;
import kd.fi.fa.business.DispatchtypeEnum;
import kd.fi.fa.business.clear.convertor.AbstractBill2ClearBillConvertor;
import kd.fi.fa.business.clear.convertor.IClearBillConvertor;
import kd.fi.fa.business.clear.data.ClearBillData;
import kd.fi.fa.business.clear.data.ClearBillDetailData;
import kd.fi.fa.business.clear.data.ClearBillHeadData;
import kd.fi.fa.business.constants.FaClearSourceEnum;
import kd.fi.fa.business.dao.impl.FaDaoOrmImpl;
import kd.fi.fa.business.utils.FaBizUtils;
import kd.fi.fa.business.utils.FaChangeModeConfUtil;
import kd.fi.fa.common.util.DateUtil;

public class DispatchBill2ClearBillConvertor
extends AbstractBill2ClearBillConvertor
implements IClearBillConvertor {
    @Override
    protected void setHeadData(DynamicObject bill, ClearBillData data) {
        Date clearDate;
        DynamicObject mainBook;
        data.setSrcEntityName("fa_dispatch_in");
        ClearBillHeadData headData = new ClearBillHeadData();
        headData.setBillNo(bill.getString("billno"));
        headData.setReason(ResManager.loadKDString((String)"\u8c03\u51fa", (String)"DispatchBill2ClearBillConvertor_0", (String)"fi-fa-business", (Object[])new Object[0]));
        headData.setOrgID(this.pk(bill.getDynamicObject("org")));
        headData.setChangeModeID(FaChangeModeConfUtil.getChangeModeDefaultValue((Long)bill.getDynamicObject("assetunit").getPkValue(), "fa_dispatch_in", "fa_clearbill"));
        headData.setCreatorId(bill.getLong("creator_id"));
        headData.setSourceBillID(bill.getPkValue());
        headData.setBillStatus(BillStatus.A);
        headData.setClearSource(FaClearSourceEnum.DISPATCH);
        long changeModeId = bill.getLong("changemode_id");
        if (changeModeId != 0L) {
            headData.setChangeModeID(changeModeId);
        }
        if ((mainBook = FaBizUtils.getAsstBookByOrg((Long)headData.getOrgID())) != null) {
            Date enddate = (Date)mainBook.get("enddate");
            Date begindate = (Date)mainBook.get("begindate");
            clearDate = Calendar.getInstance().getTime();
            if (clearDate.before(begindate)) {
                clearDate = begindate;
            } else if (clearDate.after(enddate)) {
                clearDate = enddate;
            }
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u672a\u8bbe\u7f6e\u4e3b\u8d26\u7c3f\u3002", (String)"DispatchBill2ClearBillConvertor_1", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        headData.setClearPeriod(mainBook.getLong("curperiod"));
        clearDate = DateUtil.stripTime((Date)clearDate);
        headData.setClearDate(clearDate);
        headData.setCreateTime(Calendar.getInstance().getTime());
        data.setHeadData(headData);
    }

    @Override
    protected void setDetailData(DynamicObject bill, ClearBillData data) {
        HashMap<Object, List<ClearBillDetailData>> detailDataMap = new HashMap<Object, List<ClearBillDetailData>>(16);
        DynamicObjectCollection entries = (DynamicObjectCollection)bill.get("dispatchentry");
        Set<Object> realCardPKSet = entries.stream().map(v -> this.pk(v.getDynamicObject("realcard"))).collect(Collectors.toSet());
        DynamicObject[] finCards = this.queryFinCards(realCardPKSet);
        if (finCards == null || finCards.length == 0) {
            data.setDetailDataMap(detailDataMap);
            return;
        }
        Map<Object, List<DynamicObject>> group = Stream.of(finCards).collect(Collectors.groupingBy(v -> v.get("assetbook_id")));
        Set<Map.Entry<Object, List<DynamicObject>>> entrySet = group.entrySet();
        for (Map.Entry<Object, List<DynamicObject>> entry : entrySet) {
            detailDataMap.putAll(this.setDetailDataByBook(entry.getKey(), entry.getValue(), entries, bill));
        }
        data.setDetailDataMap(detailDataMap);
    }

    private Map<? extends Object, ? extends List<ClearBillDetailData>> setDetailDataByBook(Object bookPk, List<DynamicObject> finCards, DynamicObjectCollection entries, DynamicObject dispatchBill) {
        HashMap detailDataMap = new HashMap(16);
        String dispatchtype = dispatchBill.getString("dispatchtype");
        HashMap<Long, BigDecimal> realCardIdAndEvaluate = new HashMap<Long, BigDecimal>(entries.size());
        for (DynamicObject entry : entries) {
            DynamicObject realCard = entry.getDynamicObject("realcard");
            long realCardId = 0L;
            if (realCard != null) {
                realCardId = realCard.getLong("id");
            }
            BigDecimal evaluate = entry.getBigDecimal("evaluate");
            realCardIdAndEvaluate.put(realCardId, evaluate);
        }
        for (DynamicObject finCard : finCards) {
            Boolean isCrossOrg;
            ClearBillDetailData detailData = new ClearBillDetailData();
            detailData.setOriginalVal(finCard.getBigDecimal("originalval"));
            detailData.setAddupDepre(finCard.getBigDecimal("accumdepre"));
            detailData.setDecVal(finCard.getBigDecimal("decval"));
            detailData.setNetAmount(finCard.getBigDecimal("netamount"));
            detailData.setPreresidualval(finCard.getBigDecimal("preresidualval"));
            detailData.setBaseCurrencyID(this.pk(finCard.getDynamicObject(FaDaoOrmImpl.dot("assetbook", "basecurrency"))));
            detailData.setFinCardID(finCard.getPkValue());
            Object realCardID = this.pk(finCard.getDynamicObject("realcard"));
            detailData.setRealCardID(realCardID);
            Optional<DynamicObject> findFirst = entries.stream().filter(v -> this.pk(v.getDynamicObject("realcard")).equals(realCardID)).findFirst();
            if (!findFirst.isPresent()) continue;
            DynamicObject entry = findFirst.get();
            detailData.setClearQty(entry.getBigDecimal("dispatchqty"));
            detailData.setMeasureunit(entry.get("measurement"));
            detailData.setClearIncome(BigDecimal.ZERO);
            detailData.setClearFare(BigDecimal.ZERO);
            long orgId = 0L;
            long inorgId = 0L;
            if (dispatchBill != null) {
                DynamicObject org = dispatchBill.getDynamicObject("org");
                DynamicObject inorg = dispatchBill.getDynamicObject("inorg");
                if (org != null && org.getLong("id") != 0L) {
                    orgId = org.getLong("id");
                }
                if (inorg != null && inorg.getLong("id") != 0L) {
                    inorgId = inorg.getLong("id");
                }
            }
            if ((isCrossOrg = Boolean.valueOf(orgId != inorgId)).booleanValue()) {
                if (DispatchtypeEnum.B.name().equals(dispatchtype)) {
                    detailData.setClearIncome((BigDecimal)realCardIdAndEvaluate.get(realCardID));
                }
            } else {
                detailData.setClearIncome(BigDecimal.ZERO);
            }
            detailData.setDepreuseID(this.pk(finCard.getDynamicObject("depreuse")));
            detailData.setRemark(ResManager.loadKDString((String)"\u8c03\u51fa", (String)"DispatchBill2ClearBillConvertor_0", (String)"fi-fa-business", (Object[])new Object[0]));
            if (detailDataMap.containsKey(bookPk)) {
                ((List)detailDataMap.get(bookPk)).add(detailData);
                continue;
            }
            ArrayList<ClearBillDetailData> detailDetailList = new ArrayList<ClearBillDetailData>(16);
            detailDetailList.add(detailData);
            detailDataMap.put(bookPk, detailDetailList);
        }
        return detailDataMap;
    }
}

