/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.clear.convertor;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.validate.BillStatus;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.fa.business.clear.convertor.AbstractBill2ClearBillConvertor;
import kd.fi.fa.business.clear.convertor.IClearBillConvertor;
import kd.fi.fa.business.clear.data.ClearBillData;
import kd.fi.fa.business.clear.data.ClearBillDetailData;
import kd.fi.fa.business.clear.data.ClearBillHeadData;
import kd.fi.fa.business.constants.FaClearSourceEnum;
import kd.fi.fa.business.dao.impl.FaDaoOrmImpl;
import kd.fi.fa.business.utils.FaBizUtils;
import kd.fi.fa.common.util.ContextUtil;
import kd.fi.fa.common.util.DateUtil;

public class LeaseContract2ClearBillConvertor
extends AbstractBill2ClearBillConvertor
implements IClearBillConvertor {
    private final long changeModeId;
    private final Date leaseTerminationDate;

    public LeaseContract2ClearBillConvertor(long changeModeId, Date leaseTerminationDate) {
        this.changeModeId = changeModeId;
        this.leaseTerminationDate = leaseTerminationDate;
    }

    @Override
    protected void setHeadData(DynamicObject bill, ClearBillData data) {
        data.setSrcEntityName("fa_lease_contract");
        ClearBillHeadData headData = new ClearBillHeadData();
        String leaseTerminationDateStr = DateUtil.getShortDate().format(this.leaseTerminationDate);
        headData.setReason(String.format(ResManager.loadKDString((String)"%s\u79df\u8d41\u5408\u540c\u7ec8\u6b62\u3002", (String)"LeaseContract2ClearBillConvertor_0", (String)"fi-fa-business", (Object[])new Object[0]), leaseTerminationDateStr));
        headData.setOrgID(this.pk(bill.getDynamicObject("org")));
        headData.setChangeModeID(this.changeModeId);
        headData.setSourceBillID(bill.getPkValue());
        headData.setBillStatus(BillStatus.A);
        headData.setClearSource(FaClearSourceEnum.LEASE_TERMINATION);
        DynamicObject mainBook = FaBizUtils.getAsstBookByOrg((Long)headData.getOrgID());
        if (mainBook == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u672a\u8bbe\u7f6e\u4e3b\u8d26\u7c3f\u3002", (String)"LeaseContract2ClearBillConvertor_1", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        Date beginDate = (Date)mainBook.get("begindate");
        Date clearDate = DateUtil.compareShortDate((Date)this.leaseTerminationDate, (Date)beginDate) < 0 ? beginDate : this.leaseTerminationDate;
        headData.setClearDate(clearDate);
        headData.setClearPeriod(mainBook.getLong("curperiod"));
        headData.setCreatorId(ContextUtil.getUserId());
        headData.setCreateTime(Calendar.getInstance().getTime());
        data.setHeadData(headData);
    }

    @Override
    protected void setDetailData(DynamicObject bill, ClearBillData data) {
        HashMap<Object, List<ClearBillDetailData>> detailDataMap = new HashMap<Object, List<ClearBillDetailData>>(8);
        DynamicObject realCard = BusinessDataServiceHelper.loadSingleFromCache((String)"fa_card_real", (String)FaDaoOrmImpl.comma("masterid", "assetamount", "unit"), (QFilter[])new QFilter[]{new QFilter("srcbillid", "=", (Object)bill.getLong("id")), new QFilter("isbak", "=", (Object)false)});
        HashSet<Object> cardIds = new HashSet<Object>(1);
        cardIds.add(realCard.getPkValue());
        DynamicObject[] finCards = this.queryFinCards(cardIds);
        if (finCards.length == 0) {
            data.setDetailDataMap(detailDataMap);
            return;
        }
        Map<Object, List<DynamicObject>> group = Stream.of(finCards).collect(Collectors.groupingBy(v -> v.get("assetbook_id")));
        Set<Map.Entry<Object, List<DynamicObject>>> entrySet = group.entrySet();
        for (Map.Entry<Object, List<DynamicObject>> entry : entrySet) {
            detailDataMap.putAll(this.setDetailDataByBook(entry.getKey(), entry.getValue(), realCard));
        }
        data.setDetailDataMap(detailDataMap);
    }

    private Map<Object, List<ClearBillDetailData>> setDetailDataByBook(Object bookPk, List<DynamicObject> finCards, DynamicObject realCard) {
        HashMap<Object, List<ClearBillDetailData>> detailDataMap = new HashMap<Object, List<ClearBillDetailData>>(8);
        for (DynamicObject finCard : finCards) {
            ClearBillDetailData detailData = new ClearBillDetailData();
            detailData.setRealCardID(realCard.getPkValue());
            detailData.setFinCardID(finCard.getPkValue());
            detailData.setDepreuseID(this.pk(finCard.getDynamicObject("depreuse")));
            detailData.setClearQty(realCard.getBigDecimal("assetamount"));
            detailData.setMeasureunit(realCard.getDynamicObject("unit"));
            detailData.setClearIncome(BigDecimal.ZERO);
            detailData.setClearFare(BigDecimal.ZERO);
            detailData.setOriginalVal(finCard.getBigDecimal("originalval"));
            detailData.setAddupDepre(finCard.getBigDecimal("accumdepre"));
            detailData.setDecVal(finCard.getBigDecimal("decval"));
            detailData.setNetAmount(finCard.getBigDecimal("netamount"));
            detailData.setPreresidualval(finCard.getBigDecimal("preresidualval"));
            detailData.setBaseCurrencyID(this.pk(finCard.getDynamicObject(FaDaoOrmImpl.dot("assetbook", "basecurrency"))));
            detailData.setBizDate(this.leaseTerminationDate);
            if (detailDataMap.containsKey(bookPk)) {
                ((List)detailDataMap.get(bookPk)).add(detailData);
                continue;
            }
            ArrayList<ClearBillDetailData> detailDetailList = new ArrayList<ClearBillDetailData>(8);
            detailDetailList.add(detailData);
            detailDataMap.put(bookPk, detailDetailList);
        }
        return detailDataMap;
    }
}

