/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.clear.convertor;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.validate.BillStatus;
import kd.fi.fa.business.clear.convertor.AbstractBill2ClearBillConvertor;
import kd.fi.fa.business.clear.convertor.IClearBillConvertor;
import kd.fi.fa.business.clear.data.ClearBillData;
import kd.fi.fa.business.clear.data.ClearBillDetailData;
import kd.fi.fa.business.clear.data.ClearBillHeadData;
import kd.fi.fa.business.constants.FaClearSourceEnum;
import kd.fi.fa.business.dao.impl.FaDaoOrmImpl;
import kd.fi.fa.common.util.ContextUtil;
import kd.fi.fa.common.util.DateUtil;
import kd.fi.fa.common.util.Fa;

public class SplitBill2ClearBillConvertor
extends AbstractBill2ClearBillConvertor
implements IClearBillConvertor {
    @Override
    protected void setHeadData(DynamicObject bill, ClearBillData data) {
        data.setSrcEntityName("fa_assetsplitbill");
        ClearBillHeadData headData = new ClearBillHeadData();
        Date splitDate = bill.getDate("splitdate");
        String splitDateStr = DateUtil.getShortDate().format(splitDate);
        headData.setReason(String.format(ResManager.loadKDString((String)"%s\u8d44\u4ea7\u62c6\u5206\u3002", (String)"SplitBill2ClearBillConvertor_0", (String)"fi-fa-business", (Object[])new Object[0]), splitDateStr));
        headData.setOrgID(this.pk(bill.getDynamicObject("org")));
        headData.setChangeModeID(21);
        headData.setSourceBillID(bill.getPkValue());
        headData.setBillStatus(BillStatus.A);
        headData.setClearSource(FaClearSourceEnum.SPLIT);
        headData.setClearDate(splitDate);
        headData.setClearPeriod(bill.getLong(Fa.id((String)"splitperiod")));
        headData.setCreatorId(ContextUtil.getUserId());
        headData.setCreateTime(Calendar.getInstance().getTime());
        data.setHeadData(headData);
    }

    @Override
    protected void setDetailData(DynamicObject bill, ClearBillData data) {
        HashMap<Object, List<ClearBillDetailData>> detailDataMap = new HashMap<Object, List<ClearBillDetailData>>(8);
        DynamicObject splitCard = bill.getDynamicObject("split_realcard");
        HashSet<Object> realCardIds = new HashSet<Object>(2);
        realCardIds.add(splitCard.get("masterid"));
        DynamicObject[] finCards = this.queryFinCards(realCardIds);
        if (finCards.length == 0) {
            data.setDetailDataMap(detailDataMap);
            return;
        }
        for (DynamicObject finCard : finCards) {
            Object assetBookId = finCard.getDynamicObject("assetbook").getPkValue();
            detailDataMap.putAll(this.setDetailDataByBook(assetBookId, finCard, bill));
        }
        data.setDetailDataMap(detailDataMap);
    }

    private Map<Object, List<ClearBillDetailData>> setDetailDataByBook(Object bookId, DynamicObject finCard, DynamicObject bill) {
        Date splitDate = bill.getDate("splitdate");
        ClearBillDetailData detailData = new ClearBillDetailData();
        DynamicObject realCard = bill.getDynamicObject("split_realcard");
        detailData.setRealCardID(realCard.getPkValue());
        detailData.setFinCardID(finCard.getPkValue());
        detailData.setDepreuseID(this.pk(finCard.getDynamicObject("depreuse")));
        detailData.setClearQty(realCard.getBigDecimal("assetamount"));
        detailData.setMeasureunit(realCard.getDynamicObject("unit"));
        detailData.setClearIncome(BigDecimal.ZERO);
        detailData.setClearFare(BigDecimal.ZERO);
        detailData.setOriginalVal(finCard.getBigDecimal("originalval"));
        detailData.setAddupDepre(finCard.getBigDecimal("accumdepre"));
        detailData.setDecVal(finCard.getBigDecimal("decval"));
        detailData.setNetAmount(finCard.getBigDecimal("netamount"));
        detailData.setPreresidualval(finCard.getBigDecimal("preresidualval"));
        detailData.setBaseCurrencyID(this.pk(finCard.getDynamicObject(FaDaoOrmImpl.dot("assetbook", "basecurrency"))));
        detailData.setBizDate(splitDate);
        HashMap<Object, List<ClearBillDetailData>> detailDataMap = new HashMap<Object, List<ClearBillDetailData>>(2);
        ArrayList<ClearBillDetailData> detailDetailList = new ArrayList<ClearBillDetailData>(2);
        detailDetailList.add(detailData);
        detailDataMap.put(bookId, detailDetailList);
        return detailDataMap;
    }
}

