/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.coderule;

import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.fi.fa.business.coderule.CodeRuleService;
import kd.fi.fa.business.dao.IFaBaseDao;
import kd.fi.fa.business.dao.factory.FaBaseDaoFactory;

public class CodeRuleServiceImpl
implements CodeRuleService {
    private static Log logger = LogFactory.getLog(CodeRuleServiceImpl.class);
    private CodeRuleInfo codeRuleInfo = null;
    private ICodeRuleService codeRuleService = null;
    protected DynamicObject dymObj = null;

    CodeRuleServiceImpl(DynamicObject dymObj, String orgID) {
        this.dymObj = dymObj;
        this.codeRuleService = (ICodeRuleService)ServiceFactory.getService(ICodeRuleService.class);
        this.codeRuleInfo = this.codeRuleService.getCodeRule(dymObj.getDataEntityType().getName(), dymObj, orgID);
    }

    @Override
    public boolean isAddView() {
        if (this.codeRuleInfo != null) {
            return this.codeRuleInfo.getIsAddView();
        }
        return false;
    }

    @Override
    public String getNumber() {
        String number = this.codeRuleService.getNumber(this.codeRuleInfo, this.dymObj);
        logger.info(this.getCodeRuleDesc() + ", \u4ea7\u751f\u7f16\u7801\uff1a" + number);
        return number;
    }

    @Override
    public String readNumber() {
        String number = this.codeRuleService.readNumber(this.codeRuleInfo, this.dymObj);
        logger.info(this.getCodeRuleDesc() + ", \u4ea7\u751f\u7f16\u7801\uff08\u4e0d\u6d88\u8017\u6d41\u6c34\u53f7\uff09\uff1a" + number);
        return number;
    }

    public static boolean isDuplicateAutoNumber(DynamicObject dymObj, QFilter filter) {
        if (dymObj != null) {
            String entityName = dymObj.getDataEntityType().getName();
            IFaBaseDao baseDao = FaBaseDaoFactory.getInstance(entityName);
            return baseDao.queryOne(filter) != null;
        }
        return false;
    }

    @Override
    public boolean isExistRule() {
        return this.codeRuleInfo != null;
    }

    @Override
    public String getCodeRuleDesc() {
        return this.codeRuleInfo.getId();
    }

    @Override
    public DynamicObject getDymObj() {
        return this.dymObj;
    }

    @Override
    public void recycleNumber(String entityId, DynamicObject dataInfo, String orgid, String billno) {
        if (billno != null && !StringUtils.isEmpty((CharSequence)billno.trim())) {
            this.codeRuleService.recycleNumber(entityId, dataInfo, orgid, billno);
        }
    }

    @Override
    public CodeRuleInfo getCodeRuleInfo() {
        return this.codeRuleInfo;
    }
}

