/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.dao.impl;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.LongProp;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.business.calc.DynamicObjectWrapper;
import kd.fi.fa.business.calc.FinCardCalc;
import kd.fi.fa.business.cardgenerate.CardGenerateHelper;
import kd.fi.fa.business.dao.impl.IBizSetCardDataHandler;
import kd.fi.fa.business.utils.PeriodUtil;

public class AssetCardToFinCardHandler
implements IBizSetCardDataHandler {
    private final OperateOption operateOption;

    public AssetCardToFinCardHandler(OperateOption operateOption) {
        this.operateOption = operateOption;
    }

    public OperateOption getOption() {
        return this.operateOption;
    }

    @Override
    public void handle(DynamicObject card) {
        this.handle(new DynamicObject[]{card});
    }

    @Override
    public void handle(DynamicObject[] cards) {
        boolean opFromIsc = this.getOption().containsVariable("op_from_isc");
        if (!opFromIsc) {
            return;
        }
        if (cards.length == 0) {
            return;
        }
        String entityName = cards[0].getDynamicObjectType().getName();
        Map<Long, Map<Long, DynamicObject>> finCardMap = CardGenerateHelper.generateFinCardForAssetCard(Arrays.asList(cards), entityName);
        Set orgIds = Arrays.stream(cards).map(v -> v.getLong("org.id")).collect(Collectors.toSet());
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"fa_assetbook", (String)String.join((CharSequence)",", "org", "depreuse", "startperiod"), (QFilter[])new QFilter[]{new QFilter("org", "in", orgIds)});
        Map<Long, List<DynamicObject>> depreUseIdsListMap = collection.stream().collect(Collectors.groupingBy(x -> x.getLong("org")));
        for (DynamicObject dy : cards) {
            Map<Long, DynamicObject> depreUseCardMap = finCardMap.get(dy.getLong("id"));
            List<DynamicObject> depreUseIdsList = depreUseIdsListMap.get(dy.getLong("org.id"));
            Set depreUseIds = depreUseIdsList.stream().map(v -> v.getLong("depreuse")).collect(Collectors.toSet());
            Map<Long, Long> depreUseIdsMap = depreUseIdsList.stream().collect(Collectors.toMap(k -> k.getLong("depreuse"), v -> v.getLong("startperiod")));
            DynamicObjectCollection assetCardFins = dy.getDynamicObjectCollection("finentry");
            if (assetCardFins.size() == 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5b9e\u7269\u5361\u7247\u672a\u627e\u5230\u5bf9\u5e94\u7684\u8d22\u52a1\u5361\u7247\u3002", (String)"AssetCardToFinCardHandler_0", (String)"fi-fa-business", (Object[])new Object[0]));
            }
            if (assetCardFins.size() > 1) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8d44\u4ea7\u5361\u7247\u8d22\u52a1\u5206\u5f55\u6682\u4e0d\u652f\u6301\u5f55\u5165\u591a\u5f20\u8d22\u52a1\u5361\u7247\u3002", (String)"AssetCardToFinCardHandler_1", (String)"fi-fa-business", (Object[])new Object[0]));
            }
            DataEntityPropertyCollection assetEntryImportProps = ((DynamicObject)assetCardFins.get(0)).getDynamicObjectType().getProperties();
            for (DynamicObject entry : assetCardFins) {
                long depreuseId = entry.getLong("fin_depreuse.id");
                if (0L == depreuseId) continue;
                if (!depreUseIds.contains(depreuseId)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u6838\u7b97\u7ec4\u7ec7\u7684\u6240\u6709\u8d44\u4ea7\u8d26\u7c3f\u4e2d\u4e0d\u5b58\u5728\u5f55\u5165\u7684\u6298\u65e7\u7528\u9014\u3002", (String)"AssetCardToFinCardHandler_2", (String)"fi-fa-business", (Object[])new Object[0]));
                }
                DynamicObject depreUseFinCard = depreUseCardMap.get(depreuseId);
                depreUseFinCard.set("depredept", dy.get("headusedept"));
                depreUseFinCard.set("assetcat", dy.get("assetcat"));
                for (IDataEntityProperty importProp : assetEntryImportProps) {
                    String importPropName = importProp.getName();
                    if (!importPropName.contains("fin_") || importPropName.equals("fin_basecurrency") || importPropName.equals("fin_basecurrency_id")) continue;
                    String[] finFieldSplit = importPropName.split("fin_");
                    String finField = finFieldSplit[finFieldSplit.length - 1];
                    if (importProp instanceof BasedataProp) {
                        depreUseFinCard.set(finField + "_id", (Object)entry.getLong(importPropName + ".id"));
                        depreUseFinCard.set(finField, (Object)entry.getDynamicObject(importPropName));
                        continue;
                    }
                    if (importProp instanceof DateProp) {
                        depreUseFinCard.set(finField, (Object)entry.getDate(importPropName));
                        continue;
                    }
                    if (importProp instanceof IntegerProp) {
                        depreUseFinCard.set(finField, (Object)entry.getInt(importPropName));
                        continue;
                    }
                    if (importProp instanceof DecimalProp) {
                        depreUseFinCard.set(finField, (Object)entry.getBigDecimal(importPropName));
                        continue;
                    }
                    if (importProp instanceof BooleanProp) {
                        depreUseFinCard.set(finField, (Object)entry.getBoolean(importPropName));
                        continue;
                    }
                    if (importProp instanceof LongProp) {
                        depreUseFinCard.set(finField, (Object)entry.getLong(importPropName));
                        continue;
                    }
                    depreUseFinCard.set(finField, (Object)entry.getString(importPropName));
                }
                DynamicObjectWrapper objWrapper = new DynamicObjectWrapper(depreUseFinCard);
                FinCardCalc.setNetWorth(objWrapper);
                FinCardCalc.setNetAmount(objWrapper);
                Long periodId = depreUseIdsMap.get(depreuseId);
                int periodNumber = PeriodUtil.getPeriodNumberById(periodId);
                if (periodNumber == 1) {
                    depreUseFinCard.set("addupyeardepre", (Object)0);
                }
                entry.set("fincard", (Object)depreUseFinCard);
                entry.set("fincard_id", (Object)depreUseFinCard.getLong("id"));
            }
        }
    }
}

