/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.dao.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.business.dao.IAssetPolicyDao;
import kd.fi.fa.business.dao.factory.FaAssetCatDaoFactory;
import kd.fi.fa.business.dao.impl.FaBaseDaoOrmImpl;
import kd.fi.fa.business.errorcode.FaErrorCodeUtil;

public class AssetPolicyDaoOrmImpl
extends FaBaseDaoOrmImpl
implements IAssetPolicyDao {
    public AssetPolicyDaoOrmImpl() {
        super("fa_depresystem");
    }

    @Override
    public DynamicObject queryEntryByBookAndCat(Object pk, Object catPK) {
        DynamicObject depresystem = BusinessDataServiceHelper.loadSingleFromCache((Object)pk, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"fa_depresystem"));
        DynamicObjectCollection bookEntries = depresystem.getDynamicObjectCollection("assetpolicy_entry");
        for (DynamicObject bookEntry : bookEntries) {
            long asstcatMasterid = bookEntry.getDynamicObject("assetCat").getLong("masterid");
            DynamicObjectCollection ids = QueryServiceHelper.query((String)"fa_assetcategory", (String)"id", (QFilter[])new QFilter[]{new QFilter("masterid", "=", (Object)asstcatMasterid)});
            ArrayList<Long> idList = new ArrayList<Long>();
            for (DynamicObject idDyn : ids) {
                idList.add(idDyn.getLong("id"));
            }
            if (!idList.contains(catPK)) continue;
            return bookEntry;
        }
        DynamicObject parentCat = FaAssetCatDaoFactory.getInstance().queryParent(catPK);
        if (parentCat != null && !"0".equals(parentCat.getPkValue().toString())) {
            return this.queryEntryByBookAndCat(pk, parentCat.getPkValue());
        }
        throw new KDBizException(FaErrorCodeUtil.create("ASSETBOOK_ERROR", ResManager.loadKDString((String)"\u5f53\u524d\u8d26\u7c3f\u672a\u8bbe\u7f6e\u6b64\u8d44\u4ea7\u7c7b\u522b", (String)"AssetPolicyDaoOrmImpl_0", (String)"fi-fa-business", (Object[])new Object[0])), new Object[0]);
    }

    @Override
    public DynamicObject queryDepreMethodByBookAndCat(Object pk, Object catPK) {
        DynamicObject bookEntry = this.queryEntryByBookAndCat(pk, catPK);
        return bookEntry != null ? bookEntry.getDynamicObject("depremethod") : null;
    }

    @Override
    public Boolean queryIsTaxByBookAndCat(Object pk, Object catPK) {
        DynamicObject bookEntry = this.queryEntryByBookAndCat(pk, catPK);
        return bookEntry != null ? Boolean.valueOf(bookEntry.getBoolean("isallowdeduction")) : null;
    }

    @Override
    public BigDecimal queryNetResidualValRateByBookAndCat(Object pk, Object catPK) {
        DynamicObject bookEntry = this.queryEntryByBookAndCat(pk, catPK);
        return bookEntry != null ? bookEntry.getBigDecimal("netresidualvalrate") : BigDecimal.ZERO;
    }
}

