/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.dao.impl;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.fi.fa.business.dao.impl.IBizSetCardDataHandler;
import kd.fi.fa.business.enums.ClearMethodAccumDepre;
import kd.fi.fa.business.model.FaClearAjustField;
import kd.fi.fa.business.model.FaPartClearValue;
import kd.fi.fa.common.util.Fa;

public class ClearBillAuditHandler
implements IBizSetCardDataHandler {
    private Object periodPK;
    private Map<Long, FaPartClearValue> partClearObjs;
    private Map<Long, FaClearAjustField> clearAllObjs;

    public ClearBillAuditHandler(Object periodPK, Map<Long, FaPartClearValue> partClearObjs, Map<Long, FaClearAjustField> clearAllObjs) {
        this.periodPK = periodPK;
        this.partClearObjs = partClearObjs;
        this.clearAllObjs = clearAllObjs;
    }

    @Override
    public void handle(DynamicObject finCard) {
        Long finCardPk = (Long)finCard.getPkValue();
        if (this.partClearObjs.get(finCardPk) != null) {
            FaPartClearValue fcv = this.partClearObjs.get(finCardPk);
            BigDecimal oldOriginalVal = finCard.getBigDecimal("originalval");
            finCard.set("originalval", (Object)oldOriginalVal.subtract(fcv.getOrginval()));
            finCard.set("accumdepre", (Object)finCard.getBigDecimal("accumdepre").subtract(fcv.getDepreAmount()));
            finCard.set("addupyeardepre", (Object)finCard.getBigDecimal("addupyeardepre"));
            finCard.set("decval", (Object)finCard.getBigDecimal("decval").subtract(fcv.getDeval()));
            finCard.set("netamount", (Object)finCard.getBigDecimal("netamount").subtract(fcv.getNetAmount()));
            finCard.set("preresidualval", (Object)finCard.getBigDecimal("preresidualval").subtract(fcv.getPreresidualval()));
            finCard.set("originalamount", (Object)finCard.getBigDecimal("originalval"));
            finCard.set("networth", (Object)finCard.getBigDecimal("netamount").add(finCard.getBigDecimal("decval")));
            finCard.set(ClearBillAuditHandler.id("clearperiod"), (Object)0L);
            finCard.set("monthorigvalchg", (Object)finCard.getBigDecimal("monthorigvalchg").subtract(fcv.getOrginval()));
            finCard.set("yearorigvalchg", (Object)finCard.getBigDecimal("yearorigvalchg").subtract(fcv.getOrginval()));
            finCard.set("monthdeprechg", (Object)finCard.getBigDecimal("monthdeprechg").subtract(fcv.getDeval()));
            finCard.set("monthaccumdeprechg", (Object)finCard.getBigDecimal("monthaccumdeprechg").subtract(fcv.getDepreAmount()));
            Boolean isadjustdepre = fcv.getIsadjustdepre();
            if (isadjustdepre.booleanValue()) {
                finCard.set("monthdepre", (Object)fcv.getMonthadjustdepreforcur());
                finCard.set("isneeddepre", (Object)Boolean.FALSE);
            } else {
                finCard.set("isneeddepre", (Object)Boolean.TRUE);
            }
        } else {
            BigDecimal newNetAmount;
            BigDecimal decVal;
            BigDecimal newNetWorth;
            BigDecimal originalVal;
            BigDecimal oldMonthdepre;
            BigDecimal oldAccumDepre;
            FaClearAjustField fcv = this.clearAllObjs.get(finCardPk);
            finCard.set(ClearBillAuditHandler.id("clearperiod"), this.periodPK);
            BigDecimal ov = finCard.getBigDecimal("originalval");
            BigDecimal curValChg = finCard.getBigDecimal("monthorigvalchg");
            BigDecimal yearValChg = finCard.getBigDecimal("yearorigvalchg");
            BigDecimal curDeChg = finCard.getBigDecimal("monthdeprechg");
            BigDecimal curDeReady = finCard.getBigDecimal("decval");
            BigDecimal monthaccumdeprechgFin = finCard.getBigDecimal("monthaccumdeprechg");
            BigDecimal addupdepre = fcv.getAddupdepre();
            finCard.set("monthorigvalchg", (Object)curValChg.subtract(ov));
            finCard.set("yearorigvalchg", (Object)yearValChg.subtract(ov));
            finCard.set("monthdeprechg", (Object)curDeChg.subtract(curDeReady));
            finCard.set("monthaccumdeprechg", (Object)monthaccumdeprechgFin.subtract(addupdepre));
            Boolean isadjustdepre = fcv.getIsadjustdepre();
            String clearMethod = fcv.getClearMethod();
            if (isadjustdepre.booleanValue()) {
                finCard.set("isneeddepre", (Object)Boolean.FALSE);
                finCard.set("monthdepre", (Object)fcv.getMonthadjustdepreforcur());
                oldAccumDepre = finCard.getBigDecimal("accumdepre");
                oldMonthdepre = finCard.getBigDecimal("monthdepre");
                BigDecimal newAccumDepre = oldAccumDepre.subtract(oldMonthdepre).add(fcv.getMonthadjustdepreforcur());
                finCard.set("accumdepre", (Object)newAccumDepre);
                originalVal = finCard.getBigDecimal("originalval");
                newNetWorth = originalVal.subtract(newAccumDepre);
                finCard.set("networth", (Object)newNetWorth);
                decVal = finCard.getBigDecimal("decval");
                newNetAmount = newNetWorth.subtract(decVal);
                finCard.set("netamount", (Object)newNetAmount);
                int periodnumber = fcv.getClearPeriodNumber();
                if (periodnumber == 1) {
                    finCard.set("addupyeardepre", (Object)fcv.getMonthadjustdepreforcur());
                } else {
                    BigDecimal oldYearDepre = finCard.getBigDecimal("addupyeardepre");
                    finCard.set("addupyeardepre", (Object)oldYearDepre.subtract(oldMonthdepre).add(fcv.getMonthadjustdepreforcur()));
                }
                BigDecimal monthDepreRate = fcv.getMonthadjustdepreforcur().divide(originalVal, 4, RoundingMode.HALF_UP);
                finCard.set("monthdeprerate", (Object)monthDepreRate);
            }
            if (clearMethod.equals(ClearMethodAccumDepre.FIN.name()) || clearMethod.equals(ClearMethodAccumDepre.PRE.name())) {
                finCard.set("isneeddepre", (Object)Boolean.FALSE);
                oldAccumDepre = finCard.getBigDecimal("accumdepre");
                oldMonthdepre = finCard.getBigDecimal("monthdepre");
                finCard.set("accumdepre", (Object)addupdepre);
                BigDecimal monthdepre = addupdepre.subtract(oldAccumDepre.subtract(oldMonthdepre));
                finCard.set("monthdepre", (Object)monthdepre);
                originalVal = finCard.getBigDecimal("originalval");
                newNetWorth = originalVal.subtract(addupdepre);
                finCard.set("networth", (Object)newNetWorth);
                decVal = finCard.getBigDecimal("decval");
                newNetAmount = newNetWorth.subtract(decVal);
                finCard.set("netamount", (Object)newNetAmount);
                BigDecimal oldYearDepre = finCard.getBigDecimal("addupyeardepre");
                int periodnumber = fcv.getClearPeriodNumber();
                if (periodnumber == 1) {
                    finCard.set("addupyeardepre", (Object)monthdepre);
                } else {
                    finCard.set("addupyeardepre", (Object)oldYearDepre.subtract(oldMonthdepre).add(monthdepre));
                }
                BigDecimal monthDepreRate = originalVal.compareTo(new BigDecimal(0)) == 0 ? new BigDecimal(0) : monthdepre.divide(originalVal, 4, RoundingMode.HALF_UP);
                finCard.set("monthdeprerate", (Object)monthDepreRate);
                BigDecimal depredamount = fcv.getDepredamount();
                BigDecimal olddepredamount = finCard.getBigDecimal("depredamount");
                BigDecimal oldMonthDepredamount = finCard.getBigDecimal("addidepreamount");
                finCard.set("depredamount", (Object)depredamount);
                BigDecimal monthDepredamount = depredamount.subtract(olddepredamount.subtract(oldMonthDepredamount));
                finCard.set("addidepreamount", (Object)monthDepredamount);
            } else if (clearMethod.equals(ClearMethodAccumDepre.MERGE.name())) {
                finCard.set("isneeddepre", (Object)Boolean.FALSE);
            }
        }
    }

    private static String id(String str) {
        return Fa.join((String)"_", (String[])new String[]{str, "Id"});
    }

    public Map<Long, FaPartClearValue> getPartClearObjs() {
        return this.partClearObjs;
    }

    public void setPartClearObjs(Map<Long, FaPartClearValue> partClearObjs) {
        this.partClearObjs = partClearObjs;
    }

    public Object getPeriodId() {
        return this.periodPK;
    }

    public void setPeriodId(Object periodId) {
        this.periodPK = periodId;
    }
}

