/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.dao.impl;

import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.fi.fa.business.dao.IFaBizDao;
import kd.fi.fa.business.dao.impl.FaBillDaoOrmImpl;

public class FaBizDaoOrmImpl
extends FaBillDaoOrmImpl
implements IFaBizDao {
    public FaBizDaoOrmImpl(String entityName) {
        super(entityName);
    }

    @Override
    public Object[] queryRealCardByPK(Object pk) {
        ArrayList<Object> realCardPKList = new ArrayList<Object>();
        for (DynamicObject entry : this.queryEntryByPK(pk)) {
            realCardPKList.add(entry.getDynamicObject("realcard").getPkValue());
        }
        return realCardPKList.toArray();
    }

    @Override
    public Object[] queryFinCardByPK(Object pk) {
        ArrayList<Object> finCardPKList = new ArrayList<Object>();
        for (DynamicObject entry : this.queryEntryByPK(pk)) {
            Object finCard = entry.get("fincard");
            if (finCard instanceof DynamicObject) {
                finCardPKList.add(((DynamicObject)finCard).getPkValue());
                continue;
            }
            finCardPKList.add(finCard);
        }
        return finCardPKList.toArray();
    }

    private DynamicObjectCollection queryEntryByPK(Object pk) {
        DynamicObject bill = this.queryOne(pk);
        String entryName = this.getEntryName();
        if (entryName == null) {
            throw new KDBizException(new ErrorCode("UNKNOWN_ERR", String.format(ResManager.loadKDString((String)"\u73b0\u4e0d\u652f\u6301\u3010%s\u3011\u901a\u8fc7\u4e3b\u952e\u67e5\u8be2\u5361\u7247\u5206\u5f55", (String)"FaBizDaoOrmImpl_0", (String)"fi-fa-business", (Object[])new Object[0]), entryName)), new Object[0]);
        }
        DynamicObjectCollection entryCol = bill.getDynamicObjectCollection(entryName);
        return entryCol;
    }

    private String getEntryName() {
        switch (this.entityName) {
            case "fa_change_dept": {
                return "realentry";
            }
            case "fa_clearapplybill": {
                return "clrapplybill_entry";
            }
            case "fa_clearbill": {
                return "detail_entry";
            }
            case "fa_dispatch": 
            case "fa_dispatch_in": {
                return "dispatchentry";
            }
            case "fa_recalculate": {
                return "recalculateentry";
            }
            case "fa_assetsplitbill": {
                return "assetsplitentry";
            }
        }
        return null;
    }
}

