/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.dao.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.validate.BillStatus;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.fi.fa.business.FaCopyFinCardDao.FaCopyFinCardService;
import kd.fi.fa.business.SourceFlagEnum;
import kd.fi.fa.business.dao.IFaFinCardDao;
import kd.fi.fa.business.dao.factory.FaAssetBookDaoFactory;
import kd.fi.fa.business.dao.factory.FaRealCardDaoFactory;
import kd.fi.fa.business.dao.impl.ClearBillAuditHandler;
import kd.fi.fa.business.dao.impl.ClearBillUnAuditHandler;
import kd.fi.fa.business.dao.impl.FaBillDaoOrmImpl;
import kd.fi.fa.business.dao.impl.IBizSetCardDataHandler;
import kd.fi.fa.business.depretask.DepreSplitSum;
import kd.fi.fa.business.model.FaPartClearValue;
import kd.fi.fa.business.utils.FaAssetCardFinEntryOriginalFinUtils;
import kd.fi.fa.business.utils.FaCardVersionUtils;
import kd.fi.fa.business.utils.FaCommonUtils;
import kd.fi.fa.business.utils.FaConstants;
import kd.fi.fa.business.utils.FaDepreUtil;
import kd.fi.fa.business.utils.PeriodUtil;
import kd.fi.fa.common.util.Fa;

public class FaFinCardDaoOrmImpl
extends FaBillDaoOrmImpl
implements IFaFinCardDao {
    private static final Log logger = LogFactory.getLog(FaFinCardDaoOrmImpl.class);
    protected static final String[] UPDATE_ORIGINALVAL_FIELDS = new String[]{"id", "originalval", "preresidualval", "networth", "netamount"};
    public static final String[] ID_REALCARD_BIZPERIOD = new String[]{"period", "id", "realcard", FaFinCardDaoOrmImpl.dot("realcard", "masterid"), "bizperiod", "depreuse", "org", "realcardmasterid"};
    protected static final String[] FIN_CARD_SELECTOR = new String[]{"realcard", "endperiod", "isneeddepre", "depreuse", "bizperiod", "assetbook", "decval", "depredept", "clearperiod", "accumdepre", "netamount", "addupyeardepre", "originalamount", "networth", "preresidualval", "assetcat", "monthdepre", "monthdeprerate", "depredamount", "addidepreamount", "monthdeprechg", "monthaccumdeprechg", "realcardmasterid", "originalval", "monthorigvalchg", "yearorigvalchg", "restartaddeddepre", "restartdepreamount"};

    public FaFinCardDaoOrmImpl() {
        super("fa_card_fin");
    }

    public FaFinCardDaoOrmImpl(String entityName) {
        super(entityName);
    }

    @Override
    public Map<Long, Map<Long, Long>> copyFinCards(long periodId, long depreuseId, Object[] realCardPKs, IBizSetCardDataHandler handler, String[] selector, Map<Object, Object> realCardIdMap) {
        if (realCardPKs.length == 0) {
            return new HashMap<Long, Map<Long, Long>>();
        }
        QFilter filterReal = new QFilter("id", "in", (Object)realCardPKs);
        DynamicObjectCollection realMasterList = QueryServiceHelper.query((String)"fa_card_real", (String)"masterid", (QFilter[])filterReal.toArray());
        HashSet<Long> masterIdSet = new HashSet<Long>(realMasterList.size(), 1.0f);
        for (DynamicObject realDy : realMasterList) {
            masterIdSet.add(realDy.getLong("masterid"));
        }
        QFilter filter = new QFilter("realcardmasterid", "in", masterIdSet).and(new QFilter("endperiod", ">", (Object)periodId));
        if (periodId > 0L) {
            DynamicObject period = QueryServiceHelper.queryOne((String)"bd_period", (String)"enddate", (QFilter[])new QFilter("id", "=", (Object)periodId).toArray());
            Date endDate = period.getDate("enddate");
            filter = filter.and(new QFilter("finaccountdate", "<=", (Object)endDate));
        }
        if (depreuseId > 0L) {
            filter = filter.and(new QFilter("depreuse", "=", (Object)depreuseId));
        }
        DynamicObject[] finCards = BusinessDataServiceHelper.load((String)this.entityName, (String)Fa.join((Object[])ID_REALCARD_BIZPERIOD, (String)","), (QFilter[])filter.toArray());
        return this.copyFinCards(periodId, depreuseId, finCards, handler, selector, realCardIdMap, false);
    }

    @Override
    public Map<Long, Map<Long, Long>> copyFinCards(Long orgId, long assetBookId, long depreuseId, long periodId, Set<String> numberSet, IBizSetCardDataHandler handler, String[] selector, Map<Object, Object> realCardIdMap) {
        if (numberSet.size() == 0) {
            return new HashMap<Long, Map<Long, Long>>();
        }
        QFilter filter = new QFilter("org", "=", (Object)orgId).and(new QFilter("depreuse", "=", (Object)depreuseId)).and(new QFilter("endperiod", ">", (Object)periodId)).and(new QFilter("number", "in", numberSet));
        if (periodId > 0L) {
            DynamicObject period = QueryServiceHelper.queryOne((String)"bd_period", (String)"enddate", (QFilter[])new QFilter("id", "=", (Object)periodId).toArray());
            Date endDate = period.getDate("enddate");
            filter = filter.and(new QFilter("finaccountdate", "<=", (Object)endDate));
        }
        DynamicObject[] finCards = BusinessDataServiceHelper.load((String)this.entityName, (String)Fa.join((Object[])ID_REALCARD_BIZPERIOD, (String)","), (QFilter[])filter.toArray());
        return this.copyFinCards(periodId, depreuseId, finCards, handler, selector, realCardIdMap, false);
    }

    private Map<Long, Map<Long, Long>> copyFinCards(long periodId, long depreuseId, DynamicObject[] finCards, IBizSetCardDataHandler handler, String[] selector, Map<Object, Object> realCardIdMap, Boolean isResetClear) {
        HashSet<Long> cpCardIdSet = new HashSet<Long>();
        HashSet<Long> npCardIdSet = new HashSet<Long>();
        HashSet<Long> ppCardIdSet = new HashSet<Long>();
        HashMap<Long, Map<Long, Long>> mainRealID2FinID = new HashMap<Long, Map<Long, Long>>();
        Arrays.sort(finCards, (a, b) -> Long.compare(a.getLong(FaFinCardDaoOrmImpl.id("bizperiod")), b.getLong(FaFinCardDaoOrmImpl.id("bizperiod"))));
        HashSet<Long> npCardMasterIdSet = new HashSet<Long>(finCards.length);
        for (DynamicObject finCard : finCards) {
            Map<Long, Long> depreUse2FinID;
            if (finCard.getLong(FaFinCardDaoOrmImpl.id("bizperiod")) > periodId) {
                npCardIdSet.add(finCard.getLong("id"));
                npCardMasterIdSet.add(finCard.getLong("realcardmasterid"));
            } else if (finCard.getLong(FaFinCardDaoOrmImpl.id("bizperiod")) == periodId) {
                cpCardIdSet.add(finCard.getLong("id"));
            } else {
                ppCardIdSet.add(finCard.getLong("id"));
            }
            long realID = finCard.getLong("realcardmasterid");
            if (mainRealID2FinID.get(realID) == null) {
                depreUse2FinID = new HashMap();
                mainRealID2FinID.put(realID, depreUse2FinID);
            } else {
                depreUse2FinID = (Map)mainRealID2FinID.get(realID);
            }
            depreUse2FinID.put(finCard.getLong(FaFinCardDaoOrmImpl.id("depreuse")), finCard.getLong("id"));
        }
        this.newFinCards(ppCardIdSet.toArray(), periodId);
        this.updateNewMainCard(ppCardIdSet.toArray(), periodId, handler);
        if (realCardIdMap != null && realCardIdMap.size() > 0) {
            this.updateRefRCard(periodId, depreuseId, finCards, realCardIdMap);
        }
        HashMap<Long, Map<Long, Long>> realID2mainIDMap = new HashMap<Long, Map<Long, Long>>();
        logger.info("npCardIdSet.isEmpty() " + npCardIdSet);
        if (!npCardIdSet.isEmpty()) {
            DynamicObject[] futureFinCards;
            for (DynamicObject fuCard : futureFinCards = BusinessDataServiceHelper.load((String)this.entityName, (String)Fa.join((Object[])ID_REALCARD_BIZPERIOD, (String)","), (QFilter[])new QFilter[]{new QFilter("id", "in", npCardIdSet), new QFilter("endperiod", "=", (Object)99999999999L)})) {
                Map<Long, Long> depreUse2FinID;
                long realID = fuCard.getLong("realcardmasterid");
                if (realID2mainIDMap.get(realID) == null) {
                    depreUse2FinID = new HashMap();
                    realID2mainIDMap.put(realID, depreUse2FinID);
                } else {
                    depreUse2FinID = (Map)realID2mainIDMap.get(realID);
                }
                depreUse2FinID.put(fuCard.getDynamicObject("depreuse").getLong("id"), fuCard.getLong("id"));
            }
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"fa_card_fin"), (Object[])npCardIdSet.toArray());
            logger.info("DeleteServiceHelper.delete npCardIdSet success" + npCardIdSet);
        }
        if (!isResetClear.booleanValue()) {
            if (!cpCardIdSet.isEmpty()) {
                this.updateCurrPeriodCard(cpCardIdSet.toArray(), handler, selector, realID2mainIDMap);
            }
            if (!ppCardIdSet.isEmpty()) {
                this.updateCurrPeriodCard(ppCardIdSet.toArray(), handler, selector, realID2mainIDMap);
            }
        } else {
            ClearBillUnAuditHandler clearHandler;
            Map<Long, FaPartClearValue> partClearObj;
            Set<Long> finCardIds = new HashSet<Long>();
            finCardIds.addAll(cpCardIdSet);
            if (handler instanceof ClearBillUnAuditHandler && (partClearObj = (clearHandler = (ClearBillUnAuditHandler)handler).getPartClearObjs()) != null && partClearObj.size() > 0) {
                finCardIds = finCardIds.stream().filter(id -> partClearObj.containsKey(id)).collect(Collectors.toSet());
            }
            this.updateCurrPeriodCard(finCardIds.toArray(), handler, selector, realID2mainIDMap);
        }
        new DepreSplitSum().deduct(finCards, false, false);
        if (npCardMasterIdSet.size() > 0) {
            this.resetFutureChange(periodId, npCardMasterIdSet);
        }
        return mainRealID2FinID;
    }

    private void resetFutureChange(long periodId, Set<Long> npCardMasterIdSet) {
        QFilter[] filters;
        String selectFields = Fa.comma((String[])new String[]{"id", "changebillid", "isgenfin"});
        DynamicObject[] futureChgFinRelArr = BusinessDataServiceHelper.load((String)"fa_future_chg_fin_rel", (String)selectFields, (QFilter[])(filters = new QFilter[]{new QFilter("masterid", "in", npCardMasterIdSet), new QFilter("chgdateperiod", ">", (Object)periodId), new QFilter("isgenfin", "=", (Object)"1"), new QFilter("isdeleted", "=", (Object)"0")}));
        if (futureChgFinRelArr.length == 0) {
            return;
        }
        HashSet<Long> changeIdSet = new HashSet<Long>(8);
        for (DynamicObject futureChgFinRel : futureChgFinRelArr) {
            futureChgFinRel.set("isgenfin", (Object)"0");
            changeIdSet.add(futureChgFinRel.getLong("changebillid"));
        }
        SaveServiceHelper.save((DynamicObject[])futureChgFinRelArr);
        String selectChangeFields = Fa.comma((String[])new String[]{"id", Fa.dot((String[])new String[]{"realentry", "finentry"}), Fa.dot((String[])new String[]{"realentry", "finentry", "bf_fin_info"}), Fa.dot((String[])new String[]{"realentry", "finentry", "af_fin_info"})});
        QFilter[] changeFilters = new QFilter[]{new QFilter("id", "in", changeIdSet)};
        DynamicObjectCollection changeArr = QueryServiceHelper.query((String)"fa_change_dept", (String)selectChangeFields, (QFilter[])changeFilters);
        ArrayList<Long> changeBackCards = new ArrayList<Long>(changeIdSet.size() * 2);
        ArrayList<Long> finEntryIdList = new ArrayList<Long>(changeIdSet.size() * 2);
        for (DynamicObject bill : changeArr) {
            Long aftFinInfoId;
            Long bfFinInfoId = bill.getLong(Fa.dot((String[])new String[]{"realentry", "finentry", "bf_fin_info"}));
            if (bfFinInfoId != null && bfFinInfoId != 0L) {
                changeBackCards.add(bfFinInfoId);
            }
            if ((aftFinInfoId = Long.valueOf(bill.getLong(Fa.dot((String[])new String[]{"realentry", "finentry", "af_fin_info"})))) != null && aftFinInfoId != 0L) {
                changeBackCards.add(aftFinInfoId);
            }
            if ((bfFinInfoId == null || bfFinInfoId == 0L) && (aftFinInfoId == null || aftFinInfoId == 0L)) continue;
            finEntryIdList.add(bill.getLong(Fa.dot((String[])new String[]{"realentry", "finentry"})));
        }
        if (finEntryIdList.size() > 0) {
            SqlBuilder sb = new SqlBuilder();
            sb.append("update t_fa_changebillfinentry set ", new Object[0]).append("fbeforefininfo = 0,fafterfininfo = 0", new Object[0]).append(" where ", new Object[0]).appendIn("FDetailID", finEntryIdList.toArray());
            DB.update((DBRoute)FaConstants.faDBRoute, (SqlBuilder)sb);
        }
        if (changeBackCards.size() > 0) {
            DeleteServiceHelper.delete((IDataEntityType)MetadataServiceHelper.getDataEntityType((String)"fa_changebak_fin"), (Object[])changeBackCards.toArray());
        }
    }

    private void updateRefRCard(long periodId, long depreuseId, DynamicObject[] finCards, Map<Object, Object> realCardIdMap) {
        Set<Map.Entry<Object, Object>> mapSet = realCardIdMap.entrySet();
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        ArrayList<Object[]> changeBakParams = new ArrayList<Object[]>(realCardIdMap.size());
        for (Map.Entry<Object, Object> entry : mapSet) {
            Object value = entry.getValue();
            if (value == null || value.toString().equals("0")) {
                throw new KDBizException(ResManager.loadKDString((String)"FaFinCardDaoOrmImpl#copyFinCards: \u96be\u4ee5\u8ddf\u8e2a\u7684bug\u51fa\u73b0\u4e86\uff0c\u8bf7\u6682\u505c\u64cd\u4f5c\u4fdd\u7559\u6570\u636e\uff0c\u8bb0\u4f4f\u4ea7\u751f\u6b64\u9519\u8bef\u7684\u64cd\u4f5c\u5e76\u8054\u7cfb\u7ba1\u7406\u5458", (String)"FaFinCardDaoOrmImpl_0", (String)"fi-fa-business", (Object[])new Object[0]));
            }
            if (depreuseId > 0L) {
                params.add(new Object[]{value, periodId, entry.getKey(), depreuseId});
            } else {
                params.add(new Object[]{value, periodId, entry.getKey()});
            }
            changeBakParams.add(new Object[]{value, entry.getKey()});
        }
        if (params != null && params.size() > 0) {
            int paramLen = ((Object[])params.get(0)).length;
            if (paramLen == 4) {
                DB.executeBatch((DBRoute)DBRoute.of((String)"fa"), (String)"update t_fa_card_fin set FREALCARDID =?  where fbizperiodid<? and FREALCARDID = ? and FDEPREUSEID = ?", params);
                DB.executeBatch((DBRoute)DBRoute.of((String)"fa"), (String)"update t_fa_depresplitdetail set FREALCARDID =?  where fperiodid<? and FREALCARDID = ? and FDEPREUSEID = ?", params);
                DB.executeBatch((DBRoute)DBRoute.of((String)"fa"), (String)"update t_fa_depredetailentry set frealcardid =?  where fperiodid<? and FREALCARDID = ? and FDEPREUSEID = ?", params);
            } else {
                DB.executeBatch((DBRoute)DBRoute.of((String)"fa"), (String)"update t_fa_card_fin set FREALCARDID =?  where fbizperiodid<? and FREALCARDID = ? ", params);
                DB.executeBatch((DBRoute)DBRoute.of((String)"fa"), (String)"update t_fa_depresplitdetail set FREALCARDID =?  where fperiodid<? and FREALCARDID = ? ", params);
                DB.executeBatch((DBRoute)DBRoute.of((String)"fa"), (String)"update t_fa_depredetailentry set frealcardid =?  where fperiodid<? and FREALCARDID = ? ", params);
            }
        }
        if (!changeBakParams.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"fa"), (String)"update t_fa_changebak_fin set FREALCARDID = ?  where FREALCARDID = ? ", changeBakParams);
            DB.executeBatch((DBRoute)DBRoute.of((String)"fa"), (String)"update t_fa_merge_in set finrealcardbak = ?  where finrealcardbak = ? ", changeBakParams);
        }
        FaDepreUtil.updateRefRCard4CurPeriodSplitDetail(periodId, realCardIdMap);
    }

    @Override
    public Map<Long, Map<Long, Long>> restoreCard(long periodId, long depureId, Object[] realCardPKs, IBizSetCardDataHandler handler, String[] selector) {
        return this.restoreCard(periodId, depureId, realCardPKs, handler, selector, false);
    }

    public Map<Long, Map<Long, Long>> restoreCard(Long periodId, Long depureId, Object[] realCardPKs, IBizSetCardDataHandler handler, String[] selector, Boolean isResetClear) {
        if (realCardPKs.length == 0) {
            return null;
        }
        String fields = Fa.join((Object[])ID_REALCARD_BIZPERIOD, (String)",");
        QFilter filter = new QFilter("realcardmasterid", "in", (Object)realCardPKs);
        filter.and(new QFilter("endperiod", ">", (Object)periodId));
        if (depureId > 0L) {
            filter.and(new QFilter("depreuse", "=", (Object)depureId));
        }
        DynamicObject[] finCards = BusinessDataServiceHelper.load((String)this.entityName, (String)fields, (QFilter[])filter.toArray());
        HashSet<Long> npdFinCardIdSet = new HashSet<Long>();
        HashSet<Long> cpdFinCardIdSet = new HashSet<Long>();
        HashSet<Long> npCardMasterIdSet = new HashSet<Long>(finCards.length);
        HashSet<Long> ppCardIdSet = new HashSet<Long>(finCards.length);
        for (DynamicObject dynamicObject : finCards) {
            long bizPeriodId = dynamicObject.getLong(FaFinCardDaoOrmImpl.id("bizperiod"));
            long recordPeriodId = dynamicObject.getLong(FaFinCardDaoOrmImpl.id("period"));
            if (bizPeriodId == periodId) {
                cpdFinCardIdSet.add(dynamicObject.getLong("id"));
                continue;
            }
            if (bizPeriodId > periodId) {
                if (bizPeriodId <= recordPeriodId) continue;
                npdFinCardIdSet.add(dynamicObject.getLong("id"));
                npCardMasterIdSet.add(dynamicObject.getLong("realcardmasterid"));
                continue;
            }
            ppCardIdSet.add(dynamicObject.getLong("id"));
        }
        if (ppCardIdSet.size() > 0) {
            this.newFinCards(ppCardIdSet.toArray(), periodId);
            this.updateNewMainCard(ppCardIdSet.toArray(), periodId, handler);
        }
        HashMap<Long, Map<Long, Long>> realID2mainIDMap = new HashMap<Long, Map<Long, Long>>();
        if (!npdFinCardIdSet.isEmpty()) {
            DynamicObject[] futureFinCards;
            QFilter[] filters = new QFilter[]{new QFilter("id", "in", npdFinCardIdSet), new QFilter("endperiod", "=", (Object)99999999999L)};
            for (DynamicObject fuCard : futureFinCards = BusinessDataServiceHelper.load((String)this.entityName, (String)fields, (QFilter[])filters)) {
                Map<Long, Long> depreUse2FinID;
                long realID = fuCard.getLong("realcardmasterid");
                if (realID2mainIDMap.get(realID) == null) {
                    depreUse2FinID = new HashMap();
                    realID2mainIDMap.put(realID, depreUse2FinID);
                } else {
                    depreUse2FinID = (Map)realID2mainIDMap.get(realID);
                }
                depreUse2FinID.put(fuCard.getDynamicObject("depreuse").getLong("id"), fuCard.getLong("id"));
            }
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"fa_card_fin"), (Object[])npdFinCardIdSet.toArray());
        }
        if (isResetClear.booleanValue()) {
            ClearBillAuditHandler clearHandler;
            Map<Long, FaPartClearValue> map;
            Set<Long> finCardIds = new HashSet<Long>();
            finCardIds.addAll(cpdFinCardIdSet);
            if (handler instanceof ClearBillAuditHandler && (map = (clearHandler = (ClearBillAuditHandler)handler).getPartClearObjs()) != null && map.size() > 0) {
                finCardIds = finCardIds.stream().filter(id -> partClearObj.containsKey(id)).collect(Collectors.toSet());
            }
            this.updateCurrPeriodCard(finCardIds.toArray(), handler, selector, realID2mainIDMap);
        } else {
            if (!cpdFinCardIdSet.isEmpty()) {
                this.updateCurrPeriodCard(cpdFinCardIdSet.toArray(), handler, selector, realID2mainIDMap);
            }
            if (!ppCardIdSet.isEmpty()) {
                this.updateCurrPeriodCard(ppCardIdSet.toArray(), handler, selector, realID2mainIDMap);
            }
        }
        new DepreSplitSum().deduct(finCards, false, false);
        if (npCardMasterIdSet.size() > 0) {
            this.resetFutureChange(periodId, npCardMasterIdSet);
        }
        return realID2mainIDMap;
    }

    private Map<Object, Object> newFinCards(Object[] pks, Object periodPK) {
        if (pks.length == 0) {
            return new HashMap<Object, Object>(0);
        }
        DynamicObject[] cards = BusinessDataServiceHelper.load((Object[])pks, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fa_card_fin"));
        if (cards.length == 0) {
            return new HashMap<Object, Object>(0);
        }
        DynamicObject[] finCards = new DynamicObject[cards.length];
        int length = cards.length;
        HashMap<Long, DynamicObject> finCardMap = new HashMap<Long, DynamicObject>(length);
        HashMap<Object, Object> onFinCardIdMap = new HashMap<Object, Object>(length);
        FaCopyFinCardService copycard = new FaCopyFinCardService(true, true);
        HashSet<Long> masterIdSet = new HashSet<Long>(cards.length);
        for (DynamicObject finCard : cards) {
            masterIdSet.add(finCard.getLong("realcard.masterid"));
        }
        Map<Long, List<DynamicObject>> masterId2DyMap = FaCardVersionUtils.getCardVerisons2(masterIdSet);
        LinkedList<DynamicObject> toSaveFinList = new LinkedList<DynamicObject>();
        HashMap<String, DynamicObject> orgIdDepreUseId2Period = new HashMap<String, DynamicObject>(8);
        HashMap<Object, Object> initOriginalCopyMap = new HashMap<Object, Object>(length);
        long[] copyFinIds = DBServiceHelper.genLongIds((String)"t_fa_card_fin", (int)length);
        for (int i = 0; i < length; ++i) {
            DynamicObject maxNewCard = cards[i];
            DynamicObject bakCard = copycard.clone(cards[i]);
            bakCard.set(FaFinCardDaoOrmImpl.id("endperiod"), periodPK);
            bakCard.set("createtime", (Object)new Date());
            finCards[i] = bakCard;
            long finRealID = cards[i].getLong(FaFinCardDaoOrmImpl.id("realcard"));
            bakCard.set("id", (Object)copyFinIds[i]);
            finCardMap.put(finRealID, bakCard);
            long bizPeriodId = bakCard.getLong(FaFinCardDaoOrmImpl.id("bizperiod"));
            if (bizPeriodId == 0L) {
                initOriginalCopyMap.put(bakCard.getPkValue(), maxNewCard.getPkValue());
            }
            Long masterId = maxNewCard.getLong("realcard.masterid");
            Long realCardId = maxNewCard.getLong("realcard.id");
            Long orgId = maxNewCard.getLong("org.id");
            Long depreUseId = maxNewCard.getLong("depreuse.id");
            DynamicObject targetPeriod = (DynamicObject)orgIdDepreUseId2Period.get(orgId + "_" + depreUseId);
            if (targetPeriod == null) {
                targetPeriod = PeriodUtil.getBdPeriod((Long)periodPK);
                orgIdDepreUseId2Period.put(orgId + "_" + depreUseId, targetPeriod);
            }
            DynamicObject cardVersion2 = FaCardVersionUtils.getTargetCardVersion2(orgId, masterId, targetPeriod, masterId2DyMap);
            if (realCardId.longValue() == masterId.longValue() && cardVersion2 != null) {
                Long bakRealcardId = cardVersion2.getLong("aftrealcard");
                bakCard.set(FaFinCardDaoOrmImpl.id("realcard"), (Object)bakRealcardId);
                copycard.updateFinRealIdMap(cards[i].getLong("id"), bakRealcardId);
            }
            if (cardVersion2 != null) {
                Long targetRealcardId = cardVersion2.getLong("aftrealcard");
                maxNewCard.set(FaFinCardDaoOrmImpl.id("realcard"), (Object)targetRealcardId);
            }
            toSaveFinList.add(maxNewCard);
        }
        copycard.saveService(finCards);
        if (toSaveFinList.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])cards);
        }
        if (!initOriginalCopyMap.isEmpty()) {
            FaAssetCardFinEntryOriginalFinUtils.updateOriginal4OriginalId(initOriginalCopyMap);
        }
        for (Map.Entry set : finCardMap.entrySet()) {
            onFinCardIdMap.put(set.getKey(), ((DynamicObject)set.getValue()).getPkValue());
        }
        return onFinCardIdMap;
    }

    private void updateCurrPeriodCard(Object[] pks, IBizSetCardDataHandler handler, String[] selector, Map<Long, Map<Long, Long>> realID2mainIDMap) {
        if (pks.length == 0) {
            return;
        }
        Object[] sel = FIN_CARD_SELECTOR;
        if (selector != null) {
            sel = Arrays.copyOf(FIN_CARD_SELECTOR, FIN_CARD_SELECTOR.length + selector.length);
            System.arraycopy(selector, 0, sel, FIN_CARD_SELECTOR.length, selector.length);
        }
        DynamicObjectType type = this.getSubEntityType("fa_card_fin", Fa.join((Object[])sel, (String)","));
        DynamicObject[] cards = BusinessDataReader.load((Object[])pks, (DynamicObjectType)type, (Boolean)true);
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (DynamicObject card : cards) {
            Long mainFinCardID;
            Map<Long, Long> depreUse2FinID;
            card.set(FaFinCardDaoOrmImpl.id("endperiod"), (Object)99999999999L);
            if (realID2mainIDMap != null && (depreUse2FinID = realID2mainIDMap.get(card.getLong("realcardmasterid"))) != null && (mainFinCardID = depreUse2FinID.get(card.getLong(FaFinCardDaoOrmImpl.id("depreuse")))) != null) {
                Object[] param = new Object[]{mainFinCardID, card.getLong("id")};
                params.add(param);
            }
            if (handler != null) {
                handler.handle(card);
            }
            this.copyRedundantFields(card);
        }
        SaveServiceHelper.save((DynamicObject[])cards);
        if (params.size() > 0) {
            int[] result = DB.executeBatch((DBRoute)DBRoute.of((String)"fa"), (String)"update t_fa_card_fin set fid =? where fid = ?", params);
            logger.info("FaFinCardDaoOrmImpl -> update t_fa_card_fin\uff1a" + result.length);
            int[] result2 = DB.executeBatch((DBRoute)DBRoute.of((String)"fa"), (String)"update t_fa_card_fin_i set fid =? where fid = ?", params);
            logger.info("FaFinCardDaoOrmImpl -> update t_fa_card_fin_i\uff1a" + result2.length);
        }
    }

    private void copyRedundantFields(DynamicObject finCard) {
        finCard.set("depredept", finCard.get(FaFinCardDaoOrmImpl.dot("realcard", "headusedept")));
        finCard.set("assetcat", finCard.get(FaFinCardDaoOrmImpl.dot("realcard", "assetcat")));
    }

    private DynamicObjectType getSubEntityType(String entityName, String selectProperties) {
        String[] properties = selectProperties.split(",");
        HashSet select = new HashSet(properties.length);
        Collections.addAll(select, properties);
        return EntityMetadataCache.getSubDataEntityType((String)entityName, select);
    }

    private void updateNewMainCard(Object[] pks, Object periodPK, IBizSetCardDataHandler handler) {
        DynamicObject[] dbobjs;
        if (pks.length == 0) {
            return;
        }
        DynamicObject period = QueryServiceHelper.queryOne((String)"bd_period", (String)"periodnumber", (QFilter[])new QFilter("id", "=", periodPK).toArray());
        for (DynamicObject card : dbobjs = BusinessDataServiceHelper.load((Object[])pks, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fa_card_fin"))) {
            card.set(FaFinCardDaoOrmImpl.id("bizperiod"), periodPK);
            card.set(FaFinCardDaoOrmImpl.id("endperiod"), (Object)99999999999L);
            card.set("monthorigvalchg", (Object)BigDecimal.ZERO);
            card.set("monthdeprechg", (Object)BigDecimal.ZERO);
            card.set("monthdepre", (Object)BigDecimal.ZERO);
            card.set("monthdeprerate", (Object)BigDecimal.ZERO);
            card.set("addidepreamount", (Object)BigDecimal.ZERO);
            card.set("monthaccumdeprechg", (Object)BigDecimal.ZERO);
            card.set("isneeddepre", (Object)"1");
            if (period == null || period.getInt("periodnumber") != 1) continue;
            card.set("yearorigvalchg", (Object)BigDecimal.ZERO);
            card.set("addupyeardepre", (Object)BigDecimal.ZERO);
        }
        SaveServiceHelper.save((DynamicObject[])dbobjs);
    }

    @Override
    public boolean updateOriginalVal(DynamicObject dobj) {
        DynamicObject dbobj = this.dao.generateDynamicObject(dobj, Fa.join((Object[])UPDATE_ORIGINALVAL_FIELDS, (String)","));
        FaCommonUtils.copyField(dbobj, dobj, UPDATE_ORIGINALVAL_FIELDS);
        return this.dao.updateOne(dbobj);
    }

    @Override
    public boolean updatePeriod(DynamicObject dobj) {
        Object[] fieldArray = new String[]{"id", "preusingamount"};
        String field = Fa.join((Object[])fieldArray, (String)",");
        DynamicObject dbobj = this.dao.generateDynamicObject(dobj, field);
        FaCommonUtils.copyField(dbobj, dobj, (String[])fieldArray);
        return this.dao.updateOne(dbobj);
    }

    @Override
    public DynamicObject queryMainByRealCard(Object realCardPK) {
        DynamicObject book = FaAssetBookDaoFactory.getInstance().queryMainBookByRealCard(realCardPK);
        return this.queryByRealCard(realCardPK, book.getPkValue());
    }

    @Override
    public DynamicObject[] queryByRealCard(Object realCardPK) {
        QFilter[] filters = new QFilter[]{new QFilter("realcard", "=", realCardPK)};
        return this.dao.query(filters);
    }

    @Override
    public DynamicObject[] queryByRealMasterId(Object realCardPK) {
        QFilter[] filters = new QFilter[]{new QFilter("realcardmasterid", "=", realCardPK)};
        return this.dao.query(filters);
    }

    @Override
    public DynamicObject queryByRealCard(Object realCardPK, Object bookPK) {
        QFilter[] filters = new QFilter[]{new QFilter("realcard", "=", realCardPK), new QFilter("assetbook", "=", bookPK)};
        return this.dao.queryOne(filters);
    }

    @Override
    public boolean isExistAuditedByRealCard(Object realCardPK) {
        DynamicObject[] dobjs = this.queryByRealCard(realCardPK, BillStatus.C);
        return dobjs == null || dobjs.length == 0;
    }

    @Override
    public boolean isExistAuditedBySrcNumber(Long orgId, Object srcNumber, Set<String> realNumbers) {
        DynamicObject[] realCards = FaRealCardDaoFactory.getInstance().queryCardBySrcNumber(orgId, srcNumber, realNumbers);
        Object[] realCardPKs = new Object[realCards.length];
        for (int idx = 0; idx < realCardPKs.length; ++idx) {
            realCardPKs[idx] = realCards[idx].getPkValue();
        }
        QFilter[] filters = new QFilter[]{new QFilter("realcard", "in", (Object)realCardPKs), new QFilter("billstatus", "=", (Object)BillStatus.C.toString())};
        return this.isExist(filters);
    }

    @Override
    public int deleteByFilter(QFilter[] filters) {
        if (this.isExist(filters)) {
            DynamicObject[] finCards = this.dao.query(filters);
            List<DynamicObject> finCardList = Arrays.asList(finCards);
            List finCardIdLst = finCardList.stream().filter(v -> BillStatus.C.name().equals(v.getString("billstatus"))).map(v -> v.getLong("id")).collect(Collectors.toList());
            return this.dao.deleteByFilter(filters);
        }
        return 0;
    }

    private DynamicObject[] queryByRealCard(Object realCardPK, BillStatus billStatus) {
        QFilter[] filters = new QFilter[]{new QFilter("realcard", "=", realCardPK), new QFilter("billstatus", "=", (Object)billStatus.name())};
        return this.dao.query(filters);
    }

    @Override
    public Optional<String> checkExistInitCardUnAudited(Object org, Object asstBook) {
        SqlBuilder sql = new SqlBuilder();
        sql.append("select a.fassetname, a.fsourceflag from t_fa_card_real a left join t_fa_card_fin b on a.fid = b.frealcardid", new Object[0]);
        sql.append(" and b.fassetbookid = ?", new Object[]{asstBook});
        sql.append(" and b.fbillstatus != 'C'", new Object[0]);
        sql.append(" and b.fbizperiodid = 0", new Object[0]);
        sql.append(" where a.forgid = ?", new Object[]{org});
        sql.append(" and a.fisinitialcard = '1' and a.foriginaldata = '1' and a.fjustrealcard = '0' and a.fbizstatus = 'ADD'", new Object[0]);
        DataSet dataSet = DB.queryDataSet((String)"closeInitCheckInitRealCard", (DBRoute)DBRoute.of((String)"fa"), (SqlBuilder)sql);
        HashSet<String> sourceFlags = new HashSet<String>(2);
        HashMap<String, String> assetName2SourceFlag = new HashMap<String, String>(4);
        if (dataSet.hasNext()) {
            while (dataSet.hasNext()) {
                Row next = dataSet.next();
                sourceFlags.add(next.getString("fsourceflag"));
                assetName2SourceFlag.put(next.getString("fassetname"), next.getString("fsourceflag"));
            }
            boolean isMainBook = true;
            if (sourceFlags.contains(SourceFlagEnum.INITLEASECONTRACT.name())) {
                isMainBook = QueryServiceHelper.exists((String)"fa_assetbook", (QFilter[])new QFilter[]{new QFilter("id", "=", asstBook), new QFilter("ismainbook", "=", (Object)true)});
            }
            StringBuilder names = new StringBuilder();
            for (Map.Entry entry : assetName2SourceFlag.entrySet()) {
                String value = (String)entry.getValue();
                if (SourceFlagEnum.INITLEASECONTRACT.name().equals(value) && !isMainBook) continue;
                if (names.length() > 0) {
                    names.append("\uff0c");
                }
                names.append((String)entry.getKey());
            }
            if (StringUtils.isEmpty((String)names.toString())) {
                return Optional.empty();
            }
            return Optional.of(names.toString());
        }
        return Optional.empty();
    }

    @Override
    public Map<Long, Long> findOriIdFinIdMap(Set<Object> realMasterIds, Long depreUserId) {
        HashMap<Long, Long> idRelationMap = new HashMap<Long, Long>(realMasterIds.size());
        if (CollectionUtils.isEmpty(realMasterIds)) {
            return idRelationMap;
        }
        SqlBuilder queryFinEntrySql = new SqlBuilder();
        queryFinEntrySql.append("select a.ffincardid,a.foriginalfincardid from t_fa_asset_finentry a left join t_fa_card_fin b on a.ffincardid = b.fid where b.fdepreuseid = ? and ", new Object[]{depreUserId});
        queryFinEntrySql.appendIn(" a.fid ", (Object[])realMasterIds.toArray(new Long[0]));
        try (DataSet dataSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)"fa"), (SqlBuilder)queryFinEntrySql);){
            for (Row row : dataSet) {
                idRelationMap.put(row.getLong("foriginalfincardid"), row.getLong("ffincardid"));
            }
        }
        return idRelationMap;
    }
}

