/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.dao.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.validate.BillStatus;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.fa.business.BizStatusEnum;
import kd.fi.fa.business.coderule.CodeRuleService;
import kd.fi.fa.business.dao.IFaRealCardDao;
import kd.fi.fa.business.dao.factory.FaFinCardDaoFactory;
import kd.fi.fa.business.dao.factory.FaRealCardDaoFactory;
import kd.fi.fa.business.dao.impl.FaBillDaoOrmImpl;
import kd.fi.fa.business.dao.impl.IBizSetCardDataHandler;
import kd.fi.fa.business.po.FaCardBusCtrDetailPo;
import kd.fi.fa.business.po.FaCardVersionParameter;
import kd.fi.fa.business.utils.FaCodeRulerUtils;
import kd.fi.fa.business.utils.FaConstants;
import kd.fi.fa.business.utils.FaInitAssetFinEntryDataUpService;
import kd.fi.fa.business.utils.FaRptMediateUtil;
import kd.fi.fa.business.utils.FaShareOpUtils;
import kd.fi.fa.common.util.Fa;

public class FaRealCardDaoOrmImpl
extends FaBillDaoOrmImpl
implements IFaRealCardDao {
    private static final String[] UPDATE_BIZSTATUS_FIELDS = new String[]{"id", "bizstatus"};
    private static final Log logger = LogFactory.getLog((String)"kd.fi.fa.business.dao.impl.FaRealCardDaoOrmImpl");
    private static final String TABLE_NAME_REALCARD = "T_FA_CARD_REAL";
    private static final String selectFields = Fa.dot((String[])new String[]{"realentry", "realcard"});
    private static final List<String> excludeChangeStatusList = new ArrayList<String>(2);
    private final String[] busCtrArr = new String[]{"id", "srcbillid", "srcbillentityname"};
    private final String[] cardArr = new String[]{"number"};

    public FaRealCardDaoOrmImpl() {
        super("fa_card_real");
    }

    public FaRealCardDaoOrmImpl(String entityName) {
        super(entityName);
    }

    @Override
    @Deprecated
    public Map<Object, Object> copyCards(Object[] pks, IBizSetCardDataHandler handler) {
        if (pks.length == 0) {
            return new HashMap<Object, Object>(0);
        }
        ReResult rs = this.coreCopyCards(pks, handler, null);
        return rs.realId2BakRealIdMap;
    }

    @Override
    @Deprecated
    public Map<Object, Object> copyCards(Object[] pks, IBizSetCardDataHandler handler, Long orgId, DynamicObjectCollection assetBooks, Map<String, Long[]> orgDepreUse2PeriodMap, Object excludeChangeId) {
        return this.copyCards(pks, handler, orgId, excludeChangeId, null);
    }

    @Override
    public Map<Object, Object> copyCards(Object[] pks, IBizSetCardDataHandler handler, Long orgId, Object excludeChangeId, FaCardVersionParameter cardVersionParameter) {
        if (pks.length == 0) {
            return new HashMap<Object, Object>(0);
        }
        ReResult rs = this.coreCopyCards(pks, handler, excludeChangeId);
        if (cardVersionParameter != null) {
            this.updateCardVersion2ForAudit(orgId, rs, cardVersionParameter);
        }
        return rs.realId2BakRealIdMap;
    }

    private ReResult coreCopyCards(Object[] pks, IBizSetCardDataHandler handler, Object excludeChangeId) {
        DynamicObject[] cards = BusinessDataServiceHelper.load((Object[])pks, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)this.entityName));
        DynamicObject[] cardsCopy = new DynamicObject[cards.length];
        HashMap<Object, Object> mainSrcCardIdMap = new HashMap<Object, Object>(cards.length);
        for (int i = 0; i < cards.length; ++i) {
            mainSrcCardIdMap.put(cards[i].get("masterid"), cards[i].getPkValue());
            cardsCopy[i] = (DynamicObject)new CloneUtils(true, true).clone((IDataEntityBase)cards[i]);
            cardsCopy[i].set("assetname", cards[i].get("assetname"));
            cardsCopy[i].set("isbak", (Object)"1");
            cardsCopy[i].set("createtime", (Object)new Date());
            if (handler != null) {
                handler.handle(cards[i]);
            }
            cards[i].set("originaldata", (Object)Boolean.FALSE);
        }
        SaveServiceHelper.save((DynamicObject[])cardsCopy);
        SaveServiceHelper.save((DynamicObject[])cards);
        HashMap<Object, Object> aft2befidMap = new HashMap<Object, Object>(cards.length);
        for (int i = 0; i < cards.length; ++i) {
            aft2befidMap.put(cards[i].get("id"), cardsCopy[i].get("id"));
        }
        FaRptMediateUtil.updateRealcardId(aft2befidMap);
        HashMap<Object, Object> oldSrcCardIdMap = new HashMap<Object, Object>(cardsCopy.length);
        HashMap<Object, Object> initOriginalCardMaster2PKMap = new HashMap<Object, Object>(cardsCopy.length);
        for (DynamicObject card : cardsCopy) {
            oldSrcCardIdMap.put(card.get("masterid"), card.getPkValue());
            boolean isInitCard = card.getBoolean("initialcard");
            boolean originalData = card.getBoolean("originaldata");
            if (!isInitCard || !originalData) continue;
            initOriginalCardMaster2PKMap.put(card.get("masterid"), card.getPkValue());
        }
        if (!initOriginalCardMaster2PKMap.isEmpty()) {
            FaInitAssetFinEntryDataUpService upService = new FaInitAssetFinEntryDataUpService();
            upService.genAssetFinEntryByRealMap(initOriginalCardMaster2PKMap);
        }
        Set entrySet = mainSrcCardIdMap.entrySet();
        Iterator it = entrySet.iterator();
        HashMap<Object, Object> realCardIdMap = new HashMap<Object, Object>(entrySet.size());
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            realCardIdMap.put(entry.getValue(), oldSrcCardIdMap.get(entry.getKey()));
        }
        if (!realCardIdMap.isEmpty()) {
            DynamicObject[] hisChanges;
            ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(2);
            QFilter realf = new QFilter("realentry.aftrealcard", "in", realCardIdMap.keySet());
            qFilterList.add(realf);
            if (excludeChangeId != null) {
                QFilter idFilter = new QFilter("id", "!=", excludeChangeId);
                qFilterList.add(idFilter);
            }
            String fields = "realcard,aftrealcard";
            for (DynamicObject his : hisChanges = BusinessDataServiceHelper.load((String)"fa_change_dept", (String)fields, (QFilter[])qFilterList.toArray(new QFilter[1]))) {
                DynamicObjectCollection hisEntries = his.getDynamicObjectCollection("realentry");
                for (DynamicObject entry : hisEntries) {
                    Object befRea = entry.get("realcard_id");
                    Object aftRea = entry.get("aftrealcard_id");
                    Object oldReal = realCardIdMap.get(aftRea);
                    if (oldReal == null) continue;
                    entry.set("aftrealcard_id", oldReal);
                    if (!befRea.equals(aftRea)) continue;
                    entry.set("realcard_id", oldReal);
                }
            }
            SaveServiceHelper.save((DynamicObject[])hisChanges);
        }
        ReResult rs = new ReResult();
        rs.realId2BakRealIdMap = realCardIdMap;
        return rs;
    }

    private void updateCardVersion2ForAudit(Long orgId, ReResult rs, FaCardVersionParameter cardVersionParameter) {
        Map<Object, Object> realId2BakRealIdMap = rs.realId2BakRealIdMap;
        ArrayList<DynamicObject> insertCardVerson2List = new ArrayList<DynamicObject>(realId2BakRealIdMap.size());
        ArrayList<Object[]> params = new ArrayList<Object[]>(insertCardVerson2List.size());
        for (Map.Entry<Object, Object> entry : realId2BakRealIdMap.entrySet()) {
            MainEntityType faCardVersion2 = EntityMetadataCache.getDataEntityType((String)"fa_card_version2");
            DynamicObject faCardVersion2Dy = new DynamicObject((DynamicObjectType)faCardVersion2);
            faCardVersion2Dy.set("org", (Object)orgId);
            faCardVersion2Dy.set("cardmasterid", entry.getKey());
            faCardVersion2Dy.set("accountdate", (Object)cardVersionParameter.getAccountdate());
            faCardVersion2Dy.set("versiontime", (Object)new Date());
            faCardVersion2Dy.set("befrealcard", entry.getValue());
            faCardVersion2Dy.set("aftrealcard", entry.getKey());
            faCardVersion2Dy.set("srcbillid", (Object)cardVersionParameter.getSrcbillid());
            faCardVersion2Dy.set("srcbillentityname", (Object)cardVersionParameter.getSrcbillentityname());
            insertCardVerson2List.add(faCardVersion2Dy);
            params.add(new Object[]{entry.getValue(), entry.getKey(), entry.getKey()});
        }
        if (params.size() > 0) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"fa"), (String)"update t_fa_card_version2 set faftrealcardid =? where faftrealcardid = ? and fcardmasterid = ?", params);
        }
        if (insertCardVerson2List.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])insertCardVerson2List.toArray(new DynamicObject[insertCardVerson2List.size()]));
        }
    }

    @Override
    @Deprecated
    public boolean restoreCards(Object[] oldPKs2, Map<Object, Object> befAndAftChange, BizStatusEnum bizStatus, IBizSetCardDataHandler handler) {
        return this.restoreCards(oldPKs2, befAndAftChange, bizStatus, handler, null, null);
    }

    @Override
    @Deprecated
    public boolean restoreCards(Object[] oldPKs, Map<Object, Object> befAndAftChange, BizStatusEnum bizStatus, IBizSetCardDataHandler handler, Object excludeChangeId) {
        return this.restoreCards(oldPKs, befAndAftChange, bizStatus, handler, excludeChangeId, null);
    }

    @Override
    public boolean restoreCards(Object[] oldPKs2, Map<Object, Object> befAndAftChange, BizStatusEnum bizStatus, IBizSetCardDataHandler handler, Object excludeChangeId, FaCardVersionParameter cardVersionParameter) {
        FaRptMediateUtil.updateRealcardId(befAndAftChange);
        DynamicObject[] aftChangeCards = BusinessDataServiceHelper.load((Object[])befAndAftChange.values().toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"fa_card_real"));
        Map<Object, DynamicObject> aftChangeCardMap = Arrays.stream(aftChangeCards).collect(Collectors.toMap(DataEntityBase::getPkValue, v -> v));
        Map befChangeCardMap = BusinessDataServiceHelper.loadFromCache((Object[])befAndAftChange.keySet().toArray(), (String)"fa_card_real");
        ArrayList<Object> keyValueEqualList = new ArrayList<Object>(befAndAftChange.size());
        for (Map.Entry<Object, Object> entry : befAndAftChange.entrySet()) {
            Object befChangeCardId = entry.getKey();
            DynamicObject befChangeCard = (DynamicObject)befChangeCardMap.get(befChangeCardId);
            Object object = entry.getValue();
            DynamicObject aftChangeCard = aftChangeCardMap.get(object);
            if (befChangeCardId.toString().equals(object.toString())) {
                keyValueEqualList.add(befChangeCardId);
            }
            if (bizStatus != null) {
                aftChangeCard.set("bizstatus", (Object)bizStatus);
            }
            boolean originalData = befChangeCard.getBoolean("originaldata");
            aftChangeCard.set("originaldata", (Object)originalData);
            if (handler == null) continue;
            handler.handle(aftChangeCard);
        }
        SaveServiceHelper.save((DynamicObject[])aftChangeCards);
        for (Map.Entry<Object, Object> entry : keyValueEqualList) {
            befAndAftChange.remove(entry);
        }
        if (befAndAftChange.size() == 0) {
            return true;
        }
        DynamicObject[] fincards = BusinessDataServiceHelper.load((String)"fa_card_fin", (String)"realcard", (QFilter[])new QFilter[]{new QFilter("realcard", "in", (Object)befAndAftChange.keySet().toArray())});
        if (fincards != null && fincards.length > 0) {
            for (DynamicObject dynamicObject : fincards) {
                long oldId = dynamicObject.getLong("realcard_id");
                Object newId = befAndAftChange.get(oldId);
                dynamicObject.set("realcard_id", newId);
            }
            SaveServiceHelper.save((DynamicObject[])fincards);
        }
        if (befAndAftChange != null && befAndAftChange.size() > 0) {
            ArrayList<Object[]> arrayList = new ArrayList<Object[]>(befAndAftChange.size());
            for (Map.Entry<Object, Object> bakRealId2RealId : befAndAftChange.entrySet()) {
                arrayList.add(new Object[]{bakRealId2RealId.getValue(), bakRealId2RealId.getKey()});
            }
            DB.executeBatch((DBRoute)DBRoute.of((String)"fa"), (String)"update t_fa_depresplitdetail set FREALCARDID = ?  where FREALCARDID = ? ", arrayList);
            DB.executeBatch((DBRoute)DBRoute.of((String)"fa"), (String)"update t_fa_depredetailentry set FREALCARDID = ?  where FREALCARDID = ? ", arrayList);
            DB.executeBatch((DBRoute)DBRoute.of((String)"fa"), (String)"update t_fa_changebak_fin set FREALCARDID = ?  where FREALCARDID = ? ", arrayList);
            DB.executeBatch((DBRoute)DBRoute.of((String)"fa"), (String)"update t_fa_merge_in set finrealcardbak = ?  where finrealcardbak = ? ", arrayList);
        }
        if (!befAndAftChange.isEmpty()) {
            DynamicObject[] hisChanges;
            QFilter qFilter = new QFilter("realentry.aftrealcard", "in", befAndAftChange.keySet());
            QFilter idFilter = new QFilter("id", "!=", excludeChangeId);
            for (DynamicObject his : hisChanges = BusinessDataServiceHelper.load((String)"fa_change_dept", (String)"aftrealcard,realcard", (QFilter[])new QFilter[]{qFilter, idFilter})) {
                DynamicObjectCollection realEntries = his.getDynamicObjectCollection("realentry");
                for (DynamicObject realEntry : realEntries) {
                    Object befRea = realEntry.get("realcard_id");
                    Object aftRea = realEntry.get("aftrealcard_id");
                    Object oldReal = befAndAftChange.get(aftRea);
                    if (oldReal == null) continue;
                    realEntry.set("aftrealcard_id", oldReal);
                    if (!befRea.equals(aftRea)) continue;
                    realEntry.set("realcard_id", oldReal);
                }
            }
            SaveServiceHelper.save((DynamicObject[])hisChanges);
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(befChangeCardMap.size());
        for (DynamicObject realCard : befChangeCardMap.values()) {
            boolean bl = realCard.getBoolean("initialcard");
            boolean isOriginal = realCard.getBoolean("originaldata");
            if (!bl || !isOriginal) continue;
            arrayList.add(realCard.getPkValue());
        }
        this.delete(befAndAftChange.keySet().toArray());
        if (!arrayList.isEmpty()) {
            SqlBuilder deleteAssetFinEntrySql = new SqlBuilder();
            deleteAssetFinEntrySql.appendIn("delete from  t_fa_asset_finentry where fid ", arrayList);
            DB.execute((DBRoute)DBRoute.of((String)"fa"), (SqlBuilder)deleteAssetFinEntrySql);
        }
        if (cardVersionParameter != null) {
            this.updateCardVersion2ForUnAudit(befAndAftChange, cardVersionParameter);
        }
        return true;
    }

    private void updateCardVersion2ForUnAudit(Map<Object, Object> befAndAftChange, FaCardVersionParameter cardVersionParameter) {
        QFilter[] cardVersonFilters;
        if (cardVersionParameter != null && cardVersionParameter.getSrcbillid() != null) {
            cardVersonFilters = new QFilter[]{new QFilter("srcbillid", "=", (Object)cardVersionParameter.getSrcbillid()), new QFilter("srcbillentityname", "=", (Object)cardVersionParameter.getSrcbillentityname())};
            DeleteServiceHelper.delete((String)"fa_card_version2", (QFilter[])cardVersonFilters);
        }
        if (cardVersionParameter != null && cardVersionParameter.getSrcBillIdList() != null) {
            cardVersonFilters = new QFilter[]{new QFilter("srcbillid", "in", cardVersionParameter.getSrcBillIdList()), new QFilter("srcbillentityname", "=", (Object)cardVersionParameter.getSrcbillentityname())};
            DeleteServiceHelper.delete((String)"fa_card_version2", (QFilter[])cardVersonFilters);
        }
        if (befAndAftChange.size() <= 0) {
            return;
        }
        ArrayList<Object[]> params = new ArrayList<Object[]>(befAndAftChange.size());
        for (Map.Entry<Object, Object> realCardIds : befAndAftChange.entrySet()) {
            Object[] arr = new Object[]{realCardIds.getValue(), realCardIds.getKey()};
            params.add(arr);
        }
        if (params.size() > 0) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"fa"), (String)"update t_fa_card_version2 set faftrealcardid =?  where faftrealcardid = ? ", params);
        }
    }

    @Override
    @Deprecated
    public boolean updateBizStatus(Object pk, BizStatusEnum bizStatus) {
        DynamicObject dbobj = BusinessDataServiceHelper.loadSingle((String)this.entityName, (String)Fa.join((Object[])UPDATE_BIZSTATUS_FIELDS, (String)","), (QFilter[])new QFilter("id", "in", pk).toArray());
        dbobj.set(UPDATE_BIZSTATUS_FIELDS[0], pk);
        dbobj.set(UPDATE_BIZSTATUS_FIELDS[1], (Object)bizStatus);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dbobj});
        return true;
    }

    @Override
    public boolean batchUpdateBizStatus(Object[] pks, BizStatusEnum toBizStatus) {
        if (pks.length == 0) {
            return true;
        }
        HashSet pksSet = new HashSet(pks.length);
        Arrays.stream(pks).forEach(r -> pksSet.add(Long.parseLong(String.valueOf(r))));
        boolean updateFlag = this.updateBizStatusBySql(pks, toBizStatus);
        if (updateFlag) {
            this.cleanCache();
        }
        return true;
    }

    private boolean updateBizStatusBySql(Object[] pks, BizStatusEnum toBizStatus) {
        SqlBuilder updateSqlBuilder = new SqlBuilder();
        updateSqlBuilder.append("update T_FA_CARD_REAL set fbizstatus = ?", new Object[]{toBizStatus}).appendIn(" where fid ", pks);
        return DB.execute((DBRoute)DBRoute.of((String)"fa"), (SqlBuilder)updateSqlBuilder);
    }

    private void cleanCache() {
        DataEntityCacheManager cacheManager = new DataEntityCacheManager(TABLE_NAME_REALCARD);
        cacheManager.removeByDt();
    }

    @Override
    public void batchUpdateBizStatus(Object[] pks, BizStatusEnum toBizStatus, BizStatusEnum fromBizStatus, Set<Long> masterIds, Object sourceId, String sourceEntityType) {
        ArrayList<BizStatusEnum> fromBizStatusList = new ArrayList<BizStatusEnum>(1);
        fromBizStatusList.add(fromBizStatus);
        this.batchUpdateBizStatus(pks, toBizStatus, fromBizStatusList, masterIds, sourceId, sourceEntityType);
    }

    @Override
    public void batchUpdateBizStatus(Object[] pks, BizStatusEnum toBizStatus, List<BizStatusEnum> fromBizStatuses, Set<Long> masterIds, Object sourceId, String sourceEntityType) {
        boolean backDepre;
        if (pks == null || pks.length == 0) {
            logger.info("\u66f4\u65b0\u5361\u7247\u7684\u4e3b\u952e\u4e3a\u7a7a\u3002");
            return;
        }
        if (masterIds == null || masterIds.size() == 0) {
            logger.info("\u66f4\u65b0\u5361\u7247\u7684masterId\u4e3a\u7a7a\u3002");
            return;
        }
        SqlBuilder sbBusCtrt = new SqlBuilder();
        sbBusCtrt.append("select fid from t_fa_card_bus_ctr where ", new Object[0]);
        sbBusCtrt.appendIn("fid", masterIds.toArray());
        DataSet busCtrDS = DB.queryDataSet((String)"FaRealCardDaoOrmImpl_t_fa_card_bus_ctr", (DBRoute)FaConstants.faDBRoute, (SqlBuilder)sbBusCtrt);
        HashSet<Long> busCtrSet = new HashSet<Long>(masterIds.size());
        for (Row row : busCtrDS) {
            busCtrSet.add(row.getLong("fid"));
        }
        HashSet<Long> existMasterIdSet = new HashSet<Long>(masterIds.size());
        HashSet<Long> notExistMasterIdSet = new HashSet<Long>(masterIds.size());
        for (Long masterId : masterIds) {
            if (busCtrSet.contains(masterId)) {
                existMasterIdSet.add(masterId);
                continue;
            }
            notExistMasterIdSet.add(masterId);
        }
        boolean fromReady = fromBizStatuses.size() == 1 && fromBizStatuses.get(0).name().equals(BizStatusEnum.READY.name());
        HashSet<String> fromBizStatusSet = new HashSet<String>(2);
        for (BizStatusEnum bizStatus : fromBizStatuses) {
            fromBizStatusSet.add(bizStatus.name());
        }
        boolean fromDeleteUnaudit = fromBizStatuses.size() == 2 && fromBizStatusSet.contains(BizStatusEnum.READY.name()) && fromBizStatusSet.contains(BizStatusEnum.DELETE.name());
        boolean fromDepre = fromBizStatuses.size() == 2 && fromBizStatusSet.contains(BizStatusEnum.READY.name()) && fromBizStatusSet.contains(BizStatusEnum.DEPRE.name());
        boolean bl = backDepre = fromBizStatuses.size() == 1 && fromBizStatusSet.contains(BizStatusEnum.DEPRE.name());
        if (fromDepre || backDepre) {
            String checkEntity = "'fa_card_fin', 'fa_clearbill', 'fa_change_dept', 'fa_assetsplitbill', 'fa_asset_devalue', 'fa_depreadjustbill', 'fa_workload', 'fa_depre_sum', 'fa_depre'";
            SqlBuilder sbIgnore = new SqlBuilder();
            sbIgnore.append("select fid from t_fa_card_bus_ctr where ", new Object[0]);
            sbIgnore.appendIn("fid", masterIds.toArray());
            sbIgnore.append(String.format(" and fsrcbillentityname not in (%s)", checkEntity), new Object[0]);
            DataSet ignoreDataSet = DB.queryDataSet((String)"FaRealCardDaoOrmImpl_check_bus_ctr", (DBRoute)FaConstants.faDBRoute, (SqlBuilder)sbIgnore);
            HashSet<Long> checkSet = new HashSet<Long>(masterIds.size());
            for (Row row : ignoreDataSet) {
                checkSet.add(row.getLong("fid"));
            }
            existMasterIdSet.removeAll(checkSet);
            notExistMasterIdSet.removeAll(checkSet);
        }
        Date now = new Date();
        if (existMasterIdSet.size() > 0) {
            List fromBizStrList = fromBizStatuses.stream().map(v -> v.name()).collect(Collectors.toList());
            SqlBuilder sb = new SqlBuilder();
            sb.append("update t_fa_card_bus_ctr set ", new Object[0]).append("fbizstatus = ?,", new Object[]{toBizStatus}).append("fmodifytime = ?,", new Object[]{now}).append("fsrcbillid = ?,", new Object[]{sourceId}).append("fsrcbillentityname = ?", new Object[]{sourceEntityType}).append(" where ", new Object[0]).appendIn("fid", existMasterIdSet.toArray()).appendIn("and fbizstatus", fromBizStrList.toArray());
            if (!(fromReady || fromDeleteUnaudit || fromDepre)) {
                sb.append("and fsrcbillid = ?", new Object[]{sourceId}).append("and fsrcbillentityname  = ?", new Object[]{sourceEntityType});
            }
            sb.append("and fsublocknum = 0", new Object[0]);
            int updateRows = DB.update((DBRoute)FaConstants.faDBRoute, (SqlBuilder)sb);
            if (updateRows != existMasterIdSet.size()) {
                String alterNumber = this.getOtherHoldRealAlterString(toBizStatus, existMasterIdSet, sourceId, sourceEntityType);
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5f02\u5e38,\u4ee5\u4e0b\u8d44\u4ea7\u7f16\u7801\u7684\u5361\u7247\u6b63\u5728\u505a\u5982\u4e0b\u4e1a\u52a1\uff1a%s\u3002", (String)"FaRealCardDaoOrmImpl_0", (String)"fi-fa-business", (Object[])new Object[0]), alterNumber));
            }
        }
        if (notExistMasterIdSet.size() > 0) {
            MainEntityType cardBusCotrType = EntityMetadataCache.getDataEntityType((String)"fa_card_bus_ctr");
            ArrayList<DynamicObject> notExistBusCtrList = new ArrayList<DynamicObject>(notExistMasterIdSet.size());
            for (Long masterId : notExistMasterIdSet) {
                DynamicObject cardBusCotrDy = new DynamicObject((DynamicObjectType)cardBusCotrType);
                cardBusCotrDy.set("id", (Object)masterId);
                cardBusCotrDy.set("bizstatus", (Object)toBizStatus);
                cardBusCotrDy.set("srcbillid", sourceId);
                cardBusCotrDy.set("srcbillentityname", (Object)sourceEntityType);
                cardBusCotrDy.set("sublocknum", (Object)0);
                cardBusCotrDy.set("modifytime", (Object)now);
                notExistBusCtrList.add(cardBusCotrDy);
            }
            SaveServiceHelper.save((DynamicObject[])notExistBusCtrList.toArray(new DynamicObject[notExistBusCtrList.size()]));
        }
        if (!fromDepre && !backDepre) {
            this.batchUpdateBizStatus(pks, toBizStatus);
        }
    }

    private String getOtherHoldRealAlterString(BizStatusEnum toBizStatus, Set<Long> existMasterIdSet, Object sourceId, String sourceEntityType) {
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", existMasterIdSet), new QFilter("sublocknum", ">", (Object)0)};
        DynamicObjectCollection ctrs = QueryServiceHelper.query((String)"fa_card_bus_ctr", (String)"id,detailentryentity.dtholdlockdataid dtholdlockdataid,detailentryentity.dtholdlockentityname dtholdlockentityname", (QFilter[])filters);
        HashMap<Long, String[]> masterID2ArrMap = new HashMap<Long, String[]>(16);
        HashMap<Long, String> bookId2Name = new HashMap<Long, String>(16);
        int j = 0;
        HashSet<Long> existSubSet = new HashSet<Long>(existMasterIdSet.size());
        for (DynamicObject ctr : ctrs) {
            Long masterId = ctr.getLong("id");
            Long bookId = ctr.getLong("dtholdlockdataid");
            String entityNum = ctr.getString("dtholdlockentityname");
            existSubSet.add(masterId);
            if (j >= 51) continue;
            String bookName = null;
            if (bookId2Name.get(bookId) == null) {
                DynamicObject book = QueryServiceHelper.queryOne((String)"fa_assetbook", (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)bookId)});
                if (book == null) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5f02\u5e38\uff0c\u8d44\u4ea7\u8d26\u7c3fID\u201c%1$s\u201d\u5728\u6570\u636e\u5e93\u4e0d\u5b58\u5728\u5bf9\u5e94\u6570\u636e\u3002", (String)"FaRealCardDaoOrmImpl_1", (String)"fi-fa-business", (Object[])new Object[0]), bookId));
                }
                bookName = book.getString("name");
                bookId2Name.put(bookId, bookName);
            } else {
                bookName = (String)bookId2Name.get(bookId);
            }
            MainEntityType srcbillEntityType = EntityMetadataCache.getDataEntityType((String)entityNum);
            String billEntityDispName = srcbillEntityType.getDisplayName().getLocaleValue();
            String[] arr = new String[]{bookName, entityNum + "_" + billEntityDispName};
            masterID2ArrMap.put(masterId, arr);
            ++j;
        }
        HashSet<String> alterSet = new HashSet<String>(100);
        if (masterID2ArrMap.size() > 0) {
            String alterNums = this.getValidatorAlter(masterID2ArrMap);
            alterSet.add(alterNums);
        }
        if (existSubSet.size() > 0) {
            existMasterIdSet.removeAll(existSubSet);
        }
        if (existMasterIdSet.size() == 0) {
            return ((Object)alterSet).toString();
        }
        Object[] toBizStatusArr = new String[]{toBizStatus.name()};
        SqlBuilder sb = new SqlBuilder();
        sb.append("select fid as id from t_fa_card_bus_ctr where ", new Object[0]).appendIn("fid", existMasterIdSet.toArray()).appendIn("and fbizstatus", toBizStatusArr).append("and fsrcbillid = ?", new Object[]{sourceId}).append("and fsrcbillentityname  = ?", new Object[]{sourceEntityType}).append("and fsublocknum  = 0", new Object[0]);
        DataSet dataSet = DB.queryDataSet((String)"OtherHoldRealAlter", (DBRoute)FaConstants.faDBRoute, (SqlBuilder)sb);
        Iterator it = dataSet.iterator();
        HashSet<Long> existSet = new HashSet<Long>(existMasterIdSet.size());
        while (it.hasNext()) {
            Row row = (Row)it.next();
            Long id = (Long)row.get("id");
            existSet.add(id);
        }
        if (existMasterIdSet.size() != existSet.size()) {
            existMasterIdSet.removeAll(existSet);
        }
        HashSet<Long> exceptionMasterIdSet = new HashSet<Long>(100);
        int i = 0;
        for (Long masterId : existMasterIdSet) {
            exceptionMasterIdSet.add(masterId);
            if (++i < 51) continue;
            break;
        }
        SqlBuilder sbCtr = new SqlBuilder();
        sbCtr.append("select fid as id,fsrcbillid as srcbillid,fsrcbillentityname as srcbillentityname from t_fa_card_bus_ctr where ", new Object[0]).appendIn("fid", exceptionMasterIdSet.toArray());
        DataSet dataSetCtr = DB.queryDataSet((String)"OtherHoldRealAlterSrc", (DBRoute)FaConstants.faDBRoute, (SqlBuilder)sbCtr);
        SqlBuilder sbR = new SqlBuilder();
        sbR.append("select fmasterid as masterid,fnumber as number from t_fa_card_real where ", new Object[0]).appendIn("fmasterid", exceptionMasterIdSet.toArray()).append("and fisbak = '0'", new Object[0]);
        DataSet dataSetR = DB.queryDataSet((String)"OtherHoldRealAlterNumber", (DBRoute)FaConstants.faDBRoute, (SqlBuilder)sbR);
        DataSet numSrcDs = dataSetCtr.join(dataSetR).on("id", "masterid").select(this.busCtrArr, this.cardArr).finish();
        for (Row row : numSrcDs) {
            String number = (String)row.get("number");
            String srcbillentityname = (String)row.get("srcbillentityname");
            MainEntityType srcbillEntityType = EntityMetadataCache.getDataEntityType((String)srcbillentityname);
            String billEntityDispName = srcbillEntityType.getDisplayName().getLocaleValue();
            alterSet.add("[" + number + "," + billEntityDispName + "]");
        }
        return ((Object)alterSet).toString();
    }

    @Override
    public DynamicObject[] queryCardBySrcNumber(Long orgId, Object srcNumber, Set<String> realIds) {
        return BusinessDataServiceHelper.load((String)this.entityName, (String)"id,billstatus,bizstatus", (QFilter[])this.getSrcNumberFilter(orgId, srcNumber, realIds));
    }

    @Override
    public int deleteCardBySrcNumber(Long orgId, Object srcNumber, Set<String> realIds) {
        QFilter[] realCardfilters = this.getSrcNumberFilter(orgId, srcNumber, realIds);
        QFilter[] finCardFilters = this.getFinCardFilters(orgId, srcNumber, realIds);
        FaFinCardDaoFactory.getInstance().deleteByFilter(finCardFilters);
        DynamicObject[] realDynamics = FaRealCardDaoFactory.getInstance().query("id,numberrule,billnocoderule,barcoderule,billno", realCardfilters);
        FaShareOpUtils.deleteFaShare(Arrays.asList(realDynamics), "fa_card_real");
        for (DynamicObject dataEntity : realDynamics) {
            CodeRuleService instance = CodeRuleService.getInstance(dataEntity, orgId + "");
            FaCodeRulerUtils.dealBillNo(dataEntity);
            instance.recycleNumber("fa_card_real", dataEntity, orgId + "", dataEntity.getString("billno"));
        }
        return this.dao.deleteByFilter(realCardfilters);
    }

    @Override
    public BizStatusEnum queryBizStatusByPk(Object pk) {
        DynamicObject realCard = this.queryOne(FaRealCardDaoOrmImpl.comma("id", "bizstatus"), pk);
        return BizStatusEnum.valueOf(realCard.getString("bizstatus"));
    }

    private QFilter[] getSrcNumberFilter(Long orgId, Object srcNumber, Set<String> realNumbers) {
        QFilter idFilter = null;
        if (realNumbers != null && realNumbers.size() > 0) {
            idFilter = new QFilter("number", "in", realNumbers);
        }
        return new QFilter[]{new QFilter("srcbillnumber", "=", srcNumber), new QFilter("org", "=", (Object)orgId), idFilter};
    }

    private QFilter[] getFinCardFilters(Long orgId, Object srcNumber, Set<String> realNumbers) {
        DynamicObject[] realCards = this.queryCardBySrcNumber(orgId, srcNumber, realNumbers);
        Set<Object> idSet = this.getRealCardIdSet(realCards);
        QFilter[] finCardFilters = new QFilter[]{new QFilter("realcard", "in", idSet)};
        return finCardFilters;
    }

    private Set<Object> getRealCardIdSet(DynamicObject[] realCards) {
        HashSet<Object> idSet = new HashSet<Object>(realCards.length);
        for (DynamicObject realCard : realCards) {
            idSet.add(realCard.getPkValue());
        }
        return idSet;
    }

    @Override
    public Optional<String> checkExistInitRealCardUnAudited(Object orgid) {
        DynamicObject[] realCardObjs = this.query("assetName", QFilter.of((String)"initialcard = '1' and org = ? and billStatus != ? and justrealcard = '0'", (Object[])new Object[]{orgid, BillStatus.C.name()}), null, 1);
        if (realCardObjs != null && realCardObjs.length > 0) {
            return Optional.of(Stream.of(realCardObjs).map(v -> v.getString("assetName")).collect(Collectors.joining(",")));
        }
        return Optional.empty();
    }

    @Override
    public void batchLockCard2Book(BizStatusEnum initBizStatuse, List<BizStatusEnum> fromBizStatuses, Map<Long, FaCardBusCtrDetailPo> masterId2detailMap) {
        this.batchLockCard2Book(initBizStatuse, fromBizStatuses, masterId2detailMap, null);
    }

    @Override
    public void batchLockCard2Book(BizStatusEnum initBizStatuse, List<BizStatusEnum> fromBizStatuses, Map<Long, FaCardBusCtrDetailPo> masterId2detailMap, Map<String, Object> extParameterMap) {
        if (initBizStatuse == null) {
            return;
        }
        if (fromBizStatuses == null || fromBizStatuses.size() == 0) {
            return;
        }
        if (masterId2detailMap == null || masterId2detailMap.size() == 0) {
            return;
        }
        HashSet<String> startStatus = new HashSet<String>(2);
        startStatus.add(BizStatusEnum.READY.name());
        startStatus.add(BizStatusEnum.DELETE.name());
        String checkEntity = "'fa_card_fin', 'fa_clearbill', 'fa_change_dept', 'fa_assetsplitbill', 'fa_asset_devalue', 'fa_depreadjustbill', 'fa_workload', 'fa_depre_sum', 'fa_depre'";
        SqlBuilder sbIgnore = new SqlBuilder();
        sbIgnore.append("select fid from t_fa_card_bus_ctr where ", new Object[0]);
        sbIgnore.appendIn("fid", masterId2detailMap.keySet().toArray());
        sbIgnore.appendIn(" and fbizstatus not ", startStatus.toArray());
        sbIgnore.append(String.format(" and fsrcbillentityname not in (%s)", checkEntity), new Object[0]);
        DataSet ignoreDataSet = DB.queryDataSet((String)"FaRealCardDaoOrmImpl_check_bus_ctr", (DBRoute)FaConstants.faDBRoute, (SqlBuilder)sbIgnore);
        for (Row row : ignoreDataSet) {
            masterId2detailMap.remove(row.getLong("fid"));
        }
        if (masterId2detailMap == null || masterId2detailMap.size() == 0) {
            return;
        }
        if (extParameterMap != null) {
            Long orgId = (Long)extParameterMap.get("orgId");
            Date curPeriodEndDate = (Date)extParameterMap.get("curPeriodEndDate");
            QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("changedate", ">", (Object)curPeriodEndDate), new QFilter("billstatus", "in", excludeChangeStatusList), new QFilter(Fa.dot((String[])new String[]{"realentry", "realcard"}), "in", (Object)masterId2detailMap.keySet().toArray())};
            DynamicObjectCollection changeBills = QueryServiceHelper.query((String)"fa_change_dept", (String)selectFields, (QFilter[])filters);
            for (DynamicObject bill : changeBills) {
                masterId2detailMap.remove(bill.getLong(Fa.dot((String[])new String[]{"realentry", "realcard"})));
            }
        }
        if (masterId2detailMap == null || masterId2detailMap.size() == 0) {
            return;
        }
        MainEntityType cardBusCtrType = EntityMetadataCache.getDataEntityType((String)"fa_card_bus_ctr");
        DynamicObjectCollection cardBusCtrArr = BusinessDataServiceHelper.load((Object[])masterId2detailMap.keySet().toArray(), (DynamicObjectType)cardBusCtrType);
        this.validatorData4LockCard2Book((DynamicObject[])cardBusCtrArr, masterId2detailMap);
        ArrayList<Long> existedDataIds = new ArrayList<Long>(masterId2detailMap.size());
        for (DynamicObject dynamicObject : cardBusCtrArr) {
            existedDataIds.add(dynamicObject.getLong("id"));
        }
        if (existedDataIds.size() == 0) {
            this.insertCardBusCtr(initBizStatuse, masterId2detailMap);
        } else {
            int size = masterId2detailMap.size() - existedDataIds.size();
            if (size != 0) {
                HashMap<Long, FaCardBusCtrDetailPo> notExistedData = new HashMap<Long, FaCardBusCtrDetailPo>(size, 1.0f);
                for (Map.Entry<Long, FaCardBusCtrDetailPo> entry : masterId2detailMap.entrySet()) {
                    if (existedDataIds.contains(entry.getKey())) continue;
                    notExistedData.put(entry.getKey(), entry.getValue());
                }
                this.insertCardBusCtr(initBizStatuse, notExistedData);
            }
            Date now = new Date();
            List fromBizStrList = fromBizStatuses.stream().map(v -> v.name()).collect(Collectors.toList());
            SqlBuilder sqlBuilder = new SqlBuilder();
            sqlBuilder.append("update t_fa_card_bus_ctr set ", new Object[0]).append("fmodifytime = ?,", new Object[]{now}).append("fsublocknum = fsublocknum+1", new Object[0]).append(" where ", new Object[0]).appendIn("fid", existedDataIds.toArray()).appendIn("and fbizstatus", fromBizStrList.toArray());
            int updateRows = DB.update((DBRoute)FaConstants.faDBRoute, (SqlBuilder)sqlBuilder);
            if (updateRows != existedDataIds.size()) {
                String alterNumber = this.getNotSubBusMasterIds(existedDataIds, fromBizStatuses);
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5f02\u5e38\uff0c\u4ee5\u4e0b\u8d44\u4ea7\u7f16\u7801\u7684\u5361\u7247\u83b7\u53d6\u8d26\u7c3f\u5206\u9501\u5931\u8d25\uff0c\u6b63\u5728\u505a\u5176\u4ed6\u4e1a\u52a1\uff1a\u201c%1$s\u201d\u3002", (String)"FaRealCardDaoOrmImpl_2", (String)"fi-fa-business", (Object[])new Object[0]), alterNumber));
            }
            for (DynamicObjectCollection cardBusCtr : cardBusCtrArr) {
                DynamicObjectCollection detailsDoList = cardBusCtr.getDynamicObjectCollection("detailentryentity");
                DynamicObject detailEntityEntry = detailsDoList.addNew();
                FaCardBusCtrDetailPo detail = masterId2detailMap.get(cardBusCtr.getLong("id"));
                detailEntityEntry.set("dtholdlockentityname", (Object)detail.getSourceEntityType());
                detailEntityEntry.set("dtholdlockdataid", (Object)detail.getAssetBookId());
                detailEntityEntry.set("dtmodifytime", (Object)now);
            }
            SaveServiceHelper.save((DynamicObject[])cardBusCtrArr);
        }
    }

    private void validatorData4LockCard2Book(DynamicObject[] cardBusCtrArr, Map<Long, FaCardBusCtrDetailPo> masterId2detailMap) {
        HashMap<Long, String[]> masterID2ArrMap = new HashMap<Long, String[]>(16);
        HashMap<Long, String> bookId2Name = new HashMap<Long, String>(16);
        block0: for (DynamicObject cardBusCtr : cardBusCtrArr) {
            DynamicObjectCollection detailEntity = cardBusCtr.getDynamicObjectCollection("detailentryentity");
            FaCardBusCtrDetailPo cardBusCtrDetailPo = masterId2detailMap.get(cardBusCtr.getLong("id"));
            String sublockdataid2EntityNameDB = cardBusCtrDetailPo.getAssetBookId() + "_" + cardBusCtrDetailPo.getSourceEntityType();
            for (DynamicObject detail : detailEntity) {
                String detailKey = detail.getString("dtholdlockdataid") + "_" + detail.getString("dtholdlockentityname");
                if (!sublockdataid2EntityNameDB.equals(detailKey)) continue;
                Long bookId = detail.getLong("dtholdlockdataid");
                String bookName = null;
                if (bookId2Name.get(bookId) == null) {
                    DynamicObject book = QueryServiceHelper.queryOne((String)"fa_assetbook", (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)bookId)});
                    if (book == null) {
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5f02\u5e38\uff0c\u8d44\u4ea7\u8d26\u7c3fID\u201c%1$s\u201d\u5728\u6570\u636e\u5e93\u4e0d\u5b58\u5728\u5bf9\u5e94\u6570\u636e\u3002", (String)"FaRealCardDaoOrmImpl_1", (String)"fi-fa-business", (Object[])new Object[0]), bookId));
                    }
                    bookName = book.getString("name");
                    bookId2Name.put(bookId, bookName);
                } else {
                    bookName = (String)bookId2Name.get(bookId);
                }
                String entityNum = detail.getString("dtholdlockentityname");
                MainEntityType srcbillEntityType = EntityMetadataCache.getDataEntityType((String)entityNum);
                String billEntityDispName = srcbillEntityType.getDisplayName().getLocaleValue();
                String[] arr = new String[]{bookName, billEntityDispName};
                masterID2ArrMap.put(cardBusCtr.getLong("id"), arr);
                continue block0;
            }
        }
        if (masterID2ArrMap.size() > 0) {
            String alterNums = this.getValidatorAlter(masterID2ArrMap);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5f02\u5e38\uff0c\u4ee5\u4e0b\u8d44\u4ea7\u7f16\u7801\u7684\u5361\u7247\u76ee\u524d\u6b63\u5728\u505a\u8d26\u7c3f\u4e1a\u52a1\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff1a\u201c%1$s\u201d\u3002", (String)"FaRealCardDaoOrmImpl_3", (String)"fi-fa-business", (Object[])new Object[0]), alterNums));
        }
    }

    private String getValidatorAlter(Map<Long, String[]> masterID2ArrMap) {
        if (masterID2ArrMap == null || masterID2ArrMap.size() == 0) {
            return "";
        }
        SqlBuilder sbR = new SqlBuilder();
        sbR.append("select fmasterid,fnumber as number from t_fa_card_real where ", new Object[0]).appendIn("fmasterid", masterID2ArrMap.keySet().toArray()).append("and fisbak = '0'", new Object[0]);
        StringBuilder alterSb = new StringBuilder();
        int i = 0;
        try (DataSet dataSetR = DB.queryDataSet((String)"getValidatorAlter", (DBRoute)FaConstants.faDBRoute, (SqlBuilder)sbR);){
            for (Row real : dataSetR) {
                String number = real.getString("number");
                Long masterid = real.getLong("fmasterid");
                String[] arrTemp = masterID2ArrMap.get(masterid);
                if (i == 0) {
                    alterSb.append("[").append(number).append(",").append(arrTemp[0]).append("_").append(arrTemp[1]).append("]");
                } else {
                    alterSb.append(",").append("[").append(number).append(",").append(arrTemp[0]).append("_").append(arrTemp[1]).append("]");
                }
                ++i;
            }
        }
        return alterSb.toString();
    }

    private void insertCardBusCtr(BizStatusEnum initBizStatuse, Map<Long, FaCardBusCtrDetailPo> masterId2detailMap) {
        MainEntityType cardBusCtrType = EntityMetadataCache.getDataEntityType((String)"fa_card_bus_ctr");
        ArrayList<DynamicObject> notExistBusCtrList = new ArrayList<DynamicObject>(masterId2detailMap.size());
        Date now = new Date();
        for (Map.Entry<Long, FaCardBusCtrDetailPo> cardBusCtr : masterId2detailMap.entrySet()) {
            DynamicObject cardBusCotrDy = new DynamicObject((DynamicObjectType)cardBusCtrType);
            cardBusCotrDy.set("id", (Object)cardBusCtr.getKey());
            cardBusCotrDy.set("bizstatus", (Object)initBizStatuse.name());
            cardBusCotrDy.set("srcbillid", (Object)0L);
            cardBusCotrDy.set("srcbillentityname", (Object)"fa_depre");
            cardBusCotrDy.set("sublocknum", (Object)1);
            cardBusCotrDy.set("modifytime", (Object)now);
            DynamicObjectCollection detailEntity = cardBusCotrDy.getDynamicObjectCollection("detailentryentity");
            DynamicObject detailEntityEntry = detailEntity.addNew();
            FaCardBusCtrDetailPo detail = cardBusCtr.getValue();
            detailEntityEntry.set("dtholdlockentityname", (Object)detail.getSourceEntityType());
            detailEntityEntry.set("dtholdlockdataid", (Object)detail.getAssetBookId());
            detailEntityEntry.set("dtmodifytime", (Object)now);
            notExistBusCtrList.add(cardBusCotrDy);
        }
        SaveServiceHelper.save((DynamicObject[])notExistBusCtrList.toArray(new DynamicObject[notExistBusCtrList.size()]));
    }

    @Override
    public void batchUnLockCard2Book(Map<Long, FaCardBusCtrDetailPo> masterId2detailMap) {
        if (masterId2detailMap == null || masterId2detailMap.size() == 0) {
            return;
        }
        MainEntityType cardBusCtrType = EntityMetadataCache.getDataEntityType((String)"fa_card_bus_ctr");
        DynamicObject[] cardBusCtrArr = BusinessDataServiceHelper.load((Object[])masterId2detailMap.keySet().toArray(), (DynamicObjectType)cardBusCtrType);
        HashSet<Long> sublocknumNotRightSet = new HashSet<Long>(16);
        HashSet<Long> updateMasterIdSet = new HashSet<Long>(masterId2detailMap.size());
        HashSet<Long> deleteEntryIDSet = new HashSet<Long>(masterId2detailMap.size());
        block0: for (DynamicObject cardBusCtrData : cardBusCtrArr) {
            int sublocknum = cardBusCtrData.getInt("sublocknum");
            if (sublocknum < 1) {
                sublocknumNotRightSet.add(cardBusCtrData.getLong("id"));
                continue;
            }
            DynamicObjectCollection detailEntity = cardBusCtrData.getDynamicObjectCollection("detailentryentity");
            FaCardBusCtrDetailPo cardBusCtrDetailPo = masterId2detailMap.get(cardBusCtrData.getLong("id"));
            String sublockdataid2EntityName = cardBusCtrDetailPo.getAssetBookId() + "_" + cardBusCtrDetailPo.getSourceEntityType();
            for (DynamicObject detail : detailEntity) {
                String detailKey = detail.getString("dtholdlockdataid") + "_" + detail.getString("dtholdlockentityname");
                if (!sublockdataid2EntityName.equals(detailKey)) continue;
                updateMasterIdSet.add(cardBusCtrData.getLong("id"));
                deleteEntryIDSet.add(detail.getLong("id"));
                continue block0;
            }
        }
        if (sublocknumNotRightSet.size() > 0) {
            String alterNums = this.getRealIDNumber(sublocknumNotRightSet);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5f02\u5e38\uff0c\u4ee5\u4e0b\u8d44\u4ea7\u7f16\u7801\u7684\u5361\u7247\u76ee\u524d\u6ca1\u6709\u505a\u8d26\u7c3f\u4e1a\u52a1\uff0c\u91ca\u653e\u5931\u8d25\uff1a\u201c%1$s\u201d\u3002", (String)"FaRealCardDaoOrmImpl_4", (String)"fi-fa-business", (Object[])new Object[0]), alterNums));
        }
        if (deleteEntryIDSet.size() > 0) {
            SqlBuilder deleteSb = new SqlBuilder();
            deleteSb.append("delete t_fa_card_bus_ctr_detail where ", new Object[0]).appendIn("FEntryID ", deleteEntryIDSet.toArray());
            int deleteRows = DB.update((DBRoute)FaConstants.faDBRoute, (SqlBuilder)deleteSb);
            if (deleteRows != deleteEntryIDSet.size()) {
                String alterNums = this.getRealIDNumber(updateMasterIdSet);
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5f02\u5e38\uff0c\u4ee5\u4e0b\u8d44\u4ea7\u7f16\u7801\u7684\u5361\u7247\u91ca\u653e\u8d26\u7c3f\u4e1a\u52a1\u5206\u9501\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff1a\u201c%1$s\u201d\u3002", (String)"FaRealCardDaoOrmImpl_5", (String)"fi-fa-business", (Object[])new Object[0]), alterNums));
            }
        }
        if (updateMasterIdSet.size() != 0) {
            Date now = new Date();
            SqlBuilder sb = new SqlBuilder();
            sb.append("update t_fa_card_bus_ctr set ", new Object[0]).append("fmodifytime = ?,", new Object[]{now}).append("fsublocknum = fsublocknum-1", new Object[0]).append(" where ", new Object[0]).appendIn("fid", updateMasterIdSet.toArray()).append("and fsublocknum > 0", new Object[0]);
            int updateRows = DB.update((DBRoute)FaConstants.faDBRoute, (SqlBuilder)sb);
            if (updateRows != updateMasterIdSet.size()) {
                String alterNums = this.getRealIDNumber(updateMasterIdSet);
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5f02\u5e38\uff0c\u4ee5\u4e0b\u8d44\u4ea7\u7f16\u7801\u7684\u5361\u7247\u201c%1$s\u201d\u91ca\u653e\u8d26\u7c3f\u4e1a\u52a1\u5206\u9501\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"FaRealCardDaoOrmImpl_6", (String)"fi-fa-business", (Object[])new Object[0]), alterNums));
            }
        }
    }

    private String getRealIDNumber(Set<Long> masterIds) {
        if (masterIds == null || masterIds.size() == 0) {
            return "";
        }
        SqlBuilder sbR = new SqlBuilder();
        sbR.append("select fnumber as number from t_fa_card_real where ", new Object[0]).appendIn("fmasterid", masterIds.toArray()).append("and fisbak = '0'", new Object[0]);
        StringBuilder alterSb = new StringBuilder();
        int i = 0;
        try (DataSet dataSetR = DB.queryDataSet((String)"OtherHoldRealAlterNumber", (DBRoute)FaConstants.faDBRoute, (SqlBuilder)sbR);){
            for (Row real : dataSetR) {
                String number = real.getString("number");
                if (i == 0) {
                    alterSb.append(number);
                } else {
                    alterSb.append(",").append(number);
                }
                ++i;
            }
        }
        return alterSb.toString();
    }

    private String getNotSubBusMasterIds(List<Long> masterIds, List<BizStatusEnum> fromBizStatuses) {
        List fromBizStrList = fromBizStatuses.stream().map(v -> v.name()).collect(Collectors.toList());
        SqlBuilder sbR100 = new SqlBuilder();
        sbR100.append("select fid,fsrcbillentityname from t_fa_card_bus_ctr where ", new Object[0]).appendIn("fid", masterIds.toArray()).appendIn("and FBIZSTATUS not ", fromBizStrList.toArray());
        HashSet<Long> errorMasterIds = new HashSet<Long>(masterIds.size(), 1.0f);
        HashMap<Long, String> masterId2EntityLocalNameMap = new HashMap<Long, String>(masterIds.size(), 1.0f);
        try (DataSet dataSetR = DB.queryDataSet((String)"getNotSubBusMasterIds", (DBRoute)FaConstants.faDBRoute, (SqlBuilder)sbR100);){
            for (Row ctr : dataSetR) {
                errorMasterIds.add(ctr.getLong("fid"));
                String entityName = ctr.getString("fsrcbillentityname");
                if (entityName.trim().length() <= 0) continue;
                MainEntityType srcbillEntityType = EntityMetadataCache.getDataEntityType((String)entityName);
                String billEntityDispName = srcbillEntityType.getDisplayName().getLocaleValue();
                masterId2EntityLocalNameMap.put(ctr.getLong("fid"), billEntityDispName);
            }
        }
        if (errorMasterIds == null || errorMasterIds.size() == 0) {
            return "";
        }
        SqlBuilder sbR = new SqlBuilder();
        sbR.append("select fmasterid,fnumber as number from t_fa_card_real where ", new Object[0]).appendIn("fmasterid", errorMasterIds.toArray()).append("and fisbak = '0'", new Object[0]);
        StringBuilder alterSb = new StringBuilder();
        int i = 0;
        try (DataSet dataSetR = DB.queryDataSet((String)"OtherHoldRealAlterNumber", (DBRoute)FaConstants.faDBRoute, (SqlBuilder)sbR);){
            for (Row real : dataSetR) {
                Long masterId = real.getLong("fmasterid");
                String entityLocalName = (String)masterId2EntityLocalNameMap.get(masterId);
                if (entityLocalName == null) {
                    entityLocalName = "";
                }
                String number = real.getString("number");
                if (i == 0) {
                    alterSb.append("[").append(number).append("]").append(entityLocalName);
                } else {
                    alterSb.append(",").append("[").append(number).append("]").append(entityLocalName);
                }
                ++i;
            }
        }
        return alterSb.toString();
    }

    static {
        excludeChangeStatusList.add("A");
        excludeChangeStatusList.add("B");
    }

    static class ReResult {
        Map<Object, Object> realId2BakRealIdMap;

        ReResult() {
        }
    }
}

