/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.dataasset;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.business.dataasset.DetailStatusEnum;

public class DataAssetUtil {
    public static final Set<String> NEED_UPDATE_DETAIL_MDF_TIME_FIELDS = new HashSet<String>(6);

    public static void fillEntry(Object dataAssetId, AbstractFormDataModel model, IFormView view, String entityName, int top) {
        String entityId = view.getEntityId();
        QFilter fidFilter = new QFilter("dataasset", "=", dataAssetId);
        boolean isDetail = "fa_dataassetdetail".equals(entityId);
        if (isDetail) {
            fidFilter = fidFilter.and(new QFilter("detailstatus", "=", (Object)DetailStatusEnum.ENABLE.getValue()));
        }
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"fa_dataassetdetail_base", (String)"id,detailname,detailqty,detailsupplier,detailremark,detailstatus,detailmodifer,detailmdftime,detailunit", (QFilter[])new QFilter[]{fidFilter}, (String)"detailmdftime DESC", (int)top);
        model.beginInit();
        TableValueSetter tableValueSetter = new TableValueSetter(new String[0]);
        for (int i = 0; i < collection.size(); ++i) {
            DynamicObject row = (DynamicObject)collection.get(i);
            Date detailMdfTime = row.getDate("detailmdftime");
            if (isDetail) {
                tableValueSetter.set("id", row.get("id"), i);
            } else {
                tableValueSetter.set("detailid", row.get("id"), i);
                tableValueSetter.set("detailunit", row.get("detailunit"), i);
                tableValueSetter.set("detailmdftimetext", (Object)detailMdfTime.toString(), i);
            }
            tableValueSetter.set("detailname", row.get("detailname"), i);
            tableValueSetter.set("detailqty", row.get("detailqty"), i);
            tableValueSetter.set("detailsupplier", row.get("detailsupplier"), i);
            tableValueSetter.set("detailstatus", row.get("detailstatus"), i);
            tableValueSetter.set("detailremark", row.get("detailremark"), i);
            tableValueSetter.set("detailmodifer", row.get("detailmodifer"), i);
            tableValueSetter.set("detailmdftime", (Object)detailMdfTime, i);
            if (!isDetail) continue;
            view.setEnable(Boolean.valueOf(false), i, new String[]{"detailname", "detailqty", "detailsupplier", "detailstatus", "detailremark", "detailmodifer", "detailmdftime"});
        }
        model.batchCreateNewEntryRow(entityName, tableValueSetter);
        model.endInit();
        view.updateView(entityName);
    }

    public static void buildDataAssetByDetail(DynamicObject dataAsset, Collection<DynamicObject> detailDataList) {
        List list = detailDataList.stream().filter(row -> DetailStatusEnum.ENABLE.getValue().equals(row.get("detailstatus"))).sorted(Comparator.comparing(row -> row.getDate("detailmdftime"))).collect(Collectors.toList());
        if (list.size() == 0) {
            return;
        }
        DynamicObject detail = (DynamicObject)list.get(list.size() - 1);
        BigDecimal detailQty = detail.getBigDecimal("detailqty");
        Date detailMdfTime = detail.getDate("detailmdftime");
        dataAsset.set("scaleqty", (Object)detailQty);
        dataAsset.set("lastmodifytime", (Object)detailMdfTime);
        if (dataAsset.getLong("id") == 0L) {
            dataAsset.set("id", (Object)DB.genLongId((String)"t_fa_data_asset"));
            dataAsset.set("initqty", (Object)detailQty);
        }
    }

    public static boolean updateDataAsset(DBRoute fa, Object dataAssetId, Date lastModifyTime, Set<Long> toDisableDetailIds) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(3);
        QFilter statusFilter = new QFilter("detailstatus", "=", (Object)DetailStatusEnum.ENABLE.getValue());
        filters.add(statusFilter);
        QFilter fidFilter = new QFilter("dataasset", "=", dataAssetId);
        filters.add(fidFilter);
        if (!CollectionUtils.isEmpty(toDisableDetailIds)) {
            QFilter idFilter = new QFilter("id", "not in", toDisableDetailIds);
            filters.add(idFilter);
        }
        DynamicObjectCollection lastEnableRecord = QueryServiceHelper.query((String)"fa_dataassetdetail_base", (String)"detailqty,detailmdftime", (QFilter[])filters.toArray(new QFilter[0]), (String)"detailmdftime DESC", (int)1);
        DynamicObject lastEnableRow = (DynamicObject)lastEnableRecord.get(0);
        String updateDataAssetSql = "UPDATE t_fa_data_asset SET fscaleqty=?,flastmodifytime=? WHERE fid=? and flastmodifytime=?";
        Object[] params = new Object[]{lastEnableRow.getBigDecimal("detailqty"), lastEnableRow.getDate("detailmdftime"), dataAssetId, lastModifyTime};
        return DB.execute((DBRoute)fa, (String)updateDataAssetSql, (Object[])params);
    }

    public static Object getBaseDataId(IDataModel model, String baseDataField) {
        return ((DynamicObject)model.getValue(baseDataField)).get("id");
    }

    static {
        NEED_UPDATE_DETAIL_MDF_TIME_FIELDS.add("detailname");
        NEED_UPDATE_DETAIL_MDF_TIME_FIELDS.add("detailqty");
        NEED_UPDATE_DETAIL_MDF_TIME_FIELDS.add("detailsupplier");
        NEED_UPDATE_DETAIL_MDF_TIME_FIELDS.add("detailremark");
        NEED_UPDATE_DETAIL_MDF_TIME_FIELDS.add("detailmdftime");
    }
}

