/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.depreciation;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.fi.fa.business.depreciation.FaBizInfo;
import kd.fi.fa.business.depreciation.FaBizInfoPool;
import kd.fi.fa.business.depreciation.FaBizStrategy;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.common.util.Tuple;

public class DecValStrategy
extends FaBizStrategy {
    @Override
    public String getEntityName() {
        return "fa_asset_devalue";
    }

    @Override
    public List<FaBizInfo> build(FaBizInfoPool pool, DataSet bizBillDataSet, Set<Object> realcardMasterIdSet) {
        ArrayList<FaBizInfo> lst = new ArrayList<FaBizInfo>(1600);
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)this.getEntityName());
        String typeName = type.getDisplayName().getLocaleValue();
        for (Row row : bizBillDataSet) {
            Long realCardMasterId = row.getLong("realcard");
            if (realcardMasterIdSet != null && !realcardMasterIdSet.contains(realCardMasterId)) continue;
            String bizName = String.format("%s(%s)", typeName, row.getString("billno"));
            Date billDate = row.getDate("billDate");
            Date auditDate = row.getDate("auditdate");
            Date bizDate = row.getDate("bizdate");
            FaBizInfo bizInfo = new FaBizInfo(bizName, realCardMasterId, billDate, auditDate, bizDate, 1);
            bizInfo.setField("decval");
            bizInfo.setDiffValue(row.getBigDecimal("decval"));
            lst.add(bizInfo);
        }
        return lst;
    }

    @Override
    protected String getSelectFields() {
        String selectFields = "devalueperiod.beginDate billDate, auditdate, billno,changebillentry.realcardmasterid realcard,changebillentry.bizdate bizdate,changebillentry.decval decval";
        return selectFields;
    }

    @Override
    protected String getBizDateFieldName() {
        return "changebillentry.bizdate";
    }

    @Override
    protected String getDepreUseFieldName() {
        return "depreuse";
    }

    @Override
    protected String getRealCardMasterIdFieldName() {
        return Fa.dot((String[])new String[]{"changebillentry", "realcardmasterid"});
    }

    @Override
    public Tuple<Boolean, String> getBillDateTuple() {
        return new Tuple((Object)true, (Object)"devalueperiod");
    }
}

