/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.depreciation;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.fi.fa.business.depreciation.DepreDaySegment;
import kd.fi.fa.business.depreciation.FaBizInfo;
import kd.fi.fa.common.util.Fa;

public class DepreSegment {
    private Date beginDate;
    private Date endDate;
    private Long periodId;
    private DynamicObject fincard;
    private boolean dynamic;
    private BigDecimal rate;
    private boolean firstSegOfAccountYear;
    private boolean includeNew;
    private boolean allClear;
    private boolean hasPartClear;
    public final List<FaBizInfo> bizLst = new ArrayList<FaBizInfo>();

    public List<DepreDaySegment> getDepreDaySegmentList() {
        ArrayList<DepreDaySegment> dayGroupList = new ArrayList<DepreDaySegment>(8);
        DepreDaySegment depreDaySegment = new DepreDaySegment();
        dayGroupList.add(depreDaySegment);
        depreDaySegment.setBeginDate(this.beginDate);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.beginDate);
        int beginDateSeq = calendar.get(6);
        int beginDateYear = calendar.get(1);
        if (this.bizLst.size() == 0) {
            depreDaySegment.setEndDate(this.endDate);
            calendar.setTime(this.endDate);
            int endDateSeq = calendar.get(6);
            int endDateYear = calendar.get(1);
            if (beginDateYear == endDateYear) {
                depreDaySegment.setDayCount(BigDecimal.valueOf(endDateSeq - beginDateSeq + 1));
            } else {
                calendar.set(1, endDateYear);
                calendar.set(2, 0);
                calendar.set(5, 1);
                calendar.set(10, 0);
                calendar.set(12, 0);
                calendar.set(13, 0);
                calendar.set(14, 0);
                calendar.add(6, -1);
                int beginDateYearLastDay = calendar.get(6);
                depreDaySegment.setDayCount(BigDecimal.valueOf(beginDateYearLastDay - beginDateSeq + 1 + endDateSeq));
            }
        } else {
            for (FaBizInfo faBizInfo : this.bizLst) {
                Date bizDate = faBizInfo.getBizDate();
                calendar.setTime(bizDate);
                int bizDateSeq = calendar.get(6);
                int bizDateYear = calendar.get(1);
                if (beginDateSeq == bizDateSeq) {
                    depreDaySegment.bizLst.add(faBizInfo);
                } else {
                    calendar.add(6, -1);
                    depreDaySegment.setEndDate(calendar.getTime());
                    if (bizDateYear == beginDateYear) {
                        depreDaySegment.setDayCount(BigDecimal.valueOf(bizDateSeq - beginDateSeq));
                    } else {
                        calendar.set(1, bizDateYear);
                        calendar.set(2, 0);
                        calendar.set(5, 1);
                        calendar.set(10, 0);
                        calendar.set(12, 0);
                        calendar.set(13, 0);
                        calendar.set(14, 0);
                        calendar.add(6, -1);
                        int beginDateYearLastDay = calendar.get(6);
                        depreDaySegment.setDayCount(BigDecimal.valueOf(beginDateYearLastDay - beginDateSeq + bizDateSeq));
                    }
                    depreDaySegment = new DepreDaySegment();
                    dayGroupList.add(depreDaySegment);
                    depreDaySegment.setBeginDate(bizDate);
                    depreDaySegment.bizLst.add(faBizInfo);
                    beginDateSeq = bizDateSeq;
                    beginDateYear = bizDateYear;
                }
                if (faBizInfo.isAllClear()) {
                    depreDaySegment.setAllClear(Boolean.TRUE);
                    continue;
                }
                if (!faBizInfo.isPartClear()) continue;
                depreDaySegment.setHasPartClear(true);
            }
            depreDaySegment.setEndDate(this.endDate);
            calendar.setTime(this.endDate);
            int endDateSeq = calendar.get(6);
            int endDateYear = calendar.get(1);
            if (beginDateYear == endDateYear) {
                if (endDateSeq < beginDateSeq) {
                    depreDaySegment.setDayCount(BigDecimal.ZERO);
                } else {
                    depreDaySegment.setDayCount(BigDecimal.valueOf(endDateSeq - beginDateSeq + 1));
                }
            } else {
                calendar.set(1, endDateYear);
                calendar.set(2, 0);
                calendar.set(5, 1);
                calendar.set(10, 0);
                calendar.set(12, 0);
                calendar.set(13, 0);
                calendar.set(14, 0);
                calendar.add(6, -1);
                int beginDateYearLastDay = calendar.get(6);
                depreDaySegment.setDayCount(BigDecimal.valueOf(beginDateYearLastDay - beginDateSeq + 1 + endDateSeq));
            }
        }
        return dayGroupList;
    }

    public void addBiz(FaBizInfo biz) {
        this.bizLst.add(biz);
    }

    public void setHasPartClear() {
        this.hasPartClear = true;
    }

    public boolean isHasPartClear() {
        return this.hasPartClear;
    }

    public String getAlias() {
        return String.format(ResManager.loadKDString((String)"\u671f\u533a\u95f4[%1$s, %2$s]", (String)"DepreSegment_0", (String)"fi-fa-business", (Object[])new Object[0]), Fa.getDF().format(this.beginDate), Fa.getDF().format(this.endDate));
    }

    public boolean isIncludeNew() {
        return this.includeNew;
    }

    public void setIncludeNew(boolean includeNew) {
        this.includeNew = includeNew;
    }

    public boolean isFirstSegOfAccountYear() {
        return this.firstSegOfAccountYear;
    }

    public void setFirstSegOfAccountYear(boolean firstSegOfAccountYear) {
        this.firstSegOfAccountYear = firstSegOfAccountYear;
    }

    public Long getPeriodId() {
        return this.periodId;
    }

    public void setPeriodId(Long periodId) {
        this.periodId = periodId;
    }

    public Date getBeginDate() {
        return this.beginDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public DynamicObject getFincard() {
        return this.fincard;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public BigDecimal getRate() {
        return this.rate;
    }

    public boolean isAllClear() {
        return this.allClear;
    }

    public void setBeginDate(Date beginDate) {
        this.beginDate = beginDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public void setFincard(DynamicObject fincard) {
        this.fincard = fincard;
    }

    public void setDynamic(boolean dynamic) {
        this.dynamic = dynamic;
    }

    public void setRate(BigDecimal rate) {
        this.rate = rate;
    }

    public void setAllClear(boolean allClear) {
        this.allClear = allClear;
    }

    public void setHasPartClear(boolean hasPartClear) {
        this.hasPartClear = hasPartClear;
    }

    public String toString() {
        return "DepreSegment [beginDate=" + this.beginDate + ", endDate=" + this.endDate + ", periodId=" + this.periodId + ", fincard=" + this.fincard + ", dynamic=" + this.dynamic + ", rate=" + this.rate + ", firstSegOfAccountYear=" + this.firstSegOfAccountYear + ", includeNew=" + this.includeNew + ", allClear=" + this.allClear + ", hasPartClear=" + this.hasPartClear + ", bizLst=" + this.bizLst + "]";
    }
}

