/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.depreciation;

import java.util.Date;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.business.depreciation.DecValStrategy;
import kd.fi.fa.business.depreciation.DepreBook;
import kd.fi.fa.business.depreciation.FaBizInfo;
import kd.fi.fa.business.depreciation.FaBizInfoPool;
import kd.fi.fa.common.util.Tuple;

public abstract class FaBizStrategy {
    public abstract String getEntityName();

    public abstract List<FaBizInfo> build(FaBizInfoPool var1, DataSet var2, Set<Object> var3);

    protected abstract String getSelectFields();

    protected abstract String getBizDateFieldName();

    protected abstract String getDepreUseFieldName();

    protected abstract String getRealCardMasterIdFieldName();

    public abstract Tuple<Boolean, String> getBillDateTuple();

    public DataSet queryCurPeriodBizBill(FaBizInfoPool pool, Boolean includeAll) {
        DepreBook book = pool.getBook();
        if (this.getDepreUseFieldName() == null && !book.getBook().getBoolean("ismainbook")) {
            return null;
        }
        DynamicObject curPeriod = book.getCurPeriod();
        Date beginDate = curPeriod.getDate("beginDate");
        Date endDate = curPeriod.getDate("endDate");
        String selectFields = this.getSelectFields();
        QFilter filter = this.getFilter(book);
        if (!includeAll.booleanValue()) {
            Tuple<Boolean, String> billDateTuple = this.getBillDateTuple();
            String billDateFieldName = (String)billDateTuple.item2;
            if (((Boolean)billDateTuple.item1).booleanValue()) {
                if (this instanceof DecValStrategy) {
                    Long prePeriodId = book.getPeriodGroup().getPrePeriodId(curPeriod.getLong("id"));
                    if (prePeriodId == 0L) {
                        filter = filter.and(new QFilter(billDateFieldName, "<=", curPeriod.get("id")));
                    } else {
                        filter = filter.and(new QFilter(billDateFieldName, ">=", (Object)prePeriodId));
                        filter = filter.and(new QFilter(billDateFieldName, "<=", curPeriod.get("id")));
                    }
                } else {
                    filter = filter.and(new QFilter(billDateFieldName, "=", curPeriod.get("id")));
                }
            } else {
                filter = filter.and(new QFilter(billDateFieldName, ">=", (Object)beginDate)).and(new QFilter(billDateFieldName, "<=", (Object)endDate));
            }
        }
        return QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)this.getEntityName(), (String)selectFields, (QFilter[])filter.toArray(), null);
    }

    public DataSet queryBizBill(FaBizInfoPool pool, DynamicObject beginPeriod, Set<Object> realcardMasterIdSet) {
        String billDateFieldName;
        Tuple<Boolean, String> billDateTuple;
        QFilter timeFilter;
        DepreBook book = pool.getBook();
        if (this.getDepreUseFieldName() == null && !book.getBook().getBoolean("ismainbook")) {
            return null;
        }
        String selectFields = this.getSelectFields();
        QFilter filter = this.getFilter(book);
        Date beginDate = beginPeriod.getDate("beginDate");
        Date endDate = beginPeriod.getDate("endDate");
        String bizDateFieldName = this.getBizDateFieldName();
        if (bizDateFieldName != null) {
            timeFilter = new QFilter(bizDateFieldName, ">=", (Object)beginDate);
        } else {
            billDateTuple = this.getBillDateTuple();
            billDateFieldName = (String)billDateTuple.item2;
            timeFilter = (Boolean)billDateTuple.item1 != false ? new QFilter(billDateFieldName, ">=", beginPeriod.get("id")) : new QFilter(billDateFieldName, ">=", (Object)beginDate);
        }
        billDateTuple = this.getBillDateTuple();
        billDateFieldName = (String)billDateTuple.item2;
        timeFilter = (Boolean)billDateTuple.item1 != false ? timeFilter.or(new QFilter(billDateFieldName, "=", beginPeriod.get("id"))) : timeFilter.or(new QFilter(billDateFieldName, ">=", (Object)beginDate).and(new QFilter(billDateFieldName, "<=", (Object)endDate)));
        QFilter realcardMasterIdFilter = new QFilter(this.getRealCardMasterIdFieldName(), "in", realcardMasterIdSet);
        return QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)this.getEntityName(), (String)selectFields, (QFilter[])new QFilter[]{filter, timeFilter, realcardMasterIdFilter}, null);
    }

    protected QFilter getFilter(DepreBook book) {
        DynamicObject org = book.getOrg();
        QFilter filter = new QFilter("org", "=", org.getPkValue()).and(new QFilter("billstatus", "=", (Object)"C"));
        if (this.getDepreUseFieldName() != null) {
            DynamicObject depreUse = book.getDepreUse();
            filter = filter.and(new QFilter(this.getDepreUseFieldName(), "=", depreUse.getPkValue()));
        }
        return filter;
    }
}

