/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.depreciation;

import java.math.BigDecimal;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.fi.fa.business.depreciation.DepreAlgoInter;
import kd.fi.fa.business.depreciation.DepreBook;
import kd.fi.fa.business.depreciation.DepreMethod;
import kd.fi.fa.business.depreciation.DepreSegment;
import kd.fi.fa.common.util.FormulaUtil;

public class FormulaDepreMethod
extends DepreMethod {
    private String formula;

    public FormulaDepreMethod(String formula, String type, DepreBook book) {
        super(book, type);
        this.formula = formula;
    }

    @Override
    public BigDecimal compute(DepreAlgoInter depreCard, DepreSegment seg) {
        DynamicObject finCard = depreCard.getFinCard();
        DynamicObjectType type = finCard.getDynamicObjectType();
        DataEntityPropertyCollection props = type.getProperties();
        HashMap<String, IDataEntityProperty> m = new HashMap<String, IDataEntityProperty>();
        for (IDataEntityProperty prop : props) {
            m.put(prop.getName(), prop);
        }
        BigDecimal depreAmount = (BigDecimal)FormulaUtil.executeFormula((String)this.formula, (DynamicObject)finCard, m, null);
        return depreAmount;
    }
}

