/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.depreciation;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.fi.fa.business.depreciation.FaBizInfo;
import kd.fi.fa.business.depreciation.FaBizInfoPool;
import kd.fi.fa.business.depreciation.FaBizStrategy;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.common.util.Tuple;

public class MergeBillStrategy
extends FaBizStrategy {
    private static Map<String, String> inFinField2BillFiledMap = new HashMap<String, String>(4, 1.0f);

    @Override
    public String getEntityName() {
        return "fa_mergebill";
    }

    @Override
    protected String getSelectFields() {
        StringBuilder selectFields = new StringBuilder();
        selectFields.append("mergedate,auditdate,billno,mergeperiod");
        selectFields.append(",inentryentity.inrealcardmasterid inrealcard");
        selectFields.append(",inentryentity.inoriginalval inoriginalval");
        selectFields.append(",inentryentity.inaccumdepre inaccumdepre");
        selectFields.append(",inentryentity.indecval indecval");
        selectFields.append(",inentryentity.inpreresidualval inpreresidualval");
        return selectFields.toString();
    }

    @Override
    public List<FaBizInfo> build(FaBizInfoPool pool, DataSet bizBills, Set<Object> realcardMasterIdSet) {
        ArrayList<FaBizInfo> lst = new ArrayList<FaBizInfo>(1600);
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)this.getEntityName());
        String typeName = type.getDisplayName().getLocaleValue();
        for (Row bizBill : bizBills) {
            Object realCardId = bizBill.get("inrealcard");
            if (realcardMasterIdSet != null && !realcardMasterIdSet.contains(realCardId)) continue;
            String bizName = String.format("%s(%s)", typeName, bizBill.getString("billno"));
            Date billDate = bizBill.getDate("mergedate");
            Date auditDate = bizBill.getDate("auditDate");
            Date bizDate = billDate;
            Long mergeperiodId = bizBill.getLong("mergeperiod");
            for (Map.Entry<String, String> finField2BillFiled : inFinField2BillFiledMap.entrySet()) {
                BigDecimal diffValue = bizBill.getBigDecimal(finField2BillFiled.getValue());
                if (diffValue == null || diffValue.compareTo(BigDecimal.ZERO) == 0) continue;
                FaBizInfo bizInfo = new FaBizInfo(bizName, bizBill.get("inrealcard"), billDate, auditDate, bizDate, 1);
                bizInfo.setField(finField2BillFiled.getKey());
                bizInfo.setDiffValue(diffValue);
                bizInfo.setBillDatePeriodId(mergeperiodId);
                bizInfo.setBizDatePeriodId(mergeperiodId);
                lst.add(bizInfo);
            }
        }
        return lst;
    }

    @Override
    protected String getBizDateFieldName() {
        return "mergedate";
    }

    @Override
    protected String getDepreUseFieldName() {
        return "inentryentity.indepreuse";
    }

    @Override
    public Tuple<Boolean, String> getBillDateTuple() {
        return new Tuple((Object)false, (Object)"mergedate");
    }

    @Override
    protected String getRealCardMasterIdFieldName() {
        return Fa.dot((String[])new String[]{"inentryentity", "inrealcardmasterid"});
    }

    static {
        inFinField2BillFiledMap.put("originalval", "inoriginalval");
        inFinField2BillFiledMap.put("accumdepre", "inaccumdepre");
        inFinField2BillFiledMap.put("decval", "indecval");
        inFinField2BillFiledMap.put("preresidualval", "inpreresidualval");
    }
}

