/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.depreciation;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.fa.business.depreciation.PeriodYear;
import kd.fi.fa.common.util.Fa;

public class PeriodDataStructure {
    private List<PeriodYear> periodYearLst = new ArrayList<PeriodYear>(10);
    private final Map<Long, DynamicObject> dateToPeriod = new HashMap<Long, DynamicObject>(16);
    private final List<Long> periodIdList = new ArrayList<Long>(10);
    private final Map<Long, Integer> periodIdToIndex = new HashMap<Long, Integer>(16);
    private final Map<Long, DynamicObject> periodIdToPeriod = new HashMap<Long, DynamicObject>(16);
    private static final Log log = LogFactory.getLog(PeriodDataStructure.class);

    public PeriodDataStructure(List<PeriodYear> periodYearLst) {
        this.periodYearLst = periodYearLst;
        for (PeriodYear periodYear : periodYearLst) {
            if (periodYear.getPeriodLst() == null || periodYear.getPeriodLst().size() == 0) continue;
            for (DynamicObject period : periodYear.getPeriodLst()) {
                Date begindate = period.getDate("begindate");
                Date enddate = period.getDate("enddate");
                Calendar begindateCal = Calendar.getInstance();
                begindateCal.setTime(begindate);
                while (begindate.getTime() < enddate.getTime()) {
                    this.dateToPeriod.put(begindate.getTime(), period);
                    begindateCal.add(5, 1);
                    begindate = begindateCal.getTime();
                }
                this.dateToPeriod.put(enddate.getTime(), period);
                this.periodIdList.add(period.getLong("id"));
                this.periodIdToPeriod.put(period.getLong("id"), period);
            }
        }
        Collections.sort(this.periodIdList);
        for (int i = 0; i < this.periodIdList.size(); ++i) {
            this.periodIdToIndex.put(this.periodIdList.get(i), i);
        }
    }

    public DynamicObject getPeriod(Date date, String cardNumber) {
        DynamicObject period = this.dateToPeriod.get(date.getTime());
        if (period != null) {
            return period;
        }
        String dateFmt = Fa.getDF().format(date);
        Date formatDate = null;
        try {
            formatDate = Fa.getDF().parse(dateFmt);
        }
        catch (ParseException e) {
            log.error(String.format("\u5361\u7247%s\u8f6c\u6362\u65e5\u671f%s\u5f02\u5e38", cardNumber, dateFmt), (Throwable)e);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5361\u7247%1$s\u8f6c\u6362\u65e5\u671f%2$s\u5f02\u5e38\u3002", (String)"PeriodDataStructure_0", (String)"fi-fa-business", (Object[])new Object[0]), cardNumber, dateFmt));
        }
        period = this.dateToPeriod.get(formatDate.getTime());
        return period;
    }

    public List<DynamicObject> getPeriods(Date begindate, Date enddate, String cardNumber) {
        DynamicObject begindatePeriod = this.getPeriod(begindate, cardNumber);
        if (begindatePeriod == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5361\u7247\u201c%1$s\u201d\u6839\u636e\u65e5\u671f\u201c%2$s\u201d\u627e\u4e0d\u5230\u671f\u95f4\u3002", (String)"PeriodDataStructure_1", (String)"fi-fa-business", (Object[])new Object[0]), cardNumber, Fa.getTF().format(begindate)));
        }
        DynamicObject enddatePeriod = this.getPeriod(enddate, cardNumber);
        if (enddatePeriod == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5361\u7247\u201c%1$s\u201d\u6839\u636e\u65e5\u671f\u201c%2$s\u201d\u627e\u4e0d\u5230\u671f\u95f4\u3002", (String)"PeriodDataStructure_1", (String)"fi-fa-business", (Object[])new Object[0]), cardNumber, Fa.getTF().format(enddate)));
        }
        Long beginDatePk = begindatePeriod.getLong("id");
        Long endDatePk = enddatePeriod.getLong("id");
        int begindateIndex = this.periodIdToIndex.get(beginDatePk);
        int enddateIndex = this.periodIdToIndex.get(endDatePk);
        ArrayList<DynamicObject> rangPeriods = new ArrayList<DynamicObject>(2);
        for (int i = begindateIndex; i <= enddateIndex; ++i) {
            Long periodId = this.periodIdList.get(i);
            DynamicObject peirod = this.periodIdToPeriod.get(periodId);
            rangPeriods.add(peirod);
        }
        return rangPeriods;
    }

    public int getPeriodCount(Date begindate, Date enddate, String cardNumber) {
        DynamicObject begindatePeriod = this.getPeriod(begindate, cardNumber);
        if (begindatePeriod == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5361\u7247\u201c%1$s\u201d\u6839\u636e\u65e5\u671f\u201c%2$s\u201d\u627e\u4e0d\u5230\u671f\u95f4\u3002", (String)"PeriodDataStructure_1", (String)"fi-fa-business", (Object[])new Object[0]), cardNumber, Fa.getTF().format(begindate)));
        }
        DynamicObject enddatePeriod = this.getPeriod(enddate, cardNumber);
        if (enddatePeriod == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5361\u7247\u201c%1$s\u201d\u6839\u636e\u65e5\u671f\u201c%2$s\u201d\u627e\u4e0d\u5230\u671f\u95f4\u3002", (String)"PeriodDataStructure_1", (String)"fi-fa-business", (Object[])new Object[0]), cardNumber, Fa.getTF().format(enddate)));
        }
        Long beginDatePk = begindatePeriod.getLong("id");
        Long endDatePk = enddatePeriod.getLong("id");
        int begindateIndex = this.periodIdToIndex.get(beginDatePk);
        int enddateIndex = this.periodIdToIndex.get(endDatePk);
        return enddateIndex - begindateIndex + 1;
    }

    public Long getPrePeriodId(Long periodid) {
        Long prePeriodId = 0L;
        for (Long periodIdTemp : this.periodIdList) {
            if (periodid.longValue() == periodIdTemp.longValue()) {
                return prePeriodId;
            }
            prePeriodId = periodIdTemp;
        }
        return prePeriodId;
    }
}

