/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.depreciation;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.business.depreciation.PeriodDataStructure;
import kd.fi.fa.business.depreciation.PeriodYear;
import kd.fi.fa.common.util.DateUtil;
import kd.fi.fa.common.util.Fa;

public class PeriodGroup {
    private final Object periodTypeId;
    private final List<PeriodYear> periodYearLst = new ArrayList<PeriodYear>();
    private PeriodDataStructure periodDataStr = null;
    private static final Log logger = LogFactory.getLog(PeriodGroup.class);

    public PeriodGroup(Object periodTypeId) {
        this.periodTypeId = periodTypeId;
        this.init();
        this.periodDataStr = new PeriodDataStructure(this.periodYearLst);
    }

    private void init() {
        String selectFields = "id,number,periodnumber,periodtype,begindate,enddate,periodoutline.id,periodoutline.outlinebegindate,periodoutline.outlineenddate";
        QFilter[] filters = new QFilter[]{new QFilter("periodtype", "=", this.periodTypeId), new QFilter("isadjustperiod", "=", (Object)false)};
        DynamicObjectCollection allPeriods = QueryServiceHelper.query((String)"bd_period", (String)selectFields, (QFilter[])filters, (String)"id desc");
        Map<Object, List<DynamicObject>> grp = allPeriods.stream().collect(Collectors.groupingBy(v -> v.get("periodoutline.id")));
        Set<Map.Entry<Object, List<DynamicObject>>> entrySet = grp.entrySet();
        for (Map.Entry<Object, List<DynamicObject>> entry : entrySet) {
            List<DynamicObject> periods = entry.getValue();
            Date yearBeginDate = periods.get(0).getDate("periodoutline.outlinebegindate");
            Date yearEndDate = periods.get(0).getDate("periodoutline.outlineenddate");
            if (yearBeginDate == null || yearEndDate == null) continue;
            periods.sort((v1, v2) -> Long.valueOf(v1.getString("id")).compareTo(Long.valueOf(v2.getString("id"))));
            PeriodYear periodYear = new PeriodYear(yearBeginDate, yearEndDate, periods);
            this.periodYearLst.add(periodYear);
        }
        this.periodYearLst.sort((v1, v2) -> DateUtil.compareDate((Date)v1.getYearBeginDate(), (Date)v2.getYearBeginDate()));
    }

    public DynamicObject getPeriodByDate(Date date, String cardNumber) {
        DynamicObject period = this.periodDataStr.getPeriod(date, cardNumber);
        if (period == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5361\u7247\u201c%1$s\u201d\u6839\u636e\u65e5\u671f\u201c%2$s\u201d\u627e\u4e0d\u5230\u671f\u95f4\u3002", (String)"PeriodGroup_0", (String)"fi-fa-business", (Object[])new Object[0]), cardNumber, Fa.getTF().format(date)));
        }
        return period;
    }

    @Deprecated
    public PeriodYear getPeriodYear(Object periodId) {
        for (PeriodYear periodYear : this.periodYearLst) {
            Optional<DynamicObject> findFirst = periodYear.getPeriodLst().stream().filter(v -> v.get("id").equals(periodId)).findFirst();
            if (!findFirst.isPresent()) continue;
            return periodYear;
        }
        throw new RuntimeException(String.format("cannot find periodYear by periodId: %s", periodId));
    }

    @Deprecated
    public DynamicObject getPrevPeriod(Object periodId) {
        List periodAllLst = this.periodYearLst.stream().flatMap(v -> v.getPeriodLst().stream()).collect(Collectors.toList());
        int size = periodAllLst.size();
        for (int i = 0; i < size; ++i) {
            if (i <= 0 || !((DynamicObject)periodAllLst.get(i)).get("id").equals(periodId)) continue;
            return (DynamicObject)periodAllLst.get(i - 1);
        }
        return null;
    }

    public Long getPrePeriodId(Long periodId) {
        return this.periodDataStr.getPrePeriodId(periodId);
    }

    @Deprecated
    public DynamicObject getNextPeriod(Object periodId) {
        List periodAllLst = this.periodYearLst.stream().flatMap(v -> v.getPeriodLst().stream()).collect(Collectors.toList());
        int size = periodAllLst.size();
        for (int i = 0; i < size; ++i) {
            if (i >= size - 1 || !((DynamicObject)periodAllLst.get(i)).get("id").equals(periodId)) continue;
            return (DynamicObject)periodAllLst.get(i + 1);
        }
        return null;
    }

    public List<DynamicObject> getPeriods(Date begindate, Date enddate, String cardNumber) {
        return this.periodDataStr.getPeriods(begindate, enddate, cardNumber);
    }

    public DynamicObject getPeriod(Date date, String cardNumber) {
        DynamicObject period = this.periodDataStr.getPeriod(date, cardNumber);
        if (period == null) {
            if (cardNumber == null) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6839\u636e\u65e5\u671f(%s)\u627e\u4e0d\u5230\u671f\u95f4", (String)"PeriodGroup_1", (String)"fi-fa-business", (Object[])new Object[0]), Fa.getTF().format(date)));
            }
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5361\u7247\u201c%1$s\u201d\u6839\u636e\u65e5\u671f\u201c%2$s\u201d\u627e\u4e0d\u5230\u671f\u95f4\u3002", (String)"PeriodGroup_0", (String)"fi-fa-business", (Object[])new Object[0]), cardNumber, Fa.getTF().format(date)));
        }
        return period;
    }

    public BigDecimal getYearPeriodCount() {
        return this.periodYearLst.get(0).getPeriodCount();
    }

    public int dateCmpToPeriod(Date date, DynamicObject period) {
        if (DateUtil.compareDate((Date)date, (Date)period.getDate("begindate")) < 0) {
            return -1;
        }
        if (DateUtil.compareDate((Date)date, (Date)period.getDate("enddate")) > 0) {
            return 1;
        }
        return 0;
    }

    public int dateCmpToPeriod(Date date, Date begindate, Date enddate) {
        if (DateUtil.compareDate((Date)date, (Date)begindate) < 0) {
            return -1;
        }
        if (DateUtil.compareDate((Date)date, (Date)enddate) > 0) {
            return 1;
        }
        return 0;
    }

    public int cmdPeriodByDate(Date date1, Date date2, String cardNumber) {
        DynamicObject period1 = null;
        DynamicObject period2 = null;
        try {
            period1 = this.getPeriod(date1, cardNumber);
        }
        catch (KDBizException e) {
            logger.error("\u5361\u7247" + cardNumber + "\u627e\u4e0d\u5230\u65e5\u671f\u3010" + date1 + "\u3011\u6240\u5728\u671f\u95f4", (Throwable)e);
        }
        try {
            period2 = this.getPeriod(date2, cardNumber);
        }
        catch (KDBizException e) {
            logger.error("\u5361\u7247" + cardNumber + "\u627e\u4e0d\u5230\u65e5\u671f\u3010" + date2 + "\u3011\u6240\u5728\u671f\u95f4", (Throwable)e);
        }
        if (period1 != null && period2 != null) {
            return DateUtil.compareDate((Date)period1.getDate("endDate"), (Date)period2.getDate("endDate"));
        }
        if (period1 == null && period2 == null) {
            if (this.periodYearLst.isEmpty()) {
                return 0;
            }
            PeriodYear firstPeriodYear = this.periodYearLst.get(0);
            DynamicObject firstPeriod = firstPeriodYear.getPeriodLst().get(0);
            Date firstPeriodBeginDate = firstPeriod.getDate("begindate");
            PeriodYear lastPeriodYear = this.periodYearLst.get(this.periodYearLst.size() - 1);
            DynamicObject lastPeriod = lastPeriodYear.getPeriodLst().get(lastPeriodYear.getPeriodLst().size() - 1);
            Date lastPeriodEndDate = lastPeriod.getDate("endDate");
            if (DateUtil.compareDate((Date)date1, (Date)firstPeriodBeginDate) < 0 && DateUtil.compareDate((Date)date2, (Date)firstPeriodBeginDate) < 0 || DateUtil.compareDate((Date)date1, (Date)lastPeriodEndDate) > 0 && DateUtil.compareDate((Date)date2, (Date)lastPeriodEndDate) > 0) {
                return 0;
            }
            return DateUtil.compareDate((Date)date1, (Date)date2);
        }
        return DateUtil.compareDate((Date)date1, (Date)date2);
    }
}

